/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.mpj;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import edu.usc.kmilner.mpj.taskDispatch.AsyncPostBatchHook;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.GridSourceProviderFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.mpj.AbstractAsyncLogicTreeWriter;
import org.opensha.sha.earthquake.faultSysSolution.modules.AbstractLogicTreeModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchRegionalMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;

public class MPJ_GridSeisBranchBuilder
extends MPJTaskCalculator {
    private GridSourceProviderFactory factory;
    private LogicTree<?> tree;
    private File solsDir;
    private LogicTree<?> gridSeisOnlyTree;
    private File nodesAverageDir;
    private File myAverageDir;
    private Table<String, String, AverageableModule.AveragingAccumulator<GridSourceProvider>> gridSeisAveragers;
    private File writeFullTreeFile;
    private File writeRandTreeFile;
    private File writeOnlyTreeFile;
    private int numSamples = -1;
    private int numSamplesPerSol = -1;
    private boolean[] branchWriteFlags;
    private int[] writtenBranchMappings;
    private List<LogicTreeBranch<?>> branchesAffectingOnly;
    private Map<String, double[]> rankWeights;
    private boolean averageOnly = false;
    private boolean rebuild = false;
    private ExecutorService exec;
    public static final String GRID_ASSOCIATIONS_ARCHIVE_NAME = "fault_grid_associations.zip";
    public static final String AVG_GRID_SIE_PROV_ARCHIVE_NAME = "avg_grid_seis.zip";
    public static final String GRID_BRANCH_REGIONAL_MFDS_NAME = "grid_branch_regional_mfds.zip";
    private Map<String, AverageableModule.AveragingAccumulator<GridSourceProvider>> nodeGridSourceAveragers;
    private Map<String, AverageableModule.AveragingAccumulator<FaultGridAssociations>> nodeFaultGridAveragers;
    private Map<String, BranchRegionalMFDs.Builder> nodeRegionalMFDsBuilders;
    private float sltMinMag = 0.0f;
    private String sltMagSuffix;

    public MPJ_GridSeisBranchBuilder(CommandLine cmd) throws IOException {
        super(cmd);
        this.shuffle = false;
        this.tree = LogicTree.read(new File(cmd.getOptionValue("logic-tree")));
        if (this.rank == 0) {
            this.debug("Loaded " + this.tree.size() + " tree nodes");
        }
        this.solsDir = new File(cmd.getOptionValue("sol-dir"));
        Preconditions.checkState((boolean)this.solsDir.exists());
        if (cmd.hasOption("slt-min-mag")) {
            this.sltMinMag = Float.parseFloat(cmd.getOptionValue("slt-min-mag"));
        }
        this.sltMagSuffix = this.sltMinMag > 0.0f ? "_m" + new DecimalFormat("0.##").format(this.sltMinMag) : "";
        try {
            Class<?> factoryClass = Class.forName(cmd.getOptionValue("factory"));
            this.factory = (GridSourceProviderFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        this.gridSeisOnlyTree = cmd.hasOption("gridded-logic-tree") ? LogicTree.read(new File(cmd.getOptionValue("gridded-logic-tree"))) : this.factory.getGridSourceTree(this.tree);
        Preconditions.checkNotNull(this.gridSeisOnlyTree, (Object)"Gridded seismicity tree cannot be null");
        Preconditions.checkState((this.gridSeisOnlyTree.size() > 0 ? 1 : 0) != 0, (Object)"Gridded seismicity tree cannot be empty");
        int totBranches = this.getNumTasks() * this.gridSeisOnlyTree.size();
        if (this.rank == 0) {
            this.debug("Will build " + this.gridSeisOnlyTree.size() + " grid-seis branches per fault branch, " + totBranches + " in total");
        }
        int threads = this.getNumThreads();
        if (this.rank == 0) {
            if (threads >= 16) {
                threads -= 4;
            } else if (threads >= 8) {
                threads -= 2;
            } else if (threads > 2) {
                --threads;
            }
        }
        this.exec = threads > 1 ? Executors.newFixedThreadPool(threads) : Executors.newSingleThreadExecutor();
        this.averageOnly = cmd.hasOption("average-only");
        this.rebuild = cmd.hasOption("rebuild");
        this.gridSeisAveragers = HashBasedTable.create();
        this.nodesAverageDir = new File(this.solsDir, "node_grid_seis_averages");
        if (this.rank == 0) {
            this.rankWeights = new HashMap<String, double[]>();
            if (this.nodesAverageDir.exists()) {
                for (File file : this.nodesAverageDir.listFiles()) {
                    this.debug("Deleting previous data in " + this.nodesAverageDir.getName() + "/" + file.getName());
                    if (file.isDirectory()) {
                        Preconditions.checkState((boolean)FileUtils.deleteRecursive(file));
                        continue;
                    }
                    file.delete();
                }
            } else {
                Preconditions.checkState((boolean)this.nodesAverageDir.mkdir());
            }
        }
        this.myAverageDir = new File(this.nodesAverageDir, "rank_" + this.rank);
        if (cmd.hasOption("write-full-tree")) {
            this.writeFullTreeFile = new File(cmd.getOptionValue("write-full-tree"));
        }
        if (cmd.hasOption("write-rand-tree")) {
            this.writeRandTreeFile = new File(cmd.getOptionValue("write-rand-tree"));
            if (cmd.hasOption("num-samples")) {
                Preconditions.checkState((!cmd.hasOption("num-samples-per-sol") ? 1 : 0) != 0, (Object)"Can only supply one of --num-samples and --num-samples-per-sol");
                this.numSamples = Integer.parseInt(cmd.getOptionValue("num-samples"));
            } else if (cmd.hasOption("num-samples-per-sol")) {
                Preconditions.checkState((!cmd.hasOption("num-samples") ? 1 : 0) != 0, (Object)"Can only supply one of --num-samples and --num-samples-per-sol");
                this.numSamplesPerSol = Integer.parseInt(cmd.getOptionValue("num-samples-per-sol"));
            } else {
                throw new IllegalArgumentException("Must supply either --num-samples or --num-samples-per-sol with --write-rand-tree");
            }
        }
        if (cmd.hasOption("write-only-tree")) {
            this.writeOnlyTreeFile = new File(cmd.getOptionValue("write-only-tree"));
        }
        if (this.rank == 0) {
            this.postBatchHook = new AsyncGridSeisCopier();
        }
        ArrayList<LogicTreeLevel<LogicTreeLevel>> levelsAffecting = new ArrayList<LogicTreeLevel<LogicTreeLevel>>();
        for (LogicTreeLevel level : this.tree.getLevels()) {
            if (!GridSourceProvider.affectedByLevel(level)) continue;
            levelsAffecting.add(level);
        }
        if (levelsAffecting.size() < this.tree.getLevels().size()) {
            this.debug(levelsAffecting.size() + "/" + this.tree.getLevels().size() + " levels affect gridded seismicity");
            Preconditions.checkState((!levelsAffecting.isEmpty() ? 1 : 0) != 0);
            this.branchWriteFlags = new boolean[this.tree.size()];
            this.writtenBranchMappings = new int[this.tree.size()];
            this.branchesAffectingOnly = new ArrayList(this.tree.size());
            HashMap<String, LogicTreeBranch> affectedPrefixes = new HashMap<String, LogicTreeBranch>();
            HashMap<String, Integer> affectedPrefixIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.tree.size(); ++i) {
                LogicTreeBranch<?> branch = this.tree.getBranch(i);
                ArrayList nodesAffecting = new ArrayList(levelsAffecting.size());
                for (LogicTreeLevel level : levelsAffecting) {
                    nodesAffecting.add(branch.getValue(level.getType()));
                }
                LogicTreeBranch subBranch = new LogicTreeBranch(levelsAffecting, nodesAffecting);
                String prefix = subBranch.buildFileName();
                if (affectedPrefixes.containsKey(prefix)) {
                    int origIndex;
                    subBranch = (LogicTreeBranch)affectedPrefixes.get(prefix);
                    subBranch.setOrigBranchWeight(subBranch.getOrigBranchWeight() + this.tree.getBranchWeight(i));
                    this.writtenBranchMappings[i] = origIndex = ((Integer)affectedPrefixIndexes.get(prefix)).intValue();
                } else {
                    subBranch.setOrigBranchWeight(this.tree.getBranchWeight(i));
                    affectedPrefixes.put(prefix, subBranch);
                    affectedPrefixIndexes.put(prefix, i);
                    this.writtenBranchMappings[i] = i;
                    this.branchWriteFlags[i] = true;
                }
                this.branchesAffectingOnly.add(subBranch);
            }
            this.debug("Will only write for " + affectedPrefixes.size() + " unique affected sub-branches");
        } else {
            this.debug("All " + levelsAffecting.size() + " levels affect gridded seismicity");
        }
    }

    private File getFilteredAvgFile(File dir) {
        Object name = AVG_GRID_SIE_PROV_ARCHIVE_NAME;
        if (this.sltMagSuffix.isBlank()) {
            return new File(dir, (String)name);
        }
        int zipIndex = ((String)name).indexOf(".zip");
        Preconditions.checkState((zipIndex > 0 ? 1 : 0) != 0);
        name = ((String)name).substring(0, zipIndex) + this.sltMagSuffix + ((String)name).substring(zipIndex);
        return new File(dir, (String)name);
    }

    protected int getNumTasks() {
        return this.tree.size();
    }

    /*
     * WARNING - void declaration
     */
    protected void calculateBatch(int[] batch) throws Exception {
        CompletableFuture<Void> postProcess = null;
        for (final int index : batch) {
            void var20_22;
            FaultGridAssociations gridAssoc;
            double faultWeight;
            boolean write;
            File gridSeisDir;
            LogicTreeBranch<?> origBranch = this.tree.getBranch(index);
            this.debug("Building gridded seismicity for " + index + ": " + String.valueOf(origBranch));
            File solFile = this.getSolFile(origBranch);
            Preconditions.checkState((boolean)solFile.exists());
            if (this.branchWriteFlags == null) {
                gridSeisDir = new File(solFile.getParentFile(), "grid_source_providers");
                Preconditions.checkState((gridSeisDir.exists() || gridSeisDir.mkdir() ? 1 : 0) != 0, (String)"Couldn't create grid source dir: %s", (Object)gridSeisDir);
                write = true;
                faultWeight = this.tree.getBranchWeight(origBranch);
                Preconditions.checkState((faultWeight > 0.0 ? 1 : 0) != 0, (String)"Fault branch weight=%s: %s", (Object)faultWeight, origBranch);
            } else {
                LogicTreeBranch<?> subBranch = this.branchesAffectingOnly.get(index);
                write = this.branchWriteFlags[index];
                File subDir = subBranch.getBranchDirectory(this.solsDir, write);
                gridSeisDir = new File(subDir, "grid_source_providers");
                Preconditions.checkState((!write || gridSeisDir.exists() || gridSeisDir.mkdir() ? 1 : 0) != 0, (String)"Couldn't create grid source dir: %s", (Object)gridSeisDir);
                faultWeight = subBranch.getOrigBranchWeight();
                this.debug("Branch " + index + " maps to sub-branch: " + String.valueOf(subBranch) + " with weight=" + faultWeight + " and write=" + write);
                Preconditions.checkState((faultWeight > 0.0 ? 1 : 0) != 0, (String)"Fault branch weight=%s. ORIG %s; SUB: %s", (Object)faultWeight, origBranch, subBranch);
            }
            FaultSystemSolution sol = FaultSystemSolution.load(solFile);
            this.factory.preGridBuildHook(sol, origBranch);
            FaultSystemRupSet rupSet = sol.getRupSet();
            FaultGridAssociations faultGridAssociations = gridAssoc = write ? rupSet.getModule(FaultGridAssociations.class) : null;
            if (gridAssoc != null && gridAssoc instanceof ArchivableModule) {
                File assocFile = new File(gridSeisDir, GRID_ASSOCIATIONS_ARCHIVE_NAME);
                ModuleArchive<FaultGridAssociations> archive = new ModuleArchive<FaultGridAssociations>();
                archive.addModule(gridAssoc);
                archive.write(assocFile);
            }
            final String baPrefix = AbstractAsyncLogicTreeWriter.getBA_prefix(origBranch);
            BranchOutputs outputs = new BranchOutputs();
            ArrayList futures = new ArrayList(this.gridSeisOnlyTree.size());
            for (int gridIndex = 0; gridIndex < this.gridSeisOnlyTree.size(); ++gridIndex) {
                futures.add(this.exec.submit(new CalcRunnable(origBranch, gridIndex, gridSeisDir, sol, baPrefix, outputs, write)));
            }
            for (Future future : futures) {
                future.get();
            }
            if (postProcess != null) {
                try {
                    postProcess.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MPJ_GridSeisBranchBuilder.abortAndExit((Throwable)e);
                }
            }
            final BranchRegionalMFDs regionalMFDs = outputs.mfdBuilder.build();
            Object var20_25 = null;
            if (write) {
                final GridSourceProvider avgGridProv = outputs.accumulator.getAverage();
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(){
                    final /* synthetic */ MPJ_GridSeisBranchBuilder this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            File avgFile = new File(gridSeisDir, MPJ_GridSeisBranchBuilder.AVG_GRID_SIE_PROV_ARCHIVE_NAME);
                            ModuleArchive<OpenSHA_Module> archive = new ModuleArchive<OpenSHA_Module>();
                            archive.addModule(avgGridProv);
                            archive.write(avgFile);
                            if (this.this$0.sltMinMag > 0.0f) {
                                File filteredAvgFile = this.this$0.getFilteredAvgFile(gridSeisDir);
                                archive = new ModuleArchive();
                                archive.addModule(avgGridProv.getAboveMinMag(this.this$0.sltMinMag));
                                archive.write(filteredAvgFile);
                            }
                            File mfdsFile = new File(gridSeisDir, MPJ_GridSeisBranchBuilder.GRID_BRANCH_REGIONAL_MFDS_NAME);
                            archive = new ModuleArchive();
                            archive.addModule(regionalMFDs);
                            archive.write(mfdsFile);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                        if (this.this$0.nodeGridSourceAveragers == null) {
                            this.this$0.nodeGridSourceAveragers = new HashMap<String, AverageableModule.AveragingAccumulator<GridSourceProvider>>();
                            this.this$0.nodeFaultGridAveragers = new HashMap<String, AverageableModule.AveragingAccumulator<FaultGridAssociations>>();
                        }
                        if (gridAssoc == null && this.this$0.nodeFaultGridAveragers != null) {
                            if (this.this$0.nodeFaultGridAveragers.isEmpty()) {
                                this.this$0.debug("We don't have fault grid associations; skipping consolidation");
                            } else {
                                this.this$0.debug("WARNING: not all branches have fault grid associations, skipping");
                            }
                            this.this$0.nodeFaultGridAveragers = null;
                        } else if (this.this$0.nodeFaultGridAveragers == null) {
                            this.this$0.debug("WARNING: branch " + index + " has fault grid associations, but an earlier one didn't; skipping");
                        } else {
                            if (!this.this$0.nodeFaultGridAveragers.containsKey(baPrefix)) {
                                this.this$0.nodeFaultGridAveragers.put(baPrefix, gridAssoc.averagingAccumulator());
                            }
                            AverageableModule.AveragingAccumulator<FaultGridAssociations> assocAccumulator = this.this$0.nodeFaultGridAveragers.get(baPrefix);
                            assocAccumulator.process(gridAssoc, faultWeight);
                        }
                        if (!this.this$0.nodeGridSourceAveragers.containsKey(baPrefix)) {
                            this.this$0.nodeGridSourceAveragers.put(baPrefix, avgGridProv.averagingAccumulator());
                        }
                        AverageableModule.AveragingAccumulator<GridSourceProvider> nodeAccumulator = this.this$0.nodeGridSourceAveragers.get(baPrefix);
                        nodeAccumulator.process(avgGridProv, faultWeight);
                    }
                });
            }
            outputs = null;
            CompletableFuture<Void> mfdsFuture = CompletableFuture.runAsync(new Runnable(){
                final /* synthetic */ MPJ_GridSeisBranchBuilder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (this.this$0.nodeRegionalMFDsBuilders == null) {
                        this.this$0.nodeRegionalMFDsBuilders = new HashMap<String, BranchRegionalMFDs.Builder>();
                    }
                    if (!this.this$0.nodeRegionalMFDsBuilders.containsKey(baPrefix)) {
                        this.this$0.nodeRegionalMFDsBuilders.put(baPrefix, new BranchRegionalMFDs.Builder());
                    }
                    this.this$0.debug("adding " + regionalMFDs.getBranchWeights().length + " branch regional MFDs for baPrefix=" + baPrefix + " (currently has " + this.this$0.nodeRegionalMFDsBuilders.get(baPrefix).getNumBranches() + ")");
                    this.this$0.nodeRegionalMFDsBuilders.get(baPrefix).process(regionalMFDs);
                    this.this$0.debug("DONE adding " + regionalMFDs.getBranchWeights().length + " branch regional MFDs for baPrefix=" + baPrefix + " (now has " + this.this$0.nodeRegionalMFDsBuilders.get(baPrefix).getNumBranches() + ")");
                    this.this$0.debug("done with " + index);
                }
            });
            postProcess = var20_22 == null ? mfdsFuture : CompletableFuture.allOf(new CompletableFuture[]{var20_22, mfdsFuture});
        }
        if (postProcess != null) {
            try {
                postProcess.join();
            }
            catch (Exception e) {
                e.printStackTrace();
                MPJ_GridSeisBranchBuilder.abortAndExit((Throwable)e);
            }
        }
    }

    protected File getSolFile(LogicTreeBranch<?> branch) {
        File runDir = branch.getBranchDirectory(this.solsDir, true);
        return new File(runDir, "solution.zip");
    }

    private LogicTreeBranch<?> getCombinedBranch(LogicTreeBranch<?> origBranch, LogicTreeBranch<?> gridSeisBranch) {
        ArrayList combLevels = new ArrayList();
        combLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)origBranch.getLevels());
        combLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)gridSeisBranch.getLevels());
        LogicTreeBranch<LogicTreeNode> combinedBranch = new LogicTreeBranch<LogicTreeNode>(combLevels);
        for (LogicTreeNode node : origBranch) {
            combinedBranch.setValue(node);
        }
        for (LogicTreeNode node : gridSeisBranch) {
            combinedBranch.setValue(node);
        }
        double origWeight = origBranch.getOrigBranchWeight() * gridSeisBranch.getOrigBranchWeight();
        combinedBranch.setOrigBranchWeight(origWeight);
        return combinedBranch;
    }

    /*
     * WARNING - void declaration
     */
    protected void doFinalAssembly() throws Exception {
        ModuleArchive<OpenSHA_Module> archive;
        System.gc();
        Preconditions.checkState((this.myAverageDir.exists() || this.myAverageDir.mkdir() ? 1 : 0) != 0);
        if (this.nodeGridSourceAveragers != null) {
            for (Object baPrefix : this.nodeGridSourceAveragers.keySet()) {
                void var3_3;
                String string = baPrefix;
                this.debug("Writing node averages for " + (String)baPrefix);
                if (!((String)baPrefix).isBlank()) {
                    String string2 = string + "_";
                }
                GridSourceProvider avgProv = this.nodeGridSourceAveragers.get(baPrefix).getAverage();
                archive = new ModuleArchive<OpenSHA_Module>();
                archive.addModule(avgProv);
                archive.write(new File(this.myAverageDir, (String)var3_3 + AVG_GRID_SIE_PROV_ARCHIVE_NAME));
                if (this.nodeFaultGridAveragers == null) continue;
                FaultGridAssociations associations = this.nodeFaultGridAveragers.get(baPrefix).getAverage();
                archive = new ModuleArchive();
                archive.addModule(associations);
                archive.write(new File(this.myAverageDir, (String)var3_3 + GRID_ASSOCIATIONS_ARCHIVE_NAME));
            }
        }
        this.nodeGridSourceAveragers = null;
        this.nodeFaultGridAveragers = null;
        if (this.nodeRegionalMFDsBuilders != null) {
            for (Object baPrefix : this.nodeRegionalMFDsBuilders.keySet()) {
                void var3_9;
                String string = baPrefix;
                this.debug("Writing node averages for " + (String)baPrefix);
                if (!((String)baPrefix).isBlank()) {
                    String string3 = string + "_";
                }
                BranchRegionalMFDs regionalMFDs = this.nodeRegionalMFDsBuilders.get(baPrefix).build();
                archive = new ModuleArchive();
                archive.addModule(regionalMFDs);
                archive.write(new File(this.myAverageDir, (String)var3_9 + GRID_BRANCH_REGIONAL_MFDS_NAME));
            }
        }
        this.nodeRegionalMFDsBuilders = null;
        HashMap baCommonBranches = null;
        if (this.rank == 0) {
            baCommonBranches = new HashMap();
            for (LogicTreeBranch logicTreeBranch : this.tree) {
                String baPrefix2 = AbstractAsyncLogicTreeWriter.getBA_prefix(logicTreeBranch);
                LogicTreeBranch<Object> commonBranch = (LogicTreeBranch<Object>)baCommonBranches.get(baPrefix2);
                if (commonBranch == null) {
                    ArrayList levels = new ArrayList();
                    ArrayList values = new ArrayList();
                    for (int i = 0; i < logicTreeBranch.size(); ++i) {
                        LogicTreeLevel level = logicTreeBranch.getLevel(i);
                        Object e = logicTreeBranch.getValue(i);
                        levels.add(level);
                        values.add(e);
                    }
                    commonBranch = new LogicTreeBranch<Object>(levels, values);
                    baCommonBranches.put(baPrefix2, commonBranch);
                }
                Preconditions.checkState((logicTreeBranch.size() == commonBranch.size() ? 1 : 0) != 0);
                for (int i = 0; i < logicTreeBranch.size(); ++i) {
                    Object origVal;
                    Object commonVal = commonBranch.getValue(i);
                    if (commonVal == null || (origVal = logicTreeBranch.getValue(i)) != null && commonVal.equals(origVal)) continue;
                    commonBranch.setValue(i, null);
                }
            }
        }
        if (!SINGLE_NODE_NO_MPJ) {
            MPI.COMM_WORLD.Barrier();
        }
        HashMap<String, FaultSystemSolution> baSols = null;
        if (this.rank == 0) {
            baSols = new HashMap<String, FaultSystemSolution>(baCommonBranches.keySet().size());
            for (String baPrefix : baCommonBranches.keySet()) {
                void var10_42;
                void var14_60;
                double[] baRankWeights = this.rankWeights.get(baPrefix);
                Object baFilePrefix = this.solsDir.getName();
                Object loadPrefix = baPrefix;
                if (!baPrefix.isBlank()) {
                    baFilePrefix = (String)baFilePrefix + "_" + baPrefix;
                    loadPrefix = (String)loadPrefix + "_";
                }
                File baFile = new File(this.solsDir.getParentFile(), (String)baFilePrefix + "_branch_averaged.zip");
                File baOutFile = new File(this.solsDir.getParentFile(), (String)baFilePrefix + "_branch_averaged_gridded.zip");
                Preconditions.checkState((baRankWeights.length == this.size ? 1 : 0) != 0);
                boolean bl = false;
                ArrayList<Future<GridSourceProvider>> provFutures = new ArrayList<Future<GridSourceProvider>>();
                ArrayList<Future<FaultGridAssociations>> assocFutures = new ArrayList<Future<FaultGridAssociations>>();
                ArrayList<Future<BranchRegionalMFDs>> arrayList = new ArrayList<Future<BranchRegionalMFDs>>();
                boolean bl2 = false;
                while (var14_60 < this.size) {
                    File mfdFile;
                    File rankDir = new File(this.nodesAverageDir, "rank_" + (int)var14_60);
                    Preconditions.checkState((boolean)rankDir.exists(), (String)"Dir doesn't exist: %s", (Object)rankDir.getAbsolutePath());
                    final File avgFile = new File(rankDir, (String)loadPrefix + AVG_GRID_SIE_PROV_ARCHIVE_NAME);
                    if (avgFile.exists()) {
                        ++var10_42;
                        provFutures.add(this.exec.submit(new Callable<GridSourceProvider>(){
                            final /* synthetic */ MPJ_GridSeisBranchBuilder this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public GridSourceProvider call() throws Exception {
                                ModuleArchive archive = new ModuleArchive(avgFile);
                                return archive.requireModule(GridSourceProvider.class);
                            }
                        }));
                        if (assocFutures != null) {
                            final File assocFile = new File(rankDir, (String)loadPrefix + GRID_ASSOCIATIONS_ARCHIVE_NAME);
                            if (assocFile.exists()) {
                                assocFutures.add(this.exec.submit(new Callable<FaultGridAssociations>(){
                                    final /* synthetic */ MPJ_GridSeisBranchBuilder this$0;
                                    {
                                        this.this$0 = this$0;
                                    }

                                    @Override
                                    public FaultGridAssociations call() throws Exception {
                                        ModuleArchive archive = new ModuleArchive(assocFile);
                                        return archive.requireModule(FaultGridAssociations.class);
                                    }
                                }));
                            } else {
                                assocFutures = null;
                            }
                        }
                    } else {
                        provFutures.add(null);
                        if (assocFutures != null) {
                            assocFutures.add(null);
                        }
                    }
                    if ((mfdFile = new File(rankDir, (String)loadPrefix + GRID_BRANCH_REGIONAL_MFDS_NAME)).exists()) {
                        this.debug("Will load regional MFDs from rank " + (int)var14_60 + ": " + mfdFile.getAbsolutePath());
                        arrayList.add(this.exec.submit(new Callable<BranchRegionalMFDs>(){
                            final /* synthetic */ MPJ_GridSeisBranchBuilder this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public BranchRegionalMFDs call() throws Exception {
                                ModuleArchive archive = new ModuleArchive(mfdFile);
                                return archive.requireModule(BranchRegionalMFDs.class);
                            }
                        }));
                    } else {
                        this.debug("No regional MFDs found for rank " + (int)var14_60 + ": " + mfdFile.getAbsolutePath() + " doesn't exist");
                        arrayList.add(null);
                    }
                    ++var14_60;
                }
                this.debug("Processing providers for baPrefix=" + baPrefix + " from " + (int)var10_42 + " nodes");
                Preconditions.checkState((var10_42 > 0 ? 1 : 0) != 0, (String)"No nodes processed %s", (Object)baPrefix);
                FaultSystemSolution faultSystemSolution = FaultSystemSolution.load(baFile);
                baSols.put(baPrefix, faultSystemSolution);
                AverageableModule.AveragingAccumulator<GridSourceProvider> provAccumulator = null;
                AverageableModule.AveragingAccumulator<FaultGridAssociations> assocAccumulator = null;
                BranchRegionalMFDs.Builder mfdBuilder = null;
                for (int rank = 0; rank < this.size; ++rank) {
                    Future mfdsFuture;
                    this.debug("Reading averages from " + rank);
                    Future provFuture = (Future)provFutures.get(rank);
                    if (provFuture != null) {
                        GridSourceProvider gridProv = (GridSourceProvider)provFuture.get();
                        if (provAccumulator == null) {
                            provAccumulator = gridProv.averagingAccumulator();
                        }
                        provAccumulator.process(gridProv, baRankWeights[rank]);
                        provFutures.set(rank, null);
                        if (assocFutures != null) {
                            Future assocFuture = (Future)assocFutures.get(rank);
                            FaultGridAssociations assoc = (FaultGridAssociations)assocFuture.get();
                            if (assocAccumulator == null) {
                                assocAccumulator = assoc.averagingAccumulator();
                            }
                            assocAccumulator.process(assoc, baRankWeights[rank]);
                            assocFutures.set(rank, null);
                        }
                    }
                    if ((mfdsFuture = (Future)arrayList.get(rank)) != null) {
                        BranchRegionalMFDs mfds = (BranchRegionalMFDs)mfdsFuture.get();
                        if (mfdBuilder == null) {
                            mfdBuilder = new BranchRegionalMFDs.Builder();
                        }
                        mfdBuilder.process(mfds);
                    }
                    arrayList.set(rank, null);
                }
                Preconditions.checkNotNull(provAccumulator);
                GridSourceProvider avgProv = (GridSourceProvider)provAccumulator.getAverage();
                faultSystemSolution.setGridSourceProvider(avgProv);
                if (assocAccumulator != null) {
                    FaultGridAssociations assoc = (FaultGridAssociations)assocAccumulator.getAverage();
                    faultSystemSolution.getRupSet().addModule(assoc);
                }
                BranchRegionalMFDs mfds = mfdBuilder.build();
                faultSystemSolution.addModule(mfds);
                faultSystemSolution.write(baOutFile);
            }
        }
        if (this.rank == 0) {
            this.memoryDebug("waiting for any post batch hook operations to finish");
            ((AsyncPostBatchHook)this.postBatchHook).shutdown();
            this.memoryDebug("post batch hook done");
        }
        for (Table.Cell cell : this.gridSeisAveragers.cellSet()) {
            Object prefix = (String)cell.getRowKey();
            if (!((String)prefix).isBlank()) {
                prefix = (String)prefix + "_";
            }
            prefix = (String)prefix + (String)cell.getColumnKey();
            this.debug("Building node-average for " + (String)prefix);
            GridSourceProvider avgProv = (GridSourceProvider)((AverageableModule.AveragingAccumulator)cell.getValue()).getAverage();
            ModuleArchive<GridSourceProvider> archive2 = new ModuleArchive<GridSourceProvider>();
            archive2.addModule(avgProv);
            File outputFile = new File(this.myAverageDir, prefix + ".zip");
            archive2.write(outputFile);
        }
        if (!SINGLE_NODE_NO_MPJ) {
            MPI.COMM_WORLD.Barrier();
        }
        if (this.rank == 0) {
            ArrayList fullLevels;
            Object baRankWeights;
            File file = new File(this.solsDir.getParentFile(), this.solsDir.getName() + "_gridded_branches.zip");
            SolutionLogicTree.FileBuilder sltBuilder = new SolutionLogicTree.FileBuilder(file);
            sltBuilder.setSerializeGridded(true);
            for (String baPrefix3 : baCommonBranches.keySet()) {
                baRankWeights = this.rankWeights.get(baPrefix3);
                Object baFilePrefix = this.solsDir.getName();
                if (!baPrefix3.isBlank()) {
                    baFilePrefix = (String)baFilePrefix + "_" + baPrefix3;
                }
                File baFile = new File(this.solsDir.getParentFile(), (String)baFilePrefix + "_branch_averaged.zip");
                FaultSystemSolution faultSystemSolution = FaultSystemSolution.load(baFile);
                this.debug("Building gridded-only branches for baPrefix=" + baPrefix3 + " with rankWeights=" + Joiner.on((String)",").join((Iterable)Doubles.asList((double[])baRankWeights)));
                LogicTreeBranch commonBranch = (LogicTreeBranch)baCommonBranches.get(baPrefix3);
                for (LogicTreeBranch<?> logicTreeBranch : this.gridSeisOnlyTree) {
                    Object value;
                    LogicTreeLevel<Object> level;
                    int i;
                    ArrayList arrayList = new ArrayList();
                    ArrayList values = new ArrayList();
                    for (i = 0; i < commonBranch.size(); ++i) {
                        level = commonBranch.getLevel(i);
                        value = commonBranch.getValue(i);
                        if (value == null) continue;
                        arrayList.add(level);
                        values.add(value);
                    }
                    for (i = 0; i < logicTreeBranch.size(); ++i) {
                        level = logicTreeBranch.getLevel(i);
                        value = logicTreeBranch.getValue(i);
                        if (value == null) continue;
                        arrayList.add(level);
                        values.add(value);
                    }
                    LogicTreeBranch combinedBranch = new LogicTreeBranch(arrayList, values);
                    combinedBranch.setOrigBranchWeight(logicTreeBranch.getOrigBranchWeight());
                    Iterator<LogicTreeBranch<Object>> gridPrefix = logicTreeBranch.buildFileName();
                    this.debug("Combining prividers for baPrefix=" + baPrefix3 + ", gridPrefix=" + (String)((Object)gridPrefix) + ", combBranch=" + String.valueOf(combinedBranch));
                    Object prefix = baPrefix3;
                    if (!((String)prefix).isBlank()) {
                        prefix = (String)prefix + "_";
                    }
                    prefix = (String)prefix + gridPrefix;
                    int numNodes = 0;
                    ArrayList<Future<GridSourceProvider>> futures = new ArrayList<Future<GridSourceProvider>>();
                    for (int rank = 0; rank < this.size; ++rank) {
                        File rankDir = new File(this.nodesAverageDir, "rank_" + rank);
                        Preconditions.checkState((boolean)rankDir.exists(), (String)"Dir doesn't exist: %s", (Object)rankDir.getAbsolutePath());
                        final File avgFile = new File(rankDir, (String)prefix + ".zip");
                        if (avgFile.exists()) {
                            ++numNodes;
                            futures.add(this.exec.submit(new Callable<GridSourceProvider>(){
                                final /* synthetic */ MPJ_GridSeisBranchBuilder this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public GridSourceProvider call() throws Exception {
                                    ModuleArchive archive = new ModuleArchive(avgFile);
                                    GridSourceProvider gridProv = archive.requireModule(GridSourceProvider.class);
                                    if ((double)this.this$0.sltMinMag > 0.0) {
                                        gridProv = gridProv.getAboveMinMag(this.this$0.sltMinMag);
                                    }
                                    return gridProv;
                                }
                            }));
                            continue;
                        }
                        futures.add(null);
                    }
                    this.debug("Processed providers for " + (String)prefix + " from " + numNodes + " nodes");
                    Preconditions.checkState((numNodes > 0 ? 1 : 0) != 0, (String)"No nodes processed %s", (Object)prefix);
                    AverageableModule.AveragingAccumulator<GridSourceProvider> accumulator = null;
                    for (int rank = 0; rank < this.size; ++rank) {
                        Future future = (Future)futures.get(rank);
                        if (future == null) continue;
                        GridSourceProvider gridProv = (GridSourceProvider)future.get();
                        if (accumulator == null) {
                            accumulator = gridProv.averagingAccumulator();
                        }
                        accumulator.process(gridProv, (double)baRankWeights[rank]);
                        futures.set(rank, null);
                    }
                    GridSourceProvider avgProv = (GridSourceProvider)accumulator.getAverage();
                    faultSystemSolution.addModule(avgProv);
                    sltBuilder.solution(faultSystemSolution, combinedBranch);
                }
            }
            sltBuilder.close();
            if (this.writeFullTreeFile != null || this.writeRandTreeFile != null && this.numSamples > 0) {
                this.debug("Building full logic tree for file output");
                fullLevels = new ArrayList();
                fullLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)this.tree.getLevels());
                fullLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)this.gridSeisOnlyTree.getLevels());
                ArrayList fullBranches = new ArrayList();
                baRankWeights = this.tree.iterator();
                while (baRankWeights.hasNext()) {
                    LogicTreeBranch origBranch = (LogicTreeBranch)baRankWeights.next();
                    for (LogicTreeBranch logicTreeBranch : this.gridSeisOnlyTree) {
                        fullBranches.add(this.getCombinedBranch(origBranch, logicTreeBranch));
                    }
                }
                LogicTree fullTree = LogicTree.fromExisting(fullLevels, fullBranches);
                if (this.writeFullTreeFile != null) {
                    this.debug("Writing " + fullTree.size() + " branches to " + this.writeFullTreeFile.getAbsolutePath());
                    fullTree.write(this.writeFullTreeFile);
                }
                if (this.writeRandTreeFile != null && this.numSamples > 0) {
                    Random rand = new Random((long)fullTree.size() * (long)this.numSamples);
                    LogicTree sampled = fullTree.sample(this.numSamples, false, rand);
                    this.debug("Writing " + sampled.size() + " sampled branches to " + this.writeRandTreeFile.getAbsolutePath());
                    sampled.write(this.writeRandTreeFile);
                }
            }
            if (this.writeRandTreeFile != null && this.numSamplesPerSol > 0) {
                this.debug("Building randomized logic tree with " + this.numSamplesPerSol + " gridded samples per solution for file output");
                fullLevels = new ArrayList();
                fullLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)this.tree.getLevels());
                fullLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)this.gridSeisOnlyTree.getLevels());
                ArrayList fullBranches = new ArrayList();
                Random rand = new Random((long)this.tree.size() * (long)this.gridSeisOnlyTree.size() * (long)this.numSamplesPerSol);
                IntegerPDF_FunctionSampler gridSampler = this.gridSeisOnlyTree.getSampler();
                HashMap<LogicTreeNode, Integer> origNodeCounts = new HashMap<LogicTreeNode, Integer>();
                HashMap<LogicTreeNode, Double> hashMap = new HashMap<LogicTreeNode, Double>();
                double sumOrigGridWeight = 0.0;
                for (LogicTreeBranch<?> logicTreeBranch : this.gridSeisOnlyTree) {
                    double weight = this.gridSeisOnlyTree.getBranchWeight(logicTreeBranch);
                    sumOrigGridWeight += weight;
                    for (LogicTreeNode node : logicTreeBranch) {
                        if (origNodeCounts.containsKey(node)) {
                            origNodeCounts.put(node, (Integer)origNodeCounts.get(node) + 1);
                            hashMap.put(node, (Double)hashMap.get(node) + weight);
                            continue;
                        }
                        origNodeCounts.put(node, 1);
                        hashMap.put(node, weight);
                    }
                }
                if (sumOrigGridWeight != 1.0) {
                    for (LogicTreeNode logicTreeNode : origNodeCounts.keySet()) {
                        hashMap.put(logicTreeNode, (Double)hashMap.get(logicTreeNode) / sumOrigGridWeight);
                    }
                }
                HashMap<LogicTreeNode, Integer> hashMap2 = new HashMap<LogicTreeNode, Integer>();
                HashMap<LogicTreeNode, Double> hashMap3 = new HashMap<LogicTreeNode, Double>();
                double sumSampledGridWeight = 0.0;
                for (LogicTreeBranch<?> origBranch : this.tree) {
                    double faultWeight = this.tree.getBranchWeight(origBranch);
                    ArrayList<Integer> sampledGridIndexes = new ArrayList<Integer>(this.numSamplesPerSol);
                    ArrayList<Integer> sampleCounts = new ArrayList<Integer>(this.numSamplesPerSol);
                    int totSampleCount = 0;
                    for (int i = 0; i < this.numSamplesPerSol; ++i) {
                        int listIndex;
                        int gridIndex = gridSampler.getRandomInt(rand);
                        while ((listIndex = sampleCounts.indexOf(gridIndex)) >= 0) {
                            sampleCounts.set(listIndex, (Integer)sampleCounts.get(listIndex) + 1);
                            ++totSampleCount;
                            gridIndex = gridSampler.getRandomInt(rand);
                        }
                        sampledGridIndexes.add(gridIndex);
                        sampleCounts.add(1);
                        ++totSampleCount;
                    }
                    double weightEach = 1.0 / (double)totSampleCount;
                    for (int i = 0; i < sampledGridIndexes.size(); ++i) {
                        LogicTreeBranch<?> gridBranch = this.gridSeisOnlyTree.getBranch((Integer)sampledGridIndexes.get(i));
                        double gridWeight = weightEach * (double)((Integer)sampleCounts.get(i)).intValue();
                        sumSampledGridWeight += gridWeight;
                        for (LogicTreeNode node : gridBranch) {
                            if (hashMap2.containsKey(node)) {
                                hashMap2.put(node, (Integer)hashMap2.get(node) + 1);
                                hashMap3.put(node, (Double)hashMap3.get(node) + gridWeight);
                                continue;
                            }
                            hashMap2.put(node, 1);
                            hashMap3.put(node, gridWeight);
                        }
                        double combWeight = faultWeight * gridWeight;
                        LogicTreeBranch<?> combBranch = this.getCombinedBranch(origBranch, gridBranch);
                        combBranch.setOrigBranchWeight(combWeight);
                        fullBranches.add(combBranch);
                    }
                }
                if (sumSampledGridWeight != 1.0) {
                    for (LogicTreeNode node : hashMap2.keySet()) {
                        hashMap3.put(node, (Double)hashMap3.get(node) / sumSampledGridWeight);
                    }
                }
                System.out.println("Sampled pairwise gridded tree (with " + this.numSamplesPerSol + " samples per fault branch):");
                LogicTree.printSamplingStats(this.gridSeisOnlyTree.getLevels(), hashMap2, hashMap3, origNodeCounts, hashMap);
                LogicTree randTree = LogicTree.fromExisting(fullLevels, fullBranches);
                this.debug("Writing " + randTree.size() + " sampled branches to " + this.writeRandTreeFile.getAbsolutePath());
                randTree.write(this.writeRandTreeFile);
            }
            if (this.writeOnlyTreeFile != null) {
                fullLevels = new ArrayList();
                fullLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)this.tree.getLevels());
                fullLevels.addAll((Collection<LogicTreeLevel<LogicTreeLevel<?>>>)this.gridSeisOnlyTree.getLevels());
                ArrayList onlyBranches = new ArrayList();
                for (int i = 0; i < this.tree.size(); ++i) {
                    if (this.branchWriteFlags != null && !this.branchWriteFlags[i]) continue;
                    LogicTreeBranch<?> origBranch = this.tree.getBranch(i);
                    for (LogicTreeBranch<?> logicTreeBranch : this.gridSeisOnlyTree) {
                        onlyBranches.add(this.getCombinedBranch(origBranch, logicTreeBranch));
                    }
                }
                LogicTree fullTree = LogicTree.fromExisting(fullLevels, onlyBranches);
                this.debug("Writing " + fullTree.size() + " branches to " + this.writeOnlyTreeFile.getAbsolutePath());
                fullTree.write(this.writeOnlyTreeFile);
            }
        }
        if (this.exec != null) {
            this.exec.shutdown();
        }
    }

    private void memoryDebug(String info) {
        info = info == null || ((String)info).isBlank() ? "" : (String)info + "; ";
        System.gc();
        Runtime rt = Runtime.getRuntime();
        long totalMB = rt.totalMemory() / 1024L / 1024L;
        long freeMB = rt.freeMemory() / 1024L / 1024L;
        long usedMB = totalMB - freeMB;
        this.debug((String)info + "mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB);
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        ops.addRequiredOption("lt", "logic-tree", true, "Path to logic tree JSON file");
        ops.addOption(null, "gridded-logic-tree", true, "Optional path to gridded seismicity branch logic tree JSON file (otherwise will be loaded from the factory)");
        ops.addRequiredOption(null, "factory", true, "Gridded seismicity factory classname");
        ops.addRequiredOption("sd", "sol-dir", true, "Path to directory containing solutions");
        ops.addOption("ao", "average-only", false, "Flag to only write out average gridded seismicity for each fault branch.");
        ops.addOption("wft", "write-full-tree", true, "If supplied, will write full logic tree JSON to this file");
        ops.addOption(null, "write-rand-tree", true, "If supplied, will write a randomly sampled (from the full distribution) logic tree JSON to this file. Must supply either --num-samples or --num-samples-per-sol");
        ops.addOption(null, "write-only-tree", true, "If supplied, will write out the smallest logic tree requried to do a full gridded-seismicity only hazard calculation");
        ops.addOption(null, "num-samples", true, "If --write-rand-tree is enabled, will write this many random samples of the full tree");
        ops.addOption(null, "num-samples-per-sol", true, "If --write-rand-tree is enabled, will write this many random gridded seismicity samples for each solution");
        ops.addOption(null, "rebuild", false, "Flag to force rebuild of all providers");
        ops.addOption(null, "slt-min-mag", true, "Minimum magnitude written in solution logic tree files (default is unfiltered)");
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_GridSeisBranchBuilder.createOptions();
            CommandLine cmd = MPJ_GridSeisBranchBuilder.parse((Options)options, (String[])args, MPJ_GridSeisBranchBuilder.class);
            MPJ_GridSeisBranchBuilder driver = new MPJ_GridSeisBranchBuilder(cmd);
            driver.run();
            MPJ_GridSeisBranchBuilder.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_GridSeisBranchBuilder.abortAndExit((Throwable)t);
        }
    }

    private class AsyncGridSeisCopier
    extends AsyncPostBatchHook {
        private File outputFile;
        private File avgOutputFile;
        private ArchiveOutput fullZipOut;
        private ArchiveOutput avgZipOut;
        private List<Map<String, String>> origBranchMappings;
        private List<Map<String, String>> avgBranchMappings;
        private List<Map<String, String>> fullBranchMappings;
        private CompletableFuture<List<Map<String, String>>> origZipCopyFuture;
        private String sltPrefix;
        private HashSet<String> writtenFullGridSourceFiles;
        private HashSet<String> writtenAvgGridSourceFiles;
        private List<? extends LogicTreeLevel<?>> origLevelsForGridReg;
        private List<? extends LogicTreeLevel<?>> fullLevelsForGridReg;
        private List<? extends LogicTreeLevel<?>> origLevelsForGridMechs;
        private List<? extends LogicTreeLevel<?>> origLevelsForSubSeisMFDs;
        private List<? extends LogicTreeLevel<?>> origLevelsForUnassociatedMFDs;
        private List<? extends LogicTreeLevel<?>> fullLevelsForGridMechs;
        private List<? extends LogicTreeLevel<?>> fullLevelsForSubSeisMFDs;
        private List<? extends LogicTreeLevel<?>> fullLevelsForUnassociatedMFDs;
        private List<? extends LogicTreeLevel<?>> origLevelsForGridLocs;
        private List<? extends LogicTreeLevel<?>> origLevelsForGridSources;
        private List<? extends LogicTreeLevel<?>> fullLevelsForGridLocs;
        private List<? extends LogicTreeLevel<?>> fullLevelsForGridSources;
        private Set<String> GRID_MAPPINGS_KEYS;

        public AsyncGridSeisCopier() throws IOException {
            super(1);
            this.sltPrefix = "solution_logic_tree/";
            this.GRID_MAPPINGS_KEYS = Set.of("grid_region.geojson", "grid_mech_weights.csv", "grid_sub_seis_mfds.csv", "grid_unassociated_mfds.csv", "grid_source_locations.csv", "grid_sources.csv");
            if (!MPJ_GridSeisBranchBuilder.this.averageOnly) {
                this.outputFile = new File(MPJ_GridSeisBranchBuilder.this.solsDir.getParentFile(), MPJ_GridSeisBranchBuilder.this.solsDir.getName() + "_full_gridded.zip");
                this.fullZipOut = new ArchiveOutput.ApacheZipFileOutput(this.outputFile);
            }
            this.avgOutputFile = new File(MPJ_GridSeisBranchBuilder.this.solsDir.getParentFile(), MPJ_GridSeisBranchBuilder.this.solsDir.getName() + "_avg_gridded.zip");
            this.avgZipOut = new ArchiveOutput.ApacheZipFileOutput(this.avgOutputFile);
            this.origZipCopyFuture = CompletableFuture.supplyAsync(new Supplier<List<Map<String, String>>>(){

                @Override
                public List<Map<String, String>> get() {
                    try {
                        if (!MPJ_GridSeisBranchBuilder.this.averageOnly) {
                            AsyncGridSeisCopier.this.origResultsZipCopy(AsyncGridSeisCopier.this.fullZipOut, new File(MPJ_GridSeisBranchBuilder.this.solsDir.getParentFile(), MPJ_GridSeisBranchBuilder.this.solsDir.getName() + ".zip"), null);
                        }
                        return AsyncGridSeisCopier.this.origResultsZipCopy(AsyncGridSeisCopier.this.avgZipOut, new File(MPJ_GridSeisBranchBuilder.this.solsDir.getParentFile(), MPJ_GridSeisBranchBuilder.this.solsDir.getName() + ".zip"), MPJ_GridSeisBranchBuilder.this.tree);
                    }
                    catch (Exception e) {
                        MPJTaskCalculator.abortAndExit((Throwable)e, (int)1);
                        return null;
                    }
                }
            });
            for (boolean full : new boolean[]{false, true}) {
                LogicTreeBranch<?> branch = full ? MPJ_GridSeisBranchBuilder.this.getCombinedBranch(MPJ_GridSeisBranchBuilder.this.tree.getBranch(0), MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.getBranch(0)) : MPJ_GridSeisBranchBuilder.this.tree.getBranch(0);
                ArrayList levels = new ArrayList();
                for (LogicTreeLevel level : branch.getLevels()) {
                    levels.add(level);
                }
                List<LogicTreeLevel<?>> levelsForGridReg = SolutionLogicTree.getLevelsAffectingFile("grid_region.geojson", false, levels);
                List<LogicTreeLevel<?>> levelsForGridMechs = SolutionLogicTree.getLevelsAffectingFile("grid_mech_weights.csv", false, levels);
                List<LogicTreeLevel<?>> levelsForSubSeisMFDs = SolutionLogicTree.getLevelsAffectingFile("grid_sub_seis_mfds.csv", true, levels);
                List<LogicTreeLevel<?>> levelsForSubUnassociatedMFDs = SolutionLogicTree.getLevelsAffectingFile("grid_unassociated_mfds.csv", true, levels);
                List<LogicTreeLevel<?>> levelsForGridLocs = SolutionLogicTree.getLevelsAffectingFile("grid_source_locations.csv", false, levels);
                List<LogicTreeLevel<?>> levelsForGridSources = SolutionLogicTree.getLevelsAffectingFile("grid_sources.csv", true, levels);
                if (full) {
                    this.fullLevelsForGridReg = levelsForGridReg;
                    this.fullLevelsForGridMechs = levelsForGridMechs;
                    this.fullLevelsForSubSeisMFDs = levelsForSubSeisMFDs;
                    this.fullLevelsForUnassociatedMFDs = levelsForSubUnassociatedMFDs;
                    this.fullLevelsForGridLocs = levelsForGridLocs;
                    this.fullLevelsForGridSources = levelsForGridSources;
                    continue;
                }
                this.origLevelsForGridReg = levelsForGridReg;
                this.origLevelsForGridMechs = levelsForGridMechs;
                this.origLevelsForSubSeisMFDs = levelsForSubSeisMFDs;
                this.origLevelsForUnassociatedMFDs = levelsForSubUnassociatedMFDs;
                this.origLevelsForGridLocs = levelsForGridLocs;
                this.origLevelsForGridSources = levelsForGridSources;
            }
            this.writtenAvgGridSourceFiles = new HashSet();
            this.writtenFullGridSourceFiles = new HashSet();
        }

        private List<Map<String, String>> origResultsZipCopy(ArchiveOutput out, File sourceFile, LogicTree<?> tree) throws IOException {
            ArchiveInput.ApacheZipFileInput in = new ArchiveInput.ApacheZipFileInput(sourceFile);
            String treeName = this.sltPrefix + "logic_tree.json";
            String treeMappings = this.sltPrefix + "logic_tree_mappings.json";
            List<Map<String, String>> branchMappings = null;
            for (String entry : in.getEntries()) {
                if (entry.equals(treeName)) continue;
                if (entry.equals(treeMappings)) {
                    if (tree == null) continue;
                    branchMappings = AbstractLogicTreeModule.loadBranchMappings(new InputStreamReader(in.getInputStream(treeMappings)), tree);
                    continue;
                }
                MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: copying to zip file: " + entry);
                out.transferFrom(in, entry);
            }
            in.close();
            return branchMappings;
        }

        protected void batchProcessedAsync(int[] batch, int processIndex) {
            if (this.origZipCopyFuture != null) {
                try {
                    this.origBranchMappings = this.origZipCopyFuture.get();
                    if (this.origBranchMappings != null) {
                        if (MPJ_GridSeisBranchBuilder.this.averageOnly) {
                            this.avgBranchMappings = this.origBranchMappings;
                        } else {
                            this.avgBranchMappings = new ArrayList<Map<String, String>>(this.origBranchMappings.size());
                            for (Map<String, String> orig : this.origBranchMappings) {
                                this.avgBranchMappings.add(new HashMap<String, String>(orig));
                            }
                            this.fullBranchMappings = new ArrayList<Map<String, String>>();
                            for (int i = 0; i < MPJ_GridSeisBranchBuilder.this.tree.size(); ++i) {
                                Map<String, String> orig;
                                orig = this.origBranchMappings.get(i);
                                for (int j = 0; j < MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size(); ++j) {
                                    this.fullBranchMappings.add(new LinkedHashMap<String, String>(orig));
                                }
                            }
                        }
                    }
                    this.origZipCopyFuture = null;
                }
                catch (InterruptedException | ExecutionException e) {
                    MPJTaskCalculator.abortAndExit((Throwable)e, (int)1);
                }
            }
            MPJ_GridSeisBranchBuilder.this.memoryDebug("AsyncLogicTree: beginning async call with batch size " + batch.length + " from " + processIndex + ": " + this.getRatesString());
            for (int index : batch) {
                try {
                    double branchWeight;
                    LogicTreeBranch<?> writeBranch;
                    File gridSeisDir;
                    LogicTreeBranch<?> origBranch = MPJ_GridSeisBranchBuilder.this.tree.getBranch(index);
                    MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: calcDone " + index + " = branch " + String.valueOf(origBranch));
                    if (MPJ_GridSeisBranchBuilder.this.branchWriteFlags == null) {
                        File solDir = MPJ_GridSeisBranchBuilder.this.getSolFile(origBranch).getParentFile();
                        gridSeisDir = new File(solDir, "grid_source_providers");
                        writeBranch = origBranch;
                        branchWeight = MPJ_GridSeisBranchBuilder.this.tree.getBranchWeight(origBranch);
                    } else {
                        if (!MPJ_GridSeisBranchBuilder.this.branchWriteFlags[index]) {
                            MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: skipping " + index + " (write=false)");
                            continue;
                        }
                        writeBranch = MPJ_GridSeisBranchBuilder.this.branchesAffectingOnly.get(index);
                        File subDir = writeBranch.getBranchDirectory(MPJ_GridSeisBranchBuilder.this.solsDir, false);
                        Preconditions.checkState((boolean)subDir.exists());
                        gridSeisDir = new File(subDir, "grid_source_providers");
                        branchWeight = MPJ_GridSeisBranchBuilder.this.tree.getWeightProvider().getWeight(writeBranch);
                    }
                    Preconditions.checkState((boolean)gridSeisDir.exists());
                    File avgGridFile = MPJ_GridSeisBranchBuilder.this.sltMinMag > 0.0f ? MPJ_GridSeisBranchBuilder.this.getFilteredAvgFile(gridSeisDir) : new File(gridSeisDir, MPJ_GridSeisBranchBuilder.AVG_GRID_SIE_PROV_ARCHIVE_NAME);
                    String baPrefix = AbstractAsyncLogicTreeWriter.getBA_prefix(origBranch);
                    Preconditions.checkNotNull((Object)baPrefix);
                    double[] baRankWeights = MPJ_GridSeisBranchBuilder.this.rankWeights.get(baPrefix);
                    if (baRankWeights == null) {
                        baRankWeights = new double[MPJ_GridSeisBranchBuilder.this.size];
                        MPJ_GridSeisBranchBuilder.this.rankWeights.put(baPrefix, baRankWeights);
                    }
                    int n = processIndex;
                    baRankWeights[n] = baRankWeights[n] + branchWeight;
                    MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: copying averaged grid source provider");
                    ArchiveInput.ApacheZipFileInput avgGridZip = new ArchiveInput.ApacheZipFileInput(avgGridFile);
                    Class<? extends GridSourceProvider> provClass = this.loadGridSourceProvClass(avgGridZip);
                    Map<String, String> origNameMappings = this.getNameMappings(writeBranch, false, provClass);
                    Map<String, String> branchMappings = this.avgBranchMappings == null ? null : this.avgBranchMappings.get(index);
                    for (String sourceName : origNameMappings.keySet()) {
                        String destName = origNameMappings.get(sourceName);
                        boolean hasEntry = avgGridZip.hasEntry(sourceName);
                        if (hasEntry && branchMappings != null) {
                            branchMappings.put(sourceName, destName);
                        }
                        if (this.writtenAvgGridSourceFiles.contains(destName)) continue;
                        if (!hasEntry) {
                            Preconditions.checkState((boolean)sourceName.endsWith("grid_region.geojson"));
                            continue;
                        }
                        MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: copying to zip file: " + destName);
                        this.avgZipOut.transferFrom(avgGridZip, sourceName, destName);
                        this.writtenAvgGridSourceFiles.add(destName);
                    }
                    this.writeGridProvInstance(provClass, writeBranch, this.origLevelsForSubSeisMFDs, this.avgZipOut, this.writtenAvgGridSourceFiles);
                    if (!MPJ_GridSeisBranchBuilder.this.averageOnly) {
                        for (int g = 0; g < MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size(); ++g) {
                            LogicTreeBranch<?> gridSeisBranch = MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.getBranch(g);
                            int fullIndex = index * MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size() + g;
                            Map<String, String> fullMappings = this.fullBranchMappings == null ? null : this.fullBranchMappings.get(fullIndex);
                            MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: copying branch grid source provider: " + String.valueOf(gridSeisBranch));
                            Object branchFileName = gridSeisBranch.buildFileName();
                            if (MPJ_GridSeisBranchBuilder.this.sltMinMag > 0.0f) {
                                branchFileName = (String)branchFileName + MPJ_GridSeisBranchBuilder.this.sltMagSuffix;
                            }
                            File gridSeisFile = new File(gridSeisDir, (String)branchFileName + ".zip");
                            ArchiveInput.ApacheZipFileInput sourceZip = new ArchiveInput.ApacheZipFileInput(gridSeisFile);
                            LogicTreeBranch<?> combBranch = MPJ_GridSeisBranchBuilder.this.getCombinedBranch(writeBranch, gridSeisBranch);
                            Map<String, String> nameMappings = this.getNameMappings(combBranch, true, provClass);
                            for (String sourceName : nameMappings.keySet()) {
                                String destName = nameMappings.get(sourceName);
                                boolean hasEntry = avgGridZip.hasEntry(sourceName);
                                if (hasEntry && fullMappings != null) {
                                    fullMappings.put(sourceName, destName);
                                }
                                if (this.writtenFullGridSourceFiles.contains(destName)) continue;
                                if (!hasEntry) {
                                    Preconditions.checkState((boolean)sourceName.endsWith("grid_region.geojson"));
                                    continue;
                                }
                                MPJ_GridSeisBranchBuilder.this.debug("AsyncLogicTree: copying to zip file: " + destName);
                                this.fullZipOut.transferFrom(sourceZip, sourceName, destName);
                                this.writtenFullGridSourceFiles.add(destName);
                            }
                            this.writeGridProvInstance(provClass, combBranch, this.fullLevelsForSubSeisMFDs, this.fullZipOut, this.writtenFullGridSourceFiles);
                            sourceZip.close();
                        }
                    }
                    avgGridZip.close();
                }
                catch (Exception e) {
                    MPJTaskCalculator.abortAndExit((Throwable)e, (int)1);
                }
            }
            MPJ_GridSeisBranchBuilder.this.memoryDebug("AsyncLogicTree: exiting async process, stats: " + this.getCountsString());
        }

        private Class<? extends GridSourceProvider> loadGridSourceProvClass(ArchiveInput sourceZip) throws IOException {
            Class<?> clazz;
            List<ModuleArchive.ModuleRecord> records = ModuleArchive.loadModulesManifest(sourceZip.getInputStream("modules.json"));
            Preconditions.checkState((records.size() == 1 ? 1 : 0) != 0);
            String className = records.get((int)0).className;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkState((boolean)GridSourceProvider.class.isAssignableFrom(clazz));
            return clazz;
        }

        private void writeGridProvInstance(Class<? extends GridSourceProvider> provClass, LogicTreeBranch<?> branch, List<? extends LogicTreeLevel<?>> levelsAffecting, ArchiveOutput out, HashSet<String> writtenFiles) throws IOException {
            Preconditions.checkState((boolean)ArchivableModule.class.isAssignableFrom(provClass));
            Class<? extends GridSourceProvider> moduleClass = provClass;
            if (MFDGridSourceProvider.class.isAssignableFrom(moduleClass) && !MFDGridSourceProvider.Default.class.isAssignableFrom(moduleClass)) {
                String avgInstanceFileName = this.getBranchFileName(branch, this.sltPrefix, "grid_provider_instance.json", levelsAffecting);
                out.putNextEntry(avgInstanceFileName);
                SolutionLogicTree.writeGridSourceProvInstanceFile(out.getOutputStream(), moduleClass);
                out.closeEntry();
                writtenFiles.add(avgInstanceFileName);
            }
        }

        private Map<String, String> getNameMappings(LogicTreeBranch<?> branch, boolean full, Class<? extends GridSourceProvider> provClass) {
            HashMap<String, String> nameMappings = new HashMap<String, String>(4);
            if (MFDGridSourceProvider.class.isAssignableFrom(provClass)) {
                nameMappings.put("grid_region.geojson", this.getBranchFileName(branch, this.sltPrefix, "grid_region.geojson", full ? this.fullLevelsForGridReg : this.origLevelsForGridReg));
                nameMappings.put("grid_mech_weights.csv", this.getBranchFileName(branch, this.sltPrefix, "grid_mech_weights.csv", full ? this.fullLevelsForGridMechs : this.origLevelsForGridMechs));
                nameMappings.put("grid_sub_seis_mfds.csv", this.getBranchFileName(branch, this.sltPrefix, "grid_sub_seis_mfds.csv", full ? this.fullLevelsForSubSeisMFDs : this.origLevelsForSubSeisMFDs));
                nameMappings.put("grid_unassociated_mfds.csv", this.getBranchFileName(branch, this.sltPrefix, "grid_unassociated_mfds.csv", full ? this.fullLevelsForUnassociatedMFDs : this.origLevelsForUnassociatedMFDs));
            } else if (GridSourceList.class.isAssignableFrom(provClass)) {
                nameMappings.put("grid_region.geojson", this.getBranchFileName(branch, this.sltPrefix, "grid_region.geojson", full ? this.fullLevelsForGridReg : this.origLevelsForGridReg));
                nameMappings.put("grid_source_locations.csv", this.getBranchFileName(branch, this.sltPrefix, "grid_source_locations.csv", full ? this.fullLevelsForGridLocs : this.origLevelsForGridLocs));
                nameMappings.put("grid_sources.csv", this.getBranchFileName(branch, this.sltPrefix, "grid_sources.csv", full ? this.fullLevelsForGridSources : this.origLevelsForGridSources));
            } else {
                throw new IllegalStateException("Unexpected GridSourceProvider class: " + provClass.getName());
            }
            return nameMappings;
        }

        protected String getBranchFileName(LogicTreeBranch<?> branch, String prefix, String fileName, List<? extends LogicTreeLevel<?>> mappingLevels) {
            StringBuilder ret = new StringBuilder(prefix);
            Preconditions.checkNotNull(mappingLevels, (String)"No mappings available for %", (Object)fileName);
            for (LogicTreeLevel<?> level : mappingLevels) {
                List<?> candidates = branch.getValues(level.getType());
                LogicTreeNode value = null;
                for (LogicTreeNode candidate : candidates) {
                    if (!level.isMember(candidate)) continue;
                    Preconditions.checkState((value == null ? 1 : 0) != 0, (String)"Level %s claims both %s and %s ad members", level, (Object)value, (Object)candidate);
                    value = candidate;
                }
                Preconditions.checkNotNull(value, (String)"Could not find a value that belongs to level %s, needed to retrieve %s", (Object)level.getName(), (Object)fileName);
                ret.append(value.getFilePrefix()).append("/");
            }
            ret.append(fileName);
            return ret.toString();
        }

        public void shutdown() {
            super.shutdown();
            try {
                if (!MPJ_GridSeisBranchBuilder.this.averageOnly) {
                    ArrayList combinedBranches = new ArrayList();
                    for (LogicTreeBranch<?> origBranch : MPJ_GridSeisBranchBuilder.this.tree) {
                        double faultWeight = MPJ_GridSeisBranchBuilder.this.tree.getBranchWeight(origBranch);
                        for (LogicTreeBranch<?> griddedBranch : MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree) {
                            double gridWeight = MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.getBranchWeight(griddedBranch);
                            LogicTreeBranch<?> combinedBranch = MPJ_GridSeisBranchBuilder.this.getCombinedBranch(origBranch, griddedBranch);
                            combinedBranch.setOrigBranchWeight(faultWeight * gridWeight);
                            combinedBranches.add(combinedBranch);
                        }
                    }
                    LogicTree combinedLogicTree = LogicTree.fromExisting(((LogicTreeBranch)combinedBranches.get(0)).getLevels(), combinedBranches);
                    this.fullZipOut.putNextEntry(this.sltPrefix + "logic_tree.json");
                    combinedLogicTree.writeToStream(this.fullZipOut.getOutputStream());
                    this.fullZipOut.closeEntry();
                    if (this.fullBranchMappings != null) {
                        if (MPJ_GridSeisBranchBuilder.this.writtenBranchMappings != null) {
                            Preconditions.checkState((this.fullBranchMappings.size() == MPJ_GridSeisBranchBuilder.this.tree.size() * MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size() ? 1 : 0) != 0);
                            Preconditions.checkState((MPJ_GridSeisBranchBuilder.this.writtenBranchMappings.length == MPJ_GridSeisBranchBuilder.this.tree.size() ? 1 : 0) != 0);
                            for (int i = 0; i < MPJ_GridSeisBranchBuilder.this.tree.size(); ++i) {
                                if (MPJ_GridSeisBranchBuilder.this.writtenBranchMappings[i] == i) continue;
                                for (int j = 0; j < MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size(); ++j) {
                                    int sourceIndex = MPJ_GridSeisBranchBuilder.this.writtenBranchMappings[i] * MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size() + j;
                                    int destIndex = i * MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size() + j;
                                    Map<String, String> sourceMappings = this.fullBranchMappings.get(sourceIndex);
                                    Map<String, String> destMappings = this.fullBranchMappings.get(destIndex);
                                    for (String key : sourceMappings.keySet()) {
                                        if (destMappings.containsKey(key) || !this.GRID_MAPPINGS_KEYS.contains(key)) continue;
                                        destMappings.put(key, sourceMappings.get(key));
                                    }
                                }
                            }
                        }
                        this.fullZipOut.putNextEntry(this.sltPrefix + "logic_tree_mappings.json");
                        SolutionLogicTree.writeLogicTreeMappings(new BufferedWriter(new OutputStreamWriter(this.fullZipOut.getOutputStream())), combinedLogicTree, this.fullBranchMappings);
                        this.fullZipOut.closeEntry();
                    }
                    this.fullZipOut.close();
                }
                this.avgZipOut.putNextEntry(this.sltPrefix + "logic_tree.json");
                MPJ_GridSeisBranchBuilder.this.tree.writeToStream(this.avgZipOut.getOutputStream());
                this.avgZipOut.closeEntry();
                if (this.avgBranchMappings != null) {
                    this.avgZipOut.putNextEntry(this.sltPrefix + "logic_tree_mappings.json");
                    SolutionLogicTree.writeLogicTreeMappings(new BufferedWriter(new OutputStreamWriter(this.avgZipOut.getOutputStream())), MPJ_GridSeisBranchBuilder.this.tree, this.avgBranchMappings);
                    this.avgZipOut.closeEntry();
                }
                this.avgZipOut.close();
            }
            catch (IOException e) {
                MPJTaskCalculator.abortAndExit((Throwable)e, (int)1);
            }
        }
    }

    private static class BranchOutputs {
        AverageableModule.AveragingAccumulator<GridSourceProvider> accumulator = null;
        BranchRegionalMFDs.Builder mfdBuilder = new BranchRegionalMFDs.Builder();

        private BranchOutputs() {
        }
    }

    private class CalcRunnable
    implements Runnable {
        private LogicTreeBranch<?> origBranch;
        private File gridSeisDir;
        private FaultSystemSolution sol;
        private int gridIndex;
        private BranchOutputs outputs;
        private String baPrefix;
        private boolean write;

        public CalcRunnable(LogicTreeBranch<?> origBranch, int gridIndex, File gridSeisDir, FaultSystemSolution sol, String baPrefix, BranchOutputs outputs, boolean write) {
            this.origBranch = origBranch;
            this.gridIndex = gridIndex;
            this.gridSeisDir = gridSeisDir;
            this.sol = sol;
            this.baPrefix = baPrefix;
            this.outputs = outputs;
            this.write = write;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ModuleArchive<GridSourceProvider> archive;
            LogicTreeBranch<?> gridSeisBranch = MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.getBranch(this.gridIndex);
            LogicTreeBranch<?> combinedBranch = MPJ_GridSeisBranchBuilder.this.getCombinedBranch(this.origBranch, gridSeisBranch);
            MPJ_GridSeisBranchBuilder.this.debug("Building for combined branch " + this.gridIndex + "/" + MPJ_GridSeisBranchBuilder.this.gridSeisOnlyTree.size() + ": " + String.valueOf(combinedBranch));
            File outputFile = new File(this.gridSeisDir, gridSeisBranch.buildFileName() + ".zip");
            GridSourceProvider gridProv = null;
            if (outputFile.exists() && !MPJ_GridSeisBranchBuilder.this.rebuild) {
                try {
                    archive = new ModuleArchive<GridSourceProvider>(outputFile);
                    gridProv = archive.getModule(GridSourceProvider.class);
                }
                catch (Exception e) {
                    MPJ_GridSeisBranchBuilder.this.debug("Couldn't load prior from " + outputFile.getAbsolutePath() + ", will rebuild: " + e.getMessage());
                }
            }
            if (gridProv == null) {
                try {
                    if (!this.write) {
                        MPJ_GridSeisBranchBuilder.this.debug("Need to build for " + this.gridIndex + " even though write=false");
                    }
                    gridProv = MPJ_GridSeisBranchBuilder.this.factory.buildGridSourceProvider(this.sol, combinedBranch);
                    if (this.write) {
                        archive = new ModuleArchive();
                        archive.addModule(gridProv);
                        archive.write(outputFile);
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            if (MPJ_GridSeisBranchBuilder.this.sltMinMag > 0.0f && this.write) {
                boolean doWrite;
                GridSourceProvider filteredGridProv = null;
                File filteredOutputFile = new File(this.gridSeisDir, gridSeisBranch.buildFileName() + MPJ_GridSeisBranchBuilder.this.sltMagSuffix + ".zip");
                if (filteredOutputFile.exists() && !MPJ_GridSeisBranchBuilder.this.rebuild) {
                    try {
                        ModuleArchive archive2 = new ModuleArchive(filteredOutputFile);
                        filteredGridProv = archive2.getModule(GridSourceProvider.class);
                    }
                    catch (Exception e) {
                        MPJ_GridSeisBranchBuilder.this.debug("Couldn't load prior filtered from " + filteredOutputFile.getAbsolutePath() + ", will rebuild: " + e.getMessage());
                    }
                }
                boolean bl = doWrite = filteredGridProv == null || MPJ_GridSeisBranchBuilder.this.rebuild;
                if (doWrite) {
                    if (filteredGridProv == null) {
                        filteredGridProv = gridProv.getAboveMinMag(MPJ_GridSeisBranchBuilder.this.sltMinMag);
                    }
                    ModuleArchive<GridSourceProvider> archive3 = new ModuleArchive<GridSourceProvider>();
                    archive3.addModule(filteredGridProv);
                    try {
                        archive3.write(filteredOutputFile);
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            }
            BranchOutputs branchOutputs = this.outputs;
            synchronized (branchOutputs) {
                double griddedWeight = gridSeisBranch.getOrigBranchWeight();
                if (this.write) {
                    if (this.outputs.accumulator == null) {
                        this.outputs.accumulator = gridProv.averagingAccumulator();
                    }
                    this.outputs.accumulator.process(gridProv, griddedWeight);
                    String gridPrefix = gridSeisBranch.buildFileName();
                    AverageableModule.AveragingAccumulator<GridSourceProvider> branchAccumulator = (AverageableModule.AveragingAccumulator<GridSourceProvider>)MPJ_GridSeisBranchBuilder.this.gridSeisAveragers.get((Object)this.baPrefix, (Object)gridPrefix);
                    if (branchAccumulator == null) {
                        branchAccumulator = gridProv.averagingAccumulator();
                        MPJ_GridSeisBranchBuilder.this.gridSeisAveragers.put((Object)this.baPrefix, (Object)gridPrefix, branchAccumulator);
                    }
                    branchAccumulator.process(gridProv, griddedWeight);
                }
                double faultWeight = this.origBranch.getBranchWeight();
                this.outputs.mfdBuilder.process(this.sol, gridProv, combinedBranch, faultWeight * griddedWeight);
                gridProv = null;
                System.gc();
            }
        }
    }
}

