/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.mpj;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Ints;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeCurveAverager;
import org.opensha.sha.earthquake.faultSysSolution.inversion.mpj.MPJ_LogicTreeInversionRunner;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.util.BranchAverageSolutionCreator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class MPJ_LogicTreeBranchAverageBuilder
extends MPJTaskCalculator {
    private SolutionLogicTree slt;
    private File outputDir;
    private LogicTree<LogicTreeNode> tree;
    private int depth;
    private ReportPageGen.PlotLevel plotLevel;
    private boolean skipSectBySect;
    private FaultSystemSolution compSol;
    private String compName;
    private Map<LogicTreeNode, LogicTreeLevel<?>> levelsMap;
    private List<LogicTreeNode[]> combinations;
    private boolean replot;
    private boolean process;
    private boolean rebuild;
    private static final DecimalFormat oDF = new DecimalFormat("0.#");

    public MPJ_LogicTreeBranchAverageBuilder(CommandLine cmd) throws IOException {
        super(cmd);
        this.shuffle = false;
        File inputDir = new File(cmd.getOptionValue("input-dir"));
        Preconditions.checkState((boolean)inputDir.exists());
        if (inputDir.isFile()) {
            if (cmd.hasOption("logic-tree")) {
                this.tree = LogicTree.read(new File(cmd.getOptionValue("logic-tree")));
                this.slt = SolutionLogicTree.load(inputDir, this.tree);
            } else {
                this.slt = SolutionLogicTree.load(inputDir);
                this.tree = this.slt.getLogicTree();
            }
        } else {
            Preconditions.checkArgument((boolean)cmd.hasOption("logic-tree"), (Object)"must supply logic tree if input is a directory");
            this.tree = LogicTree.read(new File(cmd.getOptionValue("logic-tree")));
            if (this.rank == 0) {
                this.debug("Loaded " + this.tree.size() + " tree nodes");
            }
            this.slt = new SolutionLogicTree.ResultsDirReader(inputDir, this.tree);
        }
        this.process = !cmd.hasOption("no-process");
        this.outputDir = new File(cmd.getOptionValue("output-dir"));
        if (cmd.hasOption("depth")) {
            this.depth = Integer.parseInt(cmd.getOptionValue("depth"));
            Preconditions.checkState((this.depth > 0 ? 1 : 0) != 0);
        } else {
            this.depth = 1;
        }
        this.combinations = MPJ_LogicTreeBranchAverageBuilder.buildCombinations(this.tree, this.depth);
        if (this.rank == 0) {
            this.debug(this.combinations.size() + " combinations for depth=" + this.depth);
        }
        if (cmd.hasOption("plot-level")) {
            this.plotLevel = ReportPageGen.PlotLevel.valueOf(cmd.getOptionValue("plot-level"));
            this.skipSectBySect = cmd.hasOption("skip-sect-by-sect");
            if (cmd.hasOption("compare-to")) {
                this.compSol = FaultSystemSolution.load(new File(cmd.getOptionValue("compare-to")));
                if (cmd.hasOption("comp-name")) {
                    this.compName = cmd.getOptionValue("comp-name");
                }
            }
        }
        this.levelsMap = new HashMap();
        for (LogicTreeLevel level : this.tree.getLevels()) {
            for (LogicTreeNode node : level.getNodes()) {
                Preconditions.checkState((!this.levelsMap.containsKey(node) ? 1 : 0) != 0);
                this.levelsMap.put(node, level);
            }
        }
        this.rebuild = cmd.hasOption("rebuild");
        this.replot = cmd.hasOption("replot");
        if (this.rank == 0) {
            MPJ_LogicTreeBranchAverageBuilder.waitOnDir(this.outputDir, 5, 1000L);
        }
    }

    private static void waitOnDir(File dir, int maxRetries, long sleepMillis) {
        int retry = 0;
        while (!dir.exists() && !dir.mkdir()) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            if (retry++ <= maxRetries) continue;
            throw new IllegalStateException("Directory doesn't exist and couldn't be created after " + maxRetries + " retries: " + dir.getAbsolutePath());
        }
    }

    protected int getNumTasks() {
        return this.combinations.size();
    }

    private String getPrefix(LogicTreeNode[] fixedNodes) {
        Object str = null;
        for (LogicTreeNode node : fixedNodes) {
            str = str == null ? "" : (String)str + "_";
            LogicTreeLevel<?> level = this.levelsMap.get(node);
            str = (String)str + level.getFilePrefix() + "_" + node.getFilePrefix();
        }
        return str;
    }

    private String getName(LogicTreeNode[] fixedNodes) {
        Object str = null;
        for (LogicTreeNode node : fixedNodes) {
            str = str == null ? "" : (String)str + ", ";
            LogicTreeLevel<?> level = this.levelsMap.get(node);
            str = (String)str + level.getShortName() + ": " + node.getName();
        }
        return str;
    }

    protected void calculateBatch(int[] batch) throws Exception {
        for (int index : batch) {
            FaultSystemSolution baSol;
            LogicTreeNode[] fixedNodes = this.combinations.get(index);
            String prefix = this.getPrefix(fixedNodes);
            final LogicTree<LogicTreeNode> subTree = this.tree.matchingAll(fixedNodes);
            this.debug("Building BA for " + index + ": " + prefix + " (" + subTree.size() + " branches)");
            Preconditions.checkState((subTree.size() > 1 ? 1 : 0) != 0, (String)"Need at least 2 branches, have %s for %s", (int)subTree.size(), (Object)prefix);
            File baFile = new File(this.outputDir, prefix + ".zip");
            if (this.rebuild || !baFile.exists()) {
                final BranchAverageSolutionCreator baCreator = new BranchAverageSolutionCreator(subTree.getWeightProvider());
                int count = 0;
                CompletableFuture<Void> processingLoadedFuture = null;
                final Stopwatch loadWatch = Stopwatch.createUnstarted();
                final Stopwatch processWatch = Stopwatch.createUnstarted();
                final Stopwatch totalWatch = Stopwatch.createStarted();
                for (final LogicTreeBranch<LogicTreeNode> logicTreeBranch : subTree) {
                    final int myCount = count++;
                    this.debug("Loading branch " + myCount + "/" + subTree.size() + " for " + prefix + ": " + String.valueOf(logicTreeBranch));
                    loadWatch.start();
                    final FaultSystemSolution sol = this.slt.forBranch(logicTreeBranch, this.process);
                    sol.getModulesAssignableTo(BranchAverageableModule.class, true);
                    sol.getRupSet().getModulesAssignableTo(BranchAverageableModule.class, true);
                    loadWatch.stop();
                    if (processingLoadedFuture != null) {
                        processingLoadedFuture.get();
                    }
                    processingLoadedFuture = CompletableFuture.runAsync(new Runnable(){
                        final /* synthetic */ MPJ_LogicTreeBranchAverageBuilder this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            processWatch.start();
                            baCreator.addSolution(sol, logicTreeBranch);
                            processWatch.stop();
                            int done = myCount + 1;
                            this.this$0.debug("Done processing branch " + myCount + "/" + subTree.size() + ";\t" + MPJ_LogicTreeInversionRunner.memoryString() + ";\tEACH: load=" + this.this$0.elapsed(loadWatch, done) + ", process=" + this.this$0.elapsed(processWatch, done) + ", tot=" + this.this$0.elapsed(totalWatch, done) + ";\tTOTAL: load=" + this.this$0.elapsed(loadWatch) + ", process=" + this.this$0.elapsed(processWatch) + ", tot=" + this.this$0.elapsed(totalWatch));
                        }
                    });
                }
                if (processingLoadedFuture != null) {
                    processingLoadedFuture.get();
                }
                totalWatch.stop();
                baSol = baCreator.build();
                baSol.write(baFile);
            } else {
                baSol = FaultSystemSolution.load(baFile);
            }
            if (this.plotLevel == null) continue;
            File reportDir = new File(this.outputDir, prefix + "_report");
            this.debug("Writing report to " + reportDir.getAbsolutePath());
            RupSetMetadata compMeta = null;
            if (this.compSol != null) {
                compMeta = new RupSetMetadata(this.compName == null ? "Full Tree" : this.compName, this.compSol);
            }
            ReportMetadata meta = new ReportMetadata(new RupSetMetadata(this.getName(fixedNodes), baSol), compMeta);
            ReportPageGen pageGen = new ReportPageGen(meta, reportDir, ReportPageGen.getDefaultSolutionPlots(this.plotLevel));
            pageGen.setReplot(this.replot);
            pageGen.setNumThreads(this.getNumThreads());
            if (this.skipSectBySect) {
                pageGen.skipSectBySect();
            }
            pageGen.generatePage();
        }
    }

    private String elapsed(Stopwatch watch) {
        return this.elapsed(watch, 0);
    }

    private String elapsed(Stopwatch watch, int per) {
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        if (per > 0) {
            secs /= (double)per;
        }
        if (secs < 60.0) {
            return oDF.format(secs) + "s";
        }
        double mins = secs / 60.0;
        if (mins < 60.0) {
            return oDF.format(mins) + "m";
        }
        double hours = mins / 60.0;
        return oDF.format(hours) + "h";
    }

    /*
     * WARNING - void declaration
     */
    protected void doFinalAssembly() throws Exception {
        if (this.rank == 0 && this.depth == 1) {
            void var10_12;
            this.debug("Building landing page and MFD plots");
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("# Individual Logic Tree Choice Branch Averages");
            lines.add("");
            lines.add("This page gives links and summary information for subsets of the logic tree with individual choices fixed. The links and plots below are for branch-averaged subsets of the model holding the listed branch choice fixed, but averaged across all other choices in the model (according to their weights).");
            lines.add("");
            int tocIndex = lines.size();
            String topLink = "_[(top)](#table-of-contents)_";
            List<List<LogicTreeNode>> levelNodesUsed = MPJ_LogicTreeBranchAverageBuilder.levelNodesUsed(this.tree);
            IncrementalMagFreqDist compMFD = null;
            EvenlyDiscretizedFunc compCmlMFD = null;
            if (this.compSol != null) {
                IncrementalMagFreqDist refFunc = FaultSysTools.initEmptyMFD(this.compSol.getRupSet());
                compMFD = this.compSol.calcTotalNucleationMFD(refFunc.getMinX(), refFunc.getMaxX(), refFunc.getDelta());
                compMFD.setName(this.compName == null ? "Full Tree" : this.compName);
                compCmlMFD = compMFD.getCumRateDistWithOffset();
                compCmlMFD.setName(compMFD.getName());
            }
            double totalWeight = 0.0;
            for (LogicTreeBranch<LogicTreeNode> logicTreeBranch : this.tree) {
                totalWeight += this.tree.getBranchWeight(logicTreeBranch);
            }
            DecimalFormat weightDF = new DecimalFormat("0.##%");
            boolean bl = false;
            while (var10_12 < levelNodesUsed.size()) {
                List<LogicTreeNode> levelNodes = levelNodesUsed.get((int)var10_12);
                if (levelNodes.size() >= 2 && !LogicTreeCurveAverager.shouldSkipLevel((LogicTreeLevel)this.tree.getLevels().get((int)var10_12), levelNodes.size())) {
                    LogicTreeLevel level = (LogicTreeLevel)this.tree.getLevels().get((int)var10_12);
                    this.debug("Building page for " + level.getName());
                    ArrayList<IncrementalMagFreqDist> incrMFDs = new ArrayList<IncrementalMagFreqDist>();
                    ArrayList<EvenlyDiscretizedFunc> cmlMFDs = new ArrayList<EvenlyDiscretizedFunc>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    MarkdownUtils.TableBuilder linkTable = MarkdownUtils.tableBuilder();
                    if (this.plotLevel != null) {
                        linkTable.addLine("Choice", "Branch Count", "Weight", "Report", "Download Solution");
                    } else {
                        linkTable.addLine("Choice", "Branch Count", "Weight", "Download Solution");
                    }
                    CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, (double)levelNodes.size() - 1.0);
                    for (int i = 0; i < levelNodes.size(); ++i) {
                        LogicTreeNode node = levelNodes.get(i);
                        LogicTreeNode[] array = new LogicTreeNode[]{node};
                        String prefix = this.getPrefix(array);
                        File solFile = new File(this.outputDir, prefix + ".zip");
                        Preconditions.checkState((boolean)solFile.exists(), (String)"Node solution doesn't exist: %s", (Object)solFile.getAbsolutePath());
                        int numBranches = 0;
                        double myWeight = 0.0;
                        for (LogicTreeBranch<LogicTreeNode> logicTreeBranch : this.tree) {
                            if (!logicTreeBranch.hasValue(node)) continue;
                            ++numBranches;
                            myWeight += this.tree.getBranchWeight(logicTreeBranch);
                        }
                        this.debug(node.getShortName() + " has " + numBranches + " branches, " + weightDF.format(myWeight / totalWeight) + " weight");
                        linkTable.initNewLine();
                        linkTable.addColumn(node.getName());
                        linkTable.addColumn(numBranches);
                        linkTable.addColumn(weightDF.format(myWeight / totalWeight));
                        if (this.plotLevel != null) {
                            linkTable.addColumn("[View Report](" + prefix + "_report/)");
                        }
                        linkTable.addColumn("[" + solFile.getName() + "](" + solFile.getName() + ")");
                        linkTable.finalizeLine();
                        FaultSystemSolution sol = FaultSystemSolution.load(solFile);
                        IncrementalMagFreqDist incrementalMagFreqDist = FaultSysTools.initEmptyMFD(sol.getRupSet());
                        IncrementalMagFreqDist mfd = sol.calcTotalNucleationMFD(incrementalMagFreqDist.getMinX(), incrementalMagFreqDist.getMaxX(), incrementalMagFreqDist.getDelta());
                        mfd.setName(node.getShortName());
                        incrMFDs.add(mfd);
                        EvenlyDiscretizedFunc cmlMFD = mfd.getCumRateDistWithOffset();
                        cmlMFD.setName(node.getShortName());
                        cmlMFDs.add(cmlMFD);
                        Color color = cpt.getColor(i);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color));
                    }
                    double minX = Double.POSITIVE_INFINITY;
                    double maxX = Double.NEGATIVE_INFINITY;
                    for (IncrementalMagFreqDist mfd : incrMFDs) {
                        for (Point2D pt : mfd) {
                            if (!(pt.getY() > 0.0)) continue;
                            minX = Math.min(minX, pt.getX());
                            maxX = Math.max(maxX, pt.getX());
                        }
                    }
                    if (this.compSol != null) {
                        incrMFDs.add(compMFD);
                        cmlMFDs.add(compCmlMFD);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
                    }
                    minX = Math.floor(minX * 5.0) / 5.0;
                    maxX = Math.ceil(maxX * 5.0) / 5.0;
                    Range xRange = new Range(minX, maxX);
                    Range incrYRange = MPJ_LogicTreeBranchAverageBuilder.yRange(incrMFDs);
                    Range cmlYRange = MPJ_LogicTreeBranchAverageBuilder.yRange(cmlMFDs);
                    PlotSpec incrSpec = new PlotSpec(incrMFDs, chars, level.getName(), "Magnitude", "Incremental Rate (/yr)");
                    incrSpec.setLegendInset(true);
                    PlotSpec cmlSpec = new PlotSpec(cmlMFDs, chars, level.getName(), "Magnitude", "Cumulative Rate (/yr)");
                    cmlSpec.setLegendInset(true);
                    MarkdownUtils.TableBuilder tableBuilder = MarkdownUtils.tableBuilder();
                    tableBuilder.addLine("Incremental", "Cumulative");
                    String plotPrefix = level.getFilePrefix() + "_mfds";
                    HeadlessGraphPanel gp = PlotUtils.initHeadless();
                    tableBuilder.initNewLine();
                    gp.drawGraphPanel(incrSpec, false, true, xRange, incrYRange);
                    PlotUtils.writePlots(this.outputDir, plotPrefix, (GraphPanel)gp, 900, 800, true, true, true);
                    tableBuilder.addColumn("![Incremental](" + plotPrefix + ".png)");
                    gp.drawGraphPanel(cmlSpec, false, true, xRange, cmlYRange);
                    plotPrefix = plotPrefix + "_cml";
                    PlotUtils.writePlots(this.outputDir, plotPrefix, (GraphPanel)gp, 900, 800, true, true, true);
                    tableBuilder.addColumn("![Cumulative](" + plotPrefix + ".png)");
                    tableBuilder.finalizeLine();
                    lines.add("");
                    lines.add("## " + level.getName());
                    lines.add(topLink);
                    lines.add("");
                    lines.addAll(linkTable.build());
                    lines.add("");
                    lines.add("### " + level.getName() + ", MFD plots");
                    lines.add(topLink);
                    lines.add("");
                    lines.addAll(tableBuilder.build());
                }
                ++var10_12;
            }
            lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 2));
            lines.add(tocIndex, "## Table Of Contents");
            MarkdownUtils.writeReadmeAndHTML(lines, this.outputDir);
        }
    }

    private static Range yRange(List<? extends DiscretizedFunc> mfds) {
        double minY = Double.POSITIVE_INFINITY;
        double maxY = 0.0;
        for (DiscretizedFunc discretizedFunc : mfds) {
            for (Point2D pt : discretizedFunc) {
                if (!(pt.getY() > 0.0)) continue;
                minY = Math.min(minY, pt.getY());
                maxY = Math.max(maxY, pt.getY());
            }
        }
        minY = Math.pow(10.0, Math.floor(Math.log10(minY)));
        maxY = Math.pow(10.0, Math.ceil(Math.log10(maxY)));
        minY = Math.max(minY, 1.0E-6);
        return new Range(minY, maxY);
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        ops.addOption("lt", "logic-tree", true, "Path to logic tree JSON file");
        ops.addRequiredOption("id", "input-dir", true, "Path to input (results) directory");
        ops.addRequiredOption("od", "output-dir", true, "Path to output directory");
        ops.addOption("pl", "plot-level", true, "This enables reports and sets the plot level, one of: " + FaultSysTools.enumOptions(ReportPageGen.PlotLevel.class) + ". Default is no report.");
        ops.addOption("cs", "compare-to", true, "Comparison solution file to use in reports");
        ops.addOption("cn", "comp-name", true, "Name of the comparison rupture set. Default: Full Tree");
        ops.addOption("ssbs", "skip-sect-by-sect", false, "Flag to skip section-by-section plots, regardless of selected plot level");
        ops.addOption("dp", "depth", true, "Depth of level combinations to include (default is 1, more than 2 is not recommended).");
        ops.addOption("rp", "replot", false, "If supplied, existing plots will be re-generated when re-running a report");
        ops.addOption("rb", "rebuild", false, "If supplied, existing branch averages will be rebuilt, otherwise they will be skipped");
        ops.addOption(null, "no-process", false, "If supplied, solution logic tree processor will be skipped when loading solutions");
        return ops;
    }

    public static List<LogicTreeNode[]> buildCombinations(LogicTree<?> tree, int depth) {
        List<List<LogicTreeNode>> levelNodesUsed = MPJ_LogicTreeBranchAverageBuilder.levelNodesUsed(tree);
        ArrayList<int[]> levelCombinations = new ArrayList<int[]>();
        MPJ_LogicTreeBranchAverageBuilder.fillInLevelCombinationsRecursive(tree, levelNodesUsed, levelCombinations, 0, new int[0], depth);
        if (depth > 1) {
            System.out.println("Found " + levelCombinations.size() + " level combinations");
        }
        ArrayList<LogicTreeNode[]> combinations = new ArrayList<LogicTreeNode[]>();
        for (int[] fixedLevels : levelCombinations) {
            MPJ_LogicTreeBranchAverageBuilder.addCombinationsRecursive(tree, levelNodesUsed, fixedLevels, 0, new LogicTreeNode[0], combinations);
        }
        if (depth > 1) {
            System.out.println("Found " + combinations.size() + " node combinations");
        }
        return combinations;
    }

    private static List<List<LogicTreeNode>> levelNodesUsed(LogicTree<?> tree) {
        ArrayList<List<LogicTreeNode>> levelNodesUsed = new ArrayList<List<LogicTreeNode>>();
        for (LogicTreeLevel level : tree.getLevels()) {
            ArrayList<LogicTreeNode> myNodes = new ArrayList<LogicTreeNode>();
            levelNodesUsed.add(myNodes);
            block1: for (LogicTreeNode node : level.getNodes()) {
                for (LogicTreeBranch<?> branch : tree) {
                    if (!branch.hasValue(node)) continue;
                    myNodes.add(node);
                    continue block1;
                }
            }
        }
        return levelNodesUsed;
    }

    private static void fillInLevelCombinationsRecursive(LogicTree<?> tree, List<List<LogicTreeNode>> levelNodesUsed, List<int[]> ret, int curDepth, int[] curFixed, int totDepth) {
        Preconditions.checkState((curFixed.length == curDepth ? 1 : 0) != 0);
        if (curDepth == totDepth) {
            ret.add(curFixed);
        } else {
            int startLevel;
            for (int l = startLevel = curFixed.length == 0 ? 0 : Ints.max((int[])curFixed) + 1; l < levelNodesUsed.size(); ++l) {
                int numNodes = levelNodesUsed.get(l).size();
                LogicTreeLevel level = (LogicTreeLevel)tree.getLevels().get(l);
                if (numNodes < 2 || LogicTreeCurveAverager.shouldSkipLevel(level, numNodes)) continue;
                int[] newFixed = Arrays.copyOf(curFixed, curFixed.length + 1);
                newFixed[newFixed.length - 1] = l;
                MPJ_LogicTreeBranchAverageBuilder.fillInLevelCombinationsRecursive(tree, levelNodesUsed, ret, curDepth + 1, newFixed, totDepth);
            }
        }
    }

    private static void addCombinationsRecursive(LogicTree<?> tree, List<List<LogicTreeNode>> levelNodesUsed, int[] fixedLevels, int curIndex, LogicTreeNode[] fixedVals, List<LogicTreeNode[]> ret) {
        Preconditions.checkState((fixedVals.length == curIndex ? 1 : 0) != 0);
        if (curIndex == fixedLevels.length) {
            ret.add(fixedVals);
        } else {
            int levelIndex = fixedLevels[curIndex];
            for (LogicTreeNode node : levelNodesUsed.get(levelIndex)) {
                LogicTreeNode[] newFixed = Arrays.copyOf(fixedVals, fixedVals.length + 1);
                newFixed[newFixed.length - 1] = node;
                MPJ_LogicTreeBranchAverageBuilder.addCombinationsRecursive(tree, levelNodesUsed, fixedLevels, curIndex + 1, newFixed, ret);
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_LogicTreeBranchAverageBuilder.createOptions();
            CommandLine cmd = MPJ_LogicTreeBranchAverageBuilder.parse((Options)options, (String[])args, MPJ_LogicTreeBranchAverageBuilder.class);
            MPJ_LogicTreeBranchAverageBuilder driver = new MPJ_LogicTreeBranchAverageBuilder(cmd);
            driver.run();
            MPJ_LogicTreeBranchAverageBuilder.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_LogicTreeBranchAverageBuilder.abortAndExit((Throwable)t);
        }
    }
}

