/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;

public class ConstraintRange {
    public final String name;
    public final String shortName;
    public final int startRow;
    public final int endRow;
    public final boolean inequality;
    public final double weight;
    public final ConstraintWeightingType weightingType;

    public static List<ConstraintRange> filterByType(List<ConstraintRange> ranges, ConstraintWeightingType type) {
        return ranges.stream().filter(R -> R.weightingType == type).collect(Collectors.toList());
    }

    public static List<ConstraintRange> filterByInequality(List<ConstraintRange> ranges, boolean inequality) {
        return ranges.stream().filter(R -> R.inequality == inequality).collect(Collectors.toList());
    }

    public ConstraintRange(String name, String shortName, int startRow, int endRow, boolean inequality, double weight, ConstraintWeightingType weightingType) {
        this.name = name;
        this.shortName = shortName;
        this.startRow = startRow;
        this.endRow = endRow;
        this.inequality = inequality;
        this.weight = weight;
        this.weightingType = weightingType;
    }

    public String toString() {
        return this.shortName + ": [" + this.startRow + ".." + this.endRow + "), " + (this.endRow - this.startRow) + " rows";
    }

    public boolean contains(int row) {
        return row >= this.startRow && row < this.endRow;
    }

    public boolean contains(int row, boolean inequality) {
        return this.inequality == inequality && row >= this.startRow && row < this.endRow;
    }

    public int hashCode() {
        return Objects.hash(this.endRow, this.inequality, this.name, this.shortName, this.startRow, this.weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintRange other = (ConstraintRange)obj;
        return this.endRow == other.endRow && this.inequality == other.inequality && Objects.equals(this.name, other.name) && Objects.equals(this.shortName, other.shortName) && this.startRow == other.startRow && Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }
}

