/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.time.StopWatch;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ColumnOrganizedAnnealingData;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.CoolingScheduleType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;

public class SerialSimulatedAnnealing
implements SimulatedAnnealing {
    protected static final String XML_METADATA_NAME = "SimulatedAnnealing";
    protected static final boolean D = false;
    protected static final boolean DD = false;
    private static final boolean ENERGY_SHORTCUT = true;
    private static final long ENERGY_SHORTCUT_DRIFT_MOD = 100000L;
    private static final boolean UNROLL_ENERGY_CALCS = true;
    private static final boolean ENERGY_SHORTCUT_DEBUG = false;
    private static final boolean COLUMN_MULT_SPEEDUP_DEBUG = false;
    private static final boolean XBEST_ACCURACY_CHECK = false;
    private double[] xbest_check_storage;
    private static CoolingScheduleType COOLING_FUNC_DEFAULT = CoolingScheduleType.FAST_SA;
    private CoolingScheduleType coolingFunc = COOLING_FUNC_DEFAULT;
    private static double coolingFuncSlowdown = 1.0;
    private static NonnegativityConstraintType NONNEGATIVITY_CONST_DEFAULT = NonnegativityConstraintType.LIMIT_ZERO_RATES;
    private NonnegativityConstraintType nonnegativityConstraintAlgorithm = NONNEGATIVITY_CONST_DEFAULT;
    private static GenerationFunctionType PERTURB_FUNC_DEFAULT = GenerationFunctionType.UNIFORM_0p0001;
    private GenerationFunctionType perturbationFunc = PERTURB_FUNC_DEFAULT;
    private IntegerSampler rupSampler = null;
    private double energyScaleFactor = 1.0;
    private boolean keepCurrentAsBest = false;
    private double[] variablePerturbBasis;
    private ColumnOrganizedAnnealingData equalityData;
    private ColumnOrganizedAnnealingData inequalityData;
    private double relativeSmoothnessWt;
    private boolean hasInequalityConstraint;
    private double[] xbest;
    private double[] misfit_best;
    private double[] misfit_ineq_best;
    private int numNonZero;
    private double[] Ebest;
    private List<ConstraintRange> constraintRanges;
    private Random r = new Random();
    private double[] initialState;
    private static final int ROLLS = 10;

    public SerialSimulatedAnnealing(DoubleMatrix2D A, double[] d, double[] initialState) {
        this(A, d, initialState, 0.0, null, null);
    }

    public SerialSimulatedAnnealing(DoubleMatrix2D A, double[] d, double[] initialState, double relativeSmoothnessWt, DoubleMatrix2D A_ineq, double[] d_ineq) {
        this(new ColumnOrganizedAnnealingData(A, d), A_ineq == null ? null : new ColumnOrganizedAnnealingData(A_ineq, d_ineq), initialState, relativeSmoothnessWt);
    }

    public SerialSimulatedAnnealing(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData, double[] initialState, double relativeSmoothnessWt) {
        this.relativeSmoothnessWt = relativeSmoothnessWt;
        this.setup(equalityData, inequalityData, initialState);
    }

    private void setup(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData, double[] initialState) {
        Preconditions.checkNotNull((Object)equalityData, (Object)"Equality data cannot be null");
        this.equalityData = equalityData;
        this.inequalityData = inequalityData;
        this.hasInequalityConstraint = inequalityData != null;
        Preconditions.checkNotNull((Object)initialState, (Object)"initial state cannot be null");
        Preconditions.checkArgument((initialState.length == equalityData.nCols ? 1 : 0) != 0, (Object)"initial state must be same lenth as nCol of A");
        if (inequalityData != null) {
            Preconditions.checkArgument((initialState.length == inequalityData.nCols ? 1 : 0) != 0, (Object)"initial state must be same lenth as nCol of A_ineq");
        }
        this.initialState = initialState;
        this.xbest = Arrays.copyOf(initialState, initialState.length);
        for (int i = 0; i < this.xbest.length; ++i) {
            Preconditions.checkState((this.xbest[i] >= 0.0 ? 1 : 0) != 0, (String)"initial solution has negative or NaN value: %s", (Object)this.xbest[i]);
            if (!(this.xbest[i] > 0.0)) continue;
            ++this.numNonZero;
        }
        this.misfit_best = new double[equalityData.nRows];
        SerialSimulatedAnnealing.calculateMisfit(equalityData, this.xbest, this.misfit_best);
        if (this.hasInequalityConstraint) {
            this.misfit_ineq_best = new double[inequalityData.nRows];
            SerialSimulatedAnnealing.calculateMisfit(inequalityData, this.xbest, this.misfit_ineq_best);
        }
        this.Ebest = this.calculateEnergy(this.xbest, this.misfit_best, this.misfit_ineq_best);
        this.rupSampler = new IntegerSampler.ContiguousIntegerSampler(initialState.length);
    }

    @Override
    public void setRandom(Random r) {
        this.r = r;
    }

    @Override
    public void setCalculationParams(CoolingScheduleType coolingFunc, NonnegativityConstraintType nonnegativeityConstraintAlgorithm, GenerationFunctionType perturbationFunc) {
        this.coolingFunc = coolingFunc;
        this.nonnegativityConstraintAlgorithm = nonnegativeityConstraintAlgorithm;
        this.perturbationFunc = perturbationFunc;
    }

    @Override
    public CoolingScheduleType getCoolingFunc() {
        return this.coolingFunc;
    }

    @Override
    public void setCoolingFunc(CoolingScheduleType coolingFunc) {
        this.coolingFunc = coolingFunc;
    }

    @Override
    public NonnegativityConstraintType getNonnegativeityConstraintAlgorithm() {
        return this.nonnegativityConstraintAlgorithm;
    }

    @Override
    public void setNonnegativeityConstraintAlgorithm(NonnegativityConstraintType nonnegativeityConstraintAlgorithm) {
        this.nonnegativityConstraintAlgorithm = nonnegativeityConstraintAlgorithm;
    }

    @Override
    public GenerationFunctionType getPerturbationFunc() {
        return this.perturbationFunc;
    }

    @Override
    public void setPerturbationFunc(GenerationFunctionType perturbationFunc) {
        this.perturbationFunc = perturbationFunc;
    }

    @Override
    public void setRuptureSampler(IntegerSampler rupSampler) {
        this.rupSampler = rupSampler;
    }

    @Override
    public void setVariablePerturbationBasis(double[] variablePerturbBasis) {
        Preconditions.checkArgument((variablePerturbBasis == null || variablePerturbBasis.length == this.xbest.length ? 1 : 0) != 0, (Object)"variablePerturbBasis must be either null of the same length as xbest");
        this.variablePerturbBasis = variablePerturbBasis;
    }

    @Override
    public double[] getBestSolution() {
        return this.xbest;
    }

    @Override
    public int getNumNonZero() {
        return this.numNonZero;
    }

    @Override
    public double[] getBestEnergy() {
        return this.Ebest;
    }

    @Override
    public double[] getBestMisfit() {
        return this.misfit_best;
    }

    @Override
    public double[] getBestInequalityMisfit() {
        return this.misfit_ineq_best;
    }

    @Override
    public void setResults(double[] Ebest, double[] xbest, double[] misfit_best, double[] misfit_ineq_best, int numNonZero) {
        this.Ebest = Arrays.copyOf(Ebest, Ebest.length);
        this.xbest = Arrays.copyOf(xbest, xbest.length);
        Preconditions.checkNotNull((Object)misfit_best, (Object)"Misfits must be supplied");
        this.misfit_best = Arrays.copyOf(misfit_best, misfit_best.length);
        if (this.hasInequalityConstraint) {
            Preconditions.checkNotNull((Object)misfit_ineq_best, (Object)"Inequality misfits must be supplied");
            this.misfit_ineq_best = Arrays.copyOf(misfit_ineq_best, misfit_ineq_best.length);
        }
        this.numNonZero = numNonZero;
    }

    @Override
    public void setResults(double[] Ebest, double[] xbest) {
        int numNonZero = 0;
        for (double x : xbest) {
            if (!(x > 0.0)) continue;
            ++numNonZero;
        }
        this.setResults(Ebest, xbest, null, null, numNonZero);
    }

    @Override
    public void setConstraintRanges(List<ConstraintRange> constraintRanges) {
        this.constraintRanges = constraintRanges;
    }

    @Override
    public List<ConstraintRange> getConstraintRanges() {
        return this.constraintRanges;
    }

    public static void calculateMisfit(ColumnOrganizedAnnealingData data, double[] solution, double[] misfit) {
        SerialSimulatedAnnealing.calculateMisfit(data.A, data.d, solution, misfit);
    }

    public static void calculateMisfit(DoubleMatrix2D mat, double[] data, double[] solution, double[] misfit) {
        DenseDoubleMatrix1D sol_clone = new DenseDoubleMatrix1D(solution);
        DenseDoubleMatrix1D syn = new DenseDoubleMatrix1D(mat.rows());
        mat.zMult((DoubleMatrix1D)sol_clone, (DoubleMatrix1D)syn);
        for (int i = 0; i < mat.rows(); ++i) {
            misfit[i] = syn.get(i) - data[i];
        }
    }

    private static double updateMisfitsCalcDeltaEnergy(ColumnOrganizedAnnealingData inputs, double[] misfits, int perturbCol, double perturbation, boolean ineq, double[] scratch) {
        double[] As = inputs.colA_values[perturbCol];
        int[] rows = inputs.colRows[perturbCol];
        int NUM = rows.length;
        Preconditions.checkState((scratch.length >= NUM ? 1 : 0) != 0);
        for (int i = 0; i < NUM; ++i) {
            scratch[i] = misfits[rows[i]];
        }
        double prevE = ineq ? SerialSimulatedAnnealing.sumSquaresIneq(scratch, NUM) : SerialSimulatedAnnealing.sumSquaresUnrolled(scratch, NUM);
        SerialSimulatedAnnealing.updateMisfits(misfits, perturbation, scratch, As, rows, NUM);
        if (ineq) {
            return SerialSimulatedAnnealing.sumSquaresIneq(scratch, NUM) - prevE;
        }
        return SerialSimulatedAnnealing.sumSquaresUnrolled(scratch, NUM) - prevE;
    }

    private static void updateMisfits(double[] misfits, double perturbation, double[] scratch, double[] As, int[] rows, int NUM) {
        for (int i = 0; i < NUM; ++i) {
            misfits[rows[i]] = Math.fma(As[i], perturbation, misfits[rows[i]]);
            scratch[i] = misfits[rows[i]];
        }
    }

    private static double sumSquares(double[] values, int NUM) {
        double ret = 0.0;
        for (int i = 0; i < NUM; ++i) {
            ret = Math.fma(values[i], values[i], ret);
        }
        return ret;
    }

    private static double sumSquaresUnrolled(double[] values, int NUM) {
        int i;
        int ROUNDS = NUM / 10;
        if (ROUNDS < 2) {
            return SerialSimulatedAnnealing.sumSquares(values, NUM);
        }
        double s0 = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double s4 = 0.0;
        double s5 = 0.0;
        double s6 = 0.0;
        double s7 = 0.0;
        double s8 = 0.0;
        double s9 = 0.0;
        for (int r = 0; r < ROUNDS; ++r) {
            i = r * 10;
            s0 = Math.fma(values[i], values[i], s0);
            s1 = Math.fma(values[i + 1], values[i + 1], s1);
            s2 = Math.fma(values[i + 2], values[i + 2], s2);
            s3 = Math.fma(values[i + 3], values[i + 3], s3);
            s4 = Math.fma(values[i + 4], values[i + 4], s4);
            s5 = Math.fma(values[i + 5], values[i + 5], s5);
            s6 = Math.fma(values[i + 6], values[i + 6], s6);
            s7 = Math.fma(values[i + 7], values[i + 7], s7);
            s8 = Math.fma(values[i + 8], values[i + 8], s8);
            s9 = Math.fma(values[i + 9], values[i + 9], s9);
        }
        double ret = s0 + s1 + s2 + s3 + s4 + s5 + s6 + s7 + s8 + s9;
        for (i = ROUNDS * 10; i < NUM; ++i) {
            ret = Math.fma(values[i], values[i], ret);
        }
        return ret;
    }

    private static double sumSquaresIneq(double[] values, int NUM) {
        double ret = 0.0;
        for (int i = 0; i < NUM; ++i) {
            double val = values[i];
            if (!(val > 0.0)) continue;
            ret = Math.fma(val, val, ret);
        }
        return ret;
    }

    @Override
    public double[] calculateEnergy(double[] solution) {
        double[] misfit = new double[this.equalityData.nRows];
        SerialSimulatedAnnealing.calculateMisfit(this.equalityData, solution, misfit);
        double[] misfit_ineq = null;
        if (this.hasInequalityConstraint) {
            misfit_ineq = new double[this.inequalityData.nRows];
            SerialSimulatedAnnealing.calculateMisfit(this.inequalityData, solution, misfit_ineq);
        }
        return this.calculateEnergy(solution, misfit, misfit_ineq);
    }

    @Override
    public double[] calculateEnergy(double[] solution, double[] misfit, double[] misfit_ineq, List<ConstraintRange> constraintRanges) {
        int ineqRows = this.hasInequalityConstraint ? this.inequalityData.nRows : 0;
        return SerialSimulatedAnnealing.calculateEnergy(solution, misfit, misfit_ineq, this.equalityData.nRows, this.equalityData.nCols, ineqRows, constraintRanges, this.relativeSmoothnessWt);
    }

    @Override
    public double[] calculateEnergy(double[] solution, double[] misfit, double[] misfit_ineq) {
        int ineqRows = this.hasInequalityConstraint ? this.inequalityData.nRows : 0;
        return SerialSimulatedAnnealing.calculateEnergy(solution, misfit, misfit_ineq, this.equalityData.nRows, this.equalityData.nCols, ineqRows, this.constraintRanges, this.relativeSmoothnessWt);
    }

    public static double[] calculateEnergy(double[] solution, double[] misfit, double[] misfit_ineq, int nRow, int nCol, int ineqRows, List<ConstraintRange> constraintRanges, double relativeSmoothnessWt) {
        double Enew;
        double[] ret;
        double Eequality = 0.0;
        if (constraintRanges == null) {
            ret = new double[4];
            Eequality = SerialSimulatedAnnealing.sumSquaresUnrolled(misfit, nRow);
        } else {
            ret = new double[4 + constraintRanges.size()];
            for (int i = 0; i < nRow; ++i) {
                double val = misfit[i] * misfit[i];
                Eequality += val;
                for (int j = 0; j < constraintRanges.size(); ++j) {
                    if (!constraintRanges.get(j).contains(i, false)) continue;
                    int n = j + 4;
                    ret[n] = ret[n] + val;
                }
            }
        }
        ret[1] = Eequality;
        Preconditions.checkState((!Double.isNaN(Eequality) ? 1 : 0) != 0, (Object)"energy from equality constraints is NaN!");
        double Eentropy = 0.0;
        if (relativeSmoothnessWt > 0.0) {
            ret[2] = Eentropy = SerialSimulatedAnnealing.calcEntropyEnergy(solution, relativeSmoothnessWt);
        }
        double Einequality = 0.0;
        if (ineqRows > 0) {
            if (constraintRanges == null) {
                Einequality = SerialSimulatedAnnealing.sumSquaresIneq(misfit_ineq, ineqRows);
            } else {
                for (int i = 0; i < ineqRows; ++i) {
                    if (!(misfit_ineq[i] > 0.0)) continue;
                    double val = misfit_ineq[i] * misfit_ineq[i];
                    Einequality += val;
                    for (int j = 0; j < constraintRanges.size(); ++j) {
                        if (!constraintRanges.get(j).contains(i, true)) continue;
                        int n = j + 4;
                        ret[n] = ret[n] + val;
                    }
                }
            }
            Preconditions.checkState((!Double.isNaN(Einequality) ? 1 : 0) != 0, (Object)"energy from inequality constraints is NaN!");
            ret[3] = Einequality;
        }
        Preconditions.checkState((!Double.isNaN(Enew = Eequality + Eentropy + Einequality) ? 1 : 0) != 0, (Object)"Enew is NaN!");
        ret[0] = Enew;
        return ret;
    }

    public static double calcEntropyEnergy(double[] solution, double relativeSmoothnessWt) {
        double Eentropy = 0.0;
        double totalEntropy = 0.0;
        double entropyConstant = 500.0;
        for (int rup = 0; rup < solution.length; ++rup) {
            if (!(solution[rup] > 0.0)) continue;
            totalEntropy -= entropyConstant * solution[rup] * Math.log(entropyConstant * solution[rup]);
        }
        if (totalEntropy == 0.0) {
            System.out.println("ZERO ENTROPY!");
            totalEntropy = 1.0E-4;
        }
        if (totalEntropy < 0.0) {
            throw new IllegalStateException("NEGATIVE ENTROPY!");
        }
        Preconditions.checkState((!Double.isNaN(Eentropy += relativeSmoothnessWt * (1.0 / totalEntropy)) ? 1 : 0) != 0, (Object)"energy from entropy constraint is NaN!");
        return Eentropy;
    }

    @Override
    public synchronized InversionState iterate(long numIterations) {
        return this.iterate(new IterationCompletionCriteria(numIterations));
    }

    @Override
    public synchronized InversionState iterate(CompletionCriteria completion) {
        return this.iterate(null, completion);
    }

    @Override
    public synchronized InversionState iterate(InversionState startingState, CompletionCriteria criteria) {
        double[] scratch;
        long startWorseKept;
        boolean rangeTrack;
        StopWatch watch = new StopWatch();
        watch.start();
        boolean bl = rangeTrack = this.constraintRanges != null && !this.constraintRanges.isEmpty();
        if (rangeTrack && criteria instanceof ProgressTrackingCompletionCriteria) {
            ((ProgressTrackingCompletionCriteria)criteria).setConstraintRanges(this.constraintRanges);
        }
        long startIter = startingState == null ? 0L : startingState.iterations;
        long startPerturbs = startingState == null ? 0L : startingState.numPerturbsKept;
        long l = startWorseKept = startingState == null ? 0L : startingState.numWorseValuesKept;
        if (rangeTrack && startIter == 0L && this.Ebest.length == 4) {
            this.Ebest = this.calculateEnergy(this.xbest, this.misfit_best, this.misfit_ineq_best);
        }
        long iter = startIter + 1L;
        long perturbs = startPerturbs;
        long worseKept = startWorseKept;
        double[] x = Arrays.copyOf(this.xbest, this.xbest.length);
        int curNumNonZero = this.numNonZero;
        double[] E = this.Ebest;
        int nCol = this.xbest.length;
        Preconditions.checkNotNull((Object)this.misfit_best);
        double[] misfit_working = Arrays.copyOf(this.misfit_best, this.misfit_best.length);
        double[] misfit_perturbed = Arrays.copyOf(this.misfit_best, this.misfit_best.length);
        double[] misfit_working_ineq = null;
        double[] misfit_perturbed_ineq = null;
        if (this.hasInequalityConstraint) {
            Preconditions.checkNotNull((Object)this.misfit_ineq_best);
            misfit_working_ineq = Arrays.copyOf(this.misfit_ineq_best, this.misfit_ineq_best.length);
            misfit_perturbed_ineq = Arrays.copyOf(this.misfit_ineq_best, this.misfit_ineq_best.length);
        }
        if (this.hasInequalityConstraint) {
            int maxCount = Integer.max(this.equalityData.maxRowsPerCol, this.inequalityData.maxRowsPerCol);
            scratch = new double[maxCount];
        } else {
            scratch = new double[this.equalityData.maxRowsPerCol];
        }
        int curPerturbChainSize = 0;
        int[] curPertubChain = new int[1000];
        long worseValsNotYetSaved = 0L;
        double worstEnergyShortcutFract = 0.0;
        double worstEnergyShortcutAbs = 0.0;
        long iterPrintMod = 1L;
        InversionState state = null;
        while (!criteria.isSatisfied(state = new InversionState(watch.getTime(), iter - 1L, this.Ebest, perturbs, worseKept, this.numNonZero, this.xbest, this.misfit_best, this.misfit_ineq_best, this.constraintRanges))) {
            int row;
            int n;
            double P;
            double T;
            double coolIter = iter;
            if (coolingFuncSlowdown != 1.0) {
                coolIter = ((double)iter - 1.0) / coolingFuncSlowdown + 1.0;
            }
            switch (this.coolingFunc) {
                case CLASSICAL_SA: {
                    T = 1.0 / Math.log(coolIter + 1.0);
                    break;
                }
                case FAST_SA: {
                    T = 1.0 / coolIter;
                    break;
                }
                case VERYFAST_SA: {
                    T = Math.exp(-(coolIter - 1.0));
                    break;
                }
                case LINEAR: {
                    T = 1.0 - coolIter / 100000.0;
                    break;
                }
                default: {
                    throw new IllegalStateException("It's impossible to get here, as long as all cooling schedule enum cases are stated above!");
                }
            }
            int index = this.rupSampler.getRandomInt(this.r);
            double perturb = this.perturbationFunc.getPerturbation(this.r, T, index, this.variablePerturbBasis);
            boolean wasZero = x[index] == 0.0;
            switch (this.nonnegativityConstraintAlgorithm) {
                case TRY_ZERO_RATES_OFTEN: {
                    if (wasZero) {
                        while (x[index] + perturb < 0.0) {
                            perturb = this.perturbationFunc.getPerturbation(this.r, T, index, this.variablePerturbBasis);
                        }
                        break;
                    }
                    if (!(x[index] + perturb < 0.0)) break;
                    perturb = -x[index];
                    break;
                }
                case LIMIT_ZERO_RATES: {
                    while (x[index] + perturb < 0.0) {
                        perturb = this.perturbationFunc.getPerturbation(this.r, T, index, this.variablePerturbBasis);
                    }
                    break;
                }
                case PREVENT_ZERO_RATES: {
                    if (!wasZero) {
                        perturb = (this.r.nextDouble() - 0.5) * 2.0 * x[index];
                        break;
                    }
                    perturb = this.r.nextDouble() * 1.0E-8;
                    break;
                }
                default: {
                    throw new IllegalStateException("You missed a Nonnegativity Constraint Algorithm type.");
                }
            }
            if (iter % 100000L == 0L) {
                E = this.calculateEnergy(x, misfit_working, misfit_working_ineq);
            }
            double prevX = x[index];
            int n2 = index;
            x[n2] = x[n2] + perturb;
            double deltaE = SerialSimulatedAnnealing.updateMisfitsCalcDeltaEnergy(this.equalityData, misfit_perturbed, index, perturb, false, scratch);
            double deltaE_ineq = Double.NaN;
            if (this.hasInequalityConstraint) {
                deltaE_ineq = SerialSimulatedAnnealing.updateMisfitsCalcDeltaEnergy(this.inequalityData, misfit_perturbed_ineq, index, perturb, true, scratch);
            }
            double energyChange = deltaE;
            double[] Enew = new double[4];
            Enew[0] = E[0] + deltaE;
            Enew[1] = E[1] + deltaE;
            if (this.hasInequalityConstraint) {
                Preconditions.checkState((boolean)Double.isFinite(deltaE_ineq));
                Enew[0] = Enew[0] + deltaE_ineq;
                Enew[3] = E[3] + deltaE_ineq;
                energyChange += deltaE_ineq;
            }
            if (this.relativeSmoothnessWt != 0.0) {
                Enew[2] = SerialSimulatedAnnealing.calcEntropyEnergy(x, this.relativeSmoothnessWt);
                Enew[0] = Enew[0] + Enew[2];
                energyChange += Enew[2] - E[2];
            }
            switch (this.nonnegativityConstraintAlgorithm) {
                case PREVENT_ZERO_RATES: {
                    if (energyChange < 0.0 || x[index] == 0.0) {
                        P = 1.0;
                        break;
                    }
                    P = Math.exp(-energyChange * this.energyScaleFactor / T);
                    break;
                }
                default: {
                    P = energyChange < 0.0 ? 1.0 : Math.exp(-energyChange * this.energyScaleFactor / T);
                }
            }
            if (P == 1.0 || P > this.r.nextDouble()) {
                if (energyChange > 0.0) {
                    ++worseValsNotYetSaved;
                }
                E = Enew;
                int[] nArray = this.equalityData.colRows[index];
                int n3 = nArray.length;
                for (n = 0; n < n3; ++n) {
                    row = nArray[n];
                    misfit_working[row] = misfit_perturbed[row];
                }
                if (this.hasInequalityConstraint) {
                    nArray = this.inequalityData.colRows[index];
                    n3 = nArray.length;
                    for (n = 0; n < n3; ++n) {
                        row = nArray[n];
                        misfit_working_ineq[row] = misfit_perturbed_ineq[row];
                    }
                }
                ++perturbs;
                Preconditions.checkState((x[index] >= 0.0 ? 1 : 0) != 0, (String)"bad x[%s]=%s", (Object)index, (Object)x[index]);
                int prevNonZero = curNumNonZero--;
                if (wasZero) {
                    if (x[index] != 0.0) {
                        Preconditions.checkState((curNumNonZero < this.xbest.length ? 1 : 0) != 0, (String)"Non-zero count (%s) already at 100% (%s). new x[%s]=%s, prev=%s", (Object[])new Object[]{curNumNonZero, this.xbest.length, index, x[index], prevX});
                        ++curNumNonZero;
                    }
                } else if (x[index] == 0.0) {
                    // empty if block
                }
                if (curPerturbChainSize >= curPertubChain.length) {
                    curPertubChain = Arrays.copyOf(curPertubChain, curPerturbChainSize + 1000);
                }
                curPertubChain[curPerturbChainSize] = index;
                ++curPerturbChainSize;
                if (Enew[0] < this.Ebest[0] || this.keepCurrentAsBest) {
                    int row2;
                    for (int i = 0; i < curPerturbChainSize; ++i) {
                        this.xbest[curPertubChain[i]] = x[curPertubChain[i]];
                    }
                    curPerturbChainSize = 0;
                    int[] nArray2 = this.equalityData.colRows[index];
                    n = nArray2.length;
                    for (row = 0; row < n; ++row) {
                        row2 = nArray2[row];
                        this.misfit_best[row2] = misfit_perturbed[row2];
                    }
                    if (this.hasInequalityConstraint) {
                        nArray2 = this.inequalityData.colRows[index];
                        n = nArray2.length;
                        for (row = 0; row < n; ++row) {
                            row2 = nArray2[row];
                            this.misfit_ineq_best[row2] = misfit_perturbed_ineq[row2];
                        }
                    }
                    if (this.constraintRanges != null && !this.constraintRanges.isEmpty()) {
                        Enew = this.calculateEnergy(x, misfit_perturbed, misfit_perturbed_ineq);
                    }
                    this.Ebest = Enew;
                    this.numNonZero = curNumNonZero;
                    worseKept += worseValsNotYetSaved;
                    worseValsNotYetSaved = 0L;
                }
            } else {
                x[index] = prevX;
                int[] nArray = this.equalityData.colRows[index];
                int n4 = nArray.length;
                for (n = 0; n < n4; ++n) {
                    row = nArray[n];
                    misfit_perturbed[row] = misfit_working[row];
                }
                if (this.hasInequalityConstraint) {
                    nArray = this.inequalityData.colRows[index];
                    n4 = nArray.length;
                    for (n = 0; n < n4; ++n) {
                        row = nArray[n];
                        misfit_perturbed_ineq[row] = misfit_working_ineq[row];
                    }
                }
            }
            ++iter;
        }
        watch.stop();
        this.Ebest = this.calculateEnergy(this.xbest, this.misfit_best, this.misfit_ineq_best);
        return state;
    }

    private static String enumOptionsStr(Enum<?>[] values) {
        Object str = null;
        for (Enum<?> e : values) {
            str = str == null ? "" : (String)str + ",";
            str = (String)str + e.name();
        }
        return str;
    }

    protected static Options createOptions() {
        Options ops = new Options();
        Option coolingOption = new Option("cool", "cooling-schedule", true, "Cooling schedule. One of: " + SerialSimulatedAnnealing.enumOptionsStr(CoolingScheduleType.values()) + ". Default: " + String.valueOf((Object)COOLING_FUNC_DEFAULT));
        coolingOption.setRequired(false);
        ops.addOption(coolingOption);
        Option perturbOption = new Option("perturb", "perturbation-function", true, "Cooling schedule. One of: " + SerialSimulatedAnnealing.enumOptionsStr(GenerationFunctionType.values()) + ". Default: " + String.valueOf((Object)PERTURB_FUNC_DEFAULT));
        perturbOption.setRequired(false);
        ops.addOption(perturbOption);
        Option nonNegOption = new Option("nonneg", "nonnegativity-const", true, "Nonnegativity constraint. One of: " + SerialSimulatedAnnealing.enumOptionsStr(NonnegativityConstraintType.values()) + ". Default: " + String.valueOf((Object)NONNEGATIVITY_CONST_DEFAULT));
        nonNegOption.setRequired(false);
        ops.addOption(nonNegOption);
        Option curAsBestOption = new Option("curbest", "cur-as-best", false, "Flag for keeping current solution as best, even if it's not the best seen.");
        curAsBestOption.setRequired(false);
        ops.addOption(curAsBestOption);
        Option slowerOption = new Option("slow", "slower-cooling", true, "If supplied, the iteration count seen by the cooling function will be divided by the given amount");
        slowerOption.setRequired(false);
        ops.addOption(slowerOption);
        Option energyScaleOption = new Option("energyscale", "energy-scale", true, "If supplied, this effectively makes changes in energies smaller (increasing the prob a jump will be taken to higher E). Increase to take more jumps early in annealing");
        energyScaleOption.setRequired(false);
        ops.addOption(energyScaleOption);
        return ops;
    }

    protected void setCalculationParamsFromOptions(CommandLine cmd) {
        if (cmd.hasOption("cool")) {
            this.coolingFunc = CoolingScheduleType.valueOf(cmd.getOptionValue("cool"));
        }
        if (cmd.hasOption("slow")) {
            coolingFuncSlowdown = Double.parseDouble(cmd.getOptionValue("slow"));
        }
        if (cmd.hasOption("perturb")) {
            this.perturbationFunc = GenerationFunctionType.valueOf(cmd.getOptionValue("perturb"));
        }
        if (cmd.hasOption("nonneg")) {
            this.nonnegativityConstraintAlgorithm = NonnegativityConstraintType.valueOf(cmd.getOptionValue("nonneg"));
        }
        if (cmd.hasOption("curbest")) {
            this.keepCurrentAsBest = true;
        }
        if (cmd.hasOption("energyscale")) {
            this.energyScaleFactor = Double.parseDouble(cmd.getOptionValue("energyscale"));
        }
    }

    @Override
    public double[] getInitialSolution() {
        return this.initialState;
    }

    @Override
    public ColumnOrganizedAnnealingData getEqualityData() {
        return this.equalityData;
    }

    @Override
    public DoubleMatrix2D getA() {
        return this.equalityData.A;
    }

    @Override
    public double[] getD() {
        return this.equalityData.d;
    }

    @Override
    public ColumnOrganizedAnnealingData getInequalityData() {
        return this.inequalityData;
    }

    @Override
    public DoubleMatrix2D getA_ineq() {
        return this.inequalityData == null ? null : this.inequalityData.A;
    }

    @Override
    public double[] getD_ineq() {
        return this.inequalityData == null ? null : this.inequalityData.d;
    }

    @Override
    public void setInputs(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData) {
        this.setup(equalityData, inequalityData, this.xbest);
    }

    @Override
    public void setAll(ColumnOrganizedAnnealingData equalityData, ColumnOrganizedAnnealingData inequalityData, double[] Ebest, double[] xbest, double[] misfit, double[] misfit_ineq, int numNonZero) {
        this.equalityData = equalityData;
        this.inequalityData = inequalityData;
        this.setResults(Ebest, xbest, misfit, misfit_ineq, numNonZero);
    }
}

