/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import com.google.common.base.Splitter;
import java.util.Iterator;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;

public class EnergyChangeCompletionCriteria
implements CompletionCriteria {
    private double energyDelta;
    private double energyPercentDelta;
    private double lookBackMins;
    private transient double lookBackStart = -1.0;
    private ArbitrarilyDiscretizedFunc energyVsTime = new ArbitrarilyDiscretizedFunc();

    public EnergyChangeCompletionCriteria(double energyDelta, double energyPercentDelta, double lookBackMins) {
        if (energyDelta <= 0.0) {
            energyDelta = Double.POSITIVE_INFINITY;
        }
        if (energyPercentDelta <= 0.0) {
            energyPercentDelta = Double.POSITIVE_INFINITY;
        }
        this.energyDelta = energyDelta;
        this.energyPercentDelta = energyPercentDelta;
        this.lookBackMins = lookBackMins;
    }

    @Override
    public boolean isSatisfied(InversionState state) {
        double mins = (double)state.elapsedTimeMillis / 1000.0 / 60.0;
        double e = state.energy[0];
        this.energyVsTime.set(mins, e);
        if (this.lookBackStart <= 0.0) {
            this.lookBackStart = this.energyVsTime.getMinX() + this.lookBackMins;
        }
        if (mins > this.lookBackStart) {
            double prevE = this.energyVsTime.getInterpolatedY(mins - this.lookBackMins);
            double delta = prevE - e;
            if (delta > this.energyDelta) {
                return false;
            }
            double pDiff = DataUtils.getPercentDiff(e, prevE);
            return pDiff <= this.energyPercentDelta;
        }
        return false;
    }

    public static EnergyChangeCompletionCriteria fromCommandLineArgument(String arg) {
        Iterator it = Splitter.on((char)',').split((CharSequence)arg).iterator();
        long millis = TimeCompletionCriteria.parseTimeString((String)it.next());
        double lookBackMins = (double)millis / 1000.0 / 60.0;
        double energyPercentDelta = Double.parseDouble((String)it.next());
        double energyDelta = Double.parseDouble((String)it.next());
        return new EnergyChangeCompletionCriteria(energyDelta, energyPercentDelta, lookBackMins);
    }

    public String toCommandLineArgument() {
        String time = TimeCompletionCriteria.getTimeStr((long)(this.lookBackMins * 60.0 * 1000.0 + 0.5));
        return time + "," + (float)this.energyPercentDelta + "," + (float)this.energyDelta;
    }

    public String toString() {
        return "EnergyChangeCompletionCriteria [energyDelta=" + this.energyDelta + ", energyPercentDelta=" + this.energyPercentDelta + ", lookBackMins=" + this.lookBackMins + "]";
    }
}

