/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;

public class ProgressTrackingCompletionCriteria
implements CompletionCriteria {
    private AnnealingProgress progress;
    private CompletionCriteria criteria;
    private long autoPlotMillis;
    private long nextPlotMillis;
    private transient GraphWindow gw;
    private transient ArrayList<ArbitrarilyDiscretizedFunc> funcs;
    private transient String plotTitle;
    private File automaticFile;
    private transient List<ConstraintRange> constraintRanges;
    private long iterMod = 0L;

    public ProgressTrackingCompletionCriteria(CompletionCriteria criteria) {
        this(criteria, null, 0.0);
    }

    public ProgressTrackingCompletionCriteria(CompletionCriteria criteria, double autoPlotMins) {
        this(criteria, null, autoPlotMins);
    }

    public ProgressTrackingCompletionCriteria(CompletionCriteria criteria, File automaticFile) {
        this(criteria, automaticFile, 0.0);
    }

    public ProgressTrackingCompletionCriteria(CompletionCriteria criteria, File automaticFile, double autoPlotMins) {
        this.criteria = criteria;
        this.automaticFile = automaticFile;
        if (autoPlotMins > 0.0) {
            this.nextPlotMillis = this.autoPlotMillis = (long)(autoPlotMins * 60.0 * 1000.0);
        } else {
            this.autoPlotMillis = 0L;
            this.nextPlotMillis = -1L;
        }
    }

    public AnnealingProgress getProgress() {
        return this.progress;
    }

    public synchronized void writeFile(File file) throws IOException {
        this.progress.getCSV().writeToFile(file);
    }

    @Override
    public boolean isSatisfied(InversionState state) {
        if (this.progress == null) {
            this.progress = AnnealingProgress.forConstraintRanges(this.constraintRanges);
        }
        if (state.energy[0] < Double.MAX_VALUE && (this.iterMod <= 0L || state.iterations % this.iterMod == 0L)) {
            this.progress.addProgress(state);
        }
        if (this.autoPlotMillis > 0L && state.elapsedTimeMillis > this.nextPlotMillis) {
            try {
                this.updatePlot();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.nextPlotMillis = state.elapsedTimeMillis + this.autoPlotMillis;
        }
        if (this.criteria.isSatisfied(state)) {
            if (this.automaticFile != null) {
                System.out.println("Criteria satisfied with time=" + (float)state.elapsedTimeMillis / 60000.0f + " min, iter=" + state.iterations + ", energy=" + state.energy[0] + ", pertubs kept=" + state.numPerturbsKept);
                System.out.println("Writing progress to file: " + this.automaticFile.getAbsolutePath());
                try {
                    this.writeFile(this.automaticFile);
                }
                catch (Exception e) {
                    System.err.println("Error writing results file!");
                    e.printStackTrace();
                }
                System.out.println("Done writing progress file (" + this.progress.size() + " entries)");
            }
            return true;
        }
        return false;
    }

    public void setPlotTitle(String plotTitle) {
        this.plotTitle = plotTitle;
    }

    private void updatePlot() {
        if (this.progress == null || this.progress.size() == 0) {
            return;
        }
        if (this.gw == null) {
            this.funcs = new ArrayList();
            this.funcs.add(new ArbitrarilyDiscretizedFunc("Total Energy"));
            this.funcs.add(new ArbitrarilyDiscretizedFunc("Equality Energy"));
            this.funcs.add(new ArbitrarilyDiscretizedFunc("Entropy Energy"));
            this.funcs.add(new ArbitrarilyDiscretizedFunc("Inequality Energy"));
            if (this.constraintRanges != null) {
                for (ConstraintRange name : this.constraintRanges) {
                    this.funcs.add(new ArbitrarilyDiscretizedFunc(name.shortName + " Energy"));
                }
            } else {
                for (int i = 4; i < this.progress.getEnergies(0).length; ++i) {
                    this.funcs.add(new ArbitrarilyDiscretizedFunc("Unknown Energy " + (i + 1)));
                }
            }
            ArrayList<PlotCurveCharacterstics> chars = SimulatedAnnealing.getEnergyBreakdownChars();
            this.updatePlotFuncs();
            Object title = "Energy vs Iterations";
            if (this.plotTitle != null) {
                title = (String)title + " (" + this.plotTitle + ")";
            }
            this.gw = new GraphWindow(this.funcs, (String)title, chars);
        } else {
            this.updatePlotFuncs();
            this.gw.getGraphWidget().drawGraph();
        }
        ArbitrarilyDiscretizedFunc equalityFunc = this.funcs.get(1);
        double maxEqualityEnergy = equalityFunc.getY(0);
        if (this.progress.getEnergies(this.progress.size() - 1)[0] < maxEqualityEnergy) {
            this.gw.setAxisRange(0.0, equalityFunc.getX(equalityFunc.size() - 1) * 1.1, 0.0, maxEqualityEnergy * 1.2);
        } else {
            this.gw.setAutoRange();
        }
    }

    private void updatePlotFuncs() {
        int start;
        for (int i = start = this.funcs.get(0).size(); i < this.progress.size(); ++i) {
            long iter = this.progress.getIterations(i);
            double[] energy = this.progress.getEnergies(i);
            for (int j = 0; j < energy.length; ++j) {
                this.funcs.get(j).set(iter, energy[j]);
            }
        }
        for (ArbitrarilyDiscretizedFunc func : this.funcs) {
            func.setInfo("Final Energy: " + func.getY(func.size() - 1));
        }
    }

    public String toString() {
        return this.criteria.toString();
    }

    public void setConstraintRanges(List<ConstraintRange> constraintRanges) {
        this.constraintRanges = constraintRanges;
    }

    public CompletionCriteria getCriteria() {
        return this.criteria;
    }

    public void setIterationModulus(long iterMod) {
        this.iterMod = iterMod;
    }
}

