/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import org.apache.commons.lang3.time.StopWatch;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.VariableSubCompletionCriteria;

public class VariableSubTimeCompletionCriteria
implements VariableSubCompletionCriteria {
    private long min;
    private long max;
    private long minMaxDiff;
    private long cur;
    private CompletionCriteria globalCriteria;

    public VariableSubTimeCompletionCriteria(long maxMillis, long minMillis) {
        this.max = maxMillis;
        this.min = minMillis;
        this.minMaxDiff = maxMillis - minMillis;
        this.cur = 0L;
    }

    @Override
    public boolean isSatisfied(InversionState state) {
        return state.elapsedTimeMillis >= this.cur;
    }

    @Override
    public void setGlobalState(StopWatch watch, long iter, double[] energy, long numPerturbsKept) {
        if (this.globalCriteria instanceof TimeCompletionCriteria) {
            long time = watch.getTime();
            long total = ((TimeCompletionCriteria)this.globalCriteria).getMillis();
            long timeLeft = total - time;
            if (timeLeft < 0L) {
                timeLeft = 0L;
            }
            this.cur = this.min + timeLeft * this.minMaxDiff / total;
        } else if (this.globalCriteria instanceof IterationCompletionCriteria) {
            long total = ((IterationCompletionCriteria)this.globalCriteria).getMinIterations();
            long itersLeft = total - iter;
            if (itersLeft < 0L) {
                itersLeft = 0L;
            }
            this.cur = this.min + itersLeft * this.minMaxDiff / total;
        } else {
            throw new IllegalStateException("Unupported global criteria: " + String.valueOf(this.globalCriteria));
        }
    }

    public String toString() {
        return "VariableSubTimeCompletionCriteria(" + (this.min + this.minMaxDiff) + " => " + this.min + ", cur = " + this.cur + " = " + (float)((double)this.cur / 1000.0) + " seconds)";
    }

    @Override
    public void setGlobalCriteria(CompletionCriteria criteria) {
        if (criteria instanceof ProgressTrackingCompletionCriteria) {
            criteria = ((ProgressTrackingCompletionCriteria)criteria).getCriteria();
        }
        this.globalCriteria = criteria;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public String getTimeStr() {
        return TimeCompletionCriteria.getTimeStr(this.max) + "," + TimeCompletionCriteria.getTimeStr(this.min);
    }

    public static VariableSubTimeCompletionCriteria instance(String maxStr, String minStr) {
        return new VariableSubTimeCompletionCriteria(TimeCompletionCriteria.parseTimeString(maxStr), TimeCompletionCriteria.parseTimeString(minStr));
    }
}

