/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class AveSlipModule
implements SubModule<FaultSystemRupSet>,
BranchAverageableModule<AveSlipModule>,
SplittableRuptureModule<AveSlipModule> {
    FaultSystemRupSet rupSet;
    public static final String DATA_FILE_NAME = "average_slips.csv";

    protected AveSlipModule(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }

    public static AveSlipModule forModel(FaultSystemRupSet rupSet, RupSetScalingRelationship scale) {
        return new ModelBased(rupSet, scale);
    }

    public static AveSlipModule precomputed(FaultSystemRupSet rupSet, double[] aveSlips) {
        return new Precomputed(rupSet, aveSlips);
    }

    public abstract double getAveSlip(int var1);

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        if (this.rupSet != null) {
            Preconditions.checkState((this.rupSet.getNumRuptures() == parent.getNumRuptures() ? 1 : 0) != 0);
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    public static class ModelBased
    extends AveSlipModule
    implements ArchivableModule {
        private RupSetScalingRelationship scale;
        private transient double[] cache;

        protected ModelBased(FaultSystemRupSet rupSet, RupSetScalingRelationship scale) {
            super(rupSet);
            this.scale = scale;
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            new Precomputed(this).writeToArchive(output, entryPrefix);
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            throw new IllegalStateException("Only pre-computed average slip modules can be loaded");
        }

        @Override
        public Class<? extends ArchivableModule> getLoadingClass() {
            return Precomputed.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getAveSlip(int rupIndex) {
            double aveSlip;
            if (this.cache == null) {
                ModelBased modelBased = this;
                synchronized (modelBased) {
                    if (this.cache == null) {
                        Preconditions.checkNotNull((Object)this.rupSet, (Object)"Parent rupture set not set");
                        this.cache = new double[this.rupSet.getNumRuptures()];
                    }
                }
            }
            if (this.cache[rupIndex] != 0.0) {
                return this.cache[rupIndex];
            }
            Preconditions.checkNotNull((Object)this.rupSet, (Object)"Parent rupture set not set");
            double totArea = this.rupSet.getAreaForRup(rupIndex);
            double length = this.rupSet.getLengthForRup(rupIndex);
            double width = totArea / length;
            double totOrigArea = 0.0;
            for (FaultSection sect : this.rupSet.getFaultSectionDataForRupture(rupIndex)) {
                totOrigArea += sect.getArea(false);
            }
            double origDDW = totOrigArea / this.rupSet.getLengthForRup(rupIndex);
            double aveRake = this.rupSet.getAveRakeForRup(rupIndex);
            this.cache[rupIndex] = aveSlip = this.scale.getAveSlip(totArea, length, width, origDDW, aveRake);
            return aveSlip;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkState((this.rupSet.getNumRuptures() == newParent.getNumRuptures() ? 1 : 0) != 0);
            return new ModelBased(newParent, this.scale);
        }

        @Override
        public String getName() {
            return this.scale.getShortName() + " Average Slips";
        }

        @Override
        public AverageableModule.AveragingAccumulator<AveSlipModule> averagingAccumulator() {
            return new AverageableModule.AveragingAccumulator<AveSlipModule>(){
                private RupSetScalingRelationship constScale;
                private double sumWeight;
                private AverageableModule.AveragingAccumulator<AveSlipModule> baAccumulator;
                {
                    this.constScale = scale;
                    this.sumWeight = 0.0;
                }

                @Override
                public void process(AveSlipModule module, double relWeight) {
                    if (this.constScale != null) {
                        RupSetScalingRelationship oScale;
                        RupSetScalingRelationship rupSetScalingRelationship = oScale = module instanceof ModelBased ? ((ModelBased)module).scale : null;
                        if (oScale != this.constScale) {
                            this.baAccumulator = new Precomputed(module).averagingAccumulator();
                            if (this.sumWeight != 0.0) {
                                this.baAccumulator.process(new ModelBased(rupSet, this.constScale), this.sumWeight);
                            }
                            this.constScale = null;
                        }
                    } else {
                        this.baAccumulator.process(module, relWeight);
                    }
                    this.sumWeight += relWeight;
                }

                @Override
                public Class<AveSlipModule> getType() {
                    return AveSlipModule.class;
                }

                @Override
                public AveSlipModule getAverage() {
                    if (this.constScale != null) {
                        return this;
                    }
                    return this.baAccumulator.getAverage();
                }
            };
        }

        @Override
        public ModelBased getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            return new ModelBased(rupSubSet, this.scale);
        }

        @Override
        public ModelBased getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            return new ModelBased(splitRupSet, this.scale);
        }
    }

    public static class Precomputed
    extends AveSlipModule
    implements CSV_BackedModule {
        private double[] aveSlips;

        private Precomputed() {
            super(null);
        }

        public Precomputed(AveSlipModule module) {
            super(module.rupSet);
            this.aveSlips = new double[module.rupSet.getNumRuptures()];
            for (int r = 0; r < this.aveSlips.length; ++r) {
                this.aveSlips[r] = module.getAveSlip(r);
            }
        }

        public Precomputed(FaultSystemRupSet rupSet, double[] aveSlips) {
            super(rupSet);
            this.aveSlips = aveSlips;
        }

        @Override
        public double getAveSlip(int rupIndex) {
            return this.aveSlips[rupIndex];
        }

        @Override
        public String getFileName() {
            return AveSlipModule.DATA_FILE_NAME;
        }

        @Override
        public CSVFile<?> getCSV() {
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Rupture Index", "Average Slip (m)");
            int numRups = this.aveSlips.length;
            for (int r = 0; r < numRups; ++r) {
                csv.addLine("" + r, "" + this.getAveSlip(r));
            }
            return csv;
        }

        @Override
        public void initFromCSV(CSVFile<String> csv) {
            int numRups = this.rupSet.getNumRuptures();
            Preconditions.checkState((csv.getNumRows() == numRups + 1 ? 1 : 0) != 0, (String)"Expected 1 header row and %s rupture rows, have %s", (int)numRups, (int)csv.getNumRows());
            double[] aveSlips = new double[numRups];
            for (int r = 0; r < numRups; ++r) {
                Preconditions.checkState((csv.getInt(r + 1, 0) == r ? 1 : 0) != 0, (Object)"Rows out of order or not 0-based");
                aveSlips[r] = csv.getDouble(r + 1, 1);
            }
            this.aveSlips = aveSlips;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkState((this.rupSet.getNumRuptures() == newParent.getNumRuptures() ? 1 : 0) != 0);
            return new Precomputed(newParent, this.aveSlips);
        }

        @Override
        public AverageableModule.AveragingAccumulator<AveSlipModule> averagingAccumulator() {
            return new AverageableModule.AveragingAccumulator<AveSlipModule>(){
                private boolean allSame;
                private AveSlipModule ref;
                private double[] refValues;
                private double[] values;
                private double sumWeight = 0.0;

                @Override
                public void process(AveSlipModule module, double relWeight) {
                    if (this.refValues == null) {
                        this.allSame = true;
                        this.ref = module;
                        this.values = new double[module.rupSet.getNumRuptures()];
                        this.refValues = new double[this.values.length];
                        for (int r = 0; r < this.values.length; ++r) {
                            this.refValues[r] = module.getAveSlip(r);
                            this.values[r] = this.refValues[r] * relWeight;
                        }
                    } else {
                        Preconditions.checkState((module.rupSet.getNumRuptures() == this.values.length ? 1 : 0) != 0);
                        for (int r = 0; r < this.values.length; ++r) {
                            double val = module.getAveSlip(r);
                            int n = r;
                            this.values[n] = this.values[n] + val * relWeight;
                            this.allSame = this.allSame && val == this.refValues[r];
                        }
                        if (!this.allSame) {
                            this.ref = null;
                        }
                    }
                    this.sumWeight += relWeight;
                }

                @Override
                public AveSlipModule getAverage() {
                    if (this.allSame) {
                        return this.ref;
                    }
                    AverageableModule.scaleToTotalWeight(this.values, this.sumWeight);
                    return new Precomputed(null, this.values);
                }

                @Override
                public Class<AveSlipModule> getType() {
                    return AveSlipModule.class;
                }
            };
        }

        @Override
        public String getName() {
            return "Precomputed Average Slips";
        }

        @Override
        public Precomputed getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            double[] filteredAveSlips = new double[rupSubSet.getNumRuptures()];
            for (int r = 0; r < rupSubSet.getNumRuptures(); ++r) {
                int origID = mappings.getOrigRupID(r);
                filteredAveSlips[r] = this.aveSlips[origID];
            }
            return new Precomputed(rupSubSet, filteredAveSlips);
        }

        @Override
        public AveSlipModule getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            double[] splitAveSlips = new double[splitRupSet.getNumRuptures()];
            for (int r = 0; r < splitRupSet.getNumRuptures(); ++r) {
                int origID = mappings.getOrigRupID(r);
                splitAveSlips[r] = this.aveSlips[origID] * mappings.getNewRupWeight(r);
            }
            return new Precomputed(splitRupSet, splitAveSlips);
        }
    }
}

