/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.JSON_TypeAdapterBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ConnectivityCluster;

public class ConnectivityClusters
implements SubModule<FaultSystemRupSet>,
JSON_TypeAdapterBackedModule<List<ConnectivityCluster>>,
Iterable<ConnectivityCluster>,
BranchAverageableModule<ConnectivityClusters>,
AverageableModule.ConstantAverageable<ConnectivityClusters> {
    private FaultSystemRupSet rupSet;
    private List<ConnectivityCluster> clusters;
    public static final String CLUSTER_MISFITS_FILE_NAME = "connectivity_cluster_misfits.csv";
    public static final String LARGEST_CLUSTER_MISFIT_PROGRESS_FILE_NAME = "connectivity_cluster_largest_misfit_progress.csv";

    public static ConnectivityClusters build(FaultSystemRupSet rupSet) {
        return new ConnectivityClusters(rupSet, ConnectivityCluster.build(rupSet));
    }

    public ConnectivityClusters(FaultSystemRupSet rupSet, List<ConnectivityCluster> clusters) {
        this.rupSet = rupSet;
        this.clusters = clusters;
    }

    private ConnectivityClusters() {
    }

    @Override
    public String getName() {
        return "Connectivity Clusters";
    }

    @Override
    public List<ConnectivityCluster> get() {
        return this.clusters;
    }

    @Override
    public void set(List<ConnectivityCluster> clusters) {
        Preconditions.checkState((this.clusters == null ? 1 : 0) != 0, (Object)"Clusters already initialized, should not call set() twice");
        this.clusters = clusters;
    }

    public int size() {
        return this.clusters.size();
    }

    public ConnectivityCluster get(int index) {
        return this.clusters.get(index);
    }

    public List<ConnectivityCluster> getSorted(Comparator<ConnectivityCluster> comp) {
        ArrayList<ConnectivityCluster> sorted = new ArrayList<ConnectivityCluster>(this.clusters);
        Collections.sort(sorted, comp);
        return sorted;
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        if (this.rupSet != null) {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(parent));
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    @Override
    public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
        if (this.rupSet != null) {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(newParent));
        }
        return new ConnectivityClusters(newParent, this.clusters);
    }

    @Override
    public String getFileName() {
        return "connectivity_clusters.json";
    }

    @Override
    public Type getType() {
        return TypeToken.getParameterized(List.class, (Type[])new Type[]{ConnectivityCluster.class}).getType();
    }

    @Override
    public void registerTypeAdapters(GsonBuilder builder) {
    }

    @Override
    public Iterator<ConnectivityCluster> iterator() {
        return this.clusters.iterator();
    }

    @Override
    public Class<ConnectivityClusters> getAveragingType() {
        return ConnectivityClusters.class;
    }

    @Override
    public boolean isIdentical(ConnectivityClusters module) {
        return ConnectivityClusters.clustersEquivalent(this, module);
    }

    private static boolean clustersEquivalent(ConnectivityClusters clusters1, ConnectivityClusters clusters2) {
        if (clusters1 == clusters2) {
            return true;
        }
        if (clusters1 == null || clusters2 == null || !clusters1.rupSet.areSectionsEquivalentTo(clusters2.rupSet)) {
            return false;
        }
        if (clusters1.size() != clusters2.size()) {
            return false;
        }
        for (int i = 0; i < clusters1.size(); ++i) {
            ConnectivityCluster cluster1 = clusters1.get(i);
            ConnectivityCluster cluster2 = clusters2.get(i);
            if (cluster1.getNumRuptures() != cluster2.getNumRuptures()) {
                return false;
            }
            if (cluster1.getNumSections() == cluster2.getNumSections()) continue;
            return false;
        }
        return true;
    }

    public static class ConnectivityClusterSolutionMisfits
    implements SubModule<FaultSystemSolution>,
    ArchivableModule,
    BranchAverageableModule<ConnectivityClusterSolutionMisfits> {
        private FaultSystemSolution sol;
        private ConnectivityClusters clusters;
        private List<InversionMisfitStats> clusterStats;
        private InversionMisfitProgress largestClusterProgress;

        public ConnectivityClusterSolutionMisfits(FaultSystemSolution sol, Map<ConnectivityCluster, InversionMisfitStats> clusterMisfits, InversionMisfitProgress largestClusterProgress) {
            this.setParent(sol);
            this.clusters = sol.getRupSet().requireModule(ConnectivityClusters.class);
            this.clusterStats = new ArrayList<InversionMisfitStats>();
            for (ConnectivityCluster cluster : this.clusters) {
                this.clusterStats.add(clusterMisfits.get(cluster));
            }
            this.largestClusterProgress = largestClusterProgress;
        }

        public InversionMisfitStats getMisfitStats(int index) {
            return this.clusterStats.get(index);
        }

        public InversionMisfitProgress getLargestClusterMisfitProgress() {
            return this.largestClusterProgress;
        }

        private ConnectivityClusterSolutionMisfits() {
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            CSVFile progressCSV = null;
            for (int i = 0; i < this.clusters.size(); ++i) {
                ConnectivityCluster cluster = this.clusters.get(i);
                InversionMisfitStats stats = this.clusterStats.get(i);
                if (stats == null) continue;
                CSVFile<?> clusterCSV = stats.getCSV();
                Preconditions.checkState((clusterCSV.getNumRows() > 0 ? 1 : 0) != 0);
                if (progressCSV == null) {
                    progressCSV = new CSVFile(true);
                    ArrayList<String> header = new ArrayList<String>();
                    header.add("Cluster Index");
                    header.add("# Sections");
                    header.add("# Ruptures");
                    for (Object val : clusterCSV.getLine(0)) {
                        header.add(val.toString());
                    }
                    progressCSV.addLine(header);
                }
                for (int row = 1; row < clusterCSV.getNumRows(); ++row) {
                    ArrayList<Object> line = new ArrayList<Object>(progressCSV.getNumCols());
                    line.add("" + i);
                    line.add("" + cluster.getNumSections());
                    line.add("" + cluster.getNumRuptures());
                    for (Object val : clusterCSV.getLine(row)) {
                        line.add(val.toString());
                    }
                    progressCSV.addLine(line);
                }
            }
            if (progressCSV != null) {
                CSV_BackedModule.writeToArchive(progressCSV, output, entryPrefix, ConnectivityClusters.CLUSTER_MISFITS_FILE_NAME);
            }
            if (this.largestClusterProgress != null) {
                CSV_BackedModule.writeToArchive(this.largestClusterProgress.getCSV(), output, entryPrefix, ConnectivityClusters.LARGEST_CLUSTER_MISFIT_PROGRESS_FILE_NAME);
            }
        }

        @Override
        public String getName() {
            return "Connectivity Cluster Inversion Misfits";
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            this.clusterStats = null;
            if (FileBackedModule.hasEntry(input, entryPrefix, ConnectivityClusters.CLUSTER_MISFITS_FILE_NAME)) {
                CSVFile<String> allStatsCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, ConnectivityClusters.CLUSTER_MISFITS_FILE_NAME);
                Preconditions.checkState((allStatsCSV.getNumRows() > 0 ? 1 : 0) != 0);
                ArrayList clusterCSVs = new ArrayList();
                List<String> origHeader = allStatsCSV.getLine(0);
                List<String> commonHeader = origHeader.subList(3, origHeader.size());
                if (this.clusters != null) {
                    for (int i = 0; i < this.clusters.size(); ++i) {
                        clusterCSVs.add(null);
                    }
                }
                for (int row = 1; row < allStatsCSV.getNumRows(); ++row) {
                    int n = allStatsCSV.getInt(row, 0);
                    while (clusterCSVs.size() <= n) {
                        clusterCSVs.add(null);
                    }
                    CSVFile<String> clusterCSV = (CSVFile<String>)clusterCSVs.get(n);
                    if (clusterCSV == null) {
                        clusterCSV = new CSVFile<String>(true);
                        clusterCSV.addLine(commonHeader);
                        clusterCSVs.set(n, clusterCSV);
                    }
                    List<String> line = allStatsCSV.getLine(row);
                    clusterCSV.addLine(line.subList(3, line.size()));
                }
                Preconditions.checkState((clusterCSVs.size() > 0 ? 1 : 0) != 0);
                this.clusterStats = new ArrayList<InversionMisfitStats>();
                for (CSVFile cSVFile : clusterCSVs) {
                    if (cSVFile == null) {
                        this.clusterStats.add(null);
                        continue;
                    }
                    this.clusterStats.add(InversionMisfitStats.fromCSV(cSVFile));
                }
            }
            this.largestClusterProgress = null;
            if (FileBackedModule.hasEntry(input, entryPrefix, ConnectivityClusters.LARGEST_CLUSTER_MISFIT_PROGRESS_FILE_NAME)) {
                CSVFile<String> progressCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, ConnectivityClusters.LARGEST_CLUSTER_MISFIT_PROGRESS_FILE_NAME);
                this.largestClusterProgress = new InversionMisfitProgress(progressCSV);
            }
        }

        @Override
        public void setParent(FaultSystemSolution sol) throws IllegalStateException {
            Preconditions.checkNotNull((Object)sol, (Object)"Must supply solution");
            if (this.sol == sol) {
                return;
            }
            Preconditions.checkState((boolean)sol.getRupSet().hasModule(ConnectivityClusters.class), (Object)"Rupture set must have connectivity clusters attached");
            ConnectivityClusters newClusters = sol.getRupSet().requireModule(ConnectivityClusters.class);
            if (this.clusters != null) {
                Preconditions.checkState((boolean)ConnectivityClusters.clustersEquivalent(this.clusters, newClusters), (Object)"Can't set parent solution, clusters incompatible");
            } else if (this.clusterStats != null) {
                Preconditions.checkState((newClusters.size() >= this.clusterStats.size() ? 1 : 0) != 0);
                while (this.clusterStats.size() < newClusters.size()) {
                    this.clusterStats.add(null);
                }
            }
            this.clusters = newClusters;
            this.sol = sol;
        }

        @Override
        public FaultSystemSolution getParent() {
            return this.sol;
        }

        @Override
        public SubModule<FaultSystemSolution> copy(FaultSystemSolution newParent) throws IllegalStateException {
            ConnectivityClusterSolutionMisfits ret = new ConnectivityClusterSolutionMisfits();
            ret.clusters = this.clusters;
            ret.clusterStats = this.clusterStats;
            ret.setParent(newParent);
            return ret;
        }

        @Override
        public AverageableModule.AveragingAccumulator<ConnectivityClusterSolutionMisfits> averagingAccumulator() {
            return new AverageableModule.AveragingAccumulator<ConnectivityClusterSolutionMisfits>(){
                private List<AverageableModule.AveragingAccumulator<InversionMisfitStats>> statsAccumulators;
                private AverageableModule.AveragingAccumulator<InversionMisfitProgress> progressAccumulator;

                @Override
                public Class<ConnectivityClusterSolutionMisfits> getType() {
                    return ConnectivityClusterSolutionMisfits.class;
                }

                @Override
                public void process(ConnectivityClusterSolutionMisfits module, double relWeight) {
                    int i;
                    if (this.statsAccumulators == null) {
                        this.statsAccumulators = new ArrayList<AverageableModule.AveragingAccumulator<InversionMisfitStats>>();
                        for (i = 0; i < clusters.size(); ++i) {
                            this.statsAccumulators.add(null);
                        }
                        if (module.largestClusterProgress != null) {
                            this.progressAccumulator = module.largestClusterProgress.averagingAccumulator();
                        }
                    }
                    Preconditions.checkState((boolean)ConnectivityClusters.clustersEquivalent(clusters, module.clusters));
                    for (i = 0; i < clusters.size(); ++i) {
                        InversionMisfitStats stats = module.clusterStats.get(i);
                        if (stats == null) continue;
                        AverageableModule.AveragingAccumulator<InversionMisfitStats> statsAccumulator = this.statsAccumulators.get(i);
                        if (statsAccumulator == null) {
                            statsAccumulator = stats.averagingAccumulator();
                            this.statsAccumulators.set(i, statsAccumulator);
                        }
                        statsAccumulator.process(stats, relWeight);
                    }
                    if (this.progressAccumulator != null && module.largestClusterProgress != null) {
                        this.progressAccumulator.process(module.largestClusterProgress, relWeight);
                    }
                }

                @Override
                public ConnectivityClusterSolutionMisfits getAverage() {
                    ArrayList<InversionMisfitStats> avgStats = new ArrayList<InversionMisfitStats>();
                    boolean hasAny = false;
                    for (int i = 0; i < clusters.size(); ++i) {
                        AverageableModule.AveragingAccumulator<InversionMisfitStats> statsAccumulator = this.statsAccumulators.get(i);
                        if (statsAccumulator == null) {
                            avgStats.add(null);
                            continue;
                        }
                        avgStats.add(statsAccumulator.getAverage());
                        hasAny = true;
                    }
                    ConnectivityClusterSolutionMisfits ret = new ConnectivityClusterSolutionMisfits();
                    ret.clusters = clusters;
                    ret.clusterStats = avgStats;
                    Preconditions.checkState((boolean)hasAny);
                    if (this.progressAccumulator != null) {
                        try {
                            ret.largestClusterProgress = this.progressAccumulator.getAverage();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return ret;
                }
            };
        }
    }
}

