/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.aftershocks.MagnitudeDependentAftershockFilter;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_AbstractGridSourceProvider;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public interface MFDGridSourceProvider
extends GridSourceProvider {
    public static final String ARCHIVE_MECH_WEIGHT_FILE_NAME = "grid_mech_weights.csv";
    public static final String ARCHIVE_SUB_SEIS_FILE_NAME = "grid_sub_seis_mfds.csv";
    public static final String ARCHIVE_UNASSOCIATED_FILE_NAME = "grid_unassociated_mfds.csv";

    public TectonicRegionType getTectonicRegionType(int var1);

    default public TectonicRegionType[] getTectonicRegionTypeArray() {
        TectonicRegionType[] ret = new TectonicRegionType[this.getNumLocations()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getTectonicRegionType(i);
        }
        return ret;
    }

    @Override
    public ProbEqkSource getSource(int var1, double var2, MagnitudeDependentAftershockFilter var4, GriddedSeismicitySettings var5);

    public ProbEqkSource getSourceSubSeisOnFault(int var1, double var2, MagnitudeDependentAftershockFilter var4, GriddedSeismicitySettings var5);

    public ProbEqkSource getSourceUnassociated(int var1, double var2, MagnitudeDependentAftershockFilter var4, GriddedSeismicitySettings var5);

    @Override
    default public ProbEqkSource getSource(TectonicRegionType tectonicRegionType, int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getSource(gridIndex, duration, aftershockFilter, gridSourceSettings);
        }
        return null;
    }

    @Override
    default public ProbEqkSource getSourceSubSeisOnFault(TectonicRegionType tectonicRegionType, int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getSourceSubSeisOnFault(gridIndex, duration, aftershockFilter, gridSourceSettings);
        }
        return null;
    }

    @Override
    default public ProbEqkSource getSourceUnassociated(TectonicRegionType tectonicRegionType, int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getSourceUnassociated(gridIndex, duration, aftershockFilter, gridSourceSettings);
        }
        return null;
    }

    @Override
    default public Set<TectonicRegionType> getTectonicRegionTypes() {
        TectonicRegionType firstTRT = this.getTectonicRegionType(0);
        EnumSet<TectonicRegionType> trts = EnumSet.of(firstTRT);
        for (int i = 1; i < this.getNumLocations(); ++i) {
            TectonicRegionType trt = this.getTectonicRegionType(i);
            if (trt == firstTRT) continue;
            trts.add(trt);
        }
        return trts;
    }

    @Override
    default public IncrementalMagFreqDist getMFD_Unassociated(TectonicRegionType tectonicRegionType, int gridIndex) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getMFD_Unassociated(gridIndex);
        }
        return null;
    }

    @Override
    default public IncrementalMagFreqDist getMFD_SubSeisOnFault(TectonicRegionType tectonicRegionType, int gridIndex) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getMFD_SubSeisOnFault(gridIndex);
        }
        return null;
    }

    @Override
    default public IncrementalMagFreqDist getMFD(TectonicRegionType tectonicRegionType, int gridIndex, double minMag) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getMFD(gridIndex, minMag);
        }
        return null;
    }

    @Override
    default public IncrementalMagFreqDist getMFD(TectonicRegionType tectonicRegionType, int gridIndex) {
        if (tectonicRegionType == null || tectonicRegionType == this.getTectonicRegionType(gridIndex)) {
            return this.getMFD(gridIndex);
        }
        return null;
    }

    @Override
    default public void scaleAll(TectonicRegionType tectonicRegionType, double[] valuesArray) {
        if (tectonicRegionType != null && this.getTectonicRegionTypes().size() > 1) {
            valuesArray = Arrays.copyOf(valuesArray, valuesArray.length);
            for (int i = 0; i < valuesArray.length; ++i) {
                TectonicRegionType trt = this.getTectonicRegionType(i);
                if (trt == tectonicRegionType) continue;
                Preconditions.checkState((Double.isNaN(valuesArray[i]) || valuesArray[i] == 1.0 || valuesArray[i] == 0.0 ? 1 : 0) != 0, (String)"Gave a non-placeholder scalar for node %s, but it has a TRT type of %s rather than the specified %s", (Object)i, (Object)trt, (Object)tectonicRegionType);
                if (valuesArray[i] == 1.0) continue;
                valuesArray[i] = 1.0;
            }
        }
        this.scaleAll(valuesArray);
    }

    @Override
    default public AverageableModule.AveragingAccumulator<GridSourceProvider> averagingAccumulator() {
        return new Averager();
    }

    @Override
    default public Location getLocation(int index) {
        return this.getGriddedRegion().getLocation(index);
    }

    @Override
    default public Location getLocationForSource(int sourceIndex) {
        return this.getLocation(sourceIndex);
    }

    @Override
    default public int getLocationIndexForSource(int sourceIndex) {
        return sourceIndex;
    }

    @Override
    default public int getLocationIndex(Location location) {
        return this.getGriddedRegion().indexForLocation(location);
    }

    @Override
    default public int getNumSources() {
        return this.getNumLocations();
    }

    @Override
    default public GridSourceProvider getAboveMinMag(float minMag) {
        HashMap<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs = new HashMap<Integer, IncrementalMagFreqDist>();
        HashMap<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs = new HashMap<Integer, IncrementalMagFreqDist>(this.getNumLocations());
        double[] fracStrikeSlip = new double[this.getNumLocations()];
        double[] fracNormal = new double[fracStrikeSlip.length];
        double[] fracReverse = new double[fracStrikeSlip.length];
        TectonicRegionType[] trts = new TectonicRegionType[fracStrikeSlip.length];
        boolean alreadyAbove = true;
        double snappedMinMag = Double.NaN;
        for (int i = 0; i < fracStrikeSlip.length; ++i) {
            fracStrikeSlip[i] = this.getFracStrikeSlip(i);
            fracNormal[i] = this.getFracNormal(i);
            fracReverse[i] = this.getFracReverse(i);
            trts[i] = this.getTectonicRegionType(i);
            IncrementalMagFreqDist subSeisMFD = this.getMFD_SubSeisOnFault(i);
            IncrementalMagFreqDist unassocMFD = this.getMFD_Unassociated(i);
            if (subSeisMFD == null && unassocMFD == null) continue;
            double myMin = Double.POSITIVE_INFINITY;
            if (subSeisMFD != null) {
                myMin = subSeisMFD.getMinX();
            }
            if (unassocMFD != null) {
                myMin = Math.min(myMin, unassocMFD.getMinX());
            }
            if ((float)myMin < minMag) {
                if (alreadyAbove) {
                    int index;
                    alreadyAbove = false;
                    IncrementalMagFreqDist mfd = unassocMFD == null ? subSeisMFD : unassocMFD;
                    snappedMinMag = mfd.getX(index = mfd.getClosestXIndex(minMag));
                    if ((float)snappedMinMag < minMag) {
                        snappedMinMag = mfd.getX(index + 1);
                        Preconditions.checkState(((float)snappedMinMag >= minMag ? 1 : 0) != 0);
                    }
                }
                if (subSeisMFD != null) {
                    nodeSubSeisMFDs.put(i, MFDGridSourceProvider.trimMFD(subSeisMFD, snappedMinMag));
                }
                if (unassocMFD == null) continue;
                nodeUnassociatedMFDs.put(i, MFDGridSourceProvider.trimMFD(unassocMFD, snappedMinMag));
                continue;
            }
            if (subSeisMFD != null) {
                nodeSubSeisMFDs.put(i, subSeisMFD);
            }
            if (unassocMFD == null) continue;
            nodeUnassociatedMFDs.put(i, unassocMFD);
        }
        if (alreadyAbove) {
            return this;
        }
        return this.newInstance(nodeSubSeisMFDs, nodeUnassociatedMFDs, fracStrikeSlip, fracNormal, fracReverse, trts);
    }

    public MFDGridSourceProvider newInstance(Map<Integer, IncrementalMagFreqDist> var1, Map<Integer, IncrementalMagFreqDist> var2, double[] var3, double[] var4, double[] var5, TectonicRegionType[] var6);

    private static IncrementalMagFreqDist trimMFD(IncrementalMagFreqDist mfdIn, double mMin) {
        double mMax;
        if (mfdIn == null) {
            return new IncrementalMagFreqDist(mMin, mMin, 1);
        }
        int mMinIndex = mfdIn.getXIndex(mMin);
        if (mMinIndex < 0) {
            mMinIndex = mfdIn.getClosestXIndex(mMin + 0.01 * mfdIn.getDelta());
            mMin = mfdIn.getX(mMinIndex);
        }
        if (Double.isNaN(mMax = mfdIn.getMaxMagWithNonZeroRate()) || mMax < mMin) {
            IncrementalMagFreqDist mfdOut = new IncrementalMagFreqDist(mMin, mMin, 1);
            return mfdOut;
        }
        double delta = mfdIn.getDelta();
        int num = (int)((mMax - mMin) / delta + 0.1) + 1;
        IncrementalMagFreqDist mfdOut = new IncrementalMagFreqDist(mMin, num, delta);
        for (int i = 0; i < mfdOut.size(); ++i) {
            double mag = mfdOut.getX(i);
            double rate = mfdIn.getY(mag);
            mfdOut.set(mag, rate);
        }
        Preconditions.checkState(((float)mfdOut.getMaxX() == (float)mMax ? 1 : 0) != 0, (String)"Bad trim! mMin=%s, mMax=%s, delta=%s, num=%s, outputMMax=%s", (Object[])new Object[]{mMin, mMax, delta, num, mfdOut.getMaxX()});
        return mfdOut;
    }

    public static void addWeighted(Map<Integer, IncrementalMagFreqDist> mfdMap, int index, IncrementalMagFreqDist newMFD, double weight) {
        IncrementalMagFreqDist ret;
        if (newMFD == null) {
            return;
        }
        IncrementalMagFreqDist runningMFD = mfdMap.get(index);
        if (runningMFD == null) {
            runningMFD = new IncrementalMagFreqDist(newMFD.getMinX(), newMFD.size(), newMFD.getDelta());
            mfdMap.put(index, runningMFD);
        }
        if ((ret = MFDGridSourceProvider.addWeighted(runningMFD, newMFD, weight)) != runningMFD) {
            mfdMap.put(index, ret);
        }
    }

    public static IncrementalMagFreqDist addWeighted(IncrementalMagFreqDist runningMFD, IncrementalMagFreqDist newMFD, double weight) {
        Preconditions.checkState(((float)runningMFD.getMinX() == (float)newMFD.getMinX() ? 1 : 0) != 0, (Object)"MFD min x inconsistent");
        Preconditions.checkState(((float)runningMFD.getDelta() == (float)newMFD.getDelta() ? 1 : 0) != 0, (Object)"MFD delta inconsistent");
        if (runningMFD.size() < newMFD.size()) {
            IncrementalMagFreqDist ret = new IncrementalMagFreqDist(newMFD.getMinX(), newMFD.size(), newMFD.getDelta());
            for (int i = 0; i < runningMFD.size(); ++i) {
                ret.set(i, runningMFD.getY(i));
            }
            runningMFD = ret;
        }
        for (int i = 0; i < newMFD.size(); ++i) {
            runningMFD.set(i, Math.fma(newMFD.getY(i), weight, runningMFD.getY(i)));
        }
        return runningMFD;
    }

    public static class Averager
    implements AverageableModule.AveragingAccumulator<GridSourceProvider> {
        private MFDGridSourceProvider refGridProv = null;
        private GriddedRegion gridReg = null;
        private Map<Integer, IncrementalMagFreqDist> subSeisMFDs = null;
        private Map<Integer, IncrementalMagFreqDist> unassociatedMFDs = null;
        private double totWeight = 0.0;
        private double[] fractSS;
        private double[] fractR;
        private double[] fractN;
        private TectonicRegionType[] trts;

        @Override
        public void process(GridSourceProvider module, double relWeight) {
            int i;
            Preconditions.checkState((boolean)(module instanceof MFDGridSourceProvider), (Object)"Only support averaging MFDGridSoruceProvider instances");
            MFDGridSourceProvider gridProv = (MFDGridSourceProvider)module;
            if (this.gridReg == null) {
                Preconditions.checkState((this.totWeight == 0.0 ? 1 : 0) != 0, (Object)"Can't reuse an averager after getAverage called");
                this.refGridProv = gridProv;
                this.gridReg = gridProv.getGriddedRegion();
                Preconditions.checkNotNull((Object)this.gridReg, (Object)"GriddedRegion cannot be null when doing MFD-based averaging");
                this.subSeisMFDs = new HashMap<Integer, IncrementalMagFreqDist>();
                this.unassociatedMFDs = new HashMap<Integer, IncrementalMagFreqDist>();
                this.fractSS = new double[gridProv.getNumLocations()];
                this.fractR = new double[this.fractSS.length];
                this.fractN = new double[this.fractSS.length];
                this.trts = new TectonicRegionType[this.fractSS.length];
                for (i = 0; i < this.trts.length; ++i) {
                    this.trts[i] = gridProv.getTectonicRegionType(i);
                }
            } else {
                Preconditions.checkState((boolean)this.gridReg.equalsRegion(gridProv.getGriddedRegion()));
            }
            this.totWeight += relWeight;
            for (i = 0; i < this.gridReg.getNodeCount(); ++i) {
                MFDGridSourceProvider.addWeighted(this.subSeisMFDs, i, gridProv.getMFD_SubSeisOnFault(i), relWeight);
                MFDGridSourceProvider.addWeighted(this.unassociatedMFDs, i, gridProv.getMFD_Unassociated(i), relWeight);
                int n = i;
                this.fractSS[n] = this.fractSS[n] + gridProv.getFracStrikeSlip(i) * relWeight;
                int n2 = i;
                this.fractR[n2] = this.fractR[n2] + gridProv.getFracReverse(i) * relWeight;
                int n3 = i;
                this.fractN[n3] = this.fractN[n3] + gridProv.getFracNormal(i) * relWeight;
                Preconditions.checkState((this.trts[i] == gridProv.getTectonicRegionType(i) ? 1 : 0) != 0);
            }
        }

        @Override
        public GridSourceProvider getAverage() {
            double scale = 1.0 / this.totWeight;
            int i = 0;
            while (i < this.fractSS.length) {
                IncrementalMagFreqDist unassociatedMFD;
                IncrementalMagFreqDist subSeisMFD = this.subSeisMFDs.get(i);
                if (subSeisMFD != null) {
                    subSeisMFD.scale(scale);
                }
                if ((unassociatedMFD = this.unassociatedMFDs.get(i)) != null) {
                    unassociatedMFD.scale(scale);
                }
                int n = i;
                this.fractSS[n] = this.fractSS[n] * scale;
                int n2 = i;
                this.fractR[n2] = this.fractR[n2] * scale;
                int n3 = i++;
                this.fractN[n3] = this.fractN[n3] * scale;
            }
            MFDGridSourceProvider ret = this.refGridProv.newInstance(this.subSeisMFDs, this.unassociatedMFDs, this.fractSS, this.fractN, this.fractR, this.trts);
            this.subSeisMFDs = null;
            this.unassociatedMFDs = null;
            this.fractSS = null;
            this.fractN = null;
            this.fractR = null;
            this.refGridProv = null;
            return ret;
        }

        @Override
        public Class<GridSourceProvider> getType() {
            return GridSourceProvider.class;
        }
    }

    public static class Default
    extends AbstractPrecomputed {
        private Default() {
        }

        public Default(MFDGridSourceProvider prov) {
            super(prov);
        }

        public Default(GriddedRegion region, CSVFile<String> subSeisCSV, CSVFile<String> unassociatedCSV, CSVFile<String> mechCSV) {
            super(region, subSeisCSV, unassociatedCSV, mechCSV);
        }

        public Default(GriddedRegion region, Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, TectonicRegionType[] trts) {
            super(region, nodeSubSeisMFDs, nodeUnassociatedMFDs, fracStrikeSlip, fracNormal, fracReverse, trts);
        }

        @Override
        public String getName() {
            return "Precomputed Default Grid Source Provider";
        }

        @Override
        protected ProbEqkSource buildSource(int gridIndex, IncrementalMagFreqDist mfd, double duration, GriddedSeismicitySettings gridSourceSettings) {
            Location loc = this.getGriddedRegion().locationForIndex(gridIndex);
            double fracStrikeSlip = this.getFracStrikeSlip(gridIndex);
            double fracNormal = this.getFracNormal(gridIndex);
            double fracReverse = this.getFracReverse(gridIndex);
            return NSHM23_AbstractGridSourceProvider.buildSource(mfd, duration, gridSourceSettings, loc, fracStrikeSlip, fracNormal, fracReverse);
        }

        @Override
        public MFDGridSourceProvider newInstance(Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, TectonicRegionType[] trts) {
            return new Default(this.getGriddedRegion(), nodeSubSeisMFDs, nodeUnassociatedMFDs, fracStrikeSlip, fracNormal, fracReverse, trts);
        }

        @Override
        public TectonicRegionType getTectonicRegionType(int gridIndex) {
            return TectonicRegionType.ACTIVE_SHALLOW;
        }
    }

    public static abstract class AbstractPrecomputed
    extends Abstract
    implements ArchivableModule {
        private GriddedRegion region;
        private ImmutableMap<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs;
        private ImmutableMap<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs;
        private double[] fracStrikeSlip;
        private double[] fracNormal;
        private double[] fracReverse;
        private TectonicRegionType[] trts;
        private boolean round = true;
        private static final int locRoundScale = 3;
        private static final int magRoundScale = 3;
        private static final int mfdRoundSigFigs = 6;

        protected AbstractPrecomputed() {
        }

        public AbstractPrecomputed(GriddedRegion region, Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, TectonicRegionType[] trts) {
            this.region = region;
            this.nodeSubSeisMFDs = ImmutableMap.copyOf(nodeSubSeisMFDs);
            this.nodeUnassociatedMFDs = ImmutableMap.copyOf(nodeUnassociatedMFDs);
            this.fracStrikeSlip = fracStrikeSlip;
            this.fracNormal = fracNormal;
            this.fracReverse = fracReverse;
            this.trts = trts;
        }

        public AbstractPrecomputed(GriddedRegion region, CSVFile<String> subSeisCSV, CSVFile<String> unassociatedCSV, CSVFile<String> mechCSV) {
            this.init(region, subSeisCSV, unassociatedCSV, mechCSV);
        }

        public AbstractPrecomputed(MFDGridSourceProvider prov) {
            this.region = prov.getGriddedRegion();
            int nodeCount = this.region.getNodeCount();
            ImmutableMap.Builder subSeisBuilder = ImmutableMap.builder();
            ImmutableMap.Builder unassociatedBuilder = ImmutableMap.builder();
            this.fracStrikeSlip = new double[nodeCount];
            this.fracNormal = new double[nodeCount];
            this.fracReverse = new double[nodeCount];
            this.trts = new TectonicRegionType[nodeCount];
            for (int i = 0; i < nodeCount; ++i) {
                IncrementalMagFreqDist unassociated;
                IncrementalMagFreqDist subSeis = prov.getMFD_SubSeisOnFault(i);
                if (subSeis != null) {
                    subSeisBuilder.put((Object)i, (Object)subSeis);
                }
                if ((unassociated = prov.getMFD_Unassociated(i)) != null) {
                    unassociatedBuilder.put((Object)i, (Object)unassociated);
                }
                this.fracStrikeSlip[i] = prov.getFracStrikeSlip(i);
                this.fracNormal[i] = prov.getFracNormal(i);
                this.fracReverse[i] = prov.getFracReverse(i);
                this.trts[i] = prov.getTectonicRegionType(i);
            }
            this.nodeSubSeisMFDs = subSeisBuilder.build();
            this.nodeUnassociatedMFDs = unassociatedBuilder.build();
        }

        public ImmutableMap<Integer, IncrementalMagFreqDist> getNodeSubSeisMFDs() {
            return this.nodeSubSeisMFDs;
        }

        public ImmutableMap<Integer, IncrementalMagFreqDist> getNodeUnassociatedMFDs() {
            return this.nodeUnassociatedMFDs;
        }

        public void setRound(boolean round) {
            this.round = round;
        }

        @Override
        public final IncrementalMagFreqDist getMFD_Unassociated(int idx) {
            return (IncrementalMagFreqDist)this.nodeUnassociatedMFDs.get((Object)idx);
        }

        @Override
        public final IncrementalMagFreqDist getMFD_SubSeisOnFault(int idx) {
            return (IncrementalMagFreqDist)this.nodeSubSeisMFDs.get((Object)idx);
        }

        @Override
        public final GriddedRegion getGriddedRegion() {
            return this.region;
        }

        @Override
        public final double getFracStrikeSlip(int idx) {
            return this.fracStrikeSlip[idx];
        }

        @Override
        public final double getFracReverse(int idx) {
            return this.fracReverse[idx];
        }

        @Override
        public final double getFracNormal(int idx) {
            return this.fracNormal[idx];
        }

        public CSVFile<String> buildSubSeisCSV() {
            if (this.nodeSubSeisMFDs == null) {
                return null;
            }
            return this.buildCSV((Map<Integer, IncrementalMagFreqDist>)this.nodeSubSeisMFDs);
        }

        public CSVFile<String> buildUnassociatedCSV() {
            if (this.nodeUnassociatedMFDs == null) {
                return null;
            }
            return this.buildCSV((Map<Integer, IncrementalMagFreqDist>)this.nodeUnassociatedMFDs);
        }

        private CSVFile<String> buildCSV(Map<Integer, IncrementalMagFreqDist> mfds) {
            IncrementalMagFreqDist xVals = null;
            for (IncrementalMagFreqDist mfd : mfds.values()) {
                if (mfd == null) continue;
                if (xVals == null) {
                    xVals = mfd;
                    break;
                }
                Preconditions.checkState((xVals.getMinX() == mfd.getMinX() ? 1 : 0) != 0, (String)"MFDs have different minX: %s != %s", (Object)xVals.getMinX(), (Object)mfd.getMinX());
                Preconditions.checkState((xVals.getDelta() == mfd.getDelta() ? 1 : 0) != 0, (String)"MFDs have different deltas: %s != %s", (Object)xVals.getDelta(), (Object)mfd.getDelta());
                if (mfd.size() <= xVals.size()) break;
                xVals = mfd;
                break;
            }
            if (xVals == null) {
                return null;
            }
            CSVFile<String> csv = new CSVFile<String>(true);
            ArrayList<Object> header = new ArrayList<Object>();
            header.add("Node Index");
            header.add("Latitude");
            header.add("Longitude");
            for (int i = 0; i < xVals.size(); ++i) {
                header.add("" + DataUtils.roundFixed(xVals.getX(i), 3));
            }
            csv.addLine((List<String>)header);
            int nodeCount = this.region.getNodeCount();
            for (int i = 0; i < nodeCount; ++i) {
                IncrementalMagFreqDist mfd = mfds.get(i);
                if (mfd == null) continue;
                Location loc = this.region.getLocation(i);
                ArrayList<Object> line = new ArrayList<Object>(header.size());
                line.add("" + i);
                line.add("" + DataUtils.roundFixed(loc.getLatitude(), 3));
                line.add("" + DataUtils.roundFixed(loc.getLongitude(), 3));
                Preconditions.checkState((mfd.size() <= xVals.size() ? 1 : 0) != 0, (String)"MFD sizes inconsistent. Expected %s values, have %s", (int)xVals.size(), (int)mfd.size());
                for (int j = 0; j < xVals.size(); ++j) {
                    if (j >= mfd.size()) {
                        line.add("0.0");
                        continue;
                    }
                    Preconditions.checkState(((float)mfd.getX(j) == (float)xVals.getX(j) ? 1 : 0) != 0, (String)"MFD x value mismatch for node %s value %s", (int)i, (int)j);
                    if (this.round) {
                        line.add("" + DataUtils.roundSigFigs(mfd.getY(j), 6));
                        continue;
                    }
                    line.add("" + mfd.getY(j));
                }
                csv.addLine((List<String>)line);
            }
            return csv;
        }

        public CSVFile<String> buildWeightsCSV() {
            CSVFile<String> csv = new CSVFile<String>(true);
            ArrayList<String> header = new ArrayList<String>();
            header.add("Node Index");
            header.add("Latitude");
            header.add("Longitude");
            header.add("Fraction Strike-Slip");
            header.add("Fraction Reverse");
            header.add("Fraction Normal");
            header.add("Tectonic Regime");
            csv.addLine((List<String>)header);
            GriddedRegion region = this.getGriddedRegion();
            for (int i = 0; i < region.getNodeCount(); ++i) {
                Location loc = region.getLocation(i);
                ArrayList<Object> line = new ArrayList<Object>(header.size());
                line.add("" + i);
                line.add("" + loc.getLatitude());
                line.add("" + loc.getLongitude());
                if (this.round) {
                    line.add("" + DataUtils.roundFixed(this.getFracStrikeSlip(i), 6));
                    line.add("" + DataUtils.roundFixed(this.getFracReverse(i), 6));
                    line.add("" + DataUtils.roundFixed(this.getFracNormal(i), 6));
                } else {
                    line.add("" + this.getFracStrikeSlip(i));
                    line.add("" + this.getFracReverse(i));
                    line.add("" + this.getFracNormal(i));
                }
                line.add(this.getTectonicRegionType(i).name());
                csv.addLine((List<String>)line);
            }
            return csv;
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            CSVFile<String> subSeisCSV = this.buildCSV((Map<Integer, IncrementalMagFreqDist>)this.nodeSubSeisMFDs);
            CSVFile<String> unassociatedCSV = this.buildCSV((Map<Integer, IncrementalMagFreqDist>)this.nodeUnassociatedMFDs);
            Feature regFeature = this.region.toFeature();
            OutputStreamWriter writer = new OutputStreamWriter(FileBackedModule.initOutputStream(output, entryPrefix, "grid_region.geojson"));
            Feature.write(regFeature, writer);
            writer.flush();
            output.closeEntry();
            if (subSeisCSV != null) {
                CSV_BackedModule.writeToArchive(subSeisCSV, output, entryPrefix, MFDGridSourceProvider.ARCHIVE_SUB_SEIS_FILE_NAME);
            }
            if (unassociatedCSV != null) {
                CSV_BackedModule.writeToArchive(unassociatedCSV, output, entryPrefix, MFDGridSourceProvider.ARCHIVE_UNASSOCIATED_FILE_NAME);
            }
            CSV_BackedModule.writeToArchive(this.buildWeightsCSV(), output, entryPrefix, MFDGridSourceProvider.ARCHIVE_MECH_WEIGHT_FILE_NAME);
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            GriddedRegion region;
            CSVFile<String> subSeisCSV = AbstractPrecomputed.loadCSV(input, entryPrefix, MFDGridSourceProvider.ARCHIVE_SUB_SEIS_FILE_NAME);
            CSVFile<String> nodeUnassociatedCSV = AbstractPrecomputed.loadCSV(input, entryPrefix, MFDGridSourceProvider.ARCHIVE_UNASSOCIATED_FILE_NAME);
            CSVFile<String> mechCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, MFDGridSourceProvider.ARCHIVE_MECH_WEIGHT_FILE_NAME);
            if (FileBackedModule.hasEntry(input, entryPrefix, "grid_region.geojson")) {
                BufferedInputStream regionIS = FileBackedModule.getInputStream(input, entryPrefix, "grid_region.geojson");
                InputStreamReader regionReader = new InputStreamReader(regionIS);
                Feature regFeature = Feature.read(regionReader);
                region = GriddedRegion.fromFeature(regFeature);
            } else {
                System.out.println("Gridded region GeoJSON not supplied, inferring region from grid nodes in focal mechanism CSV file");
                LocationList gridNodes = new LocationList();
                for (int row = 1; row < mechCSV.getNumRows(); ++row) {
                    int index = mechCSV.getInt(row, 0);
                    Preconditions.checkState((index == row - 1 ? 1 : 0) != 0, (Object)"Mechanism row indexes must be in order and 0-based");
                    double lat = mechCSV.getDouble(row, 1);
                    double lon = mechCSV.getDouble(row, 2);
                    gridNodes.add(new Location(lat, lon));
                }
                region = GriddedRegion.inferRegion(gridNodes);
            }
            this.init(region, subSeisCSV, nodeUnassociatedCSV, mechCSV);
        }

        public void init(GriddedRegion region, CSVFile<String> subSeisCSV, CSVFile<String> unassociatedCSV, CSVFile<String> mechCSV) {
            this.region = region;
            Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs = AbstractPrecomputed.csvToMFDs(region, subSeisCSV);
            Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs = AbstractPrecomputed.csvToMFDs(region, unassociatedCSV);
            this.nodeSubSeisMFDs = nodeSubSeisMFDs == null ? ImmutableMap.of() : ImmutableMap.copyOf(nodeSubSeisMFDs);
            this.nodeUnassociatedMFDs = nodeUnassociatedMFDs == null ? ImmutableMap.of() : ImmutableMap.copyOf(nodeUnassociatedMFDs);
            Preconditions.checkState((mechCSV.getNumRows() == region.getNodeCount() + 1 ? 1 : 0) != 0, (String)"Mechanism node count mismatch, expected %s, have %s", (int)region.getNodeCount(), (int)(mechCSV.getNumRows() - 1));
            this.fracStrikeSlip = new double[region.getNodeCount()];
            this.fracReverse = new double[region.getNodeCount()];
            this.fracNormal = new double[region.getNodeCount()];
            this.trts = new TectonicRegionType[region.getNodeCount()];
            for (int i = 0; i < region.getNodeCount(); ++i) {
                int row = i + 1;
                int index = mechCSV.getInt(row, 0);
                Preconditions.checkState((index == i ? 1 : 0) != 0, (Object)"Mechanism row indexes must be in order and 0-based");
                double lat = mechCSV.getDouble(row, 1);
                double lon = mechCSV.getDouble(row, 2);
                Location loc = region.getLocation(index);
                Preconditions.checkState(((float)lat == (float)loc.getLatitude() ? 1 : 0) != 0, (String)"Latitude mismatch at index %s: %s != %s", (Object)index, (Object)lat, (Object)loc.getLatitude());
                Preconditions.checkState(((float)lon == (float)loc.getLongitude() ? 1 : 0) != 0, (String)"Longitude mismatch at index %s: %s != %s", (Object)index, (Object)lon, (Object)loc.getLongitude());
                this.fracStrikeSlip[i] = mechCSV.getDouble(row, 3);
                this.fracReverse[i] = mechCSV.getDouble(row, 4);
                this.fracNormal[i] = mechCSV.getDouble(row, 5);
                List<String> line = mechCSV.getLine(row);
                this.trts[i] = line.size() < 7 ? TectonicRegionType.ACTIVE_SHALLOW : TectonicRegionType.valueOf(line.get(6));
            }
        }

        public static CSVFile<String> loadCSV(ArchiveInput input, String entryPrefix, String fileName) throws IOException {
            String entryName = ArchivableModule.getEntryName(entryPrefix, fileName);
            Preconditions.checkNotNull((Object)entryName, (String)"entryName is null. prefix='%s', fileName='%s'", (Object)entryPrefix, (Object)fileName);
            if (!input.hasEntry(entryName)) {
                return null;
            }
            return CSVFile.readStream(new BufferedInputStream(input.getInputStream(entryName)), true);
        }

        private static Map<Integer, IncrementalMagFreqDist> csvToMFDs(GriddedRegion region, CSVFile<String> csv) {
            if (csv == null) {
                return null;
            }
            HashMap<Integer, IncrementalMagFreqDist> mfds = new HashMap<Integer, IncrementalMagFreqDist>();
            double minX = csv.getDouble(0, 3);
            double maxX = csv.getDouble(0, csv.getNumCols() - 1);
            int numX = csv.getNumCols() - 3;
            for (int row = 1; row < csv.getNumRows(); ++row) {
                int index = csv.getInt(row, 0);
                Preconditions.checkState((index >= 0 && index <= region.getNodeCount() ? 1 : 0) != 0, (String)"Bad grid node index: %s (max=%s)", (int)index, (int)region.getNodeCount());
                double lat = csv.getDouble(row, 1);
                double lon = csv.getDouble(row, 2);
                Location loc = region.getLocation(index);
                Preconditions.checkState(((float)lat == (float)loc.getLatitude() ? 1 : 0) != 0, (String)"Latitude mismatch at index %s: %s != %s", (Object)index, (Object)lat, (Object)loc.getLatitude());
                Preconditions.checkState(((float)lon == (float)loc.getLongitude() ? 1 : 0) != 0, (String)"Longitude mismatch at index %s: %s != %s", (Object)index, (Object)lon, (Object)loc.getLongitude());
                if (csv.getLine(row).size() < 4 || csv.get(row, 3).isBlank()) continue;
                IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(minX, maxX, numX);
                for (int i = 0; i < numX; ++i) {
                    mfd.set(i, csv.getDouble(row, 3 + i));
                }
                mfds.put(index, mfd);
            }
            return mfds;
        }

        @Override
        public void scaleAll(double[] valuesArray) {
            if (valuesArray.length != this.getGriddedRegion().getNodeCount()) {
                throw new RuntimeException("Error: valuesArray must have same length as getGriddedRegion().getNodeCount()");
            }
            for (int i = 0; i < valuesArray.length; ++i) {
                if (valuesArray[i] == 1.0) continue;
                IncrementalMagFreqDist mfd = this.getMFD_Unassociated(i);
                if (mfd != null) {
                    mfd.scale(valuesArray[i]);
                }
                if ((mfd = this.getMFD_SubSeisOnFault(i)) == null) continue;
                mfd.scale(valuesArray[i]);
            }
        }

        @Override
        public TectonicRegionType getTectonicRegionType(int gridIndex) {
            return this.trts[gridIndex];
        }
    }

    public static abstract class Abstract
    implements MFDGridSourceProvider {
        protected abstract ProbEqkSource buildSource(int var1, IncrementalMagFreqDist var2, double var3, GriddedSeismicitySettings var5);

        @Override
        public int getNumLocations() {
            return this.getGriddedRegion().getNodeCount();
        }

        @Override
        public IncrementalMagFreqDist getMFD(int idx, double minMag) {
            return MFDGridSourceProvider.trimMFD(this.getMFD(idx), minMag);
        }

        @Override
        public double getCumulativeNucleationRate(int gridIndex, double minMag) {
            IncrementalMagFreqDist mfd = this.getMFD(gridIndex);
            if (mfd == null) {
                return 0.0;
            }
            int magIndex = mfd.getClosestXIndex(minMag);
            if ((float)mfd.getX(magIndex) < (float)minMag) {
                ++magIndex;
            }
            if (magIndex < mfd.size()) {
                return mfd.getCumRate(magIndex);
            }
            return 0.0;
        }

        @Override
        public double getCumulativeNucleationRate(TectonicRegionType tectonicRegionType, int gridIndex, double minMag) {
            if (tectonicRegionType == null || this.getTectonicRegionType(gridIndex) == tectonicRegionType) {
                return this.getCumulativeNucleationRate(gridIndex, minMag);
            }
            return 0.0;
        }

        private void applyAftershockFilter(IncrementalMagFreqDist mfd, MagnitudeDependentAftershockFilter aftershockFilter) {
            for (int i = 0; i < mfd.size(); ++i) {
                double rate = mfd.getY(i);
                if (!(rate > 0.0)) continue;
                double mag = mfd.getX(i);
                mfd.set(i, aftershockFilter.getFilteredRate(mag, rate));
            }
        }

        @Override
        public ProbEqkSource getSource(int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
            IncrementalMagFreqDist mfd = this.getMFD(gridIndex, gridSourceSettings.minimumMagnitude);
            if (mfd == null) {
                return null;
            }
            if (aftershockFilter != null) {
                this.applyAftershockFilter(mfd, aftershockFilter);
            }
            return this.buildSource(gridIndex, mfd, duration, gridSourceSettings);
        }

        @Override
        public ProbEqkSource getSourceSubSeisOnFault(int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
            IncrementalMagFreqDist mfd = this.getMFD_SubSeisOnFault(gridIndex);
            if (mfd == null) {
                return null;
            }
            mfd = MFDGridSourceProvider.trimMFD(mfd, gridSourceSettings.minimumMagnitude);
            if (aftershockFilter != null) {
                this.applyAftershockFilter(mfd, aftershockFilter);
            }
            return this.buildSource(gridIndex, mfd, duration, gridSourceSettings);
        }

        @Override
        public ProbEqkSource getSourceUnassociated(int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
            IncrementalMagFreqDist mfd = this.getMFD_Unassociated(gridIndex);
            if (mfd == null) {
                return null;
            }
            mfd = MFDGridSourceProvider.trimMFD(mfd, gridSourceSettings.minimumMagnitude);
            if (aftershockFilter != null) {
                this.applyAftershockFilter(mfd, aftershockFilter);
            }
            return this.buildSource(gridIndex, mfd, duration, gridSourceSettings);
        }

        @Override
        public IncrementalMagFreqDist getMFD(int idx) {
            IncrementalMagFreqDist nodeIndMFD = this.getMFD_Unassociated(idx);
            IncrementalMagFreqDist nodeSubMFD = this.getMFD_SubSeisOnFault(idx);
            if (nodeIndMFD == null) {
                return nodeSubMFD;
            }
            if (nodeSubMFD == null) {
                return nodeIndMFD;
            }
            Preconditions.checkState(((float)nodeIndMFD.getMinX() == (float)nodeSubMFD.getMinX() ? 1 : 0) != 0, (String)"Sub-seismo and unassociated MFDs have different minX for grid node %x: %x != %x", (Object)idx, (Object)nodeIndMFD.getMinX(), (Object)nodeSubMFD.getMinX());
            Preconditions.checkState(((float)nodeIndMFD.getDelta() == (float)nodeSubMFD.getDelta() ? 1 : 0) != 0, (String)"Sub-seismo and unassociated MFDs have different spacings for grid node %x: %x != %x", (Object)idx, (Object)nodeIndMFD.getDelta(), (Object)nodeSubMFD.getDelta());
            int retSize = Integer.max(nodeIndMFD.size(), nodeSubMFD.size());
            SummedMagFreqDist sumMFD = new SummedMagFreqDist(nodeIndMFD.getMinX(), retSize, nodeIndMFD.getDelta());
            sumMFD.addIncrementalMagFreqDist(nodeSubMFD);
            sumMFD.addIncrementalMagFreqDist(nodeIndMFD);
            return sumMFD;
        }
    }
}

