/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class ModSectMinMags
implements SubModule<FaultSystemRupSet>,
BranchAverageableModule<ModSectMinMags>,
SplittableRuptureModule<ModSectMinMags> {
    FaultSystemRupSet rupSet;

    protected ModSectMinMags(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }

    @Override
    public String getName() {
        return "Modified Section Minimum Magnitudes";
    }

    public abstract double getMinMagForSection(int var1);

    public abstract double[] getMinMagForSections();

    public boolean isBelowSectMinMag(int sectIndex, double mag) {
        return this.isBelowSectMinMag(sectIndex, mag, null);
    }

    public boolean isBelowSectMinMag(int sectIndex, double mag, EvenlyDiscretizedFunc referenceGridding) {
        double minMag = this.getMinMagForSection(sectIndex);
        if ((float)mag >= (float)minMag) {
            return false;
        }
        if (referenceGridding != null) {
            int minIndex = referenceGridding.getClosestXIndex(minMag + 1.0E-4);
            int magIndex = referenceGridding.getClosestXIndex(mag);
            return magIndex < minIndex;
        }
        return true;
    }

    public boolean isRupBelowSectMinMag(int rupIndex) {
        return this.isRupBelowSectMinMag(rupIndex, null);
    }

    public boolean isRupBelowSectMinMag(int rupIndex, EvenlyDiscretizedFunc referenceGridding) {
        double mag = this.rupSet.getMagForRup(rupIndex);
        for (int sectIndex : this.rupSet.getSectionsIndicesForRup(rupIndex)) {
            if (!this.isBelowSectMinMag(sectIndex, mag, referenceGridding)) continue;
            return true;
        }
        return false;
    }

    public static ModSectMinMags above(FaultSystemRupSet rupSet, double systemWideMinMag, boolean useMaxForParent) {
        double[] minMags = new double[rupSet.getNumSections()];
        for (int s = 0; s < minMags.length; ++s) {
            minMags[s] = Math.max(systemWideMinMag, rupSet.getMinMagForSection(s));
        }
        if (useMaxForParent) {
            for (List<FaultSection> parentSects : rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId())).values()) {
                double maxMin = 0.0;
                for (FaultSection sect : parentSects) {
                    maxMin = Math.max(maxMin, minMags[sect.getSectionId()]);
                }
                for (FaultSection sect : parentSects) {
                    minMags[sect.getSectionId()] = Math.max(minMags[sect.getSectionId()], maxMin);
                }
            }
        }
        return new Precomputed(rupSet, minMags);
    }

    public static ModSectMinMags instance(FaultSystemRupSet rupSet, double[] sectMinMags) {
        return new Precomputed(rupSet, sectMinMags);
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        if (this.rupSet != null) {
            Preconditions.checkState((this.rupSet.getNumSections() == parent.getNumSections() ? 1 : 0) != 0);
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    public static class Precomputed
    extends ModSectMinMags
    implements CSV_BackedModule {
        private double[] sectMinMags;

        private Precomputed() {
            super(null);
        }

        private Precomputed(FaultSystemRupSet rupSet, double[] sectMinMags) {
            super(rupSet);
            Preconditions.checkNotNull((Object)rupSet);
            Preconditions.checkNotNull((Object)sectMinMags);
            Preconditions.checkState((rupSet.getNumSections() == sectMinMags.length ? 1 : 0) != 0);
            this.sectMinMags = sectMinMags;
        }

        @Override
        public double getMinMagForSection(int sectIndex) {
            return this.sectMinMags[sectIndex];
        }

        @Override
        public double[] getMinMagForSections() {
            return this.sectMinMags;
        }

        @Override
        public String getFileName() {
            return "mod_sect_min_mags.csv";
        }

        @Override
        public CSVFile<?> getCSV() {
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Section Index", "Minimum Magnitude");
            for (int s = 0; s < this.sectMinMags.length; ++s) {
                csv.addLine("" + s, "" + this.sectMinMags[s]);
            }
            return csv;
        }

        @Override
        public void initFromCSV(CSVFile<String> csv) {
            int numSects = this.rupSet.getNumSections();
            Preconditions.checkState((csv.getNumRows() == numSects + 1 ? 1 : 0) != 0, (String)"Expected 1 header row and %s section rows, have %s", (int)numSects, (int)csv.getNumRows());
            double[] sectMinMags = new double[numSects];
            for (int r = 0; r < numSects; ++r) {
                int row = r + 1;
                Preconditions.checkState((csv.getInt(row, 0) == r ? 1 : 0) != 0, (Object)"Data not in order (or not 0-based)");
                sectMinMags[r] = csv.getDouble(row, 1);
            }
            this.sectMinMags = sectMinMags;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkState((this.rupSet.getNumSections() == newParent.getNumSections() ? 1 : 0) != 0);
            return new Precomputed(newParent, this.sectMinMags);
        }

        @Override
        public AverageableModule.AveragingAccumulator<ModSectMinMags> averagingAccumulator() {
            return new AverageableModule.AveragingAccumulator<ModSectMinMags>(){
                private double[] avgValues = null;
                private double sumWeight = 0.0;

                @Override
                public void process(ModSectMinMags module, double relWeight) {
                    double[] modVals = module.getMinMagForSections();
                    if (this.avgValues == null) {
                        this.avgValues = new double[modVals.length];
                    } else {
                        Preconditions.checkState((modVals.length == this.avgValues.length ? 1 : 0) != 0);
                    }
                    for (int i = 0; i < this.avgValues.length; ++i) {
                        int n = i;
                        this.avgValues[n] = this.avgValues[n] + modVals[i] * relWeight;
                    }
                    this.sumWeight += relWeight;
                }

                @Override
                public ModSectMinMags getAverage() {
                    AverageableModule.scaleToTotalWeight(this.avgValues, this.sumWeight);
                    Precomputed ret = new Precomputed();
                    ret.sectMinMags = this.avgValues;
                    return ret;
                }

                @Override
                public Class<ModSectMinMags> getType() {
                    return ModSectMinMags.class;
                }
            };
        }

        @Override
        public ModSectMinMags getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            double[] remapped = new double[mappings.getNumRetainedSects()];
            for (int s = 0; s < remapped.length; ++s) {
                remapped[s] = this.sectMinMags[mappings.getOrigSectID(s)];
            }
            return new Precomputed(rupSubSet, remapped);
        }

        @Override
        public ModSectMinMags getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            double[] remapped = new double[splitRupSet.getNumSections()];
            for (int s = 0; s < remapped.length; ++s) {
                remapped[s] = this.sectMinMags[mappings.getOrigSectID(s)];
            }
            return new Precomputed(splitRupSet, remapped);
        }
    }
}

