/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;

public abstract class SectAreas
implements SubModule<FaultSystemRupSet>,
SplittableRuptureModule<SectAreas> {
    protected FaultSystemRupSet parent;
    public static final String DATA_FILE_NAME = "sect_areas.csv";

    private SectAreas(FaultSystemRupSet parent) {
        this.parent = parent;
    }

    public static SectAreas precomputed(FaultSystemRupSet rupSet, double[] sectAreas) {
        return new Precomputed(rupSet, sectAreas);
    }

    public static SectAreas fromFaultSectData(FaultSystemRupSet rupSet) {
        return new Default(rupSet);
    }

    public abstract double getSectArea(int var1);

    public double[] getSectAreas() {
        FaultSystemRupSet rupSet = this.getParent();
        Preconditions.checkNotNull((Object)rupSet, (Object)"parent rupture set not set");
        double[] ret = new double[rupSet.getNumSections()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getSectArea(i);
        }
        return ret;
    }

    @Override
    public String getName() {
        return "Section Areas";
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        this.parent = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.parent;
    }

    public static class Precomputed
    extends SectAreas
    implements CSV_BackedModule,
    AverageableModule.ConstantAverageable<Precomputed> {
        private double[] sectAreas;

        private Precomputed() {
            super(null);
        }

        private Precomputed(FaultSystemRupSet rupSet, double[] sectAreas) {
            super(rupSet);
            int numSects = rupSet.getNumSections();
            Preconditions.checkState((sectAreas.length == numSects ? 1 : 0) != 0, (Object)"Num areas != num sections");
            this.sectAreas = sectAreas;
        }

        @Override
        public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkNotNull((Object)newParent);
            Preconditions.checkState((newParent.getNumSections() == this.sectAreas.length ? 1 : 0) != 0);
            return new Precomputed(newParent, this.sectAreas);
        }

        @Override
        public double getSectArea(int sectIndex) {
            return this.sectAreas[sectIndex];
        }

        @Override
        public double[] getSectAreas() {
            return this.sectAreas;
        }

        @Override
        public String getFileName() {
            return SectAreas.DATA_FILE_NAME;
        }

        @Override
        public CSVFile<?> getCSV() {
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Section Index", "Section Area (m^2)");
            int numSections = ((FaultSystemRupSet)this.getParent()).getNumSections();
            for (int s = 0; s < numSections; ++s) {
                csv.addLine("" + s, "" + this.getSectArea(s));
            }
            return csv;
        }

        @Override
        public void initFromCSV(CSVFile<String> csv) {
            int numSects = ((FaultSystemRupSet)this.getParent()).getNumSections();
            Preconditions.checkState((csv.getNumRows() == numSects + 1 ? 1 : 0) != 0, (String)"Expected 1 header row and %s section rows, have %s", (int)numSects, (int)csv.getNumRows());
            double[] sectAreas = new double[numSects];
            for (int s = 0; s < numSects; ++s) {
                int row = s + 1;
                Preconditions.checkState((csv.getInt(row, 0) == s ? 1 : 0) != 0, (Object)"Rows out of order or not 0-based");
                sectAreas[s] = csv.getDouble(row, 1);
            }
            this.sectAreas = sectAreas;
        }

        @Override
        public Class<Precomputed> getAveragingType() {
            return Precomputed.class;
        }

        @Override
        public boolean isIdentical(Precomputed module) {
            if (this.sectAreas.length != module.sectAreas.length) {
                return false;
            }
            for (int s = 0; s < this.sectAreas.length; ++s) {
                if ((float)this.sectAreas[s] == (float)module.sectAreas[s]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Precomputed getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            double[] filtered = new double[rupSubSet.getNumSections()];
            for (int s = 0; s < rupSubSet.getNumSections(); ++s) {
                filtered[s] = this.sectAreas[mappings.getOrigSectID(s)];
            }
            return new Precomputed(rupSubSet, filtered);
        }

        @Override
        public SectAreas getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            double[] filtered = new double[splitRupSet.getNumSections()];
            for (int s = 0; s < splitRupSet.getNumSections(); ++s) {
                filtered[s] = this.sectAreas[mappings.getOrigSectID(s)];
            }
            return new Precomputed(splitRupSet, filtered);
        }
    }

    public static class Default
    extends SectAreas
    implements SubModule<FaultSystemRupSet> {
        private double[] data = null;

        private Default(FaultSystemRupSet rupSet) {
            super(rupSet);
        }

        public Default copy(FaultSystemRupSet newParent) throws IllegalStateException {
            Preconditions.checkNotNull((Object)newParent);
            return new Default(newParent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getSectArea(int sectIndex) {
            if (this.data == null) {
                Default default_ = this;
                synchronized (default_) {
                    if (this.data == null) {
                        double[] data = new double[this.parent.getNumSections()];
                        for (int s = 0; s < data.length; ++s) {
                            data[s] = this.parent.getFaultSectionData(s).getArea(true);
                        }
                        this.data = data;
                    }
                }
            }
            return this.data[sectIndex];
        }

        @Override
        public SectAreas getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            return this.copy(rupSubSet);
        }

        @Override
        public SectAreas getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            return this.copy(splitRupSet);
        }
    }
}

