/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.earthquake.faultSysSolution.util.SlipAlongRuptureModelBranchNode;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;

public abstract class SlipAlongRuptureModel
implements OpenSHA_Module {
    private static EvenlyDiscretizedFunc taperedSlipPDF;
    private static EvenlyDiscretizedFunc taperedSlipCDF;

    public static SlipAlongRuptureModel forModel(SlipAlongRuptureModelBranchNode slipAlong) {
        return slipAlong.getModel();
    }

    public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, AveSlipModule aveSlips, int rthRup) {
        return this.calcSlipOnSectionsForRup(rupSet, rthRup, aveSlips.getAveSlip(rthRup));
    }

    public boolean isUniform() {
        return false;
    }

    public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double aveSlip) {
        List<Integer> sectionIndices = rupSet.getSectionsIndicesForRup(rthRup);
        int numSects = sectionIndices.size();
        double[] sectArea = new double[numSects];
        int index = 0;
        for (Integer sectID : sectionIndices) {
            sectArea[index] = rupSet.getAreaForSection(sectID);
            ++index;
        }
        return this.calcSlipOnSectionsForRup(rupSet, rthRup, sectArea, aveSlip);
    }

    public double calcSlipRateForSect(FaultSystemSolution sol, AveSlipModule aveSlips, int sectIndex) {
        return this.calcSlipRateForSects(sol, aveSlips)[sectIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] calcSlipRateForSects(FaultSystemSolution sol, AveSlipModule aveSlips) {
        SolutionSlipRates cached = sol.getModule(SolutionSlipRates.class);
        if (cached == null) {
            FaultSystemSolution faultSystemSolution = sol;
            synchronized (faultSystemSolution) {
                cached = sol.getModule(SolutionSlipRates.class);
                if (cached == null) {
                    cached = SolutionSlipRates.calc(sol, aveSlips, this);
                    sol.addModule(cached);
                }
            }
        }
        return cached.get();
    }

    public abstract double[] calcSlipOnSectionsForRup(FaultSystemRupSet var1, int var2, double[] var3, double var4);

    protected static double[] calcUniformSlipAlong(int numSects, double aveSlip) {
        double[] slipsForRup = new double[numSects];
        for (int s = 0; s < slipsForRup.length; ++s) {
            slipsForRup[s] = aveSlip;
        }
        return slipsForRup;
    }

    private static class PrecomputedAverager
    implements AverageableModule.AveragingAccumulator<Precomputed> {
        private double sumWeights;
        private List<double[]> weightedSlipsAlong;

        private PrecomputedAverager() {
        }

        @Override
        public Class<Precomputed> getType() {
            return Precomputed.class;
        }

        @Override
        public void process(Precomputed module, double relWeight) {
            if (this.weightedSlipsAlong == null) {
                this.weightedSlipsAlong = new ArrayList<double[]>(module.slipsAlong.size());
                for (int i = 0; i < module.slipsAlong.size(); ++i) {
                    this.weightedSlipsAlong.add(new double[module.slipsAlong.get(i).length]);
                }
                this.sumWeights = 0.0;
            }
            if (relWeight == 0.0) {
                return;
            }
            Preconditions.checkState((module.slipsAlong.size() == this.weightedSlipsAlong.size() ? 1 : 0) != 0, (String)"Passed in module has a different rupture count: %s != %s", (int)module.slipsAlong.size(), (int)this.weightedSlipsAlong.size());
            for (int r = 0; r < this.weightedSlipsAlong.size(); ++r) {
                double[] weightedSlips = this.weightedSlipsAlong.get(r);
                double[] moduleSlips = module.slipsAlong.get(r);
                Preconditions.checkState((moduleSlips.length == weightedSlips.length ? 1 : 0) != 0, (String)"Passed in module has a different section count for rupture %s: %s != %s", (Object)r, (Object)moduleSlips.length, (Object)weightedSlips.length);
                for (int s = 0; s < weightedSlips.length; ++s) {
                    int n = s;
                    weightedSlips[n] = weightedSlips[n] + relWeight * moduleSlips[s];
                }
            }
        }

        @Override
        public Precomputed getAverage() {
            Preconditions.checkNotNull(this.weightedSlipsAlong, (Object)"Never initialized (or was reused?)");
            Preconditions.checkState((this.sumWeights > 0.0 ? 1 : 0) != 0, (Object)"All weights were zero");
            if (this.sumWeights != 1.0) {
                double scalar = 1.0 / this.sumWeights;
                for (int r = 0; r < this.weightedSlipsAlong.size(); ++r) {
                    double[] weightedSlips = this.weightedSlipsAlong.get(r);
                    int s = 0;
                    while (s < weightedSlips.length) {
                        int n = s++;
                        weightedSlips[n] = weightedSlips[n] * scalar;
                    }
                }
            }
            Precomputed ret = new Precomputed(this.weightedSlipsAlong);
            this.weightedSlipsAlong = null;
            this.sumWeights = Double.NaN;
            return ret;
        }
    }

    public static class Precomputed
    extends SlipAlongRuptureModel
    implements LargeCSV_BackedModule,
    AverageableModule<Precomputed>,
    SplittableRuptureModule<Precomputed> {
        public static final String FILE_NAME = "slip_along_ruptures.csv";
        private List<double[]> slipsAlong;

        private Precomputed() {
        }

        public Precomputed(List<double[]> slipsAlong) {
            this.slipsAlong = slipsAlong;
        }

        @Override
        public String getName() {
            return "Precomputed Slip Along Ruptures";
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double[] sectArea, double aveSlip) {
            Preconditions.checkState((rupSet == null || rupSet.getNumRuptures() == this.slipsAlong.size() ? 1 : 0) != 0, (Object)"Rupture set has a different rupture count than we do");
            return this.slipsAlong.get(rthRup);
        }

        @Override
        public Precomputed getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            ArrayList<double[]> subset = new ArrayList<double[]>(mappings.getNumRetainedRuptures());
            for (int r = 0; r < mappings.getNumRetainedRuptures(); ++r) {
                subset.add(this.slipsAlong.get(mappings.getOrigRupID(r)));
            }
            return new Precomputed(subset);
        }

        @Override
        public Precomputed getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            ArrayList<double[]> splitSet = new ArrayList<double[]>(mappings.getNewNumRuptures());
            for (int r = 0; r < mappings.getNewNumRuptures(); ++r) {
                splitSet.add(this.slipsAlong.get(mappings.getOrigRupID(r)));
            }
            return new Precomputed(splitSet);
        }

        @Override
        public AverageableModule.AveragingAccumulator<Precomputed> averagingAccumulator() {
            return new PrecomputedAverager();
        }

        @Override
        public String getFileName() {
            return FILE_NAME;
        }

        @Override
        public void writeCSV(CSVWriter writer) throws IOException {
            writer.write(List.of("Rupture Index", "Section Slip 1 (m)", "...", "Section Slip N (m)"));
            for (int r = 0; r < this.slipsAlong.size(); ++r) {
                double[] slips = this.slipsAlong.get(r);
                ArrayList<String> line = new ArrayList<String>(slips.length + 1);
                line.add("" + r);
                for (double slip : slips) {
                    line.add("" + slip);
                }
                writer.write(line);
            }
        }

        @Override
        public void initFromCSV(CSVReader csv) {
            ArrayList<double[]> slipsAlong = new ArrayList<double[]>();
            csv.read();
            for (CSVReader.Row row : csv) {
                int index = row.getInt(0);
                Preconditions.checkState((index == slipsAlong.size() ? 1 : 0) != 0, (String)"Rows out of order? Encountered rupture index %s, expected %s", (int)index, (int)slipsAlong.size());
                double[] slips = new double[row.columns() - 1];
                for (int i = 0; i < slips.length; ++i) {
                    slips[i] = row.getDouble(i + 1);
                }
                slipsAlong.add(slips);
            }
            this.slipsAlong = slipsAlong;
        }
    }

    public static class AVG_UCERF3
    extends NamedSlipAlongRuptureModel {
        @Override
        public String getName() {
            return "Mean UCERF3 Slip Along Rupture";
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double[] sectArea, double aveSlip) {
            double[] slipsForRup = new double[sectArea.length];
            ArrayList<Double> meanWeights = new ArrayList<Double>();
            ArrayList<SlipAlongRuptureModels> meanSALs = new ArrayList<SlipAlongRuptureModels>();
            double sum = 0.0;
            for (SlipAlongRuptureModels sal : SlipAlongRuptureModels.values()) {
                double weight = sal.getRelativeWeight(null);
                if (!(weight > 0.0)) continue;
                meanWeights.add(weight);
                meanSALs.add(sal);
                sum += weight;
            }
            if (sum != 0.0) {
                for (int i = 0; i < meanWeights.size(); ++i) {
                    meanWeights.set(i, (Double)meanWeights.get(i) / sum);
                }
            }
            for (int i = 0; i < meanSALs.size(); ++i) {
                double weight = (Double)meanWeights.get(i);
                double[] subSlips = ((SlipAlongRuptureModels)meanSALs.get(i)).getModel().calcSlipOnSectionsForRup(rupSet, rthRup, sectArea, aveSlip);
                for (int j = 0; j < slipsForRup.length; ++j) {
                    int n = j;
                    slipsForRup[n] = slipsForRup[n] + weight * subSlips[j];
                }
            }
            return slipsForRup;
        }
    }

    public static class WG02
    extends NamedSlipAlongRuptureModel {
        @Override
        public String getName() {
            return "WG02 Slip Along Rupture";
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double[] sectArea, double aveSlip) {
            double[] slipsForRup = new double[sectArea.length];
            double[] sectMoRate = new double[sectArea.length];
            int index = 0;
            for (Integer sectID : rupSet.getSectionsIndicesForRup(rthRup)) {
                sectMoRate[index] = FaultMomentCalc.getMoment(sectArea[index], rupSet.getSlipRateForSection(sectID));
                ++index;
            }
            List<Integer> sectsInRup = rupSet.getSectionsIndicesForRup(rthRup);
            double totMoRateForRup = 0.0;
            for (Integer sectID : sectsInRup) {
                double area = rupSet.getAreaForSection(sectID);
                totMoRateForRup += FaultMomentCalc.getMoment(area, rupSet.getSlipRateForSection(sectID));
            }
            for (int s = 0; s < slipsForRup.length; ++s) {
                slipsForRup[s] = aveSlip * sectMoRate[s] * rupSet.getAreaForRup(rthRup) / (totMoRateForRup * sectArea[s]);
            }
            return slipsForRup;
        }
    }

    public static class Tapered
    extends NamedSlipAlongRuptureModel {
        @Override
        public String getName() {
            return "Tapered Slip Along Rupture";
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double[] sectArea, double aveSlip) {
            return this.calcSlipOnSectionsForRup(sectArea, rupSet.getAreaForRup(rthRup), aveSlip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public double[] calcSlipOnSectionsForRup(double[] sectArea, double rupArea, double aveSlip) {
            double[] slipsForRup = new double[sectArea.length];
            if (taperedSlipCDF == null) {
                Class<SlipAlongRuptureModel> clazz = SlipAlongRuptureModel.class;
                // MONITORENTER : org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel.class
                if (taperedSlipCDF == null) {
                    int i;
                    double y;
                    EvenlyDiscretizedFunc taperedSlipCDF = new EvenlyDiscretizedFunc(0.0, 5001, 2.0E-4);
                    EvenlyDiscretizedFunc taperedSlipPDF = new EvenlyDiscretizedFunc(0.0, 5001, 2.0E-4);
                    double sum = 0.0;
                    int num = taperedSlipPDF.size();
                    for (i = 0; i < num; sum += y, ++i) {
                        double x = taperedSlipPDF.getX(i);
                        y = Math.pow(Math.sin(x * Math.PI), 0.5);
                        taperedSlipPDF.set(i, y);
                    }
                    y = 0.0;
                    for (i = 0; i < num; ++i) {
                        taperedSlipCDF.set(i, (y += taperedSlipPDF.getY(i)) / sum);
                        taperedSlipPDF.set(i, taperedSlipPDF.getY(i) / sum);
                    }
                    SlipAlongRuptureModel.taperedSlipCDF = taperedSlipCDF;
                    SlipAlongRuptureModel.taperedSlipPDF = taperedSlipPDF;
                }
                // MONITOREXIT : clazz
            }
            double normBegin = 0.0;
            int s = 0;
            while (s < slipsForRup.length) {
                double normEnd = normBegin + sectArea[s] / rupArea;
                if (normEnd > 1.0 && normEnd < 1.01) {
                    normEnd = 1.0;
                }
                double scaleFactor = taperedSlipCDF.getInterpolatedY(normEnd) - taperedSlipCDF.getInterpolatedY(normBegin);
                Preconditions.checkState((normEnd >= normBegin ? 1 : 0) != 0, (Object)"End is before beginning!");
                Preconditions.checkState((aveSlip >= 0.0 ? 1 : 0) != 0, (Object)("Negative ave slip: " + aveSlip));
                slipsForRup[s] = aveSlip * (scaleFactor /= normEnd - normBegin);
                normBegin = normEnd;
                ++s;
            }
            return slipsForRup;
        }
    }

    public static class Default
    extends SlipAlongRuptureModel {
        @Override
        public String getName() {
            return "Default (Uniform) Slip Along Rupture";
        }

        @Override
        public boolean isUniform() {
            return true;
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double aveSlip) {
            return Default.calcUniformSlipAlong(rupSet.getSectionsIndicesForRup(rthRup).size(), aveSlip);
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double[] sectArea, double aveSlip) {
            return Default.calcUniformSlipAlong(sectArea.length, aveSlip);
        }
    }

    public static class Uniform
    extends NamedSlipAlongRuptureModel {
        @Override
        public String getName() {
            return "Uniform Slip Along Rupture";
        }

        @Override
        public boolean isUniform() {
            return true;
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double aveSlip) {
            return Uniform.calcUniformSlipAlong(rupSet.getSectionsIndicesForRup(rthRup).size(), aveSlip);
        }

        @Override
        public double[] calcSlipOnSectionsForRup(FaultSystemRupSet rupSet, int rthRup, double[] sectArea, double aveSlip) {
            return Uniform.calcUniformSlipAlong(sectArea.length, aveSlip);
        }
    }

    public static abstract class NamedSlipAlongRuptureModel
    extends SlipAlongRuptureModel
    implements ArchivableModule,
    AverageableModule.ConstantAverageable<NamedSlipAlongRuptureModel>,
    SplittableRuptureModule<NamedSlipAlongRuptureModel> {
        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        }

        @Override
        public Class<NamedSlipAlongRuptureModel> getAveragingType() {
            return NamedSlipAlongRuptureModel.class;
        }

        @Override
        public boolean isIdentical(NamedSlipAlongRuptureModel module) {
            return this.getClass().equals(module.getClass());
        }

        @Override
        public NamedSlipAlongRuptureModel getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
            return this;
        }

        @Override
        public NamedSlipAlongRuptureModel getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
            return this;
        }
    }
}

