/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.AbstractLogicTreeModule;

public abstract class TrueMeanRuptureMappings
extends AbstractLogicTreeModule {
    public static final String SUB_DIRECTORY_NAME = "mappings";
    public static final String SECT_MAPPING_FILE_NAME = "sect_mappings.csv";
    public static final String RUP_MAPPING_FILE_NAME = "rup_mappings.csv";
    public static final String RUP_MAG_FILE_NAME = "rup_mags.csv";
    protected List<? extends LogicTreeLevel<?>> sectMappingLevels;
    protected List<LogicTreeLevel<?>> rupMappingLevels;
    protected Map<String, int[]> sectFileMappingsCache = new HashMap<String, int[]>();
    protected Map<String, int[]> rupFileMappingsCache = new HashMap<String, int[]>();
    protected Map<String, double[]> rupFileMagsCache = new HashMap<String, double[]>();

    private TrueMeanRuptureMappings(ArchiveInput input, String prefix, LogicTree<?> logicTree) {
        super(input, prefix, logicTree);
    }

    @Override
    protected void setLogicTreeLevels(List<? extends LogicTreeLevel<?>> levels) {
        super.setLogicTreeLevels(levels);
        if (levels == null) {
            this.sectMappingLevels = null;
            this.rupMappingLevels = null;
        } else {
            this.sectMappingLevels = this.getLevelsAffectingFile("fault_sections.geojson", true);
            List<LogicTreeLevel<?>> rupSectLevels = this.getLevelsAffectingFile("indices.csv", true);
            List<LogicTreeLevel<?>> rupPropLevels = this.getLevelsAffectingFile("properties.csv", true);
            this.rupMappingLevels = new ArrayList();
            for (LogicTreeLevel<?> level : levels) {
                if (!this.sectMappingLevels.contains(level) && !rupSectLevels.contains(level) && !rupPropLevels.contains(level)) continue;
                this.rupMappingLevels.add(level);
            }
        }
    }

    @Override
    public String getName() {
        return "True Mean Rupture Mappings";
    }

    @Override
    protected String getSubDirectoryName() {
        return SUB_DIRECTORY_NAME;
    }

    private CSVFile<String> buildMappingCSV(String type, int[] mappings) {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Branch " + type + " Index", "Mapped " + type + " Index");
        for (int i = 0; i < mappings.length; ++i) {
            csv.addLine((String[])new String[]{"" + i, "" + mappings[i]});
        }
        return csv;
    }

    private CSVFile<String> buildMappingCSV(String type, String quantity, double[] vals) {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Branch " + type + " Index", "Branch " + quantity);
        for (int i = 0; i < vals.length; ++i) {
            csv.addLine((String[])new String[]{"" + i, "" + vals[i]});
        }
        return csv;
    }

    public abstract int[] getSectionMappings(LogicTreeBranch<?> var1);

    public abstract int[] getRuptureMappings(LogicTreeBranch<?> var1);

    public abstract double[] getRuptureMags(LogicTreeBranch<?> var1);

    @Override
    protected synchronized Map<String, String> writeBranchFilesToArchive(ArchiveOutput output, String prefix, LogicTreeBranch<?> branch, HashSet<String> writtenFiles) throws IOException {
        double[] rupMags;
        String rupMagsFile;
        int[] rupMappings;
        String rupMappingFile;
        int[] sectMappings;
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        String entryPrefix = null;
        String sectMappingFile = this.getRecordBranchFileName(branch, prefix, SECT_MAPPING_FILE_NAME, this.sectMappingLevels, mappings);
        if (writtenFiles.contains(sectMappingFile)) {
            if (!(this instanceof FileBacked)) {
                sectMappings = this.getSectionMappings(branch);
                int[] prev = this.sectFileMappingsCache.get(sectMappingFile);
                Preconditions.checkNotNull((Object)prev, (String)"Already written %s but prev not cached?", (Object)sectMappingFile);
                Preconditions.checkState((boolean)Arrays.equals(sectMappings, prev), (String)"Mappings not identical for %s, new branch: %s", (Object)sectMappingFile, branch);
            }
        } else {
            sectMappings = this.getSectionMappings(branch);
            CSVFile<String> csv = this.buildMappingCSV("Section", sectMappings);
            CSV_BackedModule.writeToArchive(csv, output, entryPrefix, sectMappingFile);
            this.sectFileMappingsCache.put(sectMappingFile, sectMappings);
            writtenFiles.add(sectMappingFile);
        }
        if (writtenFiles.contains(rupMappingFile = this.getRecordBranchFileName(branch, prefix, RUP_MAPPING_FILE_NAME, this.rupMappingLevels, mappings))) {
            if (!(this instanceof FileBacked)) {
                rupMappings = this.getRuptureMappings(branch);
                int[] prev = this.rupFileMappingsCache.get(rupMappingFile);
                Preconditions.checkNotNull((Object)prev, (String)"Already written %s but prev not cached?", (Object)rupMappingFile);
                Preconditions.checkState((boolean)Arrays.equals(rupMappings, prev), (String)"Mappings not identical for %s, new branch: %s", (Object)rupMappingFile, branch);
            }
        } else {
            rupMappings = this.getRuptureMappings(branch);
            CSVFile<String> csv = this.buildMappingCSV("Rupture", rupMappings);
            CSV_BackedModule.writeToArchive(csv, output, entryPrefix, rupMappingFile);
            this.rupFileMappingsCache.put(rupMappingFile, rupMappings);
            writtenFiles.add(rupMappingFile);
        }
        if (writtenFiles.contains(rupMagsFile = this.getRecordBranchFileName(branch, prefix, RUP_MAG_FILE_NAME, this.rupMappingLevels, mappings))) {
            if (!(this instanceof FileBacked)) {
                rupMags = this.getRuptureMags(branch);
                double[] prev = this.rupFileMagsCache.get(rupMagsFile);
                Preconditions.checkNotNull((Object)prev, (String)"Already written %s but prev not cached?", (Object)rupMagsFile);
                Preconditions.checkState((boolean)Arrays.equals(rupMags, prev), (String)"Mags not identical for %s, new branch: %s", (Object)rupMagsFile, branch);
            }
        } else {
            rupMags = this.getRuptureMags(branch);
            CSVFile<String> csv = this.buildMappingCSV("Rupture", "Magnitude", rupMags);
            CSV_BackedModule.writeToArchive(csv, output, entryPrefix, rupMagsFile);
            this.rupFileMagsCache.put(rupMagsFile, rupMags);
            writtenFiles.add(rupMagsFile);
        }
        return mappings;
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return FileBacked.class;
    }

    public static TrueMeanRuptureMappings build(LogicTree<?> tree, List<int[]> branchSectMappings, List<int[]> branchRupMappings, List<double[]> branchRupMags) {
        Preconditions.checkState((tree.size() == branchSectMappings.size() ? 1 : 0) != 0);
        Preconditions.checkState((tree.size() == branchRupMappings.size() ? 1 : 0) != 0);
        Preconditions.checkState((tree.size() == branchRupMags.size() ? 1 : 0) != 0);
        HashMap branchSectMappingsMap = new HashMap(tree.size());
        HashMap branchRupMappingsMap = new HashMap(tree.size());
        HashMap branchRupMagsMap = new HashMap(tree.size());
        for (int i = 0; i < tree.size(); ++i) {
            LogicTreeBranch<?> branch = tree.getBranch(i);
            branchSectMappingsMap.put(branch, branchSectMappings.get(i));
            branchRupMappingsMap.put(branch, branchRupMappings.get(i));
            branchRupMagsMap.put(branch, branchRupMags.get(i));
        }
        return new InMemory(tree, branchSectMappingsMap, branchRupMappingsMap, branchRupMagsMap);
    }

    private static class FileBacked
    extends TrueMeanRuptureMappings {
        private FileBacked() {
            super(null, null, null);
        }

        private FileBacked(ArchiveInput input, String prefix) {
            super(input, prefix, null);
        }

        @Override
        public int[] getSectionMappings(LogicTreeBranch<?> branch) {
            String sectMappingFile = this.getBranchFileName(branch, TrueMeanRuptureMappings.SECT_MAPPING_FILE_NAME, this.sectMappingLevels);
            return this.getIntCache(sectMappingFile, this.sectFileMappingsCache);
        }

        @Override
        public int[] getRuptureMappings(LogicTreeBranch<?> branch) {
            String rupMappingFile = this.getBranchFileName(branch, TrueMeanRuptureMappings.RUP_MAPPING_FILE_NAME, this.rupMappingLevels);
            return this.getIntCache(rupMappingFile, this.rupFileMappingsCache);
        }

        @Override
        public double[] getRuptureMags(LogicTreeBranch<?> branch) {
            String rupMappingFile = this.getBranchFileName(branch, TrueMeanRuptureMappings.RUP_MAG_FILE_NAME, this.rupMappingLevels);
            return this.getDoubleCache(rupMappingFile, this.rupFileMagsCache);
        }

        private synchronized int[] getIntCache(String fileName, Map<String, int[]> cache) {
            int[] ret = cache.get(fileName);
            if (ret == null) {
                CSVFile<String> csv;
                try {
                    ArchiveInput input = this.getArchiveInput();
                    Preconditions.checkState((boolean)input.hasEntry(fileName), (String)"Entry not found: %s", (Object)fileName);
                    csv = CSVFile.readStream(input.getInputStream(fileName), true);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                ret = new int[csv.getNumRows() - 1];
                for (int i = 0; i < ret.length; ++i) {
                    int row = i + 1;
                    int index = csv.getInt(row, 0);
                    Preconditions.checkState((index == i ? 1 : 0) != 0, (String)"File out of order, expected index %s at row %s, found %s", (Object)i, (Object)row, (Object)index);
                    ret[index] = csv.getInt(row, 1);
                }
                cache.put(fileName, ret);
            }
            return ret;
        }

        private synchronized double[] getDoubleCache(String fileName, Map<String, double[]> cache) {
            double[] ret = cache.get(fileName);
            if (ret == null) {
                CSVFile<String> csv;
                try {
                    ArchiveInput input = this.getArchiveInput();
                    Preconditions.checkState((boolean)input.hasEntry(fileName), (String)"Entry not found: %s", (Object)fileName);
                    csv = CSVFile.readStream(input.getInputStream(fileName), true);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                ret = new double[csv.getNumRows() - 1];
                for (int i = 0; i < ret.length; ++i) {
                    int row = i + 1;
                    int index = csv.getInt(row, 0);
                    Preconditions.checkState((index == i ? 1 : 0) != 0, (String)"File out of order, expected index %s at row %s, found %s", (Object)i, (Object)row, (Object)index);
                    ret[index] = csv.getDouble(row, 1);
                }
                cache.put(fileName, ret);
            }
            return ret;
        }
    }

    private static class InMemory
    extends TrueMeanRuptureMappings {
        private Map<LogicTreeBranch<?>, int[]> branchSectMappings;
        private Map<LogicTreeBranch<?>, int[]> branchRupMappings;
        private Map<LogicTreeBranch<?>, double[]> branchRupMags;

        private InMemory(LogicTree<?> logicTree, Map<LogicTreeBranch<?>, int[]> branchSectMappings, Map<LogicTreeBranch<?>, int[]> branchRupMappings, Map<LogicTreeBranch<?>, double[]> branchRupMags) {
            super(null, null, logicTree);
            this.branchSectMappings = branchSectMappings;
            this.branchRupMappings = branchRupMappings;
            this.branchRupMags = branchRupMags;
        }

        @Override
        public int[] getSectionMappings(LogicTreeBranch<?> branch) {
            return this.branchSectMappings.get(branch);
        }

        @Override
        public int[] getRuptureMappings(LogicTreeBranch<?> branch) {
            return this.branchRupMappings.get(branch);
        }

        @Override
        public double[] getRuptureMags(LogicTreeBranch<?> branch) {
            return this.branchRupMags.get(branch);
        }
    }
}

