/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBySectDetailPlots;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SlipRatePlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectIDRange;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_ConstraintBuilder;
import org.opensha.sha.faultSurface.FaultSection;

public class CreepingAndParkfieldReport
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "SAF Creeping Section and Parkfield";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        int creepingID = FaultSectionUtils.findParentSectionID(subSects, "San", "Andreas", "Creeping");
        int parkfieldID = FaultSectionUtils.findParentSectionID(subSects, "San", "Andreas", "Parkfield");
        if (creepingID < 0 && parkfieldID < 0) {
            return null;
        }
        System.out.println("Detected Parkfield ID=" + parkfieldID + " and Creeping Section ID=" + creepingID);
        List parkfieldSects = null;
        if (parkfieldID >= 0) {
            parkfieldSects = subSects.stream().filter(s -> s.getParentSectionId() == parkfieldID).collect(Collectors.toList());
        }
        List creepingSects = null;
        if (creepingID >= 0) {
            creepingSects = subSects.stream().filter(s -> s.getParentSectionId() == creepingID).collect(Collectors.toList());
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (parkfieldID >= 0) {
            lines.add(this.getSubHeading() + " Parkfield Magnitudes");
            lines.add(topLink);
            lines.add("");
            SectIDRange subSectRange = SectIDRange.build(((FaultSection)parkfieldSects.get(0)).getSectionId(), ((FaultSection)parkfieldSects.get(parkfieldSects.size() - 1)).getSectionId());
            int minSectCount = Integer.MAX_VALUE;
            int maxSectCount = 0;
            ArrayList<Integer> parkfieldRups = new ArrayList<Integer>(rupSet.getRupturesForParentSection(parkfieldID));
            int i = parkfieldRups.size();
            while (--i >= 0) {
                int rupIndex = (Integer)parkfieldRups.get(i);
                boolean match = true;
                List<Integer> rupSects = rupSet.getSectionsIndicesForRup(rupIndex);
                for (int sectID : rupSects) {
                    if (subSectRange.contains(sectID)) continue;
                    match = false;
                    break;
                }
                if (match) {
                    minSectCount = Integer.min(minSectCount, rupSects.size());
                    maxSectCount = Integer.max(maxSectCount, rupSects.size());
                    continue;
                }
                parkfieldRups.remove(i);
            }
            lines.add(parkfieldRups.size() + " ruptures found that rupture only the Parkfield section.");
            lines.add("");
            if (!parkfieldRups.isEmpty()) {
                LogicTreeBranch branch;
                MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                table.initNewLine().addColumns("# Subsections", "Rupture Count", "Length (km)", "Magnitude Range");
                RupSetScalingRelationship scaleOption = null;
                ArrayList<RupSetScalingRelationship> altScales = null;
                if (rupSet.hasModule(LogicTreeBranch.class) && (scaleOption = (branch = rupSet.getModule(LogicTreeBranch.class)).getValue(RupSetScalingRelationship.class)) != null) {
                    Class<?> temp;
                    System.out.println("Detected scaling relationship from logic tree branch: " + scaleOption.getName());
                    Class<?> scaleClass = scaleOption.getClass();
                    if (scaleClass.getEnclosingClass() != null && (temp = scaleClass.getEnclosingClass()) != null && RupSetScalingRelationship.class.isAssignableFrom(temp)) {
                        scaleClass = temp;
                    }
                    System.out.println("Class: " + scaleClass.getName());
                    if (scaleClass.isEnum() && RupSetScalingRelationship.class.isAssignableFrom(scaleClass)) {
                        altScales = new ArrayList<RupSetScalingRelationship>();
                        for (RupSetScalingRelationship option : (RupSetScalingRelationship[])scaleClass.getEnumConstants()) {
                            if (!(option.getNodeWeight(branch) > 0.0)) continue;
                            altScales.add(option);
                        }
                        System.out.println("It's an enum! Found " + altScales.size() + " options");
                        if (altScales.size() < 2) {
                            altScales = null;
                        }
                    }
                }
                if (altScales != null) {
                    table.addColumn("Mag Range Across " + altScales.size() + " Scaling Options");
                    lines.add("Magnitudes are listed for the chosen scaling relationship, _" + scaleOption.getName() + "_, as well as all " + altScales.size() + " alternative logic tree branch choices.");
                    lines.add("");
                }
                if (sol != null) {
                    table.addColumns("Annual Rate", "Recurrence Interval");
                }
                table.finalizeLine();
                double minLen = Double.POSITIVE_INFINITY;
                double maxLen = Double.NEGATIVE_INFINITY;
                double overallMinMag = Double.POSITIVE_INFINITY;
                double overallMaxMag = Double.NEGATIVE_INFINITY;
                double overallScaleMinMag = Double.POSITIVE_INFINITY;
                double overallScaleMaxMag = Double.NEGATIVE_INFINITY;
                double totRate = 0.0;
                for (int count = minSectCount; count <= maxSectCount; ++count) {
                    int rupCount = 0;
                    double len = Double.NaN;
                    double minMag = Double.POSITIVE_INFINITY;
                    double maxMag = Double.NEGATIVE_INFINITY;
                    double scaleMinMag = Double.POSITIVE_INFINITY;
                    double scaleMaxMag = Double.NEGATIVE_INFINITY;
                    double myRate = 0.0;
                    Iterator iterator = parkfieldRups.iterator();
                    while (iterator.hasNext()) {
                        int rupIndex = (Integer)iterator.next();
                        if (count != rupSet.getSectionsIndicesForRup(rupIndex).size()) continue;
                        if (++rupCount == 1) {
                            len = rupSet.getLengthForRup(rupIndex) * 0.001;
                        }
                        double mag = rupSet.getMagForRup(rupIndex);
                        minMag = Double.min(minMag, mag);
                        maxMag = Double.max(maxMag, mag);
                        if (altScales != null) {
                            for (RupSetScalingRelationship scale : altScales) {
                                double rupArea = rupSet.getAreaForRup(rupIndex);
                                double rupLength = rupSet.getLengthForRup(rupIndex);
                                double totOrigArea = 0.0;
                                for (FaultSection sect : rupSet.getFaultSectionDataForRupture(rupIndex)) {
                                    totOrigArea += sect.getArea(false);
                                }
                                double origDDW = totOrigArea / rupLength;
                                double altMag = scale.getMag(rupArea, rupLength, rupArea / rupLength, origDDW, rupSet.getAveRakeForRup(rupIndex));
                                scaleMinMag = Math.min(scaleMinMag, altMag);
                                scaleMaxMag = Math.max(scaleMaxMag, altMag);
                            }
                        }
                        if (sol == null) continue;
                        myRate += sol.getRateForRup(rupIndex);
                    }
                    minLen = Math.min(minLen, len);
                    maxLen = Math.max(maxLen, len);
                    overallMinMag = Math.min(overallMinMag, minMag);
                    overallMaxMag = Math.max(overallMaxMag, maxMag);
                    totRate += myRate;
                    if (rupCount <= 0) continue;
                    table.initNewLine();
                    table.addColumns("**" + countDF.format(count) + "**", countDF.format(rupCount), twoDigits.format(len), "[" + twoDigits.format(minMag) + "," + twoDigits.format(maxMag) + "]");
                    if (altScales != null) {
                        table.addColumn("[" + twoDigits.format(scaleMinMag) + "," + twoDigits.format(scaleMaxMag) + "]");
                        overallScaleMinMag = Math.min(overallMinMag, scaleMinMag);
                        overallScaleMaxMag = Math.max(overallMaxMag, scaleMaxMag);
                    }
                    if (sol != null) {
                        table.addColumn(Float.valueOf((float)myRate));
                        table.addColumn(twoDigits.format(1.0 / myRate));
                    }
                    table.finalizeLine();
                }
                table.initNewLine();
                table.addColumns("**Total**", countDF.format(parkfieldRups.size()), "[" + twoDigits.format(minLen) + "," + twoDigits.format(maxLen) + "]", "[" + twoDigits.format(overallMinMag) + "," + twoDigits.format(overallMaxMag) + "]");
                if (altScales != null) {
                    table.addColumn("[" + twoDigits.format(overallScaleMinMag) + "," + twoDigits.format(overallScaleMaxMag) + "]");
                }
                if (sol != null) {
                    table.addColumn(Float.valueOf((float)totRate));
                    table.addColumn(twoDigits.format(1.0 / totRate));
                }
                table.finalizeLine();
                lines.addAll(table.build());
                lines.add("");
            }
        }
        if (creepingID >= 0 && sol != null) {
            int calaverasID;
            int santaCruzID;
            lines.add(this.getSubHeading() + " Rupture Rates Through Creeping Section");
            lines.add(topLink);
            lines.add("");
            lines.add("A rupture is considered to be through the creeping section if it ruptures the creeping section as well as at least part of one section on each side of the creeping section.");
            lines.add("");
            try {
                santaCruzID = FaultSectionUtils.findParentSectionID(subSects, "San", "Andreas", "Santa", "Cruz");
            }
            catch (Exception e) {
                e.printStackTrace();
                santaCruzID = -1;
            }
            try {
                calaverasID = FaultSectionUtils.findParentSectionID(subSects, "Calaveras", "Paicines");
            }
            catch (Exception e) {
                e.printStackTrace();
                calaverasID = -1;
            }
            ArrayList<Double> minMags = new ArrayList<Double>();
            double rupSetMinMag = rupSet.getMinMag();
            double rupSetMaxMag = rupSet.getMaxMag();
            Range rupSetMagRange = new Range(rupSetMinMag, rupSetMaxMag);
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            ArrayList<Integer> rupsThroughCreeping = new ArrayList<Integer>();
            for (int rupIndex : rupSet.getRupturesForParentSection(creepingID)) {
                ClusterRupture cRup = cRups.get(rupIndex);
                if (!NSHM23_ConstraintBuilder.isRupThroughCreeping(creepingID, cRup)) continue;
                rupsThroughCreeping.add(rupIndex);
            }
            if (rupsThroughCreeping.isEmpty()) {
                lines.add("No ruptures were found through the creeping section.");
            } else {
                minMags.add(0.0);
                if (rupSetMagRange.contains(6.0)) {
                    minMags.add(6.0);
                }
                if (rupSetMagRange.contains(7.0)) {
                    minMags.add(7.0);
                }
                if (rupSetMagRange.contains(7.5)) {
                    minMags.add(7.5);
                }
                if (rupSetMagRange.contains(8.0)) {
                    minMags.add(8.0);
                }
                double[] rupLengths = rupSet.getLengthForAllRups();
                ArrayList<Double> minLengths = new ArrayList<Double>();
                if (rupLengths != null) {
                    double maxLen = StatUtils.max((double[])rupLengths);
                    for (double lenKM : new double[]{500.0, 600.0, 700.0, 800.0}) {
                        double len = lenKM * 1000.0;
                        if (!(maxLen > len)) continue;
                        minLengths.add(len);
                    }
                }
                MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                table.initNewLine().addColumns("Minimum Magnitude" + (minLengths.isEmpty() ? "" : " or Length"), "Rate Through Creeping", "RI (years)", "% of Creeping Sect Rate");
                if (santaCruzID >= 0) {
                    table.addColumn("% of Santa Cruz Rate");
                }
                if (calaverasID >= 0) {
                    table.addColumn("% of Calaveras Rate");
                }
                if (parkfieldID >= 0) {
                    table.addColumn("% of Parkfield Rate");
                }
                table.addColumn("% of Total Solution Rate");
                table.finalizeLine();
                for (boolean magThresh : new boolean[]{true, false}) {
                    ArrayList<Double> thresholds = magThresh ? minMags : minLengths;
                    Iterator iterator = thresholds.iterator();
                    while (iterator.hasNext()) {
                        double threshold = (Double)iterator.next();
                        table.initNewLine();
                        if (threshold <= 0.0) {
                            table.addColumn("**Supra-Seismogenic**");
                        } else if (magThresh) {
                            table.addColumn("**M&ge;" + optionalDigitDF.format(threshold) + "**");
                        } else {
                            table.addColumn("**L&ge;" + optionalDigitDF.format(threshold * 0.001) + " km**");
                        }
                        double rateThrough = 0.0;
                        Iterator len = rupsThroughCreeping.iterator();
                        while (len.hasNext()) {
                            int rupIndex = (Integer)len.next();
                            if (magThresh && rupSet.getMagForRup(rupIndex) >= threshold) {
                                rateThrough += sol.getRateForRup(rupIndex);
                            }
                            if (magThresh || !(rupLengths[rupIndex] >= threshold)) continue;
                            rateThrough += sol.getRateForRup(rupIndex);
                        }
                        double totCreepingRate = this.rateForSect(sol, creepingID, magThresh, threshold);
                        table.addColumn(Float.valueOf((float)rateThrough));
                        if (rateThrough > 0.0) {
                            table.addColumn(twoDigits.format(1.0 / rateThrough));
                        } else {
                            table.addColumn("_(N/A)_");
                        }
                        if (totCreepingRate == 0.0) {
                            table.addColumn("_(N/A)_");
                        } else {
                            table.addColumn(percentDF.format(rateThrough / totCreepingRate));
                        }
                        if (santaCruzID >= 0) {
                            double cruzRate = this.rateForSect(sol, santaCruzID, magThresh, threshold);
                            if (cruzRate == 0.0) {
                                table.addColumn("_(N/A)_");
                            } else {
                                table.addColumn(percentDF.format(rateThrough / cruzRate));
                            }
                        }
                        if (calaverasID >= 0) {
                            double calaverasRate = this.rateForSect(sol, calaverasID, magThresh, threshold);
                            if (calaverasRate == 0.0) {
                                table.addColumn("_(N/A)_");
                            } else {
                                table.addColumn(percentDF.format(rateThrough / calaverasRate));
                            }
                        }
                        if (parkfieldID >= 0) {
                            double parkRate = this.rateForSect(sol, parkfieldID, magThresh, threshold);
                            if (parkRate == 0.0) {
                                table.addColumn("_(N/A)_");
                            } else {
                                table.addColumn(percentDF.format(rateThrough / parkRate));
                            }
                        }
                        double totRate = 0.0;
                        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                            if (magThresh && rupSet.getMagForRup(r) >= threshold) {
                                totRate += sol.getRateForRup(r);
                            }
                            if (magThresh || !(rupLengths[r] >= threshold)) continue;
                            totRate += sol.getRateForRup(r);
                        }
                        if (totRate > 0.0) {
                            table.addColumn(percentDF.format(rateThrough / totRate));
                        } else {
                            table.addColumn("_(N/A)_");
                        }
                        table.finalizeLine();
                    }
                }
                lines.addAll(table.build());
            }
            lines.add("");
        }
        ArrayList<FaultSection> plotSects = new ArrayList<FaultSection>();
        HashMap<Integer, List<FaultSection>> parentsMap = new HashMap<Integer, List<FaultSection>>();
        if (creepingSects != null) {
            plotSects.addAll(creepingSects);
            parentsMap.put(creepingID, creepingSects);
        }
        if (parkfieldSects != null) {
            plotSects.addAll(parkfieldSects);
            parentsMap.put(parkfieldID, parkfieldSects);
        }
        Preconditions.checkState((!plotSects.isEmpty() ? 1 : 0) != 0, (Object)"Have creeping/parkfield IDs but no sections?");
        boolean latX = true;
        String xLabel = "Latitude (degrees)";
        ArrayList<XY_DataSet> emptySectFuncs = new ArrayList<XY_DataSet>();
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (FaultSection sect : plotSects) {
            DefaultXY_DataSet func = new DefaultXY_DataSet();
            for (Location loc : sect.getFaultTrace()) {
                if (latX) {
                    func.set(loc.getLatitude(), 0.0);
                    continue;
                }
                func.set(loc.getLongitude(), 0.0);
            }
            emptySectFuncs.add(func);
            minX = Math.min(minX, func.getMinX());
            maxX = Math.max(maxX, func.getMaxX());
        }
        Range xRange = new Range(minX, maxX);
        double legendRelX = latX ? 0.975 : 0.025;
        ArrayList<SectBySectDetailPlots.AlongStrikePlot> plots = new ArrayList<SectBySectDetailPlots.AlongStrikePlot>();
        String title = "Slip Rates & Reductions";
        plots.add(SectBySectDetailPlots.buildSlipRatePlot(meta, plotSects, title, emptySectFuncs, xLabel, legendRelX, false));
        plots.add(SectBySectDetailPlots.buildSlipRateReductionPlot(meta, plotSects, title, emptySectFuncs, xLabel, legendRelX));
        String prefix = "saf_creep_park_along_strike";
        SectBySectDetailPlots.writeAlongStrikePlots(resourcesDir, prefix, plots, parentsMap, latX, xLabel, xRange, "San Andreas");
        lines.add(this.getSubHeading() + " Along-Strike Slip Rates and Reductions");
        lines.add(topLink);
        lines.add("");
        lines.add("![Plot](" + relPathToResources + "/" + prefix + ".png)");
        return lines;
    }

    private double rateForSect(FaultSystemSolution sol, int parentID, boolean magThresh, double threshold) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        double rate = 0.0;
        for (int rupIndex : rupSet.getRupturesForParentSection(parentID)) {
            if (!(magThresh && rupSet.getMagForRup(rupIndex) >= threshold) && (magThresh || !(rupSet.getLengthForRup(rupIndex) >= threshold))) continue;
            rate += sol.getRateForRup(rupIndex);
        }
        return rate;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return null;
    }

    public static void main(String[] args) throws IOException {
        File solFile = new File("/data/kevin/nshm23/rup_sets/fm3_1_ucerf3.zip");
        FaultSystemSolution sol = FaultSystemSolution.load(solFile);
        FaultSystemRupSet rupSet = sol.getRupSet();
        File outputDir = new File("/tmp/test_report");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        ReportPageGen pageGen = new ReportPageGen(rupSet, sol, "Test", outputDir, List.of(new SlipRatePlots(), new CreepingAndParkfieldReport()));
        pageGen.setReplot(true);
        pageGen.generatePage();
    }
}

