/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.gui.plot.GeographicMapMaker;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.ConnectivityClusters;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.InversionProgressPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ConnectivityCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;

public class FaultSectionConnectionsPlot
extends AbstractRupSetPlot {
    private static boolean TITLES = true;
    private static boolean LEGENDS = true;
    private static boolean LEGENDS_INSET = false;
    private static int MAX_PLOT_CLUSTERS = 10;
    private static boolean SMART_RAND = true;

    @Override
    public String getName() {
        return "Fault Section Connections";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        InversionMisfitProgress largestClusterProgress;
        boolean hasComp = meta.comparison != null && meta.comparisonHasSameSects;
        System.out.println("Plotting section connections");
        FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, resourcesDir, "sect_connectivity", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Connectivity" : " "), meta.primary.jumps, MAIN_COLOR, meta.region, 800);
        FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, resourcesDir, "sect_connectivity_hires", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Connectivity" : " "), meta.primary.jumps, MAIN_COLOR, meta.region, 3000);
        if (hasComp) {
            FaultSectionConnectionsPlot.plotConnectivityLines(meta.comparison.rupSet, resourcesDir, "sect_connectivity_comp", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Connectivity" : " "), meta.comparison.jumps, COMP_COLOR, meta.region, 800);
            FaultSectionConnectionsPlot.plotConnectivityLines(meta.comparison.rupSet, resourcesDir, "sect_connectivity_comp_hires", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Connectivity" : " "), meta.comparison.jumps, COMP_COLOR, meta.region, 3000);
            FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, resourcesDir, "sect_connectivity_unique", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Unique Connectivity" : " "), meta.primaryOverlap.uniqueJumps, MAIN_COLOR, meta.region, 800);
            FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, resourcesDir, "sect_connectivity_unique_hires", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Unique Connectivity" : " "), meta.primaryOverlap.uniqueJumps, MAIN_COLOR, meta.region, 3000);
            FaultSectionConnectionsPlot.plotConnectivityLines(meta.comparison.rupSet, resourcesDir, "sect_connectivity_unique_comp", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Unique Connectivity" : " "), meta.comparisonOverlap.uniqueJumps, COMP_COLOR, meta.region, 800);
            FaultSectionConnectionsPlot.plotConnectivityLines(meta.comparison.rupSet, resourcesDir, "sect_connectivity_unique_comp_hires", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Unique Connectivity" : " "), meta.comparisonOverlap.uniqueJumps, COMP_COLOR, meta.region, 3000);
        }
        double maxConnDist = 0.0;
        for (Jump jump : meta.primary.jumps) {
            maxConnDist = Math.max(maxConnDist, jump.distance);
        }
        if (hasComp) {
            for (Jump jump : meta.comparison.jumps) {
                maxConnDist = Math.max(maxConnDist, jump.distance);
            }
        }
        FaultSectionConnectionsPlot.plotConnectivityHistogram(resourcesDir, "sect_connectivity_hist", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Connectivity" : " "), meta.primary, meta.primaryOverlap, maxConnDist, MAIN_COLOR, false, false);
        if (sol != null) {
            FaultSectionConnectionsPlot.plotConnectivityHistogram(resourcesDir, "sect_connectivity_hist_rates", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Connectivity" : " "), meta.primary, meta.primaryOverlap, maxConnDist, MAIN_COLOR, true, false);
            FaultSectionConnectionsPlot.plotConnectivityHistogram(resourcesDir, "sect_connectivity_hist_rates_log", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Connectivity" : " "), meta.primary, meta.primaryOverlap, maxConnDist, MAIN_COLOR, true, true);
        }
        if (hasComp) {
            FaultSectionConnectionsPlot.plotConnectivityHistogram(resourcesDir, "sect_connectivity_hist_comp", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Connectivity" : " "), meta.comparison, meta.comparisonOverlap, maxConnDist, COMP_COLOR, false, false);
            if (meta.comparison.sol != null) {
                FaultSectionConnectionsPlot.plotConnectivityHistogram(resourcesDir, "sect_connectivity_hist_rates_comp", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Connectivity" : " "), meta.comparison, meta.comparisonOverlap, maxConnDist, COMP_COLOR, true, false);
                FaultSectionConnectionsPlot.plotConnectivityHistogram(resourcesDir, "sect_connectivity_hist_rates_comp_log", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Connectivity" : " "), meta.comparison, meta.comparisonOverlap, maxConnDist, COMP_COLOR, true, true);
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (hasComp) {
            ArrayList<Set<Jump>> connectionsList = new ArrayList<Set<Jump>>();
            ArrayList<Color> connectedColors = new ArrayList<Color>();
            ArrayList<String> connNames = new ArrayList<String>();
            connectionsList.add(meta.primaryOverlap.uniqueJumps);
            connectedColors.add(FaultSectionConnectionsPlot.darkerTrans(MAIN_COLOR));
            connNames.add(meta.primary.name + " Only");
            connectionsList.add(meta.comparisonOverlap.uniqueJumps);
            connectedColors.add(FaultSectionConnectionsPlot.darkerTrans(COMP_COLOR));
            connNames.add(meta.comparison.name + " Only");
            connectionsList.add(meta.primaryOverlap.commonJumps);
            connectedColors.add(FaultSectionConnectionsPlot.darkerTrans(COMMON_COLOR));
            connNames.add("Common Connections");
            String combConnPrefix = "sect_connectivity_combined";
            FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, resourcesDir, combConnPrefix, TITLES ? "Combined Connectivity" : " ", connectionsList, connectedColors, connNames, meta.region, 800);
            FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, resourcesDir, combConnPrefix + "_hires", TITLES ? "Combined Connectivity" : " ", connectionsList, connectedColors, connNames, meta.region, 3000);
            lines.add("![Combined](" + relPathToResources + "/" + combConnPrefix + ".png)");
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn("[View high resolution](" + relPathToResources + "/" + combConnPrefix + "_hires.png)");
            table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + combConnPrefix + ".geojson"));
            table.addColumn("[Download GeoJSON](" + relPathToResources + "/" + combConnPrefix + ".geojson)");
            table.finalizeLine();
            lines.addAll(table.build());
            lines.add("");
            lines.add(this.getSubHeading() + " Jump Overlaps");
            lines.add(topLink);
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.addLine("", meta.primary.name, meta.comparison.name);
            table.addLine("**Total Count**", meta.primary.jumps.size(), meta.comparison.jumps.size());
            table.initNewLine();
            table.addColumn("**# Unique Jumps**");
            table.addColumn(meta.primaryOverlap.uniqueJumps.size() + " (" + percentDF.format((double)meta.primaryOverlap.uniqueJumps.size() / (double)meta.primary.jumps.size()) + ")");
            table.addColumn(meta.comparisonOverlap.uniqueJumps.size() + " (" + percentDF.format((double)meta.comparisonOverlap.uniqueJumps.size() / (double)meta.comparison.jumps.size()) + ")");
            table.finalizeLine();
            if (sol != null || meta.comparison.sol != null) {
                table.addColumn("**Unique Jump Rate**");
                if (sol == null) {
                    table.addColumn("_(N/A)_");
                } else {
                    double rateInputUnique = 0.0;
                    for (Jump jump : meta.primaryOverlap.uniqueJumps) {
                        rateInputUnique += meta.primary.jumpRates.get(jump).doubleValue();
                    }
                    table.addColumn((float)rateInputUnique + " (" + percentDF.format(rateInputUnique / sol.getTotalRateForAllFaultSystemRups()) + ")");
                }
                if (meta.comparison.sol == null) {
                    table.addColumn("_(N/A)_");
                } else {
                    double rateCompUnique = 0.0;
                    for (Jump jump : meta.comparisonOverlap.uniqueJumps) {
                        rateCompUnique += meta.comparison.jumpRates.get(jump).doubleValue();
                    }
                    table.addColumn((float)rateCompUnique + " (" + percentDF.format(rateCompUnique / meta.comparison.sol.getTotalRateForAllFaultSystemRups()) + ")");
                }
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
        }
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (hasComp) {
            table.addLine(meta.primary.name, meta.comparison.name);
        }
        File mainPlot = new File(resourcesDir, "sect_connectivity.png");
        File compPlot = new File(resourcesDir, "sect_connectivity_comp.png");
        FaultSectionConnectionsPlot.addTablePlots(table, mainPlot, compPlot, relPathToResources, hasComp);
        if (hasComp) {
            mainPlot = new File(resourcesDir, "sect_connectivity_unique.png");
            compPlot = new File(resourcesDir, "sect_connectivity_unique_comp.png");
            FaultSectionConnectionsPlot.addTablePlots(table, mainPlot, compPlot, relPathToResources, hasComp);
        }
        mainPlot = new File(resourcesDir, "sect_connectivity_hist.png");
        compPlot = new File(resourcesDir, "sect_connectivity_hist_comp.png");
        FaultSectionConnectionsPlot.addTablePlots(table, mainPlot, compPlot, relPathToResources, hasComp);
        if (sol != null || hasComp && meta.comparison.sol != null) {
            mainPlot = new File(resourcesDir, "sect_connectivity_hist_rates.png");
            compPlot = new File(resourcesDir, "sect_connectivity_hist_rates_comp.png");
            FaultSectionConnectionsPlot.addTablePlots(table, mainPlot, compPlot, relPathToResources, hasComp);
            mainPlot = new File(resourcesDir, "sect_connectivity_hist_rates_log.png");
            compPlot = new File(resourcesDir, "sect_connectivity_hist_rates_comp_log.png");
            FaultSectionConnectionsPlot.addTablePlots(table, mainPlot, compPlot, relPathToResources, hasComp);
        }
        lines.addAll(table.build());
        lines.add("");
        if (hasComp && rupSet.hasModule(RuptureConnectionSearch.class) && meta.comparison.rupSet.hasModule(RuptureConnectionSearch.class)) {
            RuptureConnectionSearch primarySearch = rupSet.getModule(RuptureConnectionSearch.class);
            RuptureConnectionSearch compSearch = meta.comparison.rupSet.getModule(RuptureConnectionSearch.class);
            System.out.println("Plotting connection examples");
            lines.add(this.getSubHeading() + " Unique Connection Example Ruptures");
            lines.add(topLink);
            lines.add("");
            lines.add("**New Ruptures with Unique Connections**");
            int maxRups = 20;
            int maxCols = 5;
            table = FaultSectionConnectionsPlot.plotConnRupExamples(primarySearch, rupSet, meta.primaryOverlap.uniqueJumps, meta.primary.jumpRupsMap, maxRups, maxCols, resourcesDir, relPathToResources, "conn_example");
            lines.add("");
            if (table == null) {
                lines.add("_(N/A)_");
            } else {
                lines.addAll(table.build());
            }
            lines.add("");
            lines.add("**" + meta.comparison.name + " Ruptures with Unique Connections**");
            table = FaultSectionConnectionsPlot.plotConnRupExamples(compSearch, meta.comparison.rupSet, meta.comparisonOverlap.uniqueJumps, meta.comparison.jumpRupsMap, maxRups, maxCols, resourcesDir, relPathToResources, "comp_conn_example");
            lines.add("");
            if (table == null) {
                lines.add("_(N/A)_");
            } else {
                lines.addAll(table.build());
            }
            lines.add("");
        }
        lines.add(this.getSubHeading() + " Connected Clusters");
        lines.add(topLink);
        lines.add("");
        lines.add("Connected clusters of fault sections, where all sections plotted in a given color connect with all other sections of the same color through ruptures. There may not be any single rupture that connects all such sections, but rather, chains of ruptures connect the sections. Only the first " + MAX_PLOT_CLUSTERS + " clusters are plotted with bold colors; smaller clusters are plotted in random saturated colors (note that neighboring clusters can be similar colors by chance), and fully isolated faults are plotted in black.");
        lines.add("");
        List<ConnectivityCluster> rsClusters = FaultSectionConnectionsPlot.rupSetClusters(rupSet);
        List<ConnectivityCluster> solClusters = null;
        if (sol != null) {
            boolean hasZero = false;
            for (double rate : sol.getRateForAllRups()) {
                if (rate != 0.0) continue;
                hasZero = true;
                break;
            }
            if (hasZero && (solClusters = FaultSectionConnectionsPlot.solClusters(sol)).size() == rsClusters.size()) {
                solClusters = null;
            }
        }
        boolean[] doSols = solClusters == null ? new boolean[]{false} : new boolean[]{false, true};
        for (boolean doSol : doSols) {
            List<ConnectivityCluster> clusters = doSol ? solClusters : rsClusters;
            Object prefix = "conn_clusters";
            if (doSol) {
                prefix = (String)prefix + "_sol";
            }
            table = MarkdownUtils.tableBuilder();
            MarkdownUtils.TableBuilder clustersTable = MarkdownUtils.tableBuilder();
            if (hasComp) {
                table.addLine(meta.primary.name, meta.comparison.name);
                List<ConnectivityCluster> compClusters = doSol ? FaultSectionConnectionsPlot.solClusters(meta.comparison.sol) : FaultSectionConnectionsPlot.rupSetClusters(meta.comparison.rupSet);
                File primaryClustersPlot = FaultSectionConnectionsPlot.plotConnectedClusters(rupSet, sol, meta.region, resourcesDir, (String)prefix, (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.primary.name) + " Clusters" : " "), clustersTable, clusters);
                File compClustersPlot = null;
                if (compClusters != null) {
                    compClustersPlot = FaultSectionConnectionsPlot.plotConnectedClusters(meta.comparison.rupSet, meta.comparison.sol, meta.region, resourcesDir, (String)prefix + "_comp", (String)(TITLES ? FaultSectionConnectionsPlot.getTruncatedTitle(meta.comparison.name) + " Clusters" : " "), null, compClusters);
                }
                table.addLine(new String[]{"![Primary clusters](" + relPathToResources + "/" + primaryClustersPlot.getName() + ")", compClustersPlot == null ? "_(N/A)_" : "![Comparison clusters](" + relPathToResources + "/" + compClustersPlot.getName() + ")"});
                table.addLine(new String[]{RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + ".geojson)", compClustersPlot == null ? "_(N/A)_" : RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_comp.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_comp.geojson)"});
            } else {
                File primaryClusters = FaultSectionConnectionsPlot.plotConnectedClusters(rupSet, sol, meta.region, resourcesDir, (String)prefix, TITLES ? "Connected Section Clusters" : " ", clustersTable, clusters);
                table.addLine("![Primary clusters](" + relPathToResources + "/" + primaryClusters.getName() + ")");
                table.addLine(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + ".geojson)");
            }
            if (solClusters != null) {
                if (doSol) {
                    lines.add(this.getSubHeading() + "# Solution Clusters");
                    lines.add(topLink);
                    lines.add("");
                    lines.add("This section shows clusters of sections connected by ruptures with nonzero rates in the fault system solution, which differs from those calculated using every available rupture in the rupture set. This can occur by random chance, or if the solver was conditioned to only use a particular subset of all available ruptures (e.g., for a segmentation constraint).");
                    lines.add("");
                } else {
                    lines.add(this.getSubHeading() + "# Rupture Set Clusters");
                    lines.add(topLink);
                    lines.add("");
                }
            }
            lines.addAll(table.build());
            lines.add("");
            lines.addAll(clustersTable.build());
        }
        if (sol != null && sol.hasModule(ConnectivityClusters.ConnectivityClusterSolutionMisfits.class) && (largestClusterProgress = sol.requireModule(ConnectivityClusters.ConnectivityClusterSolutionMisfits.class).getLargestClusterMisfitProgress()) != null) {
            InversionMisfitProgress compProgress = null;
            String compName = null;
            if (meta.hasComparisonSol() && meta.comparisonHasSameSects && meta.comparison.sol.hasModule(ConnectivityClusters.ConnectivityClusterSolutionMisfits.class)) {
                compProgress = meta.comparison.sol.requireModule(ConnectivityClusters.ConnectivityClusterSolutionMisfits.class).getLargestClusterMisfitProgress();
                compName = meta.comparison.name;
            }
            lines.add("");
            lines.add(this.getSubHeading() + " Largest Cluster Misfit Progress");
            lines.add(topLink);
            lines.add("");
            lines.addAll(InversionProgressPlot.plotMisfitProgress(largestClusterProgress, compProgress, compName, resourcesDir, relPathToResources));
        }
        return lines;
    }

    private static List<ConnectivityCluster> rupSetClusters(FaultSystemRupSet rupSet) {
        if (!rupSet.hasModule(ConnectivityClusters.class)) {
            System.out.println("Calculating connection clusters");
            Stopwatch watch = Stopwatch.createStarted();
            ConnectivityClusters clusters = ConnectivityClusters.build(rupSet);
            watch.stop();
            System.out.println("Found " + clusters.size() + " connectivity clusters in " + optionalDigitDF.format(watch.elapsed(TimeUnit.MILLISECONDS) / 1000L) + " s");
            rupSet.addModule(clusters);
        }
        return rupSet.requireModule(ConnectivityClusters.class).get();
    }

    private static List<ConnectivityCluster> solClusters(FaultSystemSolution sol) {
        if (sol == null) {
            return null;
        }
        return ConnectivityCluster.buildNonzeroRateClusters(sol);
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(ClusterRuptures.class);
    }

    @Override
    public List<String> getSummary(ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.getSubHeading() + " Connectivity Map");
        lines.add("");
        lines.add(topLink);
        lines.add("");
        String prefix = new File(resourcesDir, "sect_connectivity_combined.png").exists() ? "sect_connectivity_combined" : "sect_connectivity";
        lines.add("![map](" + relPathToResources + "/" + prefix + ".png)");
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("[View high resolution](" + relPathToResources + "/" + prefix + "_hires.png)");
        table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + prefix + ".geojson"));
        table.addColumn("[Download GeoJSON](" + relPathToResources + "/" + prefix + ".geojson)");
        table.finalizeLine();
        lines.addAll(table.build());
        return lines;
    }

    private static void addTablePlots(MarkdownUtils.TableBuilder table, File mainPlot, File compPlot, String relPath, boolean hasComp) {
        table.initNewLine();
        File mainGeoJSON = null;
        if (mainPlot.exists()) {
            table.addColumn("![plot](" + relPath + "/" + mainPlot.getName() + ")");
            mainGeoJSON = new File(mainPlot.getAbsolutePath().replaceAll(".png", ".geojson"));
        } else {
            table.addColumn("_(N/A)_");
        }
        File compGeoJSON = null;
        if (hasComp) {
            if (compPlot.exists()) {
                table.addColumn("![plot](" + relPath + "/" + compPlot.getName() + ")");
                compGeoJSON = new File(compPlot.getAbsolutePath().replaceAll(".png", ".geojson"));
            } else {
                table.addColumn("_(N/A)_");
            }
        }
        table.finalizeLine();
        if (mainGeoJSON != null && mainGeoJSON.exists() || compGeoJSON != null && compGeoJSON.exists()) {
            table.initNewLine();
            if (mainGeoJSON != null && mainGeoJSON.exists()) {
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPath + "/" + mainGeoJSON.getName()) + " [Download GeoJSON](" + relPath + "/" + mainGeoJSON.getName() + ")");
            } else {
                table.addColumn("_(N/A)_");
            }
            if (compGeoJSON != null && compGeoJSON.exists()) {
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPath + "/" + compGeoJSON.getName()) + " [Download GeoJSON](" + relPath + "/" + compGeoJSON.getName() + ")");
            } else {
                table.addColumn("_(N/A)_");
            }
            table.finalizeLine();
        }
    }

    public static Color darkerTrans(Color c) {
        c = c.darker();
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 200);
    }

    public static void plotConnectivityLines(FaultSystemRupSet rupSet, File outputDir, String prefix, String title, Set<Jump> connections, Color connectedColor, Region reg, int width) throws IOException {
        ArrayList<Set<Jump>> connectionsList = new ArrayList<Set<Jump>>();
        ArrayList<Color> connectedColors = new ArrayList<Color>();
        ArrayList<String> connNames = new ArrayList<String>();
        connectionsList.add(connections);
        connectedColors.add(connectedColor);
        connNames.add("Connections");
        FaultSectionConnectionsPlot.plotConnectivityLines(rupSet, outputDir, prefix, title, connectionsList, connectedColors, connNames, reg, width);
    }

    public static void plotConnectivityLines(FaultSystemRupSet rupSet, File outputDir, String prefix, String title, List<Set<Jump>> connectionsList, List<Color> connectedColors, List<String> connNames, Region reg, int width) throws IOException {
        RupSetMapMaker plotter = new RupSetMapMaker(rupSet, reg);
        plotter.setLegendVisible(LEGENDS);
        plotter.setLegendInset(LEGENDS_INSET);
        plotter.setWriteGeoJSON(!prefix.endsWith("_hires"));
        for (int i = 0; i < connectionsList.size(); ++i) {
            Set<Jump> connections = connectionsList.get(i);
            Color connectedColor = connectedColors.get(i);
            String connName = connNames.get(i);
            plotter.plotJumps(connections, connectedColor, FaultSectionConnectionsPlot.getTruncatedTitle(connName));
        }
        plotter.plot(outputDir, prefix, title, width);
    }

    public static void plotConnectivityHistogram(File outputDir, String prefix, String title, RupSetMetadata meta, ReportMetadata.RupSetOverlap overlap, double maxDist, Color connectedColor, boolean rateWeighted, boolean yLog) throws IOException {
        double delta = 1.0;
        maxDist = Math.max(2.0, maxDist);
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(0.0, maxDist, delta);
        hist.setName("All Connections");
        HistogramFunction uniqueHist = null;
        if (overlap != null) {
            uniqueHist = HistogramFunction.getEncompassingHistogram(0.0, maxDist, delta);
            uniqueHist.setName("Unique To Model");
        }
        double myMax = 0.0;
        double mean = 0.0;
        double sumWeights = 0.0;
        double meanAbove = 0.0;
        double sumWeightsAbove = 0.0;
        for (Jump pair : meta.jumps) {
            double dist = pair.distance;
            double weight = rateWeighted ? meta.jumpRates.get(pair) : 1.0;
            myMax = Math.max(myMax, dist);
            mean += dist * weight;
            sumWeights += weight;
            if (dist >= 0.1) {
                meanAbove += dist * weight;
                sumWeightsAbove += weight;
            }
            int xIndex = hist.getClosestXIndex(dist);
            hist.add(xIndex, weight);
            if (overlap == null || !overlap.uniqueJumps.contains(pair)) continue;
            uniqueHist.add(xIndex, weight);
        }
        mean /= sumWeights;
        meanAbove /= sumWeightsAbove;
        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        Color uniqueColor = new Color(connectedColor.getRed() / 4, connectedColor.getGreen() / 4, connectedColor.getBlue() / 4);
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, connectedColor));
        if (uniqueHist != null) {
            funcs.add(uniqueHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, uniqueColor));
        }
        String yAxisLabel = rateWeighted ? "Annual Rate" : "Count";
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Jump Distance (km)", yAxisLabel);
        spec.setLegendVisible(LEGENDS);
        spec.setLegendInset(LEGENDS_INSET);
        Range xRange = new Range(0.0, maxDist);
        Range yRange = yLog ? new Range(1.0E-6, 10.0) : new Range(0.0, Math.max(1.0, 1.05 * hist.getMaxY()));
        DecimalFormat distDF = new DecimalFormat("0.0");
        double annX = 0.975 * maxDist;
        Font annFont = new Font("SansSerif", 1, 20);
        double annYScalar = 0.975;
        double annYDelta = 0.05;
        double logMinY = Math.log10(yRange.getLowerBound());
        double logMaxY = Math.log10(yRange.getUpperBound());
        double logDeltaY = logMaxY - logMinY;
        double annY = yLog ? Math.pow(10.0, logMinY + logDeltaY * annYScalar) : annYScalar * yRange.getUpperBound();
        XYTextAnnotation maxAnn = new XYTextAnnotation("Max: " + distDF.format(myMax), annX, annY);
        maxAnn.setFont(annFont);
        maxAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
        spec.addPlotAnnotation((XYAnnotation)maxAnn);
        annY = yLog ? Math.pow(10.0, logMinY + logDeltaY * annYScalar) : (annYScalar -= annYDelta) * yRange.getUpperBound();
        XYTextAnnotation meanAnn = new XYTextAnnotation("Mean: " + distDF.format(mean), annX, annY);
        meanAnn.setFont(annFont);
        meanAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
        spec.addPlotAnnotation((XYAnnotation)meanAnn);
        annY = yLog ? Math.pow(10.0, logMinY + logDeltaY * annYScalar) : (annYScalar -= annYDelta) * yRange.getUpperBound();
        if (rateWeighted) {
            XYTextAnnotation rateAnn = new XYTextAnnotation("Total Rate: " + distDF.format(sumWeights), annX, annY);
            rateAnn.setFont(annFont);
            rateAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
            spec.addPlotAnnotation((XYAnnotation)rateAnn);
        } else {
            XYTextAnnotation countAnn = new XYTextAnnotation("Total Count: " + (int)sumWeights, annX, annY);
            countAnn.setFont(annFont);
            countAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
            spec.addPlotAnnotation((XYAnnotation)countAnn);
        }
        annY = yLog ? Math.pow(10.0, logMinY + logDeltaY * annYScalar) : (annYScalar -= annYDelta) * yRange.getUpperBound();
        XYTextAnnotation meanAboveAnn = new XYTextAnnotation("Mean >0.1: " + distDF.format(meanAbove), annX, annY);
        meanAboveAnn.setFont(annFont);
        meanAboveAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
        spec.addPlotAnnotation((XYAnnotation)meanAboveAnn);
        annY = yLog ? Math.pow(10.0, logMinY + logDeltaY * annYScalar) : (annYScalar -= annYDelta) * yRange.getUpperBound();
        if (rateWeighted) {
            XYTextAnnotation rateAnn = new XYTextAnnotation("Total Rate >0.1: " + distDF.format(sumWeightsAbove), annX, annY);
            rateAnn.setFont(annFont);
            rateAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
            spec.addPlotAnnotation((XYAnnotation)rateAnn);
        } else {
            XYTextAnnotation countAnn = new XYTextAnnotation("Total Count >0.1: " + (int)sumWeightsAbove, annX, annY);
            countAnn.setFont(annFont);
            countAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
            spec.addPlotAnnotation((XYAnnotation)countAnn);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(24);
        gp.setPlotLabelFontSize(24);
        gp.setBackgroundColor(Color.WHITE);
        gp.drawGraphPanel(spec, false, yLog, xRange, yRange);
        File file = new File(outputDir, prefix);
        gp.getChartPanel().setSize(800, 650);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
    }

    public static Map<Jump, Double> getJumps(FaultSystemSolution sol, List<ClusterRupture> ruptures, Map<Jump, List<Integer>> jumpToRupsMap) {
        HashMap<Jump, Double> jumpRateMap = new HashMap<Jump, Double>();
        for (int r = 0; r < ruptures.size(); ++r) {
            double rate = sol == null ? 1.0 : sol.getRateForRup(r);
            ClusterRupture rupture = ruptures.get(r);
            for (Jump jump : rupture.getJumpsIterable()) {
                Double prevRate;
                if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                    jump = jump.reverse();
                }
                if ((prevRate = (Double)jumpRateMap.get(jump)) == null) {
                    prevRate = 0.0;
                }
                jumpRateMap.put(jump, prevRate + rate);
                if (jumpToRupsMap == null) continue;
                List<Integer> prevRups = jumpToRupsMap.get(jump);
                if (prevRups == null) {
                    prevRups = new ArrayList<Integer>();
                    jumpToRupsMap.put(jump, prevRups);
                }
                prevRups.add(r);
            }
        }
        return jumpRateMap;
    }

    public static MarkdownUtils.TableBuilder plotConnRupExamples(RuptureConnectionSearch search, FaultSystemRupSet rupSet, Set<Jump> pairings, Map<Jump, List<Integer>> pairRupsMap, int maxRups, int maxCols, File resourcesDir, String relPathToResources, String prefix) throws IOException {
        List<Object> rups;
        ArrayList<Jump> sortedPairings = new ArrayList<Jump>(pairings);
        Collections.sort(sortedPairings, Jump.id_comparator);
        Random r = new Random(sortedPairings.size() * maxRups);
        Collections.shuffle(sortedPairings, r);
        int possibleRups = 0;
        for (Jump pair : pairings) {
            possibleRups += pairRupsMap.get(pair).size();
        }
        if (possibleRups < maxRups) {
            maxRups = possibleRups;
        }
        if (maxRups == 0) {
            return null;
        }
        int indInPairing = 0;
        ArrayList<Integer> rupsToPlot = new ArrayList<Integer>();
        while (rupsToPlot.size() < maxRups) {
            for (Jump pair : sortedPairings) {
                rups = pairRupsMap.get(pair);
                if (rups.size() <= indInPairing) continue;
                rupsToPlot.add(rups.get(indInPairing));
                if (rupsToPlot.size() != maxRups) continue;
                break;
            }
            ++indInPairing;
        }
        File rupHtmlDir = new File(resourcesDir.getParentFile(), "rupture_pages");
        Preconditions.checkState((rupHtmlDir.exists() || rupHtmlDir.mkdir() ? 1 : 0) != 0);
        System.out.println("Plotting " + String.valueOf(rupsToPlot) + " ruptures");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        rups = rupSet.requireModule(ClusterRuptures.class).getAll();
        Iterator iterator = rupsToPlot.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            String rupPrefix = prefix + "_" + rupIndex;
            ClusterRupture rupture = (ClusterRupture)rups.get(rupIndex);
            search.plotConnections(resourcesDir, rupPrefix, rupIndex, rupture, pairings, "Unique Connections");
            table.addColumn("[<img src=\"" + relPathToResources + "/" + rupPrefix + ".png\" />](" + relPathToResources + "/../" + RupHistogramPlots.generateRuptureInfoPage(rupSet, rupture, rupIndex, rupHtmlDir, rupPrefix, null, search.getDistAzCalc()) + ")");
        }
        table.finalizeLine();
        return table.wrap(maxCols, 0);
    }

    public static File plotConnectedClusters(FaultSystemRupSet rupSet, FaultSystemSolution sol, Region region, File outputDir, String prefix, String title, MarkdownUtils.TableBuilder table, List<ConnectivityCluster> clustersUnsorted) throws IOException {
        GeographicMapMaker plotter = FaultSectionConnectionsPlot.buildConnectedClustersPlot(rupSet, sol, region, table, clustersUnsorted);
        plotter.plot(outputDir, prefix, title, 1200);
        return new File(outputDir, prefix + ".png");
    }

    public static GeographicMapMaker buildConnectedClustersPlot(FaultSystemRupSet rupSet, FaultSystemSolution sol, Region region, MarkdownUtils.TableBuilder table, List<ConnectivityCluster> clustersUnsorted) throws IOException {
        int i;
        final ArrayList<ConnectivityCluster> clusters = new ArrayList<ConnectivityCluster>(clustersUnsorted);
        Collections.sort(clusters, ConnectivityCluster.sectCountComparator);
        Collections.reverse(clusters);
        System.out.println("Largest has " + ((ConnectivityCluster)clusters.get(0)).getNumSections() + " sections, " + ((ConnectivityCluster)clusters.get(0)).getNumRuptures() + " ruptures");
        float sectScalarThickness = 3.0f;
        PlotCurveCharacterstics isolatedChar = new PlotCurveCharacterstics(PlotLineType.SOLID, sectScalarThickness, Color.BLACK);
        PlotCurveCharacterstics isolatedProxyChar = new PlotCurveCharacterstics(PlotLineType.SHORT_DASHED, sectScalarThickness, Color.BLACK);
        int numNonIsolated = 0;
        for (ConnectivityCluster cluster : clusters) {
            if (cluster.getParentSectIDs().size() <= 1) continue;
            ++numNonIsolated;
        }
        int cptNumToPlot = Integer.min(MAX_PLOT_CLUSTERS, Integer.max(2, numNonIsolated));
        CPT clusterCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().reverse().rescale(0.0, (double)cptNumToPlot - 1.0);
        ArrayList<PlotCurveCharacterstics> sectChars = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<Double> sectColorSortables = new ArrayList<Double>();
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            sectChars.add(null);
            sectColorSortables.add(null);
        }
        ConnectivityClusters.ConnectivityClusterSolutionMisfits clusterMisfits = null;
        HashMap<ConnectivityCluster, InversionMisfitStats> clusterMisfitStats = null;
        if (sol != null && table != null && (clusterMisfits = sol.getModule(ConnectivityClusters.ConnectivityClusterSolutionMisfits.class)) != null) {
            clusterMisfitStats = new HashMap<ConnectivityCluster, InversionMisfitStats>();
            ConnectivityClusters origClusters = rupSet.requireModule(ConnectivityClusters.class);
            for (int i2 = 0; i2 < origClusters.size(); ++i2) {
                InversionMisfitStats stats = clusterMisfits.getMisfitStats(i2);
                if (stats == null) continue;
                clusterMisfitStats.put(origClusters.get(i2), stats);
            }
        }
        ArrayList<String> clusterMisfitNames = null;
        InversionMisfitStats.Quantity tableQuantity = InversionMisfitStats.Quantity.MAD;
        String quantityAbbrev = "MAD";
        if (table != null) {
            table.initNewLine();
            table.addColumns("Rank", "Sections", "Parent Sections", "Ruptures");
            if (clusterMisfits != null) {
                clusterMisfitNames = new ArrayList<String>();
                HashSet<String> misfitNames = new HashSet<String>();
                for (InversionMisfitStats stats : clusterMisfitStats.values()) {
                    for (InversionMisfitStats.MisfitStats misfits : stats.getStats()) {
                        String name = misfits.range.name;
                        if (misfitNames.contains(name)) continue;
                        misfitNames.add(name);
                        clusterMisfitNames.add(name);
                        table.addColumn(name + " " + quantityAbbrev);
                    }
                }
            }
            table.finalizeLine();
        }
        double[] isolatedMisfits = null;
        int[] isolatedMisfitCounts = null;
        double[] otherMisfits = null;
        int[] otherMisfitCounts = null;
        if (clusterMisfits != null) {
            isolatedMisfits = new double[clusterMisfitNames.size()];
            isolatedMisfitCounts = new int[clusterMisfitNames.size()];
            otherMisfits = new double[clusterMisfitNames.size()];
            otherMisfitCounts = new int[clusterMisfitNames.size()];
        }
        int numSections = rupSet.getNumSections();
        HashSet<Integer> allParents = new HashSet<Integer>();
        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            allParents.add(faultSection.getParentSectionId());
        }
        int numParents = allParents.size();
        int n = rupSet.getNumRuptures();
        int numOther = 0;
        int sectsOther = 0;
        int parentsOther = 0;
        int rupturesOther = 0;
        int numIsolated = 0;
        int sectsIsolated = 0;
        int rupturesIsolated = 0;
        int tableIndex = 0;
        Random rand = new Random((long)rupSet.getNumSections() * (long)clusters.size());
        HashMap<ConnectivityCluster, Double> prevRands = new HashMap<ConnectivityCluster, Double>();
        HashMap<ConnectivityCluster, Location> clusterCenters = new HashMap<ConnectivityCluster, Location>();
        for (ConnectivityCluster cluster : clusters) {
            double avgLat = 0.0;
            double avgLon = 0.0;
            for (int sectID : cluster.getSectIDs()) {
                FaultSection sect = rupSet.getFaultSectionData(sectID);
                FaultTrace trace = sect.getFaultTrace();
                avgLat += 0.5 * (trace.first().lat + trace.last().lat);
                avgLon += 0.5 * (trace.first().lon + trace.last().lon);
            }
            clusterCenters.put(cluster, new Location(avgLat /= (double)cluster.getNumSections(), avgLon /= (double)cluster.getNumSections()));
        }
        Location lowerLeft = new Location(region.getMinLat(), region.getMinLon());
        Location lowerRight = new Location(region.getMinLat(), region.getMaxLon());
        Location upperLeft = new Location(region.getMaxLat(), region.getMinLon());
        double randDistScale = Double.max(150.0, Math.max(0.1 * LocationUtils.horzDistanceFast(lowerLeft, lowerRight), 0.1 * LocationUtils.horzDistanceFast(lowerLeft, upperLeft)));
        for (i = 0; i < clusters.size(); ++i) {
            PlotCurveCharacterstics sectChar;
            int j;
            InversionMisfitStats tmp;
            ConnectivityCluster cluster = (ConnectivityCluster)clusters.get(i);
            boolean allSameParent = cluster.getParentSectIDs().size() == 1;
            double[] myMisfits = null;
            if (clusterMisfits != null && (tmp = (InversionMisfitStats)clusterMisfitStats.get(cluster)) != null) {
                myMisfits = new double[clusterMisfitNames.size()];
                List<InversionMisfitStats.MisfitStats> myMisfitStats = tmp.getStats();
                block9: for (j = 0; j < clusterMisfitNames.size(); ++j) {
                    myMisfits[j] = Double.NaN;
                    String name = (String)clusterMisfitNames.get(j);
                    for (InversionMisfitStats.MisfitStats stats : myMisfitStats) {
                        if (!name.equals(stats.range.name)) continue;
                        myMisfits[j] = stats.get(tableQuantity);
                        continue block9;
                    }
                }
            }
            if (allSameParent) {
                FaultSection first = rupSet.getFaultSectionData(cluster.getSectIDs().iterator().next());
                sectChar = first.isProxyFault() ? isolatedProxyChar : isolatedChar;
                ++numIsolated;
                sectsIsolated += cluster.getNumSections();
                rupturesIsolated += cluster.getNumRuptures();
                if (myMisfits != null) {
                    for (j = 0; j < clusterMisfitNames.size(); ++j) {
                        if (!Double.isFinite(myMisfits[j])) continue;
                        int n2 = j;
                        isolatedMisfitCounts[n2] = isolatedMisfitCounts[n2] + 1;
                        int n3 = j;
                        isolatedMisfits[n3] = isolatedMisfits[n3] + myMisfits[j];
                    }
                }
            } else if (tableIndex < cptNumToPlot) {
                Color color = clusterCPT.getColor(tableIndex);
                Color darker = color.darker();
                color = new Color((int)(0.5 * (double)(color.getRed() + darker.getRed()) + 0.5), (int)(0.5 * (double)(color.getGreen() + darker.getGreen()) + 0.5), (int)(0.5 * (double)(color.getBlue() + darker.getBlue()) + 0.5));
                sectChar = new PlotCurveCharacterstics(PlotLineType.SOLID, sectScalarThickness, color);
                ++tableIndex;
                if (table != null) {
                    table.initNewLine();
                    table.addColumns(tableIndex, FaultSectionConnectionsPlot.countStr(cluster.getNumSections(), numSections), FaultSectionConnectionsPlot.countStr(cluster.getParentSectIDs().size(), numParents), FaultSectionConnectionsPlot.countStr(cluster.getNumRuptures(), n));
                    if (clusterMisfits != null) {
                        if (myMisfits == null) {
                            for (int j2 = 0; j2 < clusterMisfitNames.size(); ++j2) {
                                table.addColumn("_(N/A)_");
                            }
                        } else {
                            for (double val : myMisfits) {
                                if (Double.isFinite(val)) {
                                    table.addColumn(Float.valueOf((float)val));
                                    continue;
                                }
                                table.addColumn("_(N/A)_");
                            }
                        }
                    }
                    table.finalizeLine();
                }
            } else {
                Location centerLoc = (Location)clusterCenters.get(cluster);
                double myRand = rand.nextDouble();
                if (SMART_RAND && !prevRands.isEmpty()) {
                    ArrayList<Double> closeRands = new ArrayList<Double>();
                    ArrayList<Double> closeDists = new ArrayList<Double>();
                    for (ConnectivityCluster oCluster : prevRands.keySet()) {
                        double centerDist = LocationUtils.horzDistanceFast(centerLoc, (Location)clusterCenters.get(oCluster));
                        if (!(centerDist < randDistScale * 2.0)) continue;
                        double minClusterDist = centerDist;
                        for (int sectID1 : cluster.getSectIDs()) {
                            FaultSection sect1 = rupSet.getFaultSectionData(sectID1);
                            Location l11 = sect1.getFaultTrace().first();
                            Location l12 = sect1.getFaultTrace().last();
                            for (int sectID2 : oCluster.getSectIDs()) {
                                FaultSection sect2 = rupSet.getFaultSectionData(sectID2);
                                Location l21 = sect2.getFaultTrace().first();
                                Location l22 = sect2.getFaultTrace().last();
                                minClusterDist = Math.min(minClusterDist, LocationUtils.horzDistanceFast(l11, l21));
                                minClusterDist = Math.min(minClusterDist, LocationUtils.horzDistanceFast(l11, l22));
                                minClusterDist = Math.min(minClusterDist, LocationUtils.horzDistanceFast(l12, l21));
                                minClusterDist = Math.min(minClusterDist, LocationUtils.horzDistanceFast(l12, l22));
                            }
                        }
                        if (!(minClusterDist < randDistScale)) continue;
                        closeRands.add((Double)prevRands.get(oCluster));
                        closeDists.add(minClusterDist);
                    }
                    if (!closeRands.isEmpty()) {
                        double furthestScore = 0.0;
                        double curRand = myRand;
                        double nextRand = rand.nextDouble();
                        for (int j3 = 0; j3 < 10; ++j3) {
                            double score = 0.0;
                            for (int k = 0; k < closeRands.size(); ++k) {
                                double dist = (Double)closeDists.get(k);
                                double closeRand = (Double)closeRands.get(k);
                                double diff = Math.abs(closeRand - curRand);
                                diff = Math.min(diff, 0.3);
                                double invDist = 1.0 - dist / randDistScale;
                                score += invDist * diff;
                            }
                            if (score > furthestScore) {
                                furthestScore = score;
                                myRand = curRand;
                            }
                            curRand = nextRand;
                            nextRand = rand.nextDouble();
                        }
                    }
                }
                prevRands.put(cluster, myRand);
                Color c = clusterCPT.getColor((float)(myRand * ((double)cptNumToPlot - 1.0)));
                int r = c.getRed();
                int g = c.getGreen();
                int b = c.getBlue();
                for (int j4 = 0; j4 < 2; ++j4) {
                    r = (int)(0.5 * ((double)r + 255.0) + 0.5);
                    g = (int)(0.5 * ((double)g + 255.0) + 0.5);
                    b = (int)(0.5 * ((double)b + 255.0) + 0.5);
                }
                Color color = new Color(r, g, b);
                sectChar = new PlotCurveCharacterstics(PlotLineType.SOLID, sectScalarThickness, color);
                ++numOther;
                sectsOther += cluster.getNumSections();
                parentsOther += cluster.getParentSectIDs().size();
                rupturesOther += cluster.getNumRuptures();
                if (myMisfits != null) {
                    for (int j5 = 0; j5 < clusterMisfitNames.size(); ++j5) {
                        if (!Double.isFinite(myMisfits[j5])) continue;
                        int n4 = j5;
                        otherMisfitCounts[n4] = otherMisfitCounts[n4] + 1;
                        int n5 = j5;
                        otherMisfits[n5] = otherMisfits[n5] + myMisfits[j5];
                    }
                }
            }
            for (int s : cluster.getSectIDs()) {
                Preconditions.checkState((sectChars.get(s) == null ? 1 : 0) != 0);
                sectChars.set(s, sectChar);
                sectColorSortables.set(s, (double)cluster.getNumSections() + (double)cluster.getNumRuptures() / (double)rupSet.getNumRuptures());
            }
        }
        if (table != null) {
            if (numOther > 0) {
                table.initNewLine();
                table.addColumns(tableIndex + 1 + "->" + (tableIndex + 1 + numOther), FaultSectionConnectionsPlot.countStr(sectsOther, numSections), FaultSectionConnectionsPlot.countStr(parentsOther, numParents), FaultSectionConnectionsPlot.countStr(rupturesOther, n));
                if (clusterMisfits != null) {
                    for (i = 0; i < otherMisfits.length; ++i) {
                        double sum = otherMisfits[i];
                        int count = otherMisfitCounts[i];
                        if (count == 0) {
                            table.addColumn("_(N/A)_");
                            continue;
                        }
                        table.addColumn(Float.valueOf((float)(sum / (double)count)));
                    }
                }
                table.finalizeLine();
            }
            if (numIsolated > 0) {
                table.initNewLine();
                table.addColumns(numIsolated + " isolated", FaultSectionConnectionsPlot.countStr(sectsIsolated, numSections), FaultSectionConnectionsPlot.countStr(numIsolated, numParents), FaultSectionConnectionsPlot.countStr(rupturesIsolated, n));
                if (clusterMisfits != null) {
                    for (i = 0; i < isolatedMisfits.length; ++i) {
                        double sum = isolatedMisfits[i];
                        int count = isolatedMisfitCounts[i];
                        if (count == 0) {
                            table.addColumn("_(N/A)_");
                            continue;
                        }
                        table.addColumn(Float.valueOf((float)(sum / (double)count)));
                    }
                }
                table.finalizeLine();
            }
        }
        RupSetMapMaker plotter = new RupSetMapMaker(rupSet, region){

            @Override
            protected Feature surfFeature(FaultSection sect, PlotCurveCharacterstics pChar) {
                return this.setClusterProps(super.surfFeature(sect, pChar), sect);
            }

            @Override
            protected Feature traceFeature(FaultSection sect, PlotCurveCharacterstics pChar) {
                return this.setClusterProps(super.traceFeature(sect, pChar), sect);
            }

            private Feature setClusterProps(Feature feature, FaultSection sect) {
                int clusterID = 0;
                for (ConnectivityCluster cluster : clusters) {
                    if (cluster.containsSect(sect)) {
                        feature.properties.set("ClusterID", clusterID);
                        feature.properties.set("ClusterParentCount", cluster.getParentSectIDs().size());
                        feature.properties.set("ClusterSectCount", cluster.getNumSections());
                        feature.properties.set("ClusterRupCount", cluster.getNumRuptures());
                        break;
                    }
                    ++clusterID;
                }
                return feature;
            }
        };
        plotter.setLegendVisible(LEGENDS);
        plotter.setLegendInset(LEGENDS_INSET);
        plotter.setWriteGeoJSON(true);
        plotter.setSectPolygonChar(new PlotCurveCharacterstics(PlotLineType.POLYGON_SOLID, 1.0f, new Color(127, 127, 127, 66)));
        plotter.plotSectChars(sectChars, null, null, sectColorSortables);
        return plotter;
    }

    private static String countStr(int num, int tot) {
        double fract = (double)num / (double)tot;
        return countDF.format(num) + " (" + percentDF.format(fract) + ")";
    }

    public static void main(String[] args) throws IOException {
        FaultSystemSolution sol = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_09_28-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged_gridded.zip"));
        FaultSectionConnectionsPlot.plotConnectedClusters(sol.getRupSet(), sol, NSHM23_RegionLoader.loadFullConterminousWUS(), new File("/tmp"), "conn_clusters", " ", null, FaultSectionConnectionsPlot.rupSetClusters(sol.getRupSet()));
        FaultSectionConnectionsPlot.plotConnectedClusters(sol.getRupSet(), sol, NSHM23_RegionLoader.loadFullConterminousWUS(), new File("/tmp"), "conn_clusters_sol", " ", null, FaultSectionConnectionsPlot.solClusters(sol));
    }
}

