/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.mahdilamb.colormap.Colors;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RuptureScalingPlot;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;
import org.opensha.sha.util.TectonicRegionType;

public class GriddedDiagnosticPlot
extends AbstractSolutionPlot {
    @Override
    public String getName() {
        return "Gridded Seismicity Rupture Properties";
    }

    private static double calcWidth(GridSourceList.GriddedRupture rup) {
        double width = rup.properties.lowerDepth - rup.properties.upperDepth;
        if (rup.properties.dip != 90.0) {
            width /= Math.sin(Math.toRadians(rup.properties.dip));
        }
        return width;
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        GridSourceList gridSources = sol.requireModule(GridSourceList.class);
        Set<TectonicRegionType> trts = gridSources.getTectonicRegionTypes();
        IncrementalMagFreqDist refMFD = gridSources.getRefMFD();
        ArrayList<String> lines = new ArrayList<String>();
        FocalMech[] mechs = FocalMech.values();
        for (TectonicRegionType trt : trts) {
            String trtName = trt.toString().replace("Crust", "").replace("Subduction", "").replace("IntraSlab", "Slab").trim();
            if (trts.size() > 1) {
                lines.add(this.getSubHeading() + " " + trtName + " Gridded Ruptures");
                lines.add(topLink);
                lines.add("");
            }
            double[] mechRates = new double[mechs.length];
            ArrayList mechRupLists = new ArrayList(mechs.length);
            for (int i = 0; i < mechs.length; ++i) {
                mechRupLists.add(new ArrayList());
            }
            for (int gridIndex = 0; gridIndex < gridSources.getNumLocations(); ++gridIndex) {
                for (GridSourceList.GriddedRupture rup : gridSources.getRuptures(trt, gridIndex)) {
                    int mechIndex;
                    if (rup.rate == 0.0) continue;
                    int n = mechIndex = GridSourceList.getMechForRake(rup.properties.rake).ordinal();
                    mechRates[n] = mechRates[n] + rup.rate;
                    ((List)mechRupLists.get(mechIndex)).add(rup);
                }
            }
            Range xRange = new Range(refMFD.getMinX() - 0.5 * refMFD.getDelta(), refMFD.getMaxX() + 0.5 * refMFD.getDelta());
            int numMechs = 0;
            double totRate = 0.0;
            for (double mechRate : mechRates) {
                totRate += mechRate;
                if (!(mechRate > 0.0)) continue;
                ++numMechs;
            }
            boolean firstMech = true;
            for (int mechIndex = 0; mechIndex < mechs.length; ++mechIndex) {
                Object titlePrefix;
                FocalMech mech = mechs[mechIndex];
                if (mechRates[mechIndex] == 0.0) continue;
                if (numMechs > 1) {
                    if (trts.size() == 1) {
                        if (firstMech) {
                            lines.add("All ruptures are" + trtName + ".");
                            lines.add("");
                        }
                        lines.add(this.getSubHeading() + " " + String.valueOf((Object)mech) + " Gridded Ruptures");
                        titlePrefix = String.valueOf((Object)mech) + " ";
                    } else {
                        lines.add(this.getSubHeading() + "# " + trtName + ", " + String.valueOf((Object)mech) + " Gridded Ruptures");
                        titlePrefix = trtName + ", " + String.valueOf((Object)mech) + " ";
                    }
                    lines.add(topLink);
                    lines.add("");
                    lines.add(percentDF.format(mechRates[mechIndex] / totRate) + " of ruptures (by-rate) are " + String.valueOf((Object)mech) + ".");
                    lines.add("");
                } else if (trts.size() == 1) {
                    if (firstMech) {
                        lines.add("All ruptures are " + trtName + ", " + String.valueOf((Object)mech) + ".");
                        lines.add("");
                    }
                    titlePrefix = "";
                } else {
                    if (firstMech) {
                        lines.add("All ruptures are " + String.valueOf((Object)mech) + ".");
                        lines.add("");
                    }
                    titlePrefix = trtName + " ";
                }
                firstMech = false;
                String prefix = "grid_props_" + trt.name() + "_" + mech.name();
                List mechRups = (List)mechRupLists.get(mechIndex);
                HashMap<Quantities, RangeTracker[]> quantityTracks = new HashMap<Quantities, RangeTracker[]>();
                for (Quantities q : Quantities.values()) {
                    RangeTracker[] tracks = new RangeTracker[refMFD.size()];
                    for (int i = 0; i < tracks.length; ++i) {
                        tracks[i] = new RangeTracker();
                    }
                    quantityTracks.put(q, tracks);
                    for (GridSourceList.GriddedRupture rup : mechRups) {
                        tracks[refMFD.getClosestXIndex(rup.properties.magnitude)].add(q.get(rup), rup.rate);
                    }
                }
                ArrayList<DiscretizedFunc> depthFuncs = new ArrayList<DiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> depthChars = new ArrayList<PlotCurveCharacterstics>();
                GriddedDiagnosticPlot.addRangeFuncs(depthFuncs, depthChars, Colors.tab_green, Quantities.UPPER_DEPTH.label, refMFD, (RangeTracker[])quantityTracks.get((Object)Quantities.UPPER_DEPTH));
                GriddedDiagnosticPlot.addRangeFuncs(depthFuncs, depthChars, Colors.tab_blue, Quantities.LOWER_DEPTH.label, refMFD, (RangeTracker[])quantityTracks.get((Object)Quantities.LOWER_DEPTH));
                double maxDepth = Math.max(1.0, GriddedDiagnosticPlot.getMax(depthFuncs));
                Range depthRange = new Range(0.0, Math.max(maxDepth * 1.1, maxDepth + 2.0));
                PlotSpec depthSpec = new PlotSpec(depthFuncs, depthChars, (String)titlePrefix + "Rupture Depths & Widths", "Magnitude", "Depth (km)");
                depthSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT);
                depthSpec.setYAxisInverted(true);
                ArrayList<DiscretizedFunc> widthFuncs = new ArrayList<DiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> widthChars = new ArrayList<PlotCurveCharacterstics>();
                GriddedDiagnosticPlot.addRangeFuncs(widthFuncs, widthChars, Color.BLACK, null, refMFD, (RangeTracker[])quantityTracks.get((Object)Quantities.WIDTH));
                double maxWidth = Math.max(1.0, GriddedDiagnosticPlot.getMax(widthFuncs));
                Range widthRange = new Range(0.0, Math.max(maxWidth * 1.1, maxWidth + 2.0));
                PlotSpec widthSpec = new PlotSpec(widthFuncs, widthChars, depthSpec.getTitle(), "Magnitude", Quantities.WIDTH.label + " (" + Quantities.WIDTH.units + ")");
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.drawGraphPanel(List.of(depthSpec, widthSpec), false, false, List.of(xRange), List.of(depthRange, widthRange));
                PlotUtils.setSubPlotWeights(gp, 2, 1);
                PlotUtils.writePlots(resourcesDir, prefix + "_depth_width", (GraphPanel)gp, 700, 800, true, true, false);
                lines.add("![Depth-Width plot](" + relPathToResources + "/" + prefix + "_depth_width.png)");
                lines.add("");
                ArrayList<DiscretizedFunc> areaFuncs = new ArrayList<DiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> areaChars = new ArrayList<PlotCurveCharacterstics>();
                GriddedDiagnosticPlot.addRangeFuncs(areaFuncs, areaChars, Colors.tab_red, null, refMFD, (RangeTracker[])quantityTracks.get((Object)Quantities.AREA));
                double minArea = Math.max(0.1, GriddedDiagnosticPlot.getMin(areaFuncs));
                double maxArea = Math.max(100.0, GriddedDiagnosticPlot.getMax(areaFuncs));
                Range areaRange = new Range(Math.pow(10.0, Math.floor(Math.log10(minArea))), Math.pow(10.0, Math.ceil(Math.log10(maxArea))));
                PlotSpec areaSpec = new PlotSpec(areaFuncs, areaChars, (String)titlePrefix + "Rupture Scaling", "Magnitude", Quantities.AREA.label + " (" + Quantities.AREA.units + ")");
                ArrayList<DiscretizedFunc> lengthFuncs = new ArrayList<DiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> lengthChars = new ArrayList<PlotCurveCharacterstics>();
                GriddedDiagnosticPlot.addRangeFuncs(lengthFuncs, lengthChars, Colors.tab_purple, null, refMFD, (RangeTracker[])quantityTracks.get((Object)Quantities.LENGTH));
                double maxLength = Math.max(10.0, GriddedDiagnosticPlot.getMax(lengthFuncs));
                Range lengthRange = new Range(0.0, Math.max(maxLength * 1.1, maxLength + 5.0));
                PlotSpec lengthSpec = new PlotSpec(lengthFuncs, lengthChars, (String)titlePrefix + "Rupture Scaling", "Magnitude", Quantities.LENGTH.label + " (" + Quantities.LENGTH.units + ")");
                gp.drawGraphPanel(List.of(areaSpec, lengthSpec), List.of(Boolean.valueOf(false)), List.of(Boolean.valueOf(true), Boolean.valueOf(false)), List.of(xRange), List.of(areaRange, lengthRange));
                PlotUtils.writePlots(resourcesDir, prefix + "_scaling", (GraphPanel)gp, 700, 800, true, true, false);
                lines.add("![Scaling plot](" + relPathToResources + "/" + prefix + "_scaling.png)");
                lines.add("");
                if (GriddedDiagnosticPlot.doAnyVary((RangeTracker[])quantityTracks.get((Object)Quantities.AREA))) {
                    String magAreaPrefix = prefix + "_mag_area_scatter";
                    GriddedDiagnosticPlot.plotScatter(resourcesDir, magAreaPrefix, mechRups, Quantities.AREA, (RangeTracker[])quantityTracks.get((Object)Quantities.AREA), refMFD);
                    lines.add("![Mag-Area Scatter](" + relPathToResources + "/" + magAreaPrefix + ".png)");
                    lines.add("");
                }
                if (!GriddedDiagnosticPlot.doAnyVary((RangeTracker[])quantityTracks.get((Object)Quantities.LENGTH))) continue;
                String magLengthPrefix = prefix + "_mag_length_scatter";
                GriddedDiagnosticPlot.plotScatter(resourcesDir, magLengthPrefix, mechRups, Quantities.LENGTH, (RangeTracker[])quantityTracks.get((Object)Quantities.LENGTH), refMFD);
                lines.add("![Mag-Length Scatter](" + relPathToResources + "/" + magLengthPrefix + ".png)");
                lines.add("");
            }
        }
        return lines;
    }

    private static double getMin(List<DiscretizedFunc> funcs) {
        double min = 0.0;
        for (DiscretizedFunc func : funcs) {
            if (func instanceof UncertainBoundedDiscretizedFunc) {
                min = Math.min(min, ((UncertainBoundedDiscretizedFunc)func).getLower().getMinY());
                continue;
            }
            min = Math.min(min, func.getMinY());
        }
        return min;
    }

    private static double getMax(List<DiscretizedFunc> funcs) {
        double max = 0.0;
        for (DiscretizedFunc func : funcs) {
            if (func instanceof UncertainBoundedDiscretizedFunc) {
                max = Math.max(max, ((UncertainBoundedDiscretizedFunc)func).getUpper().getMaxY());
                continue;
            }
            max = Math.max(max, func.getMaxY());
        }
        return max;
    }

    private static boolean doAnyVary(RangeTracker[] tracks) {
        for (RangeTracker track : tracks) {
            if (track.numFinite <= 0 || track.allSame) continue;
            return true;
        }
        return false;
    }

    private static boolean addRangeFuncs(List<DiscretizedFunc> funcs, List<PlotCurveCharacterstics> chars, Color color, String label, IncrementalMagFreqDist refMFD, RangeTracker[] tracks) {
        ArrayList<RangeTracker> curBundle = null;
        ArrayList<Double> curBundleMags = null;
        ArrayList allBundles = new ArrayList();
        ArrayList allBundleMags = new ArrayList();
        for (int i = 0; i < tracks.length; ++i) {
            if (tracks[i].numFinite > 0) {
                if (curBundle == null) {
                    curBundle = new ArrayList<RangeTracker>();
                    curBundleMags = new ArrayList<Double>();
                    allBundles.add(curBundle);
                    allBundleMags.add(curBundleMags);
                }
                curBundle.add(tracks[i]);
                curBundleMags.add(refMFD.getX(i));
                continue;
            }
            curBundle = null;
            curBundleMags = null;
        }
        if (allBundles.isEmpty()) {
            return false;
        }
        for (int b = 0; b < allBundles.size(); ++b) {
            List bundle = (List)allBundles.get(b);
            List bundleMags = (List)allBundleMags.get(b);
            boolean anyMultiple = false;
            for (RangeTracker track : bundle) {
                anyMultiple |= !track.allSame;
            }
            ArbitrarilyDiscretizedFunc average = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc lower = anyMultiple ? new ArbitrarilyDiscretizedFunc() : null;
            ArbitrarilyDiscretizedFunc upper = anyMultiple ? new ArbitrarilyDiscretizedFunc() : null;
            for (int i = 0; i < bundle.size(); ++i) {
                double mag = (Double)bundleMags.get(i);
                RangeTracker track = (RangeTracker)bundle.get(i);
                average.set(mag, track.getAverage());
                if (!anyMultiple) continue;
                lower.set(mag, track.min);
                upper.set(mag, track.max);
            }
            if (anyMultiple) {
                UncertainArbDiscFunc combFunc = new UncertainArbDiscFunc(average, lower, upper);
                if (b == 0) {
                    combFunc.setName(label);
                }
                funcs.add(combFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN_TRANS, 1.0f, color));
            }
            if (b == 0) {
                average.setName(label);
            }
            funcs.add(average);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color));
        }
        return true;
    }

    private static void plotScatter(File resourcesDir, String prefix, List<GridSourceList.GriddedRupture> rups, Quantities quantity, RangeTracker[] ranges, EvenlyDiscretizedFunc refMFD) throws IOException {
        ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < ranges.length; ++i) {
            if (ranges[i].numFinite <= 0) continue;
            meanFunc.set(refMFD.getX(i), ranges[i].getAverage());
        }
        double[] mags = new double[rups.size()];
        double[] values = new double[rups.size()];
        for (int i = 0; i < rups.size(); ++i) {
            GridSourceList.GriddedRupture rup = rups.get(i);
            mags[i] = rup.properties.magnitude;
            values[i] = quantity.get(rup);
        }
        LightFixedXFunc scatter = new LightFixedXFunc(mags, values);
        RuptureScalingPlot.plot(resourcesDir, prefix, " ", scatter, null, null, null, "Magnitude", false, quantity.label + " (" + quantity.units + ")", quantity.plotLog, meanFunc, null, null);
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(GridSourceList.class);
    }

    public static void main(String[] args) throws IOException {
        FaultSystemSolution sol = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/nshm23/batch_inversions/2024_02_02-nshm23_branches-WUS_FM_v3/results_WUS_FM_v3_branch_averaged_gridded_simplified.zip"));
        File outputDir = new File("/tmp/grid_report");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        ReportPageGen pageGen = new ReportPageGen(sol.getRupSet(), sol, "Solution", outputDir, List.of(new GriddedDiagnosticPlot()));
        pageGen.setReplot(true);
        pageGen.generatePage();
    }

    private static enum Quantities {
        AREA("Area", "km\u00b2", true){

            @Override
            public double get(GridSourceList.GriddedRupture rup) {
                return rup.properties.length * GriddedDiagnosticPlot.calcWidth(rup);
            }
        }
        ,
        LENGTH("Length", "km"){

            @Override
            public double get(GridSourceList.GriddedRupture rup) {
                return rup.properties.length;
            }
        }
        ,
        WIDTH("Down-Dip Width", "km"){

            @Override
            public double get(GridSourceList.GriddedRupture rup) {
                return GriddedDiagnosticPlot.calcWidth(rup);
            }
        }
        ,
        UPPER_DEPTH("Upper Depth", "km"){

            @Override
            public double get(GridSourceList.GriddedRupture rup) {
                return rup.properties.upperDepth;
            }
        }
        ,
        LOWER_DEPTH("Lower Depth", "km"){

            @Override
            public double get(GridSourceList.GriddedRupture rup) {
                return rup.properties.lowerDepth;
            }
        };

        public final String label;
        public final String units;
        public final boolean plotLog;

        private Quantities(String label, String units) {
            this(label, units, false);
        }

        private Quantities(String label, String units, boolean plotLog) {
            this.label = label;
            this.units = units;
            this.plotLog = plotLog;
        }

        public abstract double get(GridSourceList.GriddedRupture var1);
    }

    private static class RangeTracker {
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;
        private double sumRate = 0.0;
        private double rateWeightedSum = 0.0;
        private boolean first = true;
        private double firstVal;
        private boolean allSame;
        private int numNonFinite = 0;
        private int numFinite = 0;

        private RangeTracker() {
        }

        public void add(double value, double rate) {
            if (Double.isFinite(value)) {
                ++this.numFinite;
            } else {
                ++this.numNonFinite;
                return;
            }
            if (this.first) {
                this.firstVal = value;
                this.first = false;
                this.allSame = true;
            } else {
                this.allSame &= (float)this.firstVal == (float)value;
            }
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.rateWeightedSum += value * rate;
            this.sumRate += rate;
        }

        public double getAverage() {
            Preconditions.checkState((this.numFinite > 0 ? 1 : 0) != 0);
            if (this.allSame) {
                return this.firstVal;
            }
            return this.rateWeightedSum / this.sumRate;
        }
    }
}

