/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.Interpolate;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;

public class InversionProgressPlot
extends AbstractSolutionPlot {
    @Override
    public String getName() {
        return "Simulated Annealing Energy";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        AnnealingProgress progress = sol.requireModule(AnnealingProgress.class);
        AnnealingProgress compProgress = null;
        if (meta.hasComparisonSol()) {
            compProgress = meta.comparison.sol.getModule(AnnealingProgress.class);
        }
        ArrayList<String> lines = new ArrayList<String>();
        long millis = progress.getTime(progress.size() - 1);
        double secs = (double)millis / 1000.0;
        double mins = secs / 60.0;
        double hours = mins / 60.0;
        long perturbs = progress.getNumPerturbations(progress.size() - 1);
        long worseKept = progress.hasWorseKepts() ? progress.getNumWorseKept(progress.size() - 1) : -1L;
        long iters = progress.getIterations(progress.size() - 1);
        double totalEnergy = progress.getEnergies(progress.size() - 1)[0];
        int ips = (int)((double)iters / secs + 0.5);
        double ipp = (double)iters / (double)perturbs;
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        if (compProgress != null) {
            table.addColumn("");
        }
        table.addColumn("**Iterations**").addColumn("**Time**").addColumn("**Iterations Per Sec.**").addColumn("**Perturbations**");
        if (worseKept >= 0L) {
            table.addColumn("**# Worse Pertubations Kept**");
        }
        table.addColumn("**Iterations Per Perturb.**").addColumn("**Total Energy**");
        table.finalizeLine().initNewLine();
        if (compProgress != null) {
            table.addColumn("Primary");
        }
        table.addColumn(countDF.format(iters));
        table.addColumn(ThreadedSimulatedAnnealing.timeStr(millis));
        table.addColumn(countDF.format(ips));
        table.addColumn(countDF.format(perturbs));
        if (worseKept >= 0L) {
            table.addColumn(countDF.format(worseKept));
        }
        table.addColumn(ipp > 100.0 ? countDF.format((int)(ipp + 0.5)) : twoDigits.format(ipp));
        table.addColumn(Float.valueOf((float)totalEnergy));
        table.finalizeLine();
        long cperturbs = -1L;
        if (compProgress != null) {
            long cmillis = compProgress.getTime(compProgress.size() - 1);
            double csecs = (double)cmillis / 1000.0;
            cperturbs = compProgress.getNumPerturbations(compProgress.size() - 1);
            long citers = compProgress.getIterations(compProgress.size() - 1);
            double ctotalEnergy = compProgress.getEnergies(compProgress.size() - 1)[0];
            long cworseKept = compProgress.hasWorseKepts() ? compProgress.getNumWorseKept(compProgress.size() - 1) : -1L;
            int cips = (int)((double)citers / csecs + 0.5);
            int cipp = (int)((double)citers / (double)cperturbs + 0.5);
            table.initNewLine().addColumn("Comparison");
            table.addColumn(countDF.format(citers));
            table.addColumn(ThreadedSimulatedAnnealing.timeStr(cmillis));
            table.addColumn(countDF.format(cips));
            table.addColumn(countDF.format(cperturbs));
            if (worseKept >= 0L) {
                table.addColumn(countDF.format(cworseKept));
            }
            table.addColumn(ipp > 100.0 ? countDF.format((int)((double)cipp + 0.5)) : twoDigits.format(cipp));
            table.addColumn(Float.valueOf((float)ctotalEnergy));
            table.finalizeLine();
        }
        lines.addAll(table.invert().build());
        lines.add("");
        lines.add(this.getSubHeading() + " Final Energies");
        lines.add(topLink);
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        long deltaEachMillis = hours > 20.0 ? 18000000L : (hours > 9.0 ? 0x6DDD00L : (hours > 3.0 ? 3600000L : (hours > 1.0 ? 1800000L : (mins > 30.0 ? 900000L : (mins > 10.0 ? 300000L : 300000L)))));
        table.initNewLine().addColumn("Energy Type").addColumn("Final Energy (" + ThreadedSimulatedAnnealing.timeStr(progress.getTime(progress.size() - 1)) + ")").addColumn("% of Total");
        ArrayList<Long> progressTimes = new ArrayList<Long>();
        ArrayList<Integer> progressIndexAfters = new ArrayList<Integer>();
        int curIndex = 0;
        long maxTimeToInclude = (long)((double)millis * 0.95);
        for (long t = deltaEachMillis; t < maxTimeToInclude; t += deltaEachMillis) {
            long time;
            if (t < progress.getTime(0)) continue;
            progressTimes.add(t);
            Object str = "";
            if (t == deltaEachMillis) {
                str = "After ";
            }
            str = (String)str + ThreadedSimulatedAnnealing.timeStr(t);
            table.addColumn("_" + (String)str + "_");
            while (curIndex < progress.size() && (time = progress.getTime(curIndex)) < t) {
                ++curIndex;
            }
            progressIndexAfters.add(curIndex);
        }
        table.finalizeLine();
        double[] finalEnergies = progress.getEnergies(progress.size() - 1);
        ImmutableList<String> types = progress.getEnergyTypes();
        for (int t = 0; t < types.size(); ++t) {
            table.initNewLine();
            table.addColumn("**" + (String)types.get(t) + "**");
            if (t == 0) {
                table.addColumn("**" + (float)finalEnergies[t] + "**").addColumn("");
            } else {
                table.addColumn(Float.valueOf((float)finalEnergies[t])).addColumn(percentDF.format(finalEnergies[t] / finalEnergies[0]));
            }
            for (int i = 0; i < progressTimes.size(); ++i) {
                double val;
                long time = (Long)progressTimes.get(i);
                int i1 = (Integer)progressIndexAfters.get(i);
                if (i1 == 0) {
                    val = progress.getEnergies(i1)[t];
                } else if (i1 >= progress.size()) {
                    val = progress.getEnergies(progress.size() - 1)[t];
                } else {
                    int i0 = i1 - 1;
                    double x1 = progress.getTime(i0);
                    double x2 = progress.getTime(i1);
                    double y1 = progress.getEnergies(i0)[t];
                    double y2 = progress.getEnergies(i1)[t];
                    val = Interpolate.findY(x1, y1, x2, y2, time);
                }
                String str = "" + (float)val;
                if (i1 == 0 || i1 >= progress.size()) {
                    str = str + "*";
                }
                table.addColumn("_" + str + "_");
            }
            table.finalizeLine();
        }
        lines.addAll(table.build());
        String prefix = "sa_progress";
        SimulatedAnnealing.writeProgressPlots(progress, resourcesDir, prefix, sol.getRupSet().getNumRuptures(), compProgress);
        lines.add("");
        lines.add(this.getSubHeading() + " Energy Progress");
        lines.add(topLink);
        lines.add("");
        lines.add("![Energy vs Time](" + relPathToResources + "/" + prefix + "_energy_vs_time.png)");
        lines.add("");
        lines.add("![Energy vs Iterations](" + relPathToResources + "/" + prefix + "_energy_vs_iters.png)");
        lines.add("");
        lines.add("![Perturbations](" + relPathToResources + "/" + prefix + "_perturb_vs_iters.png)");
        if (sol.hasModule(InversionMisfitProgress.class)) {
            InversionMisfitProgress misfitProgress = sol.getModule(InversionMisfitProgress.class);
            InversionMisfitProgress compMisfitProgress = null;
            if (meta != null && meta.hasComparisonSol() && meta.comparison.sol.hasModule(InversionMisfitProgress.class)) {
                compMisfitProgress = meta.comparison.sol.getModule(InversionMisfitProgress.class);
            }
            if (!misfitProgress.getIterations().isEmpty()) {
                lines.add(this.getSubHeading() + " Constraint Misfit Progress");
                lines.add(topLink);
                lines.add("");
                String compName = compMisfitProgress == null ? null : meta.comparison.name;
                lines.addAll(InversionProgressPlot.plotMisfitProgress(misfitProgress, compMisfitProgress, compName, resourcesDir, relPathToResources));
            }
        }
        return lines;
    }

    public static List<String> plotMisfitProgress(InversionMisfitProgress misfitProgress, File resourcesDir, String relPathToResources) throws IOException {
        return InversionProgressPlot.plotMisfitProgress(misfitProgress, null, null, resourcesDir, relPathToResources);
    }

    public static List<String> plotMisfitProgress(InversionMisfitProgress misfitProgress, InversionMisfitProgress compMisfitProgress, String compName, File resourcesDir, String relPathToResources) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        List<Long> iterations = misfitProgress.getIterations();
        InversionMisfitStats.Quantity targetQuantity = misfitProgress.getTargetQuantity();
        List<Double> targetVals = misfitProgress.getTargetVals();
        List<InversionMisfitStats> statsList = misfitProgress.getStats();
        if (!iterations.isEmpty()) {
            InversionMisfitStats.Quantity[] quantities;
            ArrayList<String> constraintNames = new ArrayList<String>();
            for (InversionMisfitStats.MisfitStats stats : statsList.get(0).getStats()) {
                constraintNames.add(stats.range.name);
            }
            Preconditions.checkState((!constraintNames.isEmpty() ? 1 : 0) != 0);
            HashBasedTable constrValIterFuncs = HashBasedTable.create();
            HashMap<String, ArbitrarilyDiscretizedFunc> constrWeightIterFuncs = new HashMap<String, ArbitrarilyDiscretizedFunc>();
            HashMap<InversionMisfitStats.Quantity, ArbitrarilyDiscretizedFunc> avgValIterFuncs = new HashMap<InversionMisfitStats.Quantity, ArbitrarilyDiscretizedFunc>();
            ArbitrarilyDiscretizedFunc targetValIterFunc = targetQuantity != null && targetVals != null ? new ArbitrarilyDiscretizedFunc("Target") : null;
            for (InversionMisfitStats.Quantity q : quantities = new InversionMisfitStats.Quantity[]{InversionMisfitStats.Quantity.MAD, InversionMisfitStats.Quantity.STD_DEV}) {
                avgValIterFuncs.put(q, new ArbitrarilyDiscretizedFunc("Average"));
            }
            for (int i = 0; i < iterations.size(); ++i) {
                long iter = iterations.get(i);
                InversionMisfitStats stats = statsList.get(i);
                for (InversionMisfitStats.Quantity quantity : quantities) {
                    double avgVal = 0.0;
                    ArrayList<Double> vals = new ArrayList<Double>();
                    for (InversionMisfitStats.MisfitStats misfits : stats.getStats()) {
                        String name = misfits.range.name;
                        String funcName = name;
                        if (funcName.startsWith("Uncertain ")) {
                            funcName = funcName.substring(10).trim();
                        }
                        if (!constrValIterFuncs.contains((Object)name, (Object)quantity)) {
                            constrValIterFuncs.put((Object)name, (Object)quantity, (Object)new ArbitrarilyDiscretizedFunc(funcName));
                        }
                        double val = misfits.get(quantity);
                        ((ArbitrarilyDiscretizedFunc)constrValIterFuncs.get((Object)name, (Object)quantity)).set(iter, val);
                        avgVal += val;
                        vals.add(val);
                        if (quantity != quantities[0]) continue;
                        if (!constrWeightIterFuncs.containsKey(name)) {
                            constrWeightIterFuncs.put(name, new ArbitrarilyDiscretizedFunc(funcName));
                        }
                        ((ArbitrarilyDiscretizedFunc)constrWeightIterFuncs.get(name)).set(iter, misfits.range.weight);
                    }
                    ((ArbitrarilyDiscretizedFunc)avgValIterFuncs.get((Object)quantity)).set(iter, avgVal /= (double)stats.getStats().size());
                    if (targetValIterFunc == null || quantity != targetQuantity) continue;
                    targetValIterFunc.set(iter, (double)targetVals.get(i));
                }
            }
            InversionMisfitStats.Quantity[] plotQ = new InversionMisfitStats.Quantity[quantities.length + 1];
            for (int q = 0; q < quantities.length; ++q) {
                plotQ[q] = quantities[q];
            }
            CPT colorCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, (double)constraintNames.size() - 1.0);
            PlotSpec madSpec = null;
            Range madYRange = null;
            PlotSpec weightSpec = null;
            Range weightYRange = null;
            Range xRange = new Range(0.0, (double)iterations.get(iterations.size() - 1).longValue());
            for (InversionMisfitStats.Quantity quantity : plotQ) {
                boolean yLog;
                ArbitrarilyDiscretizedFunc avgFunc;
                Map constrFuncs;
                Object myPrefix;
                Object yAxisLabel;
                if (quantity == null) {
                    yAxisLabel = "Constraint Weight";
                    myPrefix = "misfit_progress_weights";
                    constrFuncs = constrWeightIterFuncs;
                    avgFunc = null;
                    yLog = true;
                    boolean variable = false;
                    for (ArbitrarilyDiscretizedFunc func : constrFuncs.values()) {
                        if ((float)func.getMinY() == (float)func.getMaxY()) continue;
                        variable = true;
                        break;
                    }
                    if (!variable) {
                        continue;
                    }
                } else {
                    yAxisLabel = "Misfit " + String.valueOf((Object)quantity);
                    myPrefix = "misfit_progress_" + quantity.name();
                    constrFuncs = constrValIterFuncs.column((Object)quantity);
                    avgFunc = (ArbitrarilyDiscretizedFunc)avgValIterFuncs.get((Object)quantity);
                    yLog = false;
                }
                ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                if (targetValIterFunc != null && quantity == targetQuantity) {
                    funcs.add(targetValIterFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GRAY));
                }
                if (avgFunc != null) {
                    funcs.add(avgFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
                }
                for (int i = 0; i < constraintNames.size(); ++i) {
                    String name = (String)constraintNames.get(i);
                    funcs.add((DiscretizedFunc)constrFuncs.get(name));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, colorCPT.getColor(i)));
                }
                if (quantity != null && compMisfitProgress != null) {
                    List<InversionMisfitStats> compStatsList = compMisfitProgress.getStats();
                    ArbitrarilyDiscretizedFunc compAvgFunc = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc compTargetFunc = quantity == compMisfitProgress.getTargetQuantity() ? new ArbitrarilyDiscretizedFunc() : null;
                    boolean targetDiffers = false;
                    List<Long> compIters = compMisfitProgress.getIterations();
                    List<Double> compTargets = compMisfitProgress.getTargetVals();
                    for (int i = 0; i < compIters.size(); ++i) {
                        long iter = compIters.get(i);
                        InversionMisfitStats stats = compStatsList.get(i);
                        double avgVal = 0.0;
                        ArrayList<Double> vals = new ArrayList<Double>();
                        for (InversionMisfitStats.MisfitStats misfits : stats.getStats()) {
                            double val = misfits.get(quantity);
                            avgVal += val;
                            vals.add(val);
                        }
                        compAvgFunc.set(iter, avgVal /= (double)stats.getStats().size());
                        if (compTargetFunc == null) continue;
                        double targetVal = compTargets.get(i);
                        compTargetFunc.set(iter, targetVal);
                        targetDiffers = targetDiffers || (float)targetVal != (float)avgVal;
                    }
                    if (compName == null) {
                        compName = "Comparison";
                    }
                    compAvgFunc.setName(compName + " Average");
                    funcs.add(compAvgFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.DARK_GRAY));
                    if (targetDiffers && compTargetFunc != null) {
                        compTargetFunc.setName(compName + " Target");
                        funcs.add(compTargetFunc);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, Color.DARK_GRAY));
                    }
                }
                PlotSpec spec = new PlotSpec(funcs, chars, "Misfit Progress", "Iterations", (String)yAxisLabel);
                spec.setLegendInset(true);
                Range yRange = null;
                if (yLog) {
                    double maxWeight = 0.0;
                    double minWeight = Double.POSITIVE_INFINITY;
                    for (DiscretizedFunc func : funcs) {
                        maxWeight = Math.max(maxWeight, func.getMaxY());
                        minWeight = Math.min(minWeight, func.getMinY());
                    }
                    yRange = new Range(Math.pow(10.0, Math.floor(Math.log10(minWeight))), Math.pow(10.0, Math.ceil(Math.log10(maxWeight))));
                }
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, false, yLog, xRange, yRange);
                PlotUtils.writePlots(resourcesDir, (String)myPrefix, (GraphPanel)gp, 1000, 700, true, false, false);
                lines.add("![misfit plot](" + relPathToResources + "/" + (String)myPrefix + ".png)");
                if (quantity == null) {
                    weightSpec = spec;
                    weightYRange = yRange;
                    continue;
                }
                if (quantity != InversionMisfitStats.Quantity.MAD) continue;
                madSpec = spec;
                madYRange = yRange;
            }
            if (madSpec != null && weightSpec != null) {
                weightSpec.setLegendVisible(false);
                madSpec.setTitle(" ");
                weightSpec.setTitle(" ");
                HeadlessGraphPanel headlessGraphPanel = PlotUtils.initHeadless();
                headlessGraphPanel.setTickLabelFontSize(22);
                headlessGraphPanel.setAxisLabelFontSize(24);
                headlessGraphPanel.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                ArrayList<Range> yRanges = new ArrayList<Range>();
                yRanges.add(madYRange);
                yRanges.add(weightYRange);
                headlessGraphPanel.drawGraphPanel(List.of(madSpec, weightSpec), List.of(Boolean.valueOf(false)), List.of(Boolean.valueOf(false), Boolean.valueOf(true)), List.of(xRange), yRanges);
                PlotUtils.writePlots(resourcesDir, "misfit_progress_combined", (GraphPanel)headlessGraphPanel, 1000, 1200, true, true, false);
            }
        }
        return lines;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(AnnealingProgress.class);
    }
}

