/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.SolidFillPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;

public class ParticipationRatePlot
extends AbstractSolutionPlot
implements SolidFillPlot {
    boolean fillSurfaces = false;

    @Override
    public void setFillSurfaces(boolean fillSurfaces) {
        this.fillSurfaces = fillSurfaces;
    }

    @Override
    public String getName() {
        return "Fault Participation Rates";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        FaultSystemRupSet rupSet = sol.getRupSet();
        double minMag = rupSet.getMinMag();
        double maxMag = rupSet.getMaxMag();
        ArrayList<Double> minMags = new ArrayList<Double>();
        ArrayList<String> magLabels = new ArrayList<String>();
        ArrayList<String> magPrefixes = new ArrayList<String>();
        minMags.add(0.0);
        magLabels.add("Supra-Seismogenic");
        magPrefixes.add("supra_seis");
        if (maxMag > 6.0 && minMag <= 6.0) {
            minMags.add(6.0);
            magLabels.add("M\u22656");
            magPrefixes.add("m6");
        }
        if (maxMag > 6.5 && minMag <= 6.5 && maxMag < 9.0) {
            minMags.add(6.5);
            magLabels.add("M\u22656.5");
            magPrefixes.add("m6p5");
        }
        if (maxMag > 7.0) {
            minMags.add(7.0);
            magLabels.add("M\u22657");
            magPrefixes.add("m7");
        }
        if (maxMag > 7.5 && minMag <= 7.5 && maxMag < 9.0) {
            minMags.add(7.5);
            magLabels.add("M\u22657.5");
            magPrefixes.add("m7p5");
        }
        if (maxMag > 8.0) {
            minMags.add(8.0);
            magLabels.add("M\u22658");
            magPrefixes.add("m8");
        }
        if (maxMag > 9.0) {
            minMags.add(9.0);
            magLabels.add("M\u22659");
            magPrefixes.add("m9");
        }
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-8.0, -1.0);
        cpt.setNanColor(Color.GRAY);
        RupSetMapMaker mapMaker = new RupSetMapMaker(sol.getRupSet(), meta.region);
        mapMaker.setWriteGeoJSON(true);
        mapMaker.setFillSurfaces(this.fillSurfaces);
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        CPT ratioCPT = null;
        if (meta.comparison != null && meta.comparison.sol != null && meta.comparisonHasSameSects) {
            CPT belowCPT = new CPT(0.5, 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE);
            CPT aboveCPT = new CPT(1.0, 2.0, Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
            ratioCPT = new CPT();
            ratioCPT.addAll(belowCPT);
            ratioCPT.addAll(aboveCPT);
            ratioCPT.setNanColor(Color.GRAY);
            ratioCPT.setBelowMinColor(ratioCPT.getMinColor());
            ratioCPT.setAboveMaxColor(ratioCPT.getMaxColor());
        }
        for (int m = 0; m < minMags.size(); ++m) {
            double myMinMag = (Double)minMags.get(m);
            double[] rates = sol.calcParticRateForAllSects(myMinMag, Double.POSITIVE_INFINITY);
            String myLabel = (String)magLabels.get(m);
            String markdownLabel = myLabel.replaceAll("\u2265", "&ge;");
            String magPrefix = (String)magPrefixes.get(m);
            table.initNewLine();
            table.addColumn(MarkdownUtils.boldCentered(markdownLabel));
            if (m < minMags.size() - 1) {
                String rangeLabel = myMinMag == 0.0 ? "M&le;" + optionalDigitDF.format(minMags.get(m + 1)) : "M&isin;[" + optionalDigitDF.format(myMinMag) + ", " + optionalDigitDF.format(minMags.get(m + 1)) + "]";
                table.addColumn(MarkdownUtils.boldCentered("Range: " + rangeLabel));
            } else {
                table.addColumn("");
            }
            table.finalizeLine();
            ArrayList<CallSite> prefixes = new ArrayList<CallSite>();
            String mainPrefix = "sol_partic_" + magPrefix;
            double[] plotRates = this.log10(this.maskSectsOutsideMagRange(rates, sol.getRupSet(), myMinMag, Double.POSITIVE_INFINITY));
            mapMaker.plotSectScalars(plotRates, cpt, "Log10 " + myLabel + " Participation Rate (events/yr)");
            mapMaker.plot(resourcesDir, mainPrefix, " ");
            prefixes.add((CallSite)((Object)mainPrefix));
            table.initNewLine();
            table.addColumn("![Map](" + relPathToResources + "/" + mainPrefix + ".png)");
            if (m < minMags.size() - 1) {
                double upperMag = (Double)minMags.get(m + 1);
                double[] range = sol.calcParticRateForAllSects(myMinMag, upperMag);
                String rangePrefix = "sol_partic_" + magPrefix + "_to_" + (String)magPrefixes.get(m + 1);
                Object label = "Log10 ";
                label = myMinMag == 0.0 ? (String)label + myLabel + " -> M" + optionalDigitDF.format(upperMag) : (String)label + "M" + optionalDigitDF.format(myMinMag) + " -> " + optionalDigitDF.format(upperMag);
                label = (String)label + " Participation Rate (events/yr)";
                double[] plotRange = this.log10(this.maskSectsOutsideMagRange(range, sol.getRupSet(), myMinMag, upperMag));
                mapMaker.plotSectScalars(plotRange, cpt, (String)label);
                mapMaker.plot(resourcesDir, rangePrefix, " ");
                table.addColumn("![Map](" + relPathToResources + "/" + rangePrefix + ".png)");
                prefixes.add((CallSite)((Object)rangePrefix));
            } else {
                table.addColumn("");
                prefixes.add(null);
            }
            table.finalizeLine();
            table.initNewLine();
            for (String string : prefixes) {
                if (string == null) {
                    table.addColumn("");
                    continue;
                }
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + string + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + string + ".geojson)");
            }
            table.finalizeLine();
            if (ratioCPT == null) continue;
            table.addLine(MarkdownUtils.boldCentered(markdownLabel + " Comparison Ratio"), MarkdownUtils.boldCentered(markdownLabel + " Comparison Scatter"));
            table.initNewLine();
            double[] compRates = meta.comparison.sol.calcParticRateForAllSects(myMinMag, Double.POSITIVE_INFINITY);
            double[] dArray = new double[compRates.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = rates[i] / compRates[i];
            }
            String compPrefix = "sol_partic_compare_" + magPrefix;
            mapMaker.plotSectScalars(dArray, ratioCPT, myLabel + " Primary/Comparison Participation Ratio");
            mapMaker.plot(resourcesDir, compPrefix, " ");
            table.addColumn("![Map](" + relPathToResources + "/" + compPrefix + ".png)");
            prefixes.add((CallSite)((Object)compPrefix));
            File scatter = ParticipationRatePlot.compScatterPlot(resourcesDir, compPrefix + "_scatter", rates, compRates, myLabel);
            table.addColumn("![Map](" + relPathToResources + "/" + scatter.getName() + ")");
            table.finalizeLine().initNewLine();
            table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + compPrefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + compPrefix + ".geojson)");
            table.addColumn("");
            table.finalizeLine();
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("The rate at which each fault section participates in events in the listed magnitude range. Maps in the left column give rates above various magnitude thresholds, and in the right column rates between the given threshold and the next threshold level.");
        lines.add("");
        lines.add("Rates are plotted on a log scale. Gray values mean that the rate is zero, and blue means that it is at or below the minimum plotted rate.");
        lines.add("");
        lines.addAll(table.build());
        return lines;
    }

    private double[] log10(double[] vals) {
        double[] ret = new double[vals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.log10(vals[i]);
        }
        return ret;
    }

    private double[] maskSectsOutsideMagRange(double[] values, FaultSystemRupSet rupSet, double minMag, double maxMag) {
        values = Arrays.copyOf(values, values.length);
        for (int s = 0; s < values.length; ++s) {
            if (values[s] != 0.0) continue;
            double sectMin = rupSet.getMinMagForSection(s);
            double sectMax = rupSet.getMaxMagForSection(s);
            if (!(sectMin > maxMag) && !(sectMax < minMag)) continue;
            values[s] = Double.NaN;
        }
        return values;
    }

    private static double withinRange(Range range, double val) {
        if (val < range.getLowerBound()) {
            return range.getLowerBound();
        }
        if (val > range.getUpperBound()) {
            return range.getUpperBound();
        }
        return val;
    }

    private static File compScatterPlot(File outputDir, String prefix, double[] values1, double[] values2, String label) throws IOException {
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        Range range = new Range(1.0E-8, 1.0);
        for (int i = 0; i < values1.length; ++i) {
            scatter.set(ParticipationRatePlot.withinRange(range, values1[i]), ParticipationRatePlot.withinRange(range, values2[i]));
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        funcs.add(scatter);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(range.getLowerBound(), range.getLowerBound());
        line.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        PlotSpec spec = new PlotSpec(funcs, chars, " ", "Primary " + label, "Comparison " + label);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, true, true, range, range);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, -1, true, false, false);
        return new File(outputDir, prefix + ".png");
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return null;
    }
}

