/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jfree.data.Range;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchSectBVals;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchSectNuclMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.ParticipationRatePlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class SectBValuePlot
extends AbstractSolutionPlot {
    static final EvenlyDiscretizedFunc refFunc = new EvenlyDiscretizedFunc(0.05, 110, 0.1);
    private static final double minB = -3.0;
    private static final double maxB = 3.0;

    @Override
    public String getName() {
        return "Section b-values";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        FaultSystemSolution compSol;
        FaultSystemSolution faultSystemSolution = compSol = meta.hasComparisonSol() ? meta.comparison.sol : null;
        if (compSol != null && !compSol.getRupSet().hasModule(AveSlipModule.class)) {
            compSol = null;
        }
        if (compSol != null && !meta.comparisonHasSameSects) {
            compSol = null;
        }
        RupSetMapMaker mapMaker = new RupSetMapMaker(sol.getRupSet(), meta.region);
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-3.0, 3.0);
        cpt.setNanColor(Color.GRAY);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(this.getSubHeading() + " Subsection b-values");
        lines.add(topLink);
        lines.add("");
        lines.add("These plots estimate a Gutenberg-Richter b-value for each subsection and parent section nucleation MFD. This is a rough approximation, and is intended primarily for model comparisons.");
        lines.add("");
        BranchSectBVals branchBVals = sol.getModule(BranchSectBVals.class);
        if (branchBVals != null && branchBVals.getNumBranches() > 1) {
            lines.add("Note that b-values here are calculated from the branch-averaged nucleation MFD on each section, and do not represent the average of branch-specific b-values. The latter are plotted separately at the end of this section.");
            lines.add("");
        }
        BValEstimate[] sectBVals = SectBValuePlot.estSectBValues(sol);
        BValEstimate[] compSectBVals = compSol == null ? null : SectBValuePlot.estSectBValues(compSol);
        List<? extends IncrementalMagFreqDist> targetMFDs = null;
        if (sol.getRupSet().hasModule(InversionTargetMFDs.class)) {
            targetMFDs = sol.getRupSet().getModule(InversionTargetMFDs.class).getOnFaultSupraSeisNucleationMFDs();
        }
        BValEstimate[] targetSectBVals = targetMFDs == null ? null : SectBValuePlot.estSectTargetBValues(targetMFDs);
        double[] sectRates = sol.calcTotParticRateForAllSects();
        double[] compSectRates = compSol == null ? null : compSol.calcTotParticRateForAllSects();
        String prefix = "sect_b_values";
        System.out.println("Writing b-value CSV files");
        File sectCSV = new File(resourcesDir, prefix + ".csv");
        SectBValuePlot.writeSectCSV(sectCSV, sol.getRupSet().getFaultSectionDataList(), sectBVals, targetSectBVals, branchBVals, sol.getModule(BranchSectNuclMFDs.class));
        String downloadLine = "Download b-value CSV file" + (compSol == null ? "" : "s") + ": [" + sectCSV.getName() + "](" + relPathToResources + "/" + sectCSV.getName() + ")";
        if (compSectBVals != null) {
            File compSectCSV = new File(resourcesDir, prefix + "_comp.csv");
            SectBValuePlot.writeSectCSV(compSectCSV, compSol.getRupSet().getFaultSectionDataList(), compSectBVals, null, null, null);
            downloadLine = downloadLine + " [" + compSectCSV.getName() + "](" + relPathToResources + "/" + compSectCSV.getName() + ")";
        }
        lines.add(downloadLine);
        lines.add("");
        mapMaker.plotSectScalars(SectBValuePlot.toBArray(sectBVals), cpt, "Subsection b-values");
        mapMaker.plot(resourcesDir, prefix, SectBValuePlot.getTruncatedTitle(meta.primary.name));
        if (compSol == null) {
            lines.add("![Section b-values Plot](" + relPathToResources + "/" + prefix + ".png)");
        } else {
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            mapMaker.plotSectScalars(SectBValuePlot.toBArray(compSectBVals), cpt, "Subsection b-values");
            mapMaker.plot(resourcesDir, prefix + "_comp", SectBValuePlot.getTruncatedTitle(meta.comparison.name));
            double[] diffs = new double[sectBVals.length];
            for (int i = 0; i < diffs.length; ++i) {
                diffs[i] = sectBVals[i].b - compSectBVals[i].b;
            }
            CPT diffCPT = GMT_CPT_Files.DIVERGING_BLUE_RED_UNIFORM.instance().rescale(-2.0, 2.0);
            diffCPT.setNanColor(Color.GRAY);
            mapMaker.plotSectScalars(diffs, diffCPT, "Subsection b-values, Primary - Comparison");
            mapMaker.plot(resourcesDir, prefix + "_diff", "Difference");
            table.addLine("![Section b-values Plot](" + relPathToResources + "/" + prefix + ".png)", "![Section b-values Plot](" + relPathToResources + "/" + prefix + "_comp.png)", "![Section b-values Plot](" + relPathToResources + "/" + prefix + "_diff.png)");
            lines.addAll(table.build());
        }
        lines.add("");
        lines.addAll(SectBValuePlot.getHistLines(SectBValuePlot.toBArray(sectBVals), sectRates, SectBValuePlot.toBArray(compSectBVals), compSectRates, targetSectBVals == null ? null : SectBValuePlot.toBArray(targetSectBVals), resourcesDir, relPathToResources, prefix));
        lines.add("");
        lines.add(this.getSubHeading() + " Parent Section b-values");
        lines.add(topLink);
        lines.add("");
        prefix = "parent_sect_b_values";
        Map<Integer, BValEstimate> parentBValsMap = SectBValuePlot.estParentSectBValues(sol);
        HashMap<Integer, String> parentNames = new HashMap<Integer, String>();
        for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
            if (parentNames.containsKey(faultSection.getParentSectionId())) continue;
            parentNames.put(faultSection.getParentSectionId(), faultSection.getParentSectionName());
        }
        BValEstimate[] parentBVals = new BValEstimate[parentBValsMap.size()];
        double[] dArray = new double[parentBValsMap.size()];
        SectBValuePlot.calcParentVals(sol, parentBVals, dArray, parentBValsMap);
        BValEstimate[] parentTargetBVals = null;
        Map<Integer, BValEstimate> parentTargetBValsMap = null;
        if (targetMFDs != null) {
            parentTargetBValsMap = SectBValuePlot.estParentSectTargetBValues(sol, targetMFDs);
            parentTargetBVals = new BValEstimate[parentTargetBValsMap.size()];
            SectBValuePlot.calcParentVals(sol, parentTargetBVals, null, parentTargetBValsMap);
        }
        BValEstimate[] compParentBVals = null;
        double[] compParentRates = null;
        Map<Integer, BValEstimate> compParentBValsMap = null;
        if (compSol != null) {
            compParentBValsMap = SectBValuePlot.estParentSectBValues(compSol);
            compParentBVals = new BValEstimate[compParentBValsMap.size()];
            compParentRates = new double[compParentBValsMap.size()];
            SectBValuePlot.calcParentVals(sol, compParentBVals, compParentRates, compParentBValsMap);
        }
        System.out.println("Writing b-value CSV files");
        sectCSV = new File(resourcesDir, prefix + ".csv");
        SectBValuePlot.writeParentSectCSV(sectCSV, parentNames, parentBValsMap, parentTargetBValsMap, meta.primary.rupSet.getFaultSectionDataList(), branchBVals, sol.getModule(BranchSectNuclMFDs.class));
        downloadLine = "Download b-value CSV file" + (compSol == null ? "" : "s") + ": [" + sectCSV.getName() + "](" + relPathToResources + "/" + sectCSV.getName() + ")";
        if (compSectBVals != null) {
            File compSectCSV = new File(resourcesDir, prefix + "_comp.csv");
            SectBValuePlot.writeParentSectCSV(compSectCSV, parentNames, compParentBValsMap, parentTargetBValsMap, meta.comparison.rupSet.getFaultSectionDataList(), null, null);
            downloadLine = downloadLine + " [" + compSectCSV.getName() + "](" + relPathToResources + "/" + compSectCSV.getName() + ")";
        }
        lines.add(downloadLine);
        lines.add("");
        lines.addAll(SectBValuePlot.getHistLines(SectBValuePlot.toBArray(parentBVals), dArray, SectBValuePlot.toBArray(compParentBVals), compParentRates, parentTargetBVals == null ? null : SectBValuePlot.toBArray(parentTargetBVals), resourcesDir, relPathToResources, prefix));
        if (branchBVals != null && branchBVals.getNumBranches() > 1) {
            lines.add("");
            lines.add(this.getSubHeading() + " Branch-averaged subsection b-values");
            lines.add(topLink);
            lines.add("");
            lines.add("This solution has branch-specific b-values attached. The following plots show the branch-averaged b-value, interquartile range (IQR), and total range computed across all " + branchBVals.getNumBranches() + " branches.");
            lines.add("");
            double[] meanBVals = new double[sectBVals.length];
            double[] minBVals = new double[sectBVals.length];
            double[] maxBVals = new double[sectBVals.length];
            double[] p25BVals = new double[sectBVals.length];
            double[] p75BVals = new double[sectBVals.length];
            double[] bValIQR = new double[sectBVals.length];
            double[] bValRange = new double[sectBVals.length];
            for (int s = 0; s < meanBVals.length; ++s) {
                ArbDiscrEmpiricalDistFunc dist = branchBVals.getSectBValDist(s);
                meanBVals[s] = dist.getMean();
                p25BVals[s] = dist.getInterpolatedFractile(0.25);
                p75BVals[s] = dist.getInterpolatedFractile(0.75);
                minBVals[s] = dist.getMinX();
                maxBVals[s] = dist.getMaxX();
                bValIQR[s] = p75BVals[s] - p25BVals[s];
                bValRange[s] = maxBVals[s] - minBVals[s];
            }
            mapMaker.setWriteGeoJSON(false);
            mapMaker.setWritePDFs(false);
            mapMaker.plotSectScalars(meanBVals, cpt, "Branch-averaged subsection b-values");
            mapMaker.plot(resourcesDir, prefix + "_ba", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            lines.add("![BA b-values](" + relPathToResources + "/" + prefix + "_ba.png)");
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            CPT rangeCPT = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse().rescale(0.0, 3.0);
            rangeCPT.setNanColor(Color.GRAY);
            table.addLine(MarkdownUtils.boldCentered("Interquartile Range"), MarkdownUtils.boldCentered("Full Range"));
            table.initNewLine();
            mapMaker.plotSectScalars(bValIQR, rangeCPT, "Subsection b-value IQR");
            mapMaker.plot(resourcesDir, prefix + "_iqr", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            table.addColumn("![b-value IQR](" + relPathToResources + "/" + prefix + "_iqr.png)");
            mapMaker.plotSectScalars(bValRange, rangeCPT, "Subsection b-value Range");
            mapMaker.plot(resourcesDir, prefix + "_range", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            table.addColumn("![b-value range](" + relPathToResources + "/" + prefix + "_range.png)");
            table.finalizeLine();
            table.addLine(MarkdownUtils.boldCentered("Minimum"), MarkdownUtils.boldCentered("Maximum"));
            table.initNewLine();
            mapMaker.plotSectScalars(minBVals, cpt, "Subsection minimum b-value");
            mapMaker.plot(resourcesDir, prefix + "_min", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            table.addColumn("![b-value min](" + relPathToResources + "/" + prefix + "_min.png)");
            mapMaker.plotSectScalars(maxBVals, cpt, "Subsection maximum b-value");
            mapMaker.plot(resourcesDir, prefix + "_max", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            table.addColumn("![b-value max](" + relPathToResources + "/" + prefix + "_max.png)");
            table.finalizeLine();
            table.addLine(MarkdownUtils.boldCentered("25 %-ile"), MarkdownUtils.boldCentered("75 %-ile"));
            table.initNewLine();
            mapMaker.plotSectScalars(p25BVals, cpt, "Subsection 25 %-ile b-value");
            mapMaker.plot(resourcesDir, prefix + "_p25", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            table.addColumn("![b-value p25](" + relPathToResources + "/" + prefix + "_p25.png)");
            mapMaker.plotSectScalars(p75BVals, cpt, "Subsection 75 %-ile b-value");
            mapMaker.plot(resourcesDir, prefix + "_p75", SectBValuePlot.getTruncatedTitle(meta.primary.name));
            table.addColumn("![b-value p75](" + relPathToResources + "/" + prefix + "_p75.png)");
            table.finalizeLine();
            lines.addAll(table.build());
        }
        return lines;
    }

    private static void calcParentVals(FaultSystemSolution sol, BValEstimate[] parentBVals, double[] parentRates, Map<Integer, BValEstimate> parentBValsMap) {
        Preconditions.checkState((parentBVals.length == parentBValsMap.size() ? 1 : 0) != 0);
        ArrayList<Integer> parentIDs = new ArrayList<Integer>(parentBValsMap.keySet());
        Collections.sort(parentIDs);
        for (int i = 0; i < parentIDs.size(); ++i) {
            int parentID = (Integer)parentIDs.get(i);
            parentBVals[i] = parentBValsMap.get(parentID);
            if (parentRates == null) continue;
            parentRates[i] = 0.0;
            for (int r : sol.getRupSet().getRupturesForParentSection(parentID)) {
                int n = i;
                parentRates[n] = parentRates[n] + sol.getRateForRup(r);
            }
        }
    }

    public static double[] calcRupMoments(FaultSystemRupSet rupSet) {
        AveSlipModule aveSlips = rupSet.requireModule(AveSlipModule.class);
        double[] ret = new double[rupSet.getNumRuptures()];
        for (int r = 0; r < ret.length; ++r) {
            ret[r] = FaultMomentCalc.getMoment(rupSet.getAreaForRup(r), aveSlips.getAveSlip(r));
        }
        return ret;
    }

    static double calcSectMomentRate(FaultSystemRupSet rupSet, double[] rupMoRates, boolean nucleation, int sectIndex) {
        double sectArea = rupSet.getAreaForSection(sectIndex);
        double ret = 0.0;
        for (int r : rupSet.getRupturesForSection(sectIndex)) {
            if (nucleation) {
                ret += rupMoRates[r] * sectArea / rupSet.getAreaForRup(r);
                continue;
            }
            ret += rupMoRates[r];
        }
        return ret;
    }

    static double[] calcSectMomentRates(FaultSystemRupSet rupSet, double[] rupMoRates, boolean nucleation) {
        double[] ret = new double[rupSet.getNumSections()];
        for (int s = 0; s < ret.length; ++s) {
            ret[s] = SectBValuePlot.calcSectMomentRate(rupSet, rupMoRates, nucleation, s);
        }
        return ret;
    }

    public static BValEstimate[] estSectBValues(FaultSystemSolution sol) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        BValEstimate[] ret = new BValEstimate[rupSet.getNumSections()];
        ModSectMinMags modMinMags = rupSet.getModule(ModSectMinMags.class);
        RupMFDsModule rupMFDs = sol.getModule(RupMFDsModule.class);
        for (int s = 0; s < ret.length; ++s) {
            boolean[] binsAvail = new boolean[refFunc.size()];
            boolean[] binsUsed = new boolean[refFunc.size()];
            SectBValuePlot.calcSectMags(s, sol, modMinMags, rupMFDs, binsAvail, binsUsed);
            IncrementalMagFreqDist sectMFD = sol.calcNucleationMFD_forSect(s, refFunc.getX(0), refFunc.getX(refFunc.size() - 1), refFunc.size());
            ret[s] = SectBValuePlot.estBValue(binsAvail, binsUsed, sectMFD);
        }
        return ret;
    }

    static void calcSectMags(int sectionIndex, FaultSystemSolution sol, ModSectMinMags modMinMags, RupMFDsModule rupMFDs, boolean[] binsAvail, boolean[] binsUsed) {
        List<? extends IncrementalMagFreqDist> targets;
        Preconditions.checkState((refFunc.size() == binsAvail.length ? 1 : 0) != 0);
        Preconditions.checkState((refFunc.size() == binsUsed.length ? 1 : 0) != 0);
        FaultSystemRupSet rupSet = sol.getRupSet();
        IncrementalMagFreqDist target = null;
        if (rupSet.hasModule(InversionTargetMFDs.class) && (targets = rupSet.requireModule(InversionTargetMFDs.class).getOnFaultSupraSeisNucleationMFDs()) != null) {
            target = targets.get(sectionIndex);
        }
        for (int rupIndex : rupSet.getRupturesForSection(sectionIndex)) {
            DiscretizedFunc rupMFD = null;
            if (rupMFDs != null) {
                rupMFD = rupMFDs.getRuptureMFD(rupIndex);
            }
            if (rupMFD == null) {
                rupMFD = new ArbitrarilyDiscretizedFunc();
                rupMFD.set(rupSet.getMagForRup(rupIndex), sol.getRateForRup(rupIndex));
            }
            for (Point2D pt : rupMFD) {
                double mag = pt.getX();
                if (modMinMags != null && modMinMags.isBelowSectMinMag(sectionIndex, mag, refFunc)) continue;
                double rate = pt.getY();
                int magIndex = refFunc.getClosestXIndex(mag);
                if (rate > 0.0) {
                    binsUsed[magIndex] = true;
                }
                if (!(rate > 0.0) && target != null && !SectBValuePlot.targetBinAvail(target, mag)) continue;
                binsAvail[magIndex] = true;
            }
        }
    }

    private static boolean targetBinAvail(IncrementalMagFreqDist target, double mag) {
        double halfDelta = target.getDelta() * 0.5;
        if (mag > target.getMaxX() + halfDelta || mag < target.getMinX() - halfDelta) {
            return false;
        }
        int magIndex = target.getClosestXIndex(mag);
        return target.getY(magIndex) > 0.0;
    }

    public static BValEstimate[] estSectTargetBValues(List<? extends IncrementalMagFreqDist> sectNuclMFDs) {
        BValEstimate[] ret = new BValEstimate[sectNuclMFDs.size()];
        for (int s = 0; s < ret.length; ++s) {
            boolean[] bins = new boolean[refFunc.size()];
            IncrementalMagFreqDist sectMFD = new IncrementalMagFreqDist(refFunc.getMinX(), refFunc.size(), refFunc.getDelta());
            IncrementalMagFreqDist target = sectNuclMFDs.get(s);
            boolean any = false;
            for (Point2D pt : target) {
                if (!(pt.getY() > 0.0)) continue;
                int binIndex = sectMFD.getClosestXIndex(pt.getX());
                sectMFD.add(binIndex, pt.getY());
                bins[binIndex] = true;
                any = true;
            }
            ret[s] = any ? SectBValuePlot.estBValue(bins, bins, sectMFD) : new BValEstimate(0.0, 0.0, 0.0, bins, bins);
        }
        return ret;
    }

    public static Map<Integer, BValEstimate> estParentSectBValues(FaultSystemSolution sol) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        HashMap<Integer, BValEstimate> ret = new HashMap<Integer, BValEstimate>();
        Map<Integer, List<FaultSection>> sectsByParent = rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        ModSectMinMags modMinMags = rupSet.getModule(ModSectMinMags.class);
        RupMFDsModule rupMFDs = sol.getModule(RupMFDsModule.class);
        for (int p : sectsByParent.keySet()) {
            boolean[] binsAvail = new boolean[refFunc.size()];
            boolean[] binsUsed = new boolean[refFunc.size()];
            List<FaultSection> sects = sectsByParent.get(p);
            for (FaultSection sect : sects) {
                int s = sect.getSectionId();
                SectBValuePlot.calcSectMags(s, sol, modMinMags, rupMFDs, binsAvail, binsUsed);
            }
            SummedMagFreqDist parentMFD = sol.calcNucleationMFD_forParentSect(p, refFunc.getMinX(), refFunc.getMaxX(), refFunc.size());
            ret.put(p, SectBValuePlot.estBValue(binsAvail, binsUsed, parentMFD));
        }
        return ret;
    }

    public static Map<Integer, BValEstimate> estParentSectTargetBValues(FaultSystemSolution sol, List<? extends IncrementalMagFreqDist> sectNuclMFDs) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        HashMap<Integer, BValEstimate> ret = new HashMap<Integer, BValEstimate>();
        Map<Integer, List<FaultSection>> sectsByParent = rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        for (int p : sectsByParent.keySet()) {
            boolean[] bins = new boolean[refFunc.size()];
            IncrementalMagFreqDist parentMFD = new IncrementalMagFreqDist(refFunc.getMinX(), refFunc.size(), refFunc.getDelta());
            List<FaultSection> sects = sectsByParent.get(p);
            boolean any = false;
            for (FaultSection sect : sects) {
                int s = sect.getSectionId();
                IncrementalMagFreqDist target = sectNuclMFDs.get(s);
                for (Point2D pt : target) {
                    if (!(pt.getY() > 0.0)) continue;
                    int binIndex = parentMFD.getClosestXIndex(pt.getX());
                    parentMFD.add(binIndex, pt.getY());
                    bins[binIndex] = true;
                    any = true;
                }
            }
            if (any) {
                ret.put(p, SectBValuePlot.estBValue(bins, bins, parentMFD));
                continue;
            }
            ret.put(p, new BValEstimate(0.0, 0.0, 0.0, bins, bins));
        }
        return ret;
    }

    private static double[] toBArray(BValEstimate[] vals) {
        if (vals == null) {
            return null;
        }
        double[] ret = new double[vals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = vals[i].b;
        }
        return ret;
    }

    static BValEstimate estBValue(boolean[] binsAvail, boolean[] binsUsed, IncrementalMagFreqDist nuclMFD) {
        Preconditions.checkState((refFunc.size() == binsAvail.length ? 1 : 0) != 0);
        Preconditions.checkState((refFunc.size() == binsUsed.length ? 1 : 0) != 0);
        int minMagIndex = -1;
        int maxMagIndex = 0;
        for (int i = 0; i < binsAvail.length; ++i) {
            if (!binsAvail[i]) continue;
            if (minMagIndex < 0) {
                minMagIndex = i;
            }
            maxMagIndex = i;
        }
        if (minMagIndex < 0) {
            double nuclRate = nuclMFD.calcSumOfY_Vals();
            Preconditions.checkState((nuclRate == 0.0 ? 1 : 0) != 0, (String)"No bins available but nuclRate=%s", (Object)nuclRate);
            return new BValEstimate(-3.0, 0.0, 0.0, binsAvail, binsUsed);
        }
        double minMag = refFunc.getX(minMagIndex);
        double maxMag = refFunc.getX(maxMagIndex);
        double supraRate = 0.0;
        double moRate = 0.0;
        for (int i = minMagIndex; i <= maxMagIndex; ++i) {
            supraRate += nuclMFD.getY(i);
            moRate += nuclMFD.getMomentRate(i);
        }
        double b = SectBValuePlot.estBValue(minMag, maxMag, supraRate, moRate);
        return new BValEstimate(b, supraRate, moRate, binsAvail, binsUsed);
    }

    public static double estBValue(double minMag, double maxMag, double supraRate, double moRate) {
        Preconditions.checkState((minMag >= refFunc.getMinX() - 0.5 ? 1 : 0) != 0);
        Preconditions.checkState((maxMag <= refFunc.getMaxX() + 0.5 ? 1 : 0) != 0);
        int binnedMinIndex = refFunc.getClosestXIndex(minMag);
        int binnedMaxIndex = refFunc.getClosestXIndex(maxMag);
        if (binnedMinIndex == binnedMaxIndex) {
            return 0.0;
        }
        if (binnedMinIndex > binnedMaxIndex) {
            return Double.NaN;
        }
        Preconditions.checkState((binnedMaxIndex > binnedMinIndex ? 1 : 0) != 0);
        minMag = refFunc.getX(binnedMinIndex);
        maxMag = refFunc.getX(binnedMaxIndex);
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(minMag, 1 + binnedMaxIndex - binnedMinIndex, refFunc.getDelta());
        gr.setAllButBvalue(minMag, maxMag, moRate, supraRate);
        return gr.get_bValue();
    }

    private static List<String> getHistLines(double[] bValues, double[] rates, double[] compBValues, double[] compRates, double[] targetBValues, File outputDir, String relPath, String prefix) throws IOException {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (compBValues == null) {
            table.addLine("b-value Distribution", "b-value Rate-Dependence");
        } else {
            table.addLine("Primary b-value Distribution", "Primary b-value Rate-Dependence");
        }
        File histPlot = SectBValuePlot.histPlot(outputDir, prefix + "_hist", bValues, "b-value", MAIN_COLOR);
        File scatterPlot = SectBValuePlot.rateScatterPlot(outputDir, prefix + "_rate_scatter", bValues, rates, MAIN_COLOR);
        table.addLine("![Histogram](" + relPath + "/" + histPlot.getName() + ")", "![Scatter](" + relPath + "/" + scatterPlot.getName() + ")");
        if (targetBValues != null) {
            SectBValuePlot.compHistLines(bValues, targetBValues, outputDir, relPath, prefix + "_target", table, Color.CYAN.darker(), "Target");
        }
        if (compBValues != null) {
            File cHistPlot = SectBValuePlot.histPlot(outputDir, prefix + "_hist_comp", compBValues, "b-value", COMP_COLOR);
            File cScatterPlot = SectBValuePlot.rateScatterPlot(outputDir, prefix + "_rate_scatter_comp", compBValues, compRates, COMP_COLOR);
            table.addLine(MarkdownUtils.boldCentered("Comparison B-Value Distribution"), MarkdownUtils.boldCentered("Comparison b-value Rate-Dependence"));
            table.addLine("![Histogram](" + relPath + "/" + cHistPlot.getName() + ")", "![Scatter](" + relPath + "/" + cScatterPlot.getName() + ")");
            SectBValuePlot.compHistLines(bValues, compBValues, outputDir, relPath, prefix + "_comp", table, COMMON_COLOR, "Comparison");
        }
        return table.build();
    }

    public static void compHistLines(double[] bValues, double[] compBValues, File outputDir, String relPath, String prefix, MarkdownUtils.TableBuilder table, Color color, String compName) throws IOException {
        double[] diffs = new double[bValues.length];
        for (int i = 0; i < diffs.length; ++i) {
            diffs[i] = bValues[i] - compBValues[i];
        }
        File histDiffPlot = SectBValuePlot.histPlot(outputDir, prefix + "_hist_diff", diffs, "Primary - " + compName + " b-value", color);
        File compScatterPlot = SectBValuePlot.compScatterPlot(outputDir, prefix + "_scatter", bValues, compBValues, color, compName);
        table.addLine(MarkdownUtils.boldCentered(compName + " b-value Difference"), MarkdownUtils.boldCentered(compName + " b-value Scatter"));
        table.addLine("![Histogram](" + relPath + "/" + histDiffPlot.getName() + ")", "![Scatter](" + relPath + "/" + compScatterPlot.getName() + ")");
    }

    private static File histPlot(File outputDir, String prefix, double[] values, String xAxisLabel, Color color) throws IOException {
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(-2.99, 2.99, 0.05);
        for (double value : values) {
            if (!Double.isFinite(value)) continue;
            hist.add(hist.getClosestXIndex(value), 1.0);
        }
        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
        funcs.add(hist);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
        PlotSpec spec = new PlotSpec(funcs, chars, " ", xAxisLabel, "Count");
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        Range xRange = new Range(-3.0, 3.0);
        gp.drawGraphPanel(spec, false, false, xRange, null);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, 650, true, false, false);
        return new File(outputDir, prefix + ".png");
    }

    private static double withinBRange(double val) {
        if (val < -3.0) {
            return -3.0;
        }
        if (val > 3.0) {
            return 3.0;
        }
        return val;
    }

    private static File rateScatterPlot(File outputDir, String prefix, double[] bValues, double[] rates, Color color) throws IOException {
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        for (int i = 0; i < bValues.length; ++i) {
            scatter.set(rates[i], SectBValuePlot.withinBRange(bValues[i]));
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        funcs.add(scatter);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, color));
        PlotSpec spec = new PlotSpec(funcs, chars, " ", "Supra-Seismogenic Rate", "B-Value");
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        Range xRange = new Range(1.0E-6, 1.0);
        Range yRange = new Range(-3.0, 3.0);
        gp.drawGraphPanel(spec, true, false, xRange, yRange);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, 650, true, false, false);
        return new File(outputDir, prefix + ".png");
    }

    private static File compScatterPlot(File outputDir, String prefix, double[] bValues1, double[] bValues2, Color color, String compName) throws IOException {
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        for (int i = 0; i < bValues1.length; ++i) {
            scatter.set(SectBValuePlot.withinBRange(bValues1[i]), SectBValuePlot.withinBRange(bValues2[i]));
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        funcs.add(scatter);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, color));
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(-3.0, -3.0);
        line.set(3.0, 3.0);
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        PlotSpec spec = new PlotSpec(funcs, chars, " ", "Primary B-Value", compName + " B-Value");
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        Range range = new Range(-3.0, 3.0);
        gp.drawGraphPanel(spec, false, false, range, range);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, -1, true, false, false);
        return new File(outputDir, prefix + ".png");
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(AveSlipModule.class);
    }

    private static void writeSectCSV(File outputFile, List<? extends FaultSection> sects, BValEstimate[] bVals, BValEstimate[] bValTargets, BranchSectBVals branchBVals, BranchSectNuclMFDs branchMFDs) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        List<String> header = BValEstimate.tableHeader("sect index", "sect name");
        if (branchBVals != null) {
            header.add("min branch b-value");
            header.add("25 %-ile branch b-value");
            header.add("75 %-ile branch b-value");
            header.add("max branch b-value");
            header.add("mean branch b-value");
        }
        if (branchMFDs != null) {
            header.add("min branch supra-seis event rate");
            header.add("max branch supra-seis event rate");
        }
        if (bValTargets != null) {
            header.add("target MFD b-value");
            header.add("target supra-seis event rate");
            header.add("target supra-seis moment rate");
            if (branchBVals != null && branchBVals.hasTargetBVals()) {
                header.add("min branch target b-value");
                header.add("max branch target b-value");
                header.add("mean branch target b-value");
            }
        }
        csv.addLine(header);
        for (int s = 0; s < sects.size(); ++s) {
            ArbDiscrEmpiricalDistFunc dist;
            FaultSection sect = sects.get(s);
            List<String> line = bVals[s].tableLine("" + s, sect.getName());
            if (branchBVals != null) {
                dist = branchBVals.getSectBValDist(s);
                line.add("" + (float)dist.getMinX());
                line.add("" + (float)dist.getInterpolatedFractile(0.25));
                line.add("" + (float)dist.getInterpolatedFractile(0.75));
                line.add("" + (float)dist.getMaxX());
                line.add("" + (float)dist.getMean());
            }
            if (branchMFDs != null) {
                EvenlyDiscretizedFunc[] cmlMFDs = branchMFDs.calcCumulativeSectFractiles(List.of(Integer.valueOf(s)), 0.0, 1.0);
                line.add("" + (float)cmlMFDs[0].getY(0));
                line.add("" + (float)cmlMFDs[1].getY(0));
            }
            if (bValTargets != null) {
                line.add("" + (float)bValTargets[s].b);
                line.add("" + bValTargets[s].supraRate);
                line.add("" + bValTargets[s].moRate);
                if (branchBVals != null && branchBVals.hasTargetBVals()) {
                    dist = branchBVals.getSectTargetBValDist(s);
                    line.add("" + (float)dist.getMinX());
                    line.add("" + (float)dist.getMaxX());
                    line.add("" + (float)dist.getMean());
                }
            }
            csv.addLine(line);
        }
        csv.writeToFile(outputFile);
    }

    private static void writeParentSectCSV(File outputFile, Map<Integer, String> parentNames, Map<Integer, BValEstimate> bVals, Map<Integer, BValEstimate> bValTargets, List<? extends FaultSection> subSects, BranchSectBVals branchBVals, BranchSectNuclMFDs branchMFDs) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        List<Integer> parentIDs = ComparablePairing.getSortedData(parentNames);
        if (branchBVals != null && !branchBVals.hasParentBVals()) {
            branchBVals = null;
        }
        List<String> header = BValEstimate.tableHeader("parent sect ID", "parent sect name");
        if (branchBVals != null) {
            header.add("min branch b-value");
            header.add("25 %-ile branch b-value");
            header.add("75 %-ile branch b-value");
            header.add("max branch b-value");
            header.add("mean branch b-value");
        }
        if (branchMFDs != null) {
            header.add("min branch supra-seis event rate");
            header.add("max branch supra-seis event rate");
        }
        if (bValTargets != null) {
            header.add("target MFD b-value");
            header.add("target supra-seis event rate");
            header.add("target supra-seis moment rate");
            if (branchBVals != null && branchBVals.hasTargetBVals()) {
                header.add("min branch target b-value");
                header.add("max branch target b-value");
                header.add("mean branch target b-value");
            }
        }
        csv.addLine(header);
        for (int parentID : parentIDs) {
            String name = parentNames.get(parentID);
            List<String> line = bVals.get(parentID).tableLine("" + parentID, name);
            if (branchBVals != null) {
                ArbDiscrEmpiricalDistFunc dist = branchBVals.getParentBValDist(parentID);
                line.add("" + (float)dist.getMinX());
                line.add("" + (float)dist.getInterpolatedFractile(0.25));
                line.add("" + (float)dist.getInterpolatedFractile(0.75));
                line.add("" + (float)dist.getMaxX());
                line.add("" + (float)dist.getMean());
            }
            if (branchMFDs != null) {
                ArrayList<Integer> sectIDs = new ArrayList<Integer>();
                for (FaultSection faultSection : subSects) {
                    if (faultSection.getParentSectionId() != parentID) continue;
                    sectIDs.add(faultSection.getSectionId());
                }
                EvenlyDiscretizedFunc[] cmlMFDs = branchMFDs.calcCumulativeSectFractiles(sectIDs, 0.0, 1.0);
                line.add("" + (float)cmlMFDs[0].getY(0));
                line.add("" + (float)cmlMFDs[1].getY(0));
            }
            if (bValTargets != null) {
                BValEstimate target = bValTargets.get(parentID);
                line.add("" + (float)target.b);
                line.add("" + target.supraRate);
                line.add("" + target.moRate);
                if (branchBVals != null && branchBVals.hasTargetBVals()) {
                    ArbDiscrEmpiricalDistFunc dist = branchBVals.getParentTargetBValDist(parentID);
                    line.add("" + (float)dist.getMinX());
                    line.add("" + (float)dist.getMaxX());
                    line.add("" + (float)dist.getMean());
                }
            }
            csv.addLine(line);
        }
        csv.writeToFile(outputFile);
    }

    public static void main(String[] args) throws IOException {
        File solFile = new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_11_03-reproduce-ucerf3-ref_branch-uniform-nshm23_draft-supra_b_0.8-2h/mean_solution.zip");
        File compSolFile = new File("/home/kevin/OpenSHA/UCERF3/rup_sets/modular/FM3_1_ZENGBB_Shaw09Mod_DsrUni_CharConst_M5Rate7.9_MMaxOff7.6_NoFix_SpatSeisU3.zip");
        File outputDir = new File("/tmp/report");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        FaultSystemSolution sol = FaultSystemSolution.load(solFile);
        FaultSystemSolution compSol = FaultSystemSolution.load(compSolFile);
        ReportMetadata meta = new ReportMetadata(new RupSetMetadata("Primary", sol), new RupSetMetadata("Comparison", compSol));
        ReportPageGen gen = new ReportPageGen(meta, outputDir, List.of(new SectBValuePlot(), new ParticipationRatePlot()));
        gen.setReplot(true);
        gen.generatePage();
    }

    public static class BValEstimate {
        public final double b;
        public final double supraRate;
        public final double moRate;
        public final double minMagBin;
        public final double maxMagBin;
        public final int numBins;
        public final int numBinsAvailable;
        public final int numBinsUsed;

        public BValEstimate(double b, double supraRate, double moRate, boolean[] binsAvail, boolean[] binsUsed) {
            this.b = b;
            this.supraRate = supraRate;
            this.moRate = moRate;
            int minIndex = -1;
            int maxIndex = 0;
            int numBinsAvailable = 0;
            int numBinsUsed = 0;
            for (int i = 0; i < binsAvail.length; ++i) {
                if (!binsAvail[i]) continue;
                ++numBinsAvailable;
                if (minIndex < 0) {
                    minIndex = i;
                }
                maxIndex = i;
                if (!binsUsed[i]) continue;
                ++numBinsUsed;
            }
            this.numBins = 1 + maxIndex - minIndex;
            this.minMagBin = minIndex >= 0 ? refFunc.getX(minIndex) : Double.NaN;
            this.maxMagBin = maxIndex >= 0 ? refFunc.getX(maxIndex) : Double.NaN;
            this.numBinsAvailable = numBinsAvailable;
            this.numBinsUsed = numBinsUsed;
        }

        private static List<String> tableHeader(String ... initialCols) {
            ArrayList<String> line = new ArrayList<String>();
            if (initialCols != null) {
                for (String col : initialCols) {
                    line.add(col);
                }
            }
            line.add("b-value");
            line.add("supra-seis event rate");
            line.add("supra-seis moment rate");
            line.add("min mag (binned)");
            line.add("max mag (binned)");
            line.add("# supra-seis mag bins");
            line.add("# supra-seis mag bins w/ available rupture");
            line.add("# supra-seis mag bins w/ nonzero rate");
            return line;
        }

        private List<String> tableLine(String ... initialCols) {
            ArrayList<String> line = new ArrayList<String>();
            if (initialCols != null) {
                for (String col : initialCols) {
                    line.add(col);
                }
            }
            line.add("" + (float)this.b);
            line.add("" + this.supraRate);
            line.add("" + this.moRate);
            line.add("" + (float)this.minMagBin);
            line.add("" + (float)this.maxMagBin);
            line.add("" + this.numBins);
            line.add("" + this.numBinsAvailable);
            line.add("" + this.numBinsUsed);
            return line;
        }
    }
}

