/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SectionTotalRateConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchParentSectParticMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchSectBVals;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchSectNuclMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchSectParticMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBValuePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SolMFDPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.AnyWithinDistConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ConnectionPointsRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupCartoonGenerator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class SectBySectDetailPlots
extends AbstractRupSetPlot {
    private double maxNeighborDistance;
    private boolean doGeoJSON = false;
    private static PlotCurveCharacterstics highlightChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 5.0f, Color.BLACK);
    private static RupHistogramPlots.HistScalar[] plotScalars = new RupHistogramPlots.HistScalar[]{RupHistogramPlots.HistScalar.MAG, RupHistogramPlots.HistScalar.LENGTH, RupHistogramPlots.HistScalar.CUM_JUMP_DIST};
    private static Range MFD_DEFAULT_Y_RANGE = new Range(1.0E-10, 0.01);
    private static Range MFD_MAX_Y_RANGE = new Range(1.0E-10, 10.0);
    private static double MFD_MAX_Y_RANGE_ORDERS_MAG = 8.0;
    private static final Color TARGET_COLOR = Color.CYAN.darker();
    private static final int boundsAlpha = 60;
    private static final Color targetBoundsColor = new Color(TARGET_COLOR.getRed(), TARGET_COLOR.getGreen(), TARGET_COLOR.getBlue(), 60);
    private static final Color PRIMARY_BOUNDS = new Color(MAIN_COLOR.getRed(), MAIN_COLOR.getGreen(), MAIN_COLOR.getBlue(), 30);
    private static final Color PRIMARY_68_OVERLAY = new Color(MAIN_COLOR.getRed(), MAIN_COLOR.getGreen(), MAIN_COLOR.getBlue(), 30);
    private static final Color PRIMARY_68_STANDALONE = new Color(MAIN_COLOR.getRed(), MAIN_COLOR.getGreen(), MAIN_COLOR.getBlue(), 60);
    private static final float primaryThickness = 3.0f;
    private static final float compThickness = 2.0f;

    public SectBySectDetailPlots() {
        this(Double.NaN);
    }

    public SectBySectDetailPlots(double maxNeighborDistance) {
        this.maxNeighborDistance = maxNeighborDistance;
    }

    @Override
    public String getName() {
        return "Parent Section Detail Pages";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        SectionDistanceAzimuthCalculator distAzCalc = rupSet.getModule(SectionDistanceAzimuthCalculator.class);
        if (distAzCalc == null) {
            distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
            rupSet.addModule(distAzCalc);
        }
        if (Double.isNaN(this.maxNeighborDistance)) {
            PlausibilityConfiguration config = rupSet.getModule(PlausibilityConfiguration.class);
            if (config == null || config.getConnectionStrategy() == null) {
                System.out.println(this.getName() + ": WARNING, no maximum jump distance specified & no connection strategy. Will include everything up to 20 km.");
                this.maxNeighborDistance = 20.0;
            } else {
                this.maxNeighborDistance = config.getConnectionStrategy().getMaxJumpDist();
            }
        }
        if (!rupSet.hasModule(ClusterRuptures.class)) {
            rupSet.addModule(ClusterRuptures.singleStranged(rupSet));
        }
        if (meta.comparisonHasSameSects && !meta.comparison.rupSet.hasModule(ClusterRuptures.class)) {
            meta.comparison.rupSet.addModule(ClusterRuptures.singleStranged(meta.comparison.rupSet));
        }
        Map<Integer, List<FaultSection>> sectsByParent = rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        File parentsDir = new File(resourcesDir.getParentFile(), "parent_sect_pages");
        Preconditions.checkState((parentsDir.exists() || parentsDir.mkdir() ? 1 : 0) != 0);
        ArrayList<RupHistogramPlots.HistScalarValues> scalarVals = new ArrayList<RupHistogramPlots.HistScalarValues>();
        List<ClusterRupture> cRups = rupSet.requireModule(ClusterRuptures.class).getAll();
        for (RupHistogramPlots.HistScalar scalar : plotScalars) {
            scalarVals.add(new RupHistogramPlots.HistScalarValues(scalar, rupSet, sol, cRups, distAzCalc));
        }
        HashMap<String, SectPageCallable> linkCallsMap = new HashMap<String, SectPageCallable>();
        for (int parentID : sectsByParent.keySet()) {
            String parentName = sectsByParent.get(parentID).get(0).getParentSectionName();
            linkCallsMap.put(parentName, new SectPageCallable(meta, parentID, parentName, parentsDir, distAzCalc, sectsByParent, scalarVals));
        }
        HashMap<String, String> linksMap = new HashMap<String, String>();
        int threads = this.getNumThreads();
        if (threads > 1) {
            ExecutorService exec = Executors.newFixedThreadPool(threads);
            HashMap futures = new HashMap();
            for (String parentName : linkCallsMap.keySet()) {
                futures.put(parentName, exec.submit((Callable)linkCallsMap.get(parentName)));
            }
            for (String parentName : futures.keySet()) {
                String link;
                try {
                    String subDirName = (String)((Future)futures.get(parentName)).get();
                    link = relPathToResources + "/../" + parentsDir.getName() + "/" + subDirName;
                }
                catch (RuntimeException | ExecutionException e) {
                    System.err.println("Error processing SectBySectDetailPlots plot for parent fault: " + parentName);
                    e.printStackTrace();
                    link = null;
                    System.err.flush();
                }
                catch (InterruptedException e) {
                    try {
                        exec.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionUtils.asRuntimeException(e);
                }
                linksMap.put(parentName, link);
            }
            exec.shutdown();
        } else {
            for (String parentName : linkCallsMap.keySet()) {
                String link;
                try {
                    String subDirName = (String)((Callable)linkCallsMap.get(parentName)).call();
                    link = relPathToResources + "/../" + parentsDir.getName() + "/" + subDirName;
                }
                catch (RuntimeException e) {
                    System.err.println("Error processing SectBySectDetailPlots plot for parent fault: " + parentName);
                    e.printStackTrace();
                    link = null;
                    System.err.flush();
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                linksMap.put(parentName, link);
            }
        }
        ArrayList<String> sortedNames = new ArrayList<String>(linksMap.keySet());
        Collections.sort(sortedNames);
        MarkdownUtils.TableBuilder table = SectBySectDetailPlots.buildSectLinksTable(linksMap, sortedNames, "Fault Section");
        ArrayList<String> lines = new ArrayList<String>();
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, meta.region){

            @Override
            protected Feature surfFeature(FaultSection sect, PlotCurveCharacterstics pChar) {
                return this.featureLink(super.surfFeature(sect, pChar), sect);
            }

            @Override
            protected Feature traceFeature(FaultSection sect, PlotCurveCharacterstics pChar) {
                return this.featureLink(super.traceFeature(sect, pChar), sect);
            }

            private Feature featureLink(Feature feature, FaultSection sect) {
                feature.properties.set("name", sect.getParentSectionName());
                feature.properties.set("id", sect.getParentSectionId());
                feature.properties.set("subSectID", sect.getSectionId());
                return feature;
            }
        };
        mapMaker.setWriteGeoJSON(true);
        mapMaker.setRegion(meta.region);
        mapMaker.setWritePDFs(false);
        ArrayList<Color> sectColors = new ArrayList<Color>();
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            sectColors.add(null);
        }
        Random rand = new Random(rupSet.getNumSections() * sectsByParent.size());
        ArrayList<Integer> sortedIDs = new ArrayList<Integer>(sectsByParent.keySet());
        Collections.sort(sortedIDs);
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
        Iterator iterator = sortedIDs.iterator();
        while (iterator.hasNext()) {
            int parentID = (Integer)iterator.next();
            List<FaultSection> sects = sectsByParent.get(parentID);
            Color color = cpt.getColor(rand.nextFloat());
            for (FaultSection sect : sects) {
                sectColors.set(sect.getSectionId(), color);
            }
        }
        mapMaker.plotSectColors(sectColors);
        mapMaker.plot(resourcesDir, "parent_sections", "Parent Fault Sections");
        lines.add("This section includes links to pages with plots for specific parent fault sections.");
        lines.add("");
        lines.add("Clickable GeoJSON map to identify fault section names (each parent section is plotted in a random color): " + RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/parent_sections.geojson") + " [Download GeoJSON](" + relPathToResources + "/parent_sections.geojson)");
        lines.add("");
        lines.addAll(table.build());
        return lines;
    }

    public void plotSingleParent(File outputDir, ReportMetadata meta, int parentID) throws IOException {
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        FaultSystemSolution sol = meta.primary.sol;
        SectionDistanceAzimuthCalculator distAzCalc = rupSet.getModule(SectionDistanceAzimuthCalculator.class);
        if (distAzCalc == null) {
            distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
            rupSet.addModule(distAzCalc);
        }
        if (Double.isNaN(this.maxNeighborDistance)) {
            PlausibilityConfiguration config = rupSet.getModule(PlausibilityConfiguration.class);
            if (config == null || config.getConnectionStrategy() == null) {
                System.out.println(this.getName() + ": WARNING, no maximum jump distance specified & no connection strategy. Will include everything up to 20 km.");
                this.maxNeighborDistance = 20.0;
            } else {
                this.maxNeighborDistance = config.getConnectionStrategy().getMaxJumpDist();
            }
        }
        if (!rupSet.hasModule(ClusterRuptures.class)) {
            rupSet.addModule(ClusterRuptures.singleStranged(rupSet));
        }
        if (meta.comparisonHasSameSects && !meta.comparison.rupSet.hasModule(ClusterRuptures.class)) {
            meta.comparison.rupSet.addModule(ClusterRuptures.singleStranged(meta.comparison.rupSet));
        }
        Map<Integer, List<FaultSection>> sectsByParent = rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        Preconditions.checkState((boolean)sectsByParent.containsKey(parentID));
        String parentName = sectsByParent.get(parentID).get(0).getParentSectionName();
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        ArrayList<RupHistogramPlots.HistScalarValues> scalarVals = new ArrayList<RupHistogramPlots.HistScalarValues>();
        List<ClusterRupture> cRups = rupSet.requireModule(ClusterRuptures.class).getAll();
        for (RupHistogramPlots.HistScalar scalar : plotScalars) {
            scalarVals.add(new RupHistogramPlots.HistScalarValues(scalar, rupSet, sol, cRups, distAzCalc));
        }
        this.buildSectionPage(meta, parentID, parentName, outputDir, distAzCalc, sectsByParent, scalarVals);
    }

    static MarkdownUtils.TableBuilder buildSectLinksTable(Map<String, String> linksMap, List<String> sortedNames, String header) {
        return SectBySectDetailPlots.buildSectLinksTable(linksMap, sortedNames, null, header);
    }

    static MarkdownUtils.TableBuilder buildSectLinksTable(Map<String, String> linksMap, List<String> sortedNames, Map<String, Boolean> highlights, String header) {
        int cols = sortedNames.size() > 30 ? 3 : (sortedNames.size() > 15 ? 2 : 1);
        int rows = (int)Math.ceil((double)sortedNames.size() / (double)cols);
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        for (int c = 0; c < cols; ++c) {
            table.addColumn("Fault Section");
        }
        table.finalizeLine();
        for (int row = 0; row < rows; ++row) {
            table.initNewLine();
            for (int col = 0; col < cols; ++col) {
                int index = rows * col + row;
                if (index >= sortedNames.size()) {
                    table.addColumn("");
                    continue;
                }
                String name = sortedNames.get(index);
                String link = linksMap.get(name);
                if (link == null) {
                    table.addColumn("_" + name + "_");
                    continue;
                }
                if (highlights != null && highlights.get(name).booleanValue()) {
                    table.addColumn("[**" + name + "**](" + linksMap.get(name) + ")");
                    continue;
                }
                table.addColumn("[" + name + "](" + linksMap.get(name) + ")");
            }
            table.finalizeLine();
        }
        return table;
    }

    private String buildSectionPage(ReportMetadata meta, int parentSectIndex, String parentName, File parentsDir, SectionDistanceAzimuthCalculator distAzCalc, Map<Integer, List<FaultSection>> sectsByParent, List<RupHistogramPlots.HistScalarValues> scalarVals) throws IOException {
        System.out.println("Building page for: " + parentName);
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        String dirName = SectBySectDetailPlots.getFileSafe(parentName);
        File parentDir = new File(parentsDir, dirName);
        Preconditions.checkState((parentDir.exists() || parentDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(parentDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# " + parentName + " Details");
        lines.add("");
        List<Integer> allRups = rupSet.getRupturesForParentSection(parentSectIndex);
        if (allRups == null || allRups.isEmpty()) {
            lines.add("No Ruptures on " + parentName);
            MarkdownUtils.writeReadmeAndHTML(lines, parentDir);
            return dirName;
        }
        List<FaultSection> parentSects = sectsByParent.get(parentSectIndex);
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = Double.NEGATIVE_INFINITY;
        double minLen = Double.POSITIVE_INFINITY;
        double maxLen = Double.NEGATIVE_INFINITY;
        boolean hasMultiFault = false;
        double minSingleFaultMag = Double.POSITIVE_INFINITY;
        double maxSingleFaultMag = Double.NEGATIVE_INFINITY;
        double minNonzeroRateMag = Double.POSITIVE_INFINITY;
        double maxNonzeroRateMag = Double.NEGATIVE_INFINITY;
        HashSet<Integer> directConnections = new HashSet<Integer>();
        HashSet<Integer> allConnections = new HashSet<Integer>();
        double totRate = 0.0;
        double multiRate = 0.0;
        int rupCount = 0;
        ModSectMinMags minMags = meta.primary.rupSet.getModule(ModSectMinMags.class);
        double maxMin = minMags == null ? 0.0 : StatUtils.max((double[])minMags.getMinMagForSections());
        int rupCountNonZero = 0;
        int rupCountBelowMin = 0;
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        for (int r : allRups) {
            ++rupCount;
            double mag = rupSet.getMagForRup(r);
            minMag = Math.min(minMag, mag);
            maxMag = Math.max(maxMag, mag);
            double len = rupSet.getLengthForRup(r) * 0.001;
            minLen = Math.min(minLen, len);
            maxLen = Math.max(maxLen, len);
            ClusterRupture rup = cRups.get(r);
            if (rup.getTotalNumClusters() > 1) {
                hasMultiFault = true;
            } else {
                minSingleFaultMag = Math.min(minSingleFaultMag, mag);
                maxSingleFaultMag = Math.max(maxSingleFaultMag, mag);
            }
            if (meta.primary.sol != null) {
                double rate = meta.primary.sol.getRateForRup(r);
                totRate += rate;
                if (rup.getTotalNumClusters() > 1) {
                    multiRate += rate;
                }
                if (rate > 0.0) {
                    ++rupCountNonZero;
                    minNonzeroRateMag = Math.min(minNonzeroRateMag, mag);
                    maxNonzeroRateMag = Math.max(maxNonzeroRateMag, mag);
                }
            }
            if (minMags != null && mag < maxMin) {
                boolean below = false;
                Iterator<Comparable<Integer>> iterator = rupSet.getSectionsIndicesForRup(r).iterator();
                while (iterator.hasNext()) {
                    int s = (Integer)iterator.next();
                    if (!(mag < minMags.getMinMagForSection(s))) continue;
                    below = true;
                    break;
                }
                if (below) {
                    ++rupCountBelowMin;
                }
            }
            if (rup.getTotalNumClusters() <= 1) continue;
            RuptureTreeNavigator nav = rup.getTreeNavigator();
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                if (cluster.parentSectionID == parentSectIndex) {
                    FaultSubsectionCluster predecessor = nav.getPredecessor(cluster);
                    if (predecessor != null) {
                        directConnections.add(predecessor.parentSectionID);
                    }
                    for (FaultSubsectionCluster descendant : nav.getDescendants(cluster)) {
                        directConnections.add(descendant.parentSectionID);
                    }
                    continue;
                }
                allConnections.add(cluster.parentSectionID);
            }
        }
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("_Property_", "_Value_");
        table.addLine("**Rupture Count**", countDF.format(rupCount));
        if (minMags != null) {
            table.addLine("**Ruptures Above Sect Min Mag**", countDF.format(rupCount - rupCountBelowMin));
        }
        if (meta.primary.sol != null) {
            table.addLine("**Ruptures w/ Nonzero Rates**", countDF.format(rupCountNonZero));
        }
        table.addLine("**Magnitude Range**", "[" + twoDigits.format(minMag) + ", " + twoDigits.format(maxMag) + "]");
        if (hasMultiFault) {
            table.addLine("**Single-Fault Magnitude Range**", "[" + twoDigits.format(minSingleFaultMag) + ", " + twoDigits.format(maxSingleFaultMag) + "]");
        }
        if (meta.primary.sol != null) {
            table.addLine("**Magnitude Range w/ Nonzero Rates**", "[" + twoDigits.format(minNonzeroRateMag) + ", " + twoDigits.format(maxNonzeroRateMag) + "]");
        }
        table.addLine("**Length Range**", "[" + countDF.format(minLen) + ", " + countDF.format(maxLen) + "] km");
        if (meta.primary.sol != null) {
            table.addLine("**Total Rate**", (float)totRate + " /yr");
            table.addLine("**Multi-Fault Rate**", (float)multiRate + " /yr (" + percentDF.format(multiRate / totRate) + ")");
        }
        table.addLine("**Directly-Connected Faults**", countDF.format(directConnections.size()));
        table.addLine("**All Co-Rupturing Faults**", countDF.format(allConnections.size()));
        lines.addAll(table.build());
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "_[(top)](#table-of-contents)_";
        if (meta.primary.sol != null) {
            lines.add("");
            lines.addAll(SectBySectDetailPlots.getMFDLines(meta, parentName, parentSects, resourcesDir, topLink));
            lines.add("");
            lines.addAll(SectBySectDetailPlots.getAlongStrikeLines(meta, parentName, parentSects, resourcesDir, topLink));
            lines.add("");
            lines.addAll(SectBySectDetailPlots.getLengthLines(meta, parentName, parentSects, resourcesDir, topLink));
            lines.add("");
            lines.addAll(SectBySectDetailPlots.getRateWeightedLengthExampleLines(meta, parentName, parentSects, resourcesDir, topLink));
        } else {
            lines.add("");
            lines.addAll(this.getScalarLines(meta, parentSectIndex, parentName, parentSects, rupSet, resourcesDir, topLink, scalarVals));
        }
        lines.add("");
        lines.addAll(this.getConnectivityLines(meta, parentSectIndex, parentName, distAzCalc, sectsByParent, rupSet, resourcesDir, topLink));
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 3));
        lines.add(tocIndex, "## Table Of Contents");
        MarkdownUtils.writeReadmeAndHTML(lines, parentDir);
        return dirName;
    }

    private List<String> getScalarLines(ReportMetadata meta, int parentSectIndex, String parentName, List<? extends FaultSection> parentSects, FaultSystemRupSet rupSet, File outputDir, String topLink, List<RupHistogramPlots.HistScalarValues> scalars) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Scalar Histograms & Example Ruptures");
        lines.add(topLink);
        lines.add("");
        HashSet<Integer> sectRups = new HashSet<Integer>(rupSet.getRupturesForParentSection(parentSectIndex));
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        for (RupHistogramPlots.HistScalarValues scalarVals : scalars) {
            RupHistogramPlots.HistScalar scalar = scalarVals.getScalar();
            lines.add("### " + scalar.getName());
            lines.add(topLink);
            lines.add("");
            String prefix = "hist_" + scalar.name();
            RupHistogramPlots.plotRuptureHistogram(outputDir, prefix, scalarVals, sectRups, null, null, MAIN_COLOR, false, false);
            lines.add("![" + scalar.getName() + " plot](" + outputDir.getName() + "/" + prefix + ".png)");
            lines.add("");
            double[] fractiles = scalar.getExampleRupPlotFractiles();
            if (fractiles == null || fractiles.length <= 0) continue;
            ArrayList<Integer> filteredIndexes = new ArrayList<Integer>();
            ArrayList<Double> filteredVals = new ArrayList<Double>();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                if (!sectRups.contains(r)) continue;
                filteredIndexes.add(r);
                filteredVals.add(scalarVals.getValue(r));
            }
            List sortedIndexes = ComparablePairing.getSortedData(filteredVals, filteredIndexes);
            int[] fractileIndexes = new int[fractiles.length];
            for (int j = 0; j < fractiles.length; ++j) {
                double f = fractiles[j];
                fractileIndexes[j] = f == 1.0 ? filteredIndexes.size() - 1 : (int)(f * (double)filteredIndexes.size());
            }
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            for (int j = 0; j < fractiles.length; ++j) {
                int index = (Integer)sortedIndexes.get(fractileIndexes[j]);
                double val = scalarVals.getValue(index);
                double f = fractiles[j];
                Object str = f == 0.0 ? "Minimum" : (f == 1.0 ? "Maximum" : "p" + new DecimalFormat("0.#").format(f * 100.0));
                str = (String)str + ": ";
                str = val < 0.1 ? (String)str + (float)val : (String)str + new DecimalFormat("0.##").format(val);
                table.addColumn("**" + (String)str + "**");
            }
            table.finalizeLine();
            table.initNewLine();
            for (int rawIndex : fractileIndexes) {
                int index = (Integer)sortedIndexes.get(rawIndex);
                String rupPrefix = "rupture_" + index;
                ClusterRupture rup = cRups.get(index);
                PlotSpec spec = RupCartoonGenerator.buildRupturePlot(rup, "Rupture " + index, false, true, new HashSet<FaultSection>(parentSects), Color.GREEN.darker().darker(), parentName);
                RupCartoonGenerator.plotRupture(outputDir, rupPrefix, spec, true);
                table.addColumn("![Rupture " + index + "](" + outputDir.getName() + "/" + rupPrefix + ".png)");
            }
            lines.addAll(table.wrap(4, 0).build());
            lines.add("");
        }
        return lines;
    }

    static List<String> getLengthLines(ReportMetadata meta, String faultName, List<FaultSection> faultSects, File outputDir, String topLink) throws IOException {
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        FaultSystemSolution sol = meta.primary.sol;
        double[] rupLengths = rupSet.getLengthForAllRups();
        if (rupLengths == null) {
            return new ArrayList<String>();
        }
        HashSet<Integer> rupIndexes = new HashSet<Integer>();
        for (FaultSection faultSection : faultSects) {
            rupIndexes.addAll(rupSet.getRupturesForSection(faultSection.getSectionId()));
        }
        if (rupIndexes.isEmpty()) {
            return new ArrayList<String>();
        }
        boolean anyRate = false;
        Iterator iterator = rupIndexes.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            if (!(sol.getRateForRup(rupIndex) > 0.0)) continue;
            anyRate = true;
            break;
        }
        if (!anyRate) {
            return new ArrayList<String>();
        }
        DataUtils.MinMaxAveTracker minMaxAveTracker = new DataUtils.MinMaxAveTracker();
        Iterator rupIndex = rupIndexes.iterator();
        while (rupIndex.hasNext()) {
            int rupIndex2 = (Integer)rupIndex.next();
            minMaxAveTracker.addValue(rupLengths[rupIndex2] * 0.001);
        }
        HistogramFunction countHist = RupHistogramPlots.HistScalar.LENGTH.getHistogram(minMaxAveTracker);
        HistogramFunction rateHist = RupHistogramPlots.HistScalar.LENGTH.getHistogram(minMaxAveTracker);
        Iterator iterator2 = rupIndexes.iterator();
        while (iterator2.hasNext()) {
            int rupIndex3 = (Integer)iterator2.next();
            int index = countHist.getClosestXIndex(rupLengths[rupIndex3] * 0.001);
            countHist.add(index, 1.0);
            rateHist.add(index, sol.getRateForRup(rupIndex3));
        }
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        ArrayList<Range> yRanges = new ArrayList<Range>();
        ArrayList<Boolean> yLogs = new ArrayList<Boolean>();
        Range xRange = null;
        Color color = MAIN_COLOR;
        for (int p = 0; p < 3; ++p) {
            Range yRange;
            boolean rateWeighted;
            boolean logY;
            HistogramFunction hist;
            if (p == 0) {
                hist = countHist;
                logY = false;
                rateWeighted = false;
            } else if (p == 1) {
                hist = rateHist;
                logY = false;
                rateWeighted = true;
            } else {
                hist = rateHist;
                logY = true;
                rateWeighted = true;
            }
            ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(hist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
            String title = "Rupture Length Histogram";
            String xAxisLabel = "Length (km)";
            String yAxisLabel = rateWeighted ? "Annual Rate" : "Count";
            PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
            if (xRange == null) {
                xRange = new Range(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
            }
            if (logY) {
                double minY = Double.POSITIVE_INFINITY;
                double maxY = 0.0;
                for (DiscretizedFunc discretizedFunc : funcs) {
                    for (Point2D pt : discretizedFunc) {
                        double y = pt.getY();
                        if (!(y > 0.0)) continue;
                        minY = Math.min(minY, y);
                        maxY = Math.max(maxY, y);
                    }
                }
                yRange = new Range(Math.pow(10.0, Math.floor(Math.log10(minY))), Math.pow(10.0, Math.ceil(Math.log10(maxY))));
            } else {
                double maxY = hist.getMaxY();
                yRange = new Range(0.0, 1.05 * maxY);
            }
            specs.add(spec);
            yRanges.add(yRange);
            yLogs.add(logY);
        }
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(specs, List.of(Boolean.valueOf(false)), yLogs, List.of(xRange), yRanges);
        gp.getChartPanel().setSize(800, 1200);
        File pngFile = new File(outputDir, "length_hist.png");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Length Distributions");
        lines.add(topLink);
        lines.add("");
        lines.add("Fault rupture length distributions. The top panel shows the raw count of ruptures in which _" + faultName + "_ participates in the rupture set as a function of rupture length. The bottom two panels show the rate-weighted distribution (i.e., the distribution of lengths in the solution). The middle panel is plotted with a linear scale, and the bottom paney a logarithmic scale.");
        lines.add("");
        lines.add("![Length Hist](" + outputDir.getName() + "/" + pngFile.getName() + ")");
        return lines;
    }

    static List<String> getRateWeightedLengthExampleLines(ReportMetadata meta, String faultName, List<FaultSection> faultSects, File outputDir, String topLink) throws IOException {
        double[] fractiles = new double[]{0.5, 0.75, 0.9, 0.975, 0.99, 1.0};
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        FaultSystemSolution sol = meta.primary.sol;
        double[] rupLengths = rupSet.getLengthForAllRups();
        ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
        if (rupLengths == null || cRups == null) {
            return new ArrayList<String>();
        }
        HashSet<Integer> rupIndexes = new HashSet<Integer>();
        for (FaultSection faultSection : faultSects) {
            for (int rupIndex : rupSet.getRupturesForSection(faultSection.getSectionId())) {
                if (!(sol.getRateForRup(rupIndex) > 0.0)) continue;
                rupIndexes.add(rupIndex);
            }
        }
        boolean hasMultiFault = false;
        Iterator iterator = rupIndexes.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            Integer commonParent = null;
            for (FaultSection sect3 : rupSet.getFaultSectionDataForRupture(rupIndex)) {
                if (commonParent == null) {
                    commonParent = sect3.getParentSectionId();
                    continue;
                }
                if (commonParent.intValue() == sect3.getParentSectionId()) continue;
                hasMultiFault = true;
                break;
            }
            if (!hasMultiFault) continue;
            break;
        }
        if (!hasMultiFault) {
            return new ArrayList<String>();
        }
        ArbDiscrEmpiricalDistFunc arbDiscrEmpiricalDistFunc = new ArbDiscrEmpiricalDistFunc();
        Iterator rupIndex = rupIndexes.iterator();
        while (rupIndex.hasNext()) {
            int rupIndex2 = (Integer)rupIndex.next();
            arbDiscrEmpiricalDistFunc.set(rupLengths[rupIndex2], sol.getRateForRup(rupIndex2));
        }
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        for (int f = 0; f < fractiles.length; ++f) {
            table.addColumn(MarkdownUtils.boldCentered("p" + optionalDigitDF.format(fractiles[f] * 100.0) + " Example"));
        }
        table.finalizeLine();
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, meta.region);
        mapMaker.setWriteGeoJSON(false);
        mapMaker.setWritePDFs(false);
        table.initNewLine();
        HashSet<Integer> writtenRups = new HashSet<Integer>();
        for (int f = 0; f < fractiles.length; ++f) {
            double targetLen = arbDiscrEmpiricalDistFunc.getInterpolatedFractile(fractiles[f]);
            double closestDiff = Double.POSITIVE_INFINITY;
            int closestIndex = -1;
            Iterator iterator2 = rupIndexes.iterator();
            while (iterator2.hasNext()) {
                int rupIndex3 = (Integer)iterator2.next();
                double len = rupLengths[rupIndex3];
                double diff = Math.abs(len - targetLen);
                if (!(diff < closestDiff)) continue;
                closestDiff = diff;
                closestIndex = rupIndex3;
            }
            int rupIndex4 = closestIndex;
            String rupPrefix = "rupture_" + rupIndex4;
            if (!writtenRups.contains(rupIndex4)) {
                DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
                DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
                List<FaultSection> rupSects = rupSet.getFaultSectionDataForRupture(rupIndex4);
                for (FaultSection sect4 : rupSects) {
                    LocationList locs = sect4.getAveDip() == 90.0 ? sect4.getFaultTrace() : sect4.getFaultSurface(1.0).getEvenlyDiscritizedPerimeter();
                    for (Location loc : locs) {
                        latTrack.addValue(loc.getLatitude());
                        lonTrack.addValue(loc.getLongitude());
                    }
                }
                double minLon = lonTrack.getMin();
                double maxLon = lonTrack.getMax();
                double minLat = latTrack.getMin();
                double maxLat = latTrack.getMax();
                Region region = new Region(new Location(minLat -= 0.05, minLon -= 0.05), new Location(maxLat += 0.05, maxLon += 0.05));
                mapMaker.setRegion(region);
                mapMaker.setSectHighlights(rupSects, highlightChar);
                double length = rupLengths[rupIndex4] * 0.001;
                String title = "Rupture " + rupIndex4 + ", M" + optionalDigitDF.format(rupSet.getMagForRup(rupIndex4)) + ", " + optionalDigitDF.format(length) + " km, rate=" + expProbDF.format(sol.getRateForRup(rupIndex4));
                mapMaker.plot(outputDir, rupPrefix, title);
                writtenRups.add(rupIndex4);
            }
            table.addColumn("![Rupture " + rupIndex4 + "](" + outputDir.getName() + "/" + rupPrefix + ".png)");
        }
        table.finalizeLine();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Rupture Examples");
        lines.add(topLink);
        lines.add("");
        lines.add("The following table includes example ruptures, selected at various percentiles from the rate-weighted rupture length distribution. So, for example, the rupture with length closest to the median length (again, rate-weighted) is plotted in the first column ('p50 Example'). The longest participating rupture is plotted last ('p100 Example').");
        lines.add("");
        lines.add("It is important to note that the rupture examples here may not be representative, and may have negligible rates. They are included for illustration purposes only.");
        lines.add("");
        lines.addAll(table.wrap(4, 0).build());
        return lines;
    }

    private List<String> getConnectivityLines(ReportMetadata meta, int parentSectIndex, String parentName, SectionDistanceAzimuthCalculator distAzCalc, Map<Integer, List<FaultSection>> sectsByParent, FaultSystemRupSet rupSet, File outputDir, String topLink) throws IOException {
        Object logValTrack;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Connectivity");
        lines.add(topLink);
        lines.add("");
        List<FaultSection> mySects = sectsByParent.get(parentSectIndex);
        ArrayList<Integer> parentsIDsToConsider = new ArrayList<Integer>();
        HashMap<Integer, Double> matchMinDists = new HashMap<Integer, Double>();
        for (int parentID : sectsByParent.keySet()) {
            if (parentID == parentSectIndex) continue;
            double minDist = Double.POSITIVE_INFINITY;
            for (FaultSection s1 : sectsByParent.get(parentID)) {
                for (FaultSection s2 : mySects) {
                    minDist = Double.min(minDist, distAzCalc.getDistance(s1, s2));
                }
            }
            if (!(minDist <= this.maxNeighborDistance)) continue;
            parentsIDsToConsider.add(parentID);
            matchMinDists.put(parentID, minDist);
        }
        ClusterRuptures clusterRups = rupSet.requireModule(ClusterRuptures.class);
        RupConnectionsData rupData = new RupConnectionsData(parentSectIndex, clusterRups, rupSet, meta.primary.sol);
        RupConnectionsData compRupData = null;
        if (meta.comparisonHasSameSects) {
            compRupData = new RupConnectionsData(parentSectIndex, meta.comparison.rupSet.requireModule(ClusterRuptures.class), meta.comparison.rupSet, meta.comparison.sol);
        }
        HashSet<FaultSection> plotSectsSet = new HashSet<FaultSection>();
        plotSectsSet.addAll(mySects);
        Iterator<Object> iterator = parentsIDsToConsider.iterator();
        while (iterator.hasNext()) {
            int parentID = (Integer)((Object)iterator.next());
            plotSectsSet.addAll((Collection)sectsByParent.get(parentID));
        }
        iterator = rupData.sectCoruptureCounts.keySet().iterator();
        while (iterator.hasNext()) {
            int sectID = (Integer)iterator.next();
            plotSectsSet.add(rupSet.getFaultSectionData(sectID));
        }
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        for (FaultSection plotSect : plotSectsSet) {
            LocationList perim;
            RuptureSurface surf = plotSect.getFaultSurface(5.0);
            try {
                perim = surf.getPerimeter();
            }
            catch (RuntimeException e) {
                perim = surf.getEvenlyDiscritizedPerimeter();
            }
            for (Object loc : perim) {
                latTrack.addValue(((Location)loc).lat);
                lonTrack.addValue(((Location)loc).lon);
            }
        }
        if (this.maxNeighborDistance > 0.0 && this.maxNeighborDistance < 500.0) {
            for (FaultSection sect : mySects) {
                LocationList traceBuffer;
                try {
                    traceBuffer = new Region((LocationList)sect.getFaultTrace(), this.maxNeighborDistance).getBorder();
                }
                catch (RuntimeException e) {
                    traceBuffer = new Region(LocationList.of(sect.getFaultTrace().first(), sect.getFaultTrace().last()), this.maxNeighborDistance).getBorder();
                }
                for (Location loc : traceBuffer) {
                    latTrack.addValue(loc.lat);
                    lonTrack.addValue(loc.lon);
                }
            }
        }
        Region plotRegion = new Region(new Location(latTrack.getMin() - 0.1, lonTrack.getMin() - 0.1), new Location(latTrack.getMax() + 0.1, lonTrack.getMax() + 0.1));
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, meta.region);
        mapMaker.setWriteGeoJSON(this.doGeoJSON);
        mapMaker.setRegion(plotRegion);
        mapMaker.setWritePDFs(false);
        mapMaker.setSkipNaNs(true);
        mapMaker.setSectHighlights(mySects, highlightChar);
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        ArrayList<String> jsonLinks = this.doGeoJSON ? new ArrayList<String>() : null;
        boolean[] isPlotRates = rupData.sectCoruptureRates == null ? new boolean[]{false} : new boolean[]{true};
        for (Object rate : (Object)isPlotRates) {
            String prefix;
            String label;
            double max;
            double min;
            Map<Integer, Number> valsMap;
            Map<Integer, Number> map = valsMap = rate != false ? rupData.sectCoruptureRates : rupData.sectCoruptureCounts;
            if (valsMap == null) continue;
            double[] scalars = new double[rupSet.getNumSections()];
            logValTrack = new DataUtils.MinMaxAveTracker();
            for (int s = 0; s < scalars.length; ++s) {
                if (valsMap.containsKey(s) && valsMap.get(s).doubleValue() > 0.0) {
                    double logVal = Math.log10(valsMap.get(s).doubleValue());
                    ((DataUtils.MinMaxAveTracker)logValTrack).addValue(logVal);
                    scalars[s] = logVal;
                    continue;
                }
                scalars[s] = Double.NaN;
            }
            if (rate != false) {
                if (((DataUtils.MinMaxAveTracker)logValTrack).getNum() == 0) {
                    min = -6.0;
                    max = -1.0;
                } else {
                    max = Math.ceil(((DataUtils.MinMaxAveTracker)logValTrack).getMax());
                    min = Math.floor(((DataUtils.MinMaxAveTracker)logValTrack).getMin());
                    min = Math.max(min, max - 5.0);
                }
                label = "Log10 Co-rupture Rate";
                prefix = "corupture_rate";
            } else {
                if (((DataUtils.MinMaxAveTracker)logValTrack).getNum() == 0) {
                    min = 0.0;
                    max = 1.0;
                } else {
                    min = Math.floor(((DataUtils.MinMaxAveTracker)logValTrack).getMin());
                    max = Math.ceil(((DataUtils.MinMaxAveTracker)logValTrack).getMax());
                }
                label = "Log10 Co-rupture Count";
                prefix = "corupture_count";
            }
            if (min == max) {
                max += 1.0;
            }
            CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(min, max);
            cpt.setNanColor(Color.GRAY);
            mapMaker.clearSectScalars();
            mapMaker.plotSectScalars(scalars, cpt, label);
            mapMaker.plot(outputDir, prefix, parentName + " Connectivity");
            table.addColumn("![Map](" + outputDir.getName() + "/" + prefix + ".png)");
            if (!this.doGeoJSON) continue;
            jsonLinks.add(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", prefix + ".geojson") + " [Download GeoJSON](" + prefix + ".geojson)");
        }
        table.finalizeLine();
        if (this.doGeoJSON) {
            table.addLine(jsonLinks);
        }
        lines.addAll(table.build());
        lines.add("");
        lines.add("### Nearby Sections");
        lines.add(topLink);
        lines.add("");
        String nearbyLink = "[_(back to table)_](#" + MarkdownUtils.getAnchorName("Nearby Sections") + ")";
        PlausibilityConfiguration config = rupSet.getModule(PlausibilityConfiguration.class);
        HashMap<String, String> linksMap = new HashMap<String, String>();
        HashMap parentMarkdowns = new HashMap();
        HashMap<String, Boolean> parentConnecteds = new HashMap<String, Boolean>();
        HashMap<Object, Double> parentDists = new HashMap<Object, Double>();
        logValTrack = parentsIDsToConsider.iterator();
        while (logValTrack.hasNext()) {
            int parentID = (Integer)logValTrack.next();
            List<FaultSection> parentSects = sectsByParent.get(parentID);
            Object name = parentSects.get(0).getParentSectionName();
            double minDist = (Double)matchMinDists.get(parentID);
            name = (String)name + ", " + optionalDigitDF.format(minDist) + " km away";
            ArrayList<Object> connLines = new ArrayList<Object>();
            connLines.add("#### " + (String)name);
            connLines.add(nearbyLink);
            connLines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn("");
            table.addColumn(meta.primary.name);
            if (meta.comparisonHasSameSects) {
                table.addColumn(meta.comparison.name);
            }
            table.finalizeLine();
            parentDists.put(name, minDist);
            boolean connected = rupData.parentCoruptures.containsKey(parentID);
            table.initNewLine();
            table.addColumn("**Connected?**");
            table.addColumn(connected);
            if (meta.comparisonHasSameSects) {
                table.addColumn(compRupData.parentCoruptures.containsKey(parentID));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Directly Connected?**");
            boolean directly = rupData.directlyConnectedParents.contains(parentID);
            table.addColumn(directly);
            if (meta.comparisonHasSameSects) {
                table.addColumn(compRupData.directlyConnectedParents.contains(parentID));
            }
            table.finalizeLine();
            if (directly) {
                double minRupDist = Double.POSITIVE_INFINITY;
                double rateWeightDist = 0.0;
                double sumRate = 0.0;
                block18: for (int rupIndex : rupData.parentCoruptures.get(parentID)) {
                    ClusterRupture rup = clusterRups.get(rupIndex);
                    for (Jump jump : rup.getJumpsIterable()) {
                        if ((jump.fromCluster.parentSectionID != parentID || jump.toCluster.parentSectionID != parentSectIndex) && (jump.fromCluster.parentSectionID != parentSectIndex || jump.toCluster.parentSectionID != parentID)) continue;
                        minRupDist = Math.min(minRupDist, jump.distance);
                        if (meta.primary.sol == null) continue block18;
                        double rate = meta.primary.sol.getRateForRup(rupIndex);
                        rateWeightDist += rate * jump.distance;
                        sumRate += rate;
                        continue block18;
                    }
                }
                if (sumRate > 0.0) {
                    rateWeightDist /= sumRate;
                }
                table.initNewLine().addColumn("**Min Co-Rupture Dist**").addColumn(optionalDigitDF.format(minRupDist) + " km");
                if (meta.comparisonHasSameSects) {
                    List<Integer> compCorups = compRupData.parentCoruptures.get(parentID);
                    if (compCorups == null) {
                        table.addColumn("_N/A_");
                        table.finalizeLine();
                        if (sumRate > 0.0) {
                            table.initNewLine().addColumn("**Min Rate-Weighted Dist**").addColumn(optionalDigitDF.format(rateWeightDist) + " km");
                            table.addColumn("_N/A_");
                            table.finalizeLine();
                        }
                    } else {
                        double cminRupDist = Double.POSITIVE_INFINITY;
                        double crateWeightDist = 0.0;
                        double csumRate = 0.0;
                        ClusterRuptures compClusterRuprs = meta.comparison.rupSet.requireModule(ClusterRuptures.class);
                        block20: for (int rupIndex : compCorups) {
                            ClusterRupture rup = compClusterRuprs.get(rupIndex);
                            for (Jump jump : rup.getJumpsIterable()) {
                                if ((jump.fromCluster.parentSectionID != parentID || jump.toCluster.parentSectionID != parentSectIndex) && (jump.fromCluster.parentSectionID != parentSectIndex || jump.toCluster.parentSectionID != parentID)) continue;
                                cminRupDist = Math.min(cminRupDist, jump.distance);
                                if (meta.comparison.sol == null) continue block20;
                                double rate = meta.comparison.sol.getRateForRup(rupIndex);
                                crateWeightDist += rate * jump.distance;
                                csumRate += rate;
                                continue block20;
                            }
                        }
                        if (csumRate > 0.0) {
                            crateWeightDist /= csumRate;
                        }
                        table.addColumn(optionalDigitDF.format(cminRupDist) + " km");
                        table.finalizeLine();
                        if (sumRate > 0.0) {
                            table.initNewLine().addColumn("**Min Rate-Weighted Dist**").addColumn(optionalDigitDF.format(rateWeightDist) + " km");
                            if (csumRate > 0.0) {
                                table.addColumn(optionalDigitDF.format(crateWeightDist) + " km");
                            } else {
                                table.addColumn("_N/A_");
                            }
                            table.finalizeLine();
                        }
                    }
                } else {
                    table.finalizeLine();
                    if (sumRate > 0.0) {
                        table.initNewLine();
                        table.addColumn("**Min Rate-Weighted Dist**").addColumn(optionalDigitDF.format(rateWeightDist) + " km");
                        table.finalizeLine();
                    }
                }
            }
            table.initNewLine();
            boolean coruptures = false;
            table.addColumn("**Co-rupture Count**");
            if (rupData.parentCoruptures.containsKey(parentID)) {
                table.addColumn(countDF.format(rupData.parentCoruptures.get(parentID).size()));
                coruptures = true;
            } else {
                table.addColumn("0");
            }
            if (meta.comparisonHasSameSects) {
                if (compRupData.parentCoruptures.containsKey(parentID)) {
                    table.addColumn(countDF.format(compRupData.parentCoruptures.get(parentID).size()));
                    coruptures = true;
                } else {
                    table.addColumn("0");
                }
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Co-rupture Rate**");
            if (rupData.parentCoruptureRates != null && rupData.parentCoruptureRates.containsKey(parentID)) {
                table.addColumn(Float.valueOf(rupData.parentCoruptureRates.get(parentID).floatValue()));
            } else {
                table.addColumn("_N/A_");
            }
            if (meta.comparisonHasSameSects) {
                if (compRupData.parentCoruptureRates != null && compRupData.parentCoruptureRates.containsKey(parentID)) {
                    table.addColumn(Float.valueOf(compRupData.parentCoruptureRates.get(parentID).floatValue()));
                } else {
                    table.addColumn("_N/A_");
                }
            }
            table.finalizeLine();
            if (coruptures) {
                DataUtils.MinMaxAveTracker minMax;
                table.initNewLine();
                table.addColumn("**Co-rupture Mag Range**");
                if (rupData.parentCoruptureMags.containsKey(parentID)) {
                    minMax = rupData.parentCoruptureMags.get(parentID);
                    table.addColumn("[" + twoDigits.format(minMax.getMin()) + ", " + twoDigits.format(minMax.getMax()) + "]");
                } else {
                    table.addColumn("_N/A_");
                }
                if (meta.comparisonHasSameSects) {
                    if (compRupData.parentCoruptureMags.containsKey(parentID)) {
                        minMax = compRupData.parentCoruptureMags.get(parentID);
                        table.addColumn("[" + twoDigits.format(minMax.getMin()) + ", " + twoDigits.format(minMax.getMax()) + "]");
                    } else {
                        table.addColumn("_N/A_");
                    }
                }
                table.finalizeLine();
            }
            connLines.addAll(table.build());
            if (!connected && config != null && config.getFilters() != null && !config.getFilters().isEmpty() && config.getConnectionStrategy() != null && meta.primary.sol == null) {
                ArrayList<FaultSection> pairSects = new ArrayList<FaultSection>();
                ArrayList<FaultSubsectionCluster> pairClusters = new ArrayList<FaultSubsectionCluster>();
                pairSects.addAll(mySects);
                pairClusters.add(new FaultSubsectionCluster(mySects));
                pairSects.addAll(parentSects);
                pairClusters.add(new FaultSubsectionCluster(parentSects));
                AnyWithinDistConnectionStrategy pairStrat = new AnyWithinDistConnectionStrategy(pairSects, pairClusters, distAzCalc, this.maxNeighborDistance);
                PlausibilityConfiguration pairConfig = new PlausibilityConfiguration(List.of(new FullConnectionOneWayFilter((FaultSubsectionCluster)pairClusters.get(0), (FaultSubsectionCluster)pairClusters.get(1))), 0, pairStrat, distAzCalc);
                ClusterRuptureBuilder builder = new ClusterRuptureBuilder(pairConfig);
                List<ClusterRupture> possibleRups = builder.build(new ConnectionPointsRuptureGrowingStrategy());
                ArrayList<Boolean> passes = new ArrayList<Boolean>();
                boolean hasPassAll = false;
                List<PlausibilityFilter> filters = config.getFilters();
                for (int p = 0; p < filters.size(); ++p) {
                    passes.add(false);
                }
                for (ClusterRupture rup : possibleRups) {
                    boolean passAll = true;
                    for (int p = 0; p < filters.size(); ++p) {
                        PlausibilityResult result;
                        PlausibilityFilter filter = filters.get(p);
                        try {
                            result = filter.apply(rup, false);
                        }
                        catch (Exception e) {
                            result = PlausibilityResult.FAIL_HARD_STOP;
                        }
                        if (result.isPass()) {
                            passes.set(p, true);
                            continue;
                        }
                        passAll = false;
                    }
                    if (!passAll) continue;
                    hasPassAll = true;
                }
                connLines.add("");
                connLines.add("### Plausibility Filters Comparisons");
                connLines.add("");
                connLines.add("Here, we try to figure out which plausibility filter(s) precluded connections between these two fault sections. This is not necessarily done using the exact same connection strategy (i.e., the algorithm that chooses where jumps occur), so results might not exactly match the original rupture building algorithm.");
                connLines.add("");
                connLines.add("Plausibility filters precluding direct connection:");
                connLines.add("");
                boolean hasNever = false;
                for (int p = 0; p < filters.size(); ++p) {
                    PlausibilityFilter filter = filters.get(p);
                    if (((Boolean)passes.get(p)).booleanValue()) continue;
                    hasNever = true;
                    connLines.add("* " + filter.getName());
                }
                if (!hasNever) {
                    if (hasPassAll) {
                        connLines.add("* _None found, and this test found a rupture that passed all filters. This may be due to the connection strategy: we try many connection points here and may have found one that works and was not included in the original rupture set, or no connections may have been allowed to this fault in the case of an adaptive strategy._");
                    } else {
                        connLines.add("* _Each filter passed for at least one possible rupture connecting these two sections, but no individual rupture between the two sections passed all filters simultaneously._");
                    }
                }
            }
            parentConnecteds.put((String)name, connected);
            linksMap.put((String)name, "#" + MarkdownUtils.getAnchorName((String)name));
            parentMarkdowns.put(name, connLines);
        }
        List<String> sortedNames = ComparablePairing.getSortedData(parentDists);
        lines.addAll(SectBySectDetailPlots.buildSectLinksTable(linksMap, sortedNames, parentConnecteds, "Fault Section").build());
        lines.add("");
        for (String name : sortedNames) {
            lines.addAll((Collection)parentMarkdowns.get(name));
        }
        return lines;
    }

    static List<String> getMFDLines(ReportMetadata meta, String faultName, List<FaultSection> faultSects, File outputDir, String topLink) throws IOException {
        double val;
        boolean hasGridded;
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        FaultSystemSolution sol = meta.primary.sol;
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = Double.NEGATIVE_INFINITY;
        HashSet<Integer> rups = new HashSet<Integer>();
        for (FaultSection faultSection : faultSects) {
            List<Integer> myRups = rupSet.getRupturesForSection(faultSection.getSectionId());
            rups.addAll(myRups);
            if (myRups.size() <= 0) continue;
            minMag = Math.min(minMag, rupSet.getMinMagForSection(faultSection.getSectionId()));
            maxMag = Math.max(maxMag, rupSet.getMaxMagForSection(faultSection.getSectionId()));
        }
        if (rups.isEmpty()) {
            return new ArrayList<String>();
        }
        if (sol.hasModule(RupMFDsModule.class)) {
            RupMFDsModule mfds = sol.getModule(RupMFDsModule.class);
            Iterator iterator = rups.iterator();
            while (iterator.hasNext()) {
                int rupIndex = (Integer)iterator.next();
                DiscretizedFunc mfd = mfds.getRuptureMFD(rupIndex);
                if (mfd == null) continue;
                minMag = Math.min(minMag, mfd.getMinX());
                maxMag = Math.max(maxMag, mfd.getMaxX());
            }
        }
        GridSourceProvider gridProv = sol.getGridSourceProvider();
        FaultGridAssociations faultGridAssociations = rupSet.getModule(FaultGridAssociations.class);
        boolean bl = hasGridded = gridProv != null && (gridProv instanceof GridSourceList || faultGridAssociations != null);
        if (hasGridded) {
            minMag = Math.min(minMag, 5.0);
        }
        IncrementalMagFreqDist defaultMFD = SolMFDPlot.initDefaultMFD(6.0, 8.0, minMag, maxMag);
        SummedMagFreqDist nuclTargetMFD = null;
        if (meta.primary.rupSet.hasModule(InversionTargetMFDs.class)) {
            nuclTargetMFD = SectBySectDetailPlots.calcTargetMFD(faultSects, meta.primary.rupSet.requireModule(InversionTargetMFDs.class));
        }
        Range xRange = SolMFDPlot.xRange(defaultMFD);
        ArrayList<XY_DataSet> incrFuncs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> incrChars = new ArrayList<PlotCurveCharacterstics>();
        IncrementalMagFreqDist particMFD = sol.calcParticipationMFD_forRups(rups, defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size());
        SummedMagFreqDist nuclMFD = new SummedMagFreqDist(defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size());
        for (FaultSection faultSection : faultSects) {
            nuclMFD.addIncrementalMagFreqDist(sol.calcNucleationMFD_forSect(faultSection.getSectionId(), defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size()));
        }
        if (hasGridded) {
            Object griddedMFD = null;
            for (FaultSection sect : faultSects) {
                Object rup2;
                if (gridProv instanceof GridSourceList) {
                    for (Object rup2 : ((GridSourceList)gridProv).getAssociatedRuptures(sect.getSectionId())) {
                        double assocFract = ((GridSourceList.GriddedRupture)rup2).getFractAssociated(sect.getSectionId());
                        double assocRate = assocFract * ((GridSourceList.GriddedRupture)rup2).rate;
                        if (griddedMFD == null) {
                            IncrementalMagFreqDist refMFD = ((GridSourceList)gridProv).getRefMFD();
                            griddedMFD = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
                        }
                        ((EvenlyDiscretizedFunc)griddedMFD).add(((EvenlyDiscretizedFunc)griddedMFD).getClosestXIndex(((GridSourceList.GriddedRupture)rup2).properties.magnitude), assocRate);
                    }
                    continue;
                }
                Map<Integer, Double> scaledNodeFracts = faultGridAssociations.getScaledNodeFractions(sect.getSectionId());
                rup2 = scaledNodeFracts.keySet().iterator();
                while (rup2.hasNext()) {
                    int nodeIndex = rup2.next();
                    double fract = scaledNodeFracts.get(nodeIndex);
                    IncrementalMagFreqDist nodeMFD = gridProv.getMFD_SubSeisOnFault(nodeIndex);
                    if (!(fract > 0.0) || nodeMFD == null) continue;
                    for (int i = 0; i < nodeMFD.size(); ++i) {
                        double y = nodeMFD.getY(i);
                        if (!(y > 0.0)) continue;
                        if (griddedMFD == null) {
                            griddedMFD = new IncrementalMagFreqDist(nodeMFD.getMinX(), nodeMFD.size(), nodeMFD.getDelta());
                        } else {
                            Preconditions.checkState(((float)((EvenlyDiscretizedFunc)griddedMFD).getMinX() == (float)nodeMFD.getMinX() ? 1 : 0) != 0);
                            Preconditions.checkState(((float)((EvenlyDiscretizedFunc)griddedMFD).getDelta() == (float)nodeMFD.getDelta() ? 1 : 0) != 0);
                            if (((EvenlyDiscretizedFunc)griddedMFD).size() <= i) {
                                IncrementalMagFreqDist newMFD = new IncrementalMagFreqDist(nodeMFD.getMinX(), nodeMFD.size(), nodeMFD.getDelta());
                                for (int j = 0; j < ((EvenlyDiscretizedFunc)griddedMFD).size(); ++j) {
                                    newMFD.set(j, ((EvenlyDiscretizedFunc)griddedMFD).getY(j));
                                }
                                griddedMFD = newMFD;
                            }
                        }
                        ((EvenlyDiscretizedFunc)griddedMFD).add(i, y);
                    }
                }
            }
            if (griddedMFD != null) {
                ((IncrementalMagFreqDist)griddedMFD).setName("Sub-Seismogenic");
                incrFuncs.add((XY_DataSet)griddedMFD);
                incrChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.CYAN));
            }
        }
        incrFuncs.add(particMFD);
        incrChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, MAIN_COLOR));
        incrFuncs.add(nuclMFD);
        incrChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, MAIN_COLOR.darker()));
        BranchSectNuclMFDs branchNuclMFDs = sol.getModule(BranchSectNuclMFDs.class);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<PlotCurveCharacterstics> cmlChars = new ArrayList<PlotCurveCharacterstics>();
        if (nuclTargetMFD != null) {
            nuclTargetMFD.setName("Target Nucleation");
            Color targetColor = Color.GREEN.darker();
            SectBySectDetailPlots.addFakeHistFromFunc(nuclTargetMFD, incrFuncs, incrChars, new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, targetColor));
            arrayList.add(nuclTargetMFD.getCumRateDistWithOffset());
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, targetColor));
        }
        boolean[] binsAvail = new boolean[SectBValuePlot.refFunc.size()];
        boolean[] binsUsed = new boolean[SectBValuePlot.refFunc.size()];
        ModSectMinMags modMinMags = rupSet.getModule(ModSectMinMags.class);
        RupMFDsModule rupMFDs = sol.getModule(RupMFDsModule.class);
        for (FaultSection sect : faultSects) {
            SectBValuePlot.calcSectMags(sect.getSectionId(), meta.primary.sol, modMinMags, rupMFDs, binsAvail, binsUsed);
        }
        IncrementalMagFreqDist transNuclMFD = new IncrementalMagFreqDist(SectBValuePlot.refFunc.getMinX(), SectBValuePlot.refFunc.size(), SectBValuePlot.refFunc.getDelta());
        double minNuclMag = Double.POSITIVE_INFINITY;
        double maxNuclMag = 0.0;
        for (Point2D pt : nuclMFD) {
            if (!(pt.getY() > 0.0)) continue;
            transNuclMFD.add(transNuclMFD.getClosestXIndex(pt.getX()), pt.getY());
            minNuclMag = Math.min(minNuclMag, pt.getX());
            maxNuclMag = Math.max(maxNuclMag, pt.getX());
        }
        if (transNuclMFD.calcSumOfY_Vals() > 0.0) {
            double bVal = SectBValuePlot.estBValue((boolean[])binsAvail, (boolean[])binsUsed, (IncrementalMagFreqDist)transNuclMFD).b;
            GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(nuclMFD.getMinX(), nuclMFD.size(), nuclMFD.getDelta());
            gr.setAllButTotMoRate(gr.getX(gr.getClosestXIndex(minNuclMag)), gr.getX(gr.getClosestXIndex(maxNuclMag)), transNuclMFD.calcSumOfY_Vals(), bVal);
            gr.setName("Nucl. G-R fit, b=" + optionalDigitDF.format(bVal));
            SectBySectDetailPlots.addFakeHistFromFunc(gr, incrFuncs, incrChars, new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, new Color(0, 0, 0, 127)));
        }
        SummedMagFreqDist compNuclMFD = null;
        EvenlyDiscretizedFunc compCmlParticMFD = null;
        if (meta.comparisonHasSameSects && meta.comparison.sol != null) {
            HashSet<Integer> compRups = new HashSet<Integer>();
            for (Object sect : faultSects) {
                compRups.addAll(meta.comparison.rupSet.getRupturesForSection(sect.getSectionId()));
            }
            IncrementalMagFreqDist compParticMFD = meta.comparison.sol.calcParticipationMFD_forRups(compRups, defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size());
            compNuclMFD = new SummedMagFreqDist(defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size());
            for (FaultSection sect : faultSects) {
                compNuclMFD.addIncrementalMagFreqDist(meta.comparison.sol.calcNucleationMFD_forSect(sect.getSectionId(), defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size()));
            }
            particMFD.setName("Primary Participation");
            nuclMFD.setName("Primary Nucleation");
            compParticMFD.setName("Comparison Participation");
            compNuclMFD.setName("Comparison Nucleation");
            SectBySectDetailPlots.addFakeHistFromFunc(compParticMFD, incrFuncs, incrChars, new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, COMP_COLOR));
            SectBySectDetailPlots.addFakeHistFromFunc(compNuclMFD, incrFuncs, incrChars, new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, COMP_COLOR));
            compCmlParticMFD = compParticMFD.getCumRateDistWithOffset();
            arrayList.add(compCmlParticMFD);
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, COMP_COLOR));
            arrayList.add(compNuclMFD.getCumRateDistWithOffset());
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, COMP_COLOR));
        } else {
            particMFD.setName("Participation");
            nuclMFD.setName("Nucleation");
        }
        EvenlyDiscretizedFunc cmlParticMFD = particMFD.getCumRateDistWithOffset();
        arrayList.add(cmlParticMFD);
        cmlChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, MAIN_COLOR));
        EvenlyDiscretizedFunc nuclCmlMFD = nuclMFD.getCumRateDistWithOffset();
        arrayList.add(nuclCmlMFD);
        cmlChars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 4.0f, MAIN_COLOR));
        Range yRange = SectBySectDetailPlots.yRange(arrayList, MFD_DEFAULT_Y_RANGE, MFD_MAX_Y_RANGE, MFD_MAX_Y_RANGE_ORDERS_MAG);
        if (yRange == null) {
            return new ArrayList<String>();
        }
        Integer commonParentID = faultSects.get(0).getParentSectionId();
        for (FaultSection sect : faultSects) {
            int parentID = sect.getParentSectionId();
            if (parentID >= 0 && parentID == commonParentID) continue;
            commonParentID = null;
            break;
        }
        BranchParentSectParticMFDs parentParticMFDs = commonParentID == null ? null : sol.getModule(BranchParentSectParticMFDs.class);
        UncertainArbDiscFunc cmlParticBounds = null;
        if (parentParticMFDs != null) {
            EvenlyDiscretizedFunc[] cmlMinMedMax = parentParticMFDs.calcCumulativeSectFractiles(commonParentID, 0.0, 0.16, 0.5, 0.84, 1.0);
            cmlParticBounds = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[2], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[0], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[4], nuclCmlMFD.getMinX()));
            UncertainArbDiscFunc cml68 = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[2], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[1], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[3], nuclCmlMFD.getMinX()));
            cmlParticBounds.setName("Participation p[0,16,84,100]");
            arrayList.add(cmlParticBounds);
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_BOUNDS));
            cml68.setName(null);
            arrayList.add(cml68);
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_68_OVERLAY));
        } else if (branchNuclMFDs != null) {
            ArrayList<Integer> sectIDs = new ArrayList<Integer>(faultSects.size());
            for (FaultSection sect : faultSects) {
                sectIDs.add(sect.getSectionId());
            }
            EvenlyDiscretizedFunc[] cmlMinMedMax = branchNuclMFDs.calcCumulativeSectFractiles(sectIDs, 0.0, 0.16, 0.5, 0.84, 1.0);
            UncertainArbDiscFunc cmlBounds = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[2], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[0], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[4], nuclCmlMFD.getMinX()));
            UncertainArbDiscFunc cml68 = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[2], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[1], nuclCmlMFD.getMinX()), SolMFDPlot.extendCumulativeToLowerBound(cmlMinMedMax[3], nuclCmlMFD.getMinX()));
            cmlBounds.setName("Nucleation p[0,16,84,100]");
            arrayList.add(cmlBounds);
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_BOUNDS));
            cml68.setName(null);
            arrayList.add(cml68);
            cmlChars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_68_OVERLAY));
        }
        ArrayList<IncrementalMagFreqDist> availableFuncs = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<PlotCurveCharacterstics> availableChars = new ArrayList<PlotCurveCharacterstics>();
        IncrementalMagFreqDist availableRups = defaultMFD.deepClone();
        IncrementalMagFreqDist usedRups = defaultMFD.deepClone();
        for (int rupIndex : rups) {
            double rate = sol.getRateForRup(rupIndex);
            double mag = rupSet.getMagForRup(rupIndex);
            int magIndex = availableRups.getClosestXIndex(mag);
            availableRups.add(magIndex, 1.0);
            if (!(rate > 0.0)) continue;
            usedRups.add(magIndex, 1.0);
        }
        availableRups.setName("Available Ruptures");
        availableFuncs.add(availableRups);
        availableChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GREEN.brighter()));
        usedRups.setName("Utilized Ruptures");
        availableFuncs.add(usedRups);
        availableChars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GREEN.darker()));
        PlotSpec availableSpec = new PlotSpec(availableFuncs, availableChars, null, "Magnitude", "Rupture Count");
        availableSpec.setLegendInset(RectangleAnchor.TOP_LEFT, 0.025, 0.975, 0.3, true);
        List<Range> xRanges = List.of(xRange);
        double countMax = Math.pow(10.0, Math.ceil(Math.max(1.0, Math.log10(availableRups.getMaxY()))));
        List<Range> yRanges = List.of(yRange, new Range(0.8, countMax));
        List<Boolean> xLogs = List.of(Boolean.valueOf(false));
        List<Boolean> yLogs = List.of(Boolean.valueOf(true), Boolean.valueOf(true));
        int[] weights = new int[]{7, 3};
        PlotSpec incrSpec = new PlotSpec(incrFuncs, incrChars, faultName, "Magnitude", "Incremental Rate (per yr)");
        PlotSpec cmlSpec = new PlotSpec(arrayList, cmlChars, faultName, "Magnitude", "Cumulative Rate (per yr)");
        incrSpec.setLegendInset(true);
        cmlSpec.setLegendInset(true);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.setTickLabelFontSize(20);
        Object prefix = "sect_mfd";
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("Incremental", "Cumulative");
        table.initNewLine();
        gp.drawGraphPanel(List.of(incrSpec, availableSpec), xLogs, yLogs, xRanges, yRanges);
        PlotUtils.setSubPlotWeights(gp, weights);
        PlotUtils.writePlots(outputDir, (String)prefix, (GraphPanel)gp, 1000, 1100, true, true, true);
        table.addColumn("![Incremental Plot](" + outputDir.getName() + "/" + (String)prefix + ".png)");
        prefix = (String)prefix + "_cumulative";
        gp.drawGraphPanel(List.of(cmlSpec, availableSpec), xLogs, yLogs, xRanges, yRanges);
        PlotUtils.setSubPlotWeights(gp, weights);
        PlotUtils.writePlots(outputDir, (String)prefix, (GraphPanel)gp, 1000, 1100, true, true, true);
        table.addColumn("![Cumulative Plot](" + outputDir.getName() + "/" + (String)prefix + ".png)");
        table.finalizeLine();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Magnitude-Frequency Distribution");
        lines.add(topLink);
        lines.add("");
        lines.add("Fault magnitude-frequency distributions. The left plot shows incremental rates (rates within each magnitude bin), and the right plot shows cumulative rates (rates at or above the given magnitude).");
        lines.add("");
        lines.add("The smaller bottom panel shows the distribution of available ruptures with a green histogram and _is not rate-weighted_. It only shows the raw count of ruptures of various magnitudes available in the rupture set.");
        lines.add("");
        lines.addAll(table.build());
        if (sol.hasModule(RupMFDsModule.class)) {
            lines.add("");
            lines.add("_NOTE: This solution has a distribution of magnitudes and rates for each ruptures, and is likely a branch-averaged solution. That full distribution for each rupture is used to construct the MFDs above, but only mean magnitudes are used in the lower panel showing available and utilized magnitudes, and thus there may be bins with nonzero rates in the top panel where no mgnitudes are shown in the bottom. The magnitude rage at the top of this page also only considers mean magnitudes._");
        }
        table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("Magnitude");
        table.addColumn("Participation Rate");
        if (cmlParticBounds != null) {
            table.addColumn("Range");
        }
        table.addColumn("Participation RI (yrs)");
        if (cmlParticBounds != null) {
            table.addColumn("Range");
        }
        if (compCmlParticMFD != null) {
            table.addColumn("Comparison Rate");
            table.addColumn("Comparison RI (yrs)");
        }
        table.finalizeLine();
        int firstIndex = 0;
        double firstVal = cmlParticMFD.getY(0);
        int i = 1;
        while (i < cmlParticMFD.size() && (float)(val = cmlParticMFD.getY(i)) == (float)firstVal) {
            firstIndex = i++;
        }
        for (i = firstIndex; i < cmlParticMFD.size(); ++i) {
            Object boundsStr;
            double compVal;
            val = cmlParticMFD.getY(i);
            double d = compVal = compCmlParticMFD == null ? 0.0 : compCmlParticMFD.getY(i);
            if (val == 0.0 && compVal == 0.0) break;
            double mag = cmlParticMFD.getX(i);
            table.initNewLine();
            table.addColumn("__M&ge;" + optionalDigitDF.format(mag) + "__");
            table.addColumn("" + (float)val);
            if (cmlParticBounds != null && (float)mag <= (float)cmlParticBounds.getMaxX()) {
                boundsStr = "[";
                boundsStr = (String)boundsStr + SectBySectDetailPlots.rangeRateStr(cmlParticBounds.getLower(), mag);
                boundsStr = (String)boundsStr + ", ";
                boundsStr = (String)boundsStr + SectBySectDetailPlots.rangeRateStr(cmlParticBounds.getUpper(), mag);
                boundsStr = (String)boundsStr + "]";
                table.addColumn((String)boundsStr);
            }
            table.addColumn(SectBySectDetailPlots.riRateStr(1.0 / val));
            if (cmlParticBounds != null && (float)mag <= (float)cmlParticBounds.getMaxX()) {
                boundsStr = "[";
                boundsStr = (String)boundsStr + SectBySectDetailPlots.riRateStr(cmlParticBounds.getUpper(), mag);
                boundsStr = (String)boundsStr + ", ";
                boundsStr = (String)boundsStr + SectBySectDetailPlots.riRateStr(cmlParticBounds.getLower(), mag);
                boundsStr = (String)boundsStr + "]";
                table.addColumn((String)boundsStr);
            }
            if (compCmlParticMFD != null) {
                table.addColumn("" + (float)compVal);
                table.addColumn(SectBySectDetailPlots.riRateStr(1.0 / compVal));
            }
            table.finalizeLine();
        }
        lines.add("");
        lines.add("### Cumulative Rates and Recurrence Intervals Table");
        lines.add(topLink);
        lines.add("");
        lines.addAll(table.build());
        if (branchNuclMFDs != null) {
            int alpha = branchNuclMFDs.getNumBranches() > 10000 ? 20 : (branchNuclMFDs.getNumBranches() > 5000 ? 40 : (branchNuclMFDs.getNumBranches() > 1000 ? 60 : (branchNuclMFDs.getNumBranches() > 500 ? 80 : (branchNuclMFDs.getNumBranches() > 100 ? 100 : 160))));
            Color indvColor = new Color(80, 80, 80, alpha);
            PlotCurveCharacterstics indvCurveChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, indvColor);
            Color minColor = Color.GREEN.darker();
            Color maxColor = Color.MAGENTA.darker();
            AbstractDiscretizedFunc minMFD = null;
            double minRate = Double.POSITIVE_INFINITY;
            AbstractDiscretizedFunc maxMFD = null;
            double maxRate = 0.0;
            incrFuncs = new ArrayList();
            incrChars = new ArrayList();
            ArrayList<EvenlyDiscretizedFunc> arrayList2 = new ArrayList<EvenlyDiscretizedFunc>();
            cmlChars = new ArrayList();
            int branches = branchNuclMFDs.getNumBranches();
            Preconditions.checkState((branches > 0 ? 1 : 0) != 0);
            for (int b = 0; b < branches; ++b) {
                AbstractDiscretizedFunc mfd = null;
                for (FaultSection sect : faultSects) {
                    IncrementalMagFreqDist sectMFD = branchNuclMFDs.getSectionMFD(b, sect.getSectionId());
                    if (mfd == null) {
                        mfd = new SummedMagFreqDist(sectMFD.getMinX(), sectMFD.getMaxX(), sectMFD.size());
                    }
                    ((SummedMagFreqDist)mfd).addIncrementalMagFreqDist(sectMFD);
                }
                double totRate = mfd.calcSumOfY_Vals();
                if (totRate > maxRate) {
                    maxRate = totRate;
                    maxMFD = mfd;
                }
                if (totRate < minRate) {
                    minRate = totRate;
                    minMFD = mfd;
                }
                ((IncrementalMagFreqDist)mfd).setName(null);
                incrFuncs.add(mfd);
                incrChars.add(indvCurveChar);
                AbstractDiscretizedFunc cmlMFD = ((IncrementalMagFreqDist)mfd).getCumRateDistWithOffset();
                if (cmlMFD.getMinX() > xRange.getLowerBound()) {
                    Iterator<Object> extended = new ArbitrarilyDiscretizedFunc();
                    extended.set(xRange.getLowerBound(), cmlMFD.getY(0));
                    for (Point2D pt : cmlMFD) {
                        extended.set(pt);
                    }
                    cmlMFD = extended;
                }
                arrayList2.add((EvenlyDiscretizedFunc)cmlMFD);
                cmlChars.add(indvCurveChar);
            }
            if (incrFuncs.size() > 0 && maxMFD != null) {
                ArbitrarilyDiscretizedFunc extended;
                ((XY_DataSet)incrFuncs.get(0)).setName("Individual Branches");
                ((DiscretizedFunc)arrayList2.get(0)).setName("Individual Branches");
                PlotCurveCharacterstics minChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, minColor);
                minMFD = ((IncrementalMagFreqDist)minMFD).deepClone();
                ((IncrementalMagFreqDist)minMFD).setName("Min Rate MFD");
                incrFuncs.add(minMFD);
                incrChars.add(minChar);
                PlotCurveCharacterstics maxChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, maxColor);
                maxMFD = ((IncrementalMagFreqDist)maxMFD).deepClone();
                ((IncrementalMagFreqDist)maxMFD).setName("Max Rate MFD");
                incrFuncs.add(maxMFD);
                incrChars.add(maxChar);
                AbstractDiscretizedFunc cmlMinMFD = ((IncrementalMagFreqDist)minMFD).getCumRateDistWithOffset();
                AbstractDiscretizedFunc cmlMaxMFD = ((IncrementalMagFreqDist)maxMFD).getCumRateDistWithOffset();
                if (cmlMinMFD.getMinX() > xRange.getLowerBound()) {
                    extended = new ArbitrarilyDiscretizedFunc();
                    extended.set(xRange.getLowerBound(), cmlMinMFD.getY(0));
                    for (Point2D pt : cmlMinMFD) {
                        extended.set(pt);
                    }
                    cmlMinMFD = extended;
                }
                if (cmlMaxMFD.getMinX() > xRange.getLowerBound()) {
                    extended = new ArbitrarilyDiscretizedFunc();
                    extended.set(xRange.getLowerBound(), cmlMaxMFD.getY(0));
                    for (Point2D pt : cmlMaxMFD) {
                        extended.set(pt);
                    }
                    cmlMaxMFD = extended;
                }
                cmlMinMFD.setName(((IncrementalMagFreqDist)minMFD).getName());
                cmlMaxMFD.setName(((IncrementalMagFreqDist)maxMFD).getName());
                arrayList2.add((EvenlyDiscretizedFunc)cmlMinMFD);
                cmlChars.add(minChar);
                arrayList2.add((EvenlyDiscretizedFunc)cmlMaxMFD);
                cmlChars.add(maxChar);
                ArrayList<Integer> sectIDs = new ArrayList<Integer>(faultSects.size());
                for (FaultSection sect : faultSects) {
                    sectIDs.add(sect.getSectionId());
                }
                IncrementalMagFreqDist medianMFD = branchNuclMFDs.calcIncrementalSectFractiles(sectIDs, 0.5)[0];
                double[] dArray = new double[]{0.5};
                AbstractDiscretizedFunc medianCmlMFD = branchNuclMFDs.calcCumulativeSectFractiles(sectIDs, dArray)[0];
                if (medianCmlMFD.getMinX() > xRange.getLowerBound()) {
                    ArbitrarilyDiscretizedFunc extended2 = new ArbitrarilyDiscretizedFunc();
                    extended2.set(xRange.getLowerBound(), medianCmlMFD.getY(0));
                    for (Point2D pt : medianCmlMFD) {
                        extended2.set(pt);
                    }
                    medianCmlMFD = extended2;
                }
                if (compNuclMFD != null) {
                    PlotCurveCharacterstics compChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, COMP_COLOR);
                    compNuclMFD.setName("Comparison Mean");
                    incrFuncs.add(compNuclMFD);
                    incrChars.add(compChar);
                    EvenlyDiscretizedFunc compCmlMFD = compNuclMFD.getCumRateDistWithOffset();
                    compCmlMFD.setName("Comparison Mean");
                    arrayList2.add(compCmlMFD);
                    cmlChars.add(compChar);
                    nuclMFD.setName("Primary Mean");
                    medianMFD.setName("Primary Median");
                } else {
                    nuclMFD.setName("Mean");
                    medianMFD.setName("Median");
                }
                medianCmlMFD.setName(medianMFD.getName());
                PlotCurveCharacterstics medianChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, MAIN_COLOR);
                incrFuncs.add(medianMFD);
                incrChars.add(medianChar);
                arrayList2.add((EvenlyDiscretizedFunc)medianCmlMFD);
                cmlChars.add(medianChar);
                PlotCurveCharacterstics meanChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, MAIN_COLOR);
                incrFuncs.add(nuclMFD);
                incrChars.add(meanChar);
                nuclCmlMFD.setName(nuclMFD.getName());
                arrayList2.add(nuclCmlMFD);
                cmlChars.add(meanChar);
                incrSpec = new PlotSpec(incrFuncs, incrChars, faultName, "Magnitude", "Incremental Nucleation Rate (per yr)");
                cmlSpec = new PlotSpec(arrayList2, cmlChars, faultName, "Magnitude", "Cumulative Nucleation Rate (per yr)");
                incrSpec.setLegendInset(true);
                cmlSpec.setLegendInset(true);
                prefix = "sect_mfd_dist";
                table = MarkdownUtils.tableBuilder();
                table.addLine("Incremental", "Cumulative");
                table.initNewLine();
                gp.drawGraphPanel(incrSpec, false, true, xRange, yRange);
                PlotUtils.writePlots(outputDir, (String)prefix, (GraphPanel)gp, 1000, 800, true, false, false);
                table.addColumn("![Incremental Plot](" + outputDir.getName() + "/" + (String)prefix + ".png)");
                prefix = (String)prefix + "_cumulative";
                gp.drawGraphPanel(cmlSpec, false, true, xRange, yRange);
                PlotUtils.writePlots(outputDir, (String)prefix, (GraphPanel)gp, 1000, 800, true, false, false);
                table.addColumn("![Cumulative Plot](" + outputDir.getName() + "/" + (String)prefix + ".png)");
                table.finalizeLine();
                lines.add("");
                lines.add("### Individual Branch Nucleation MFDs");
                lines.add(topLink);
                lines.add("");
                lines.add("Individual nucleation MFDs across " + branches + " logic tree branches. The individual branches with the highest and lowest total rate are highlighted, as are the mean and median models.");
                lines.add("");
                lines.addAll(table.build());
            }
        }
        return lines;
    }

    private static String rangeRateStr(DiscretizedFunc func, double mag) {
        if ((float)mag == (float)func.getMinX()) {
            return SectBySectDetailPlots.rangeRateStr(func.getY(0));
        }
        if ((float)mag == (float)func.getMaxX()) {
            return SectBySectDetailPlots.rangeRateStr(func.getY(func.size() - 1));
        }
        if ((float)mag > (float)func.getMaxX() || (float)mag < (float)func.getMinX()) {
            return "_N/A_";
        }
        return SectBySectDetailPlots.rangeRateStr(func.getInterpolatedY(mag));
    }

    private static String rangeRateStr(double rate) {
        if (rate < 0.1) {
            return expProbDF.format(rate);
        }
        return "" + (float)rate;
    }

    private static String riRateStr(DiscretizedFunc func, double mag) {
        if ((float)mag == (float)func.getMinX()) {
            return SectBySectDetailPlots.riRateStr(1.0 / func.getY(0));
        }
        if ((float)mag == (float)func.getMaxX()) {
            return SectBySectDetailPlots.riRateStr(1.0 / func.getY(func.size() - 1));
        }
        if ((float)mag > (float)func.getMaxX() || (float)mag < (float)func.getMinX()) {
            return "_N/A_";
        }
        return SectBySectDetailPlots.riRateStr(1.0 / func.getInterpolatedY(mag));
    }

    private static String riRateStr(double ri) {
        if (ri > 1.0) {
            return riDF.format(ri);
        }
        return "" + (float)ri;
    }

    public static SummedMagFreqDist calcTargetMFD(List<FaultSection> faultSects, InversionTargetMFDs targetMFDs) {
        List<? extends IncrementalMagFreqDist> sectNuclMFDs = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
        SummedMagFreqDist nuclTargetMFD = null;
        if (sectNuclMFDs != null) {
            for (FaultSection sect : faultSects) {
                IncrementalMagFreqDist sectTarget = sectNuclMFDs.get(sect.getSectionId());
                if (sectTarget == null) {
                    nuclTargetMFD = null;
                    break;
                }
                if (nuclTargetMFD == null) {
                    nuclTargetMFD = new SummedMagFreqDist(sectTarget.getMinX(), sectTarget.size(), sectTarget.getDelta());
                }
                nuclTargetMFD.addIncrementalMagFreqDist(sectTarget);
            }
        }
        return nuclTargetMFD;
    }

    private static void addFakeHistFromFunc(EvenlyDiscretizedFunc mfd, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, PlotCurveCharacterstics pChar) {
        boolean first = true;
        double plusMinus = mfd.getDelta() * 0.4;
        for (int i = 0; i < mfd.size(); ++i) {
            double x = mfd.getX(i);
            double y = mfd.getY(i);
            if (!(y > 0.0)) continue;
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            if (first) {
                xy.setName(mfd.getName());
            }
            first = false;
            double lowX = x - plusMinus;
            double highX = x + plusMinus;
            xy.set(lowX, y);
            xy.set(highX, y);
            funcs.add(xy);
            chars.add(pChar);
        }
    }

    private static void addLineGapFuncs(EvenlyDiscretizedFunc mfd, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, PlotCurveCharacterstics pChar) {
        boolean first = true;
        double plusMinus = mfd.getDelta() * 0.25;
        DefaultXY_DataSet continuation = null;
        for (int i = 0; i < mfd.size(); ++i) {
            DefaultXY_DataSet xy;
            boolean neighbors;
            double x = mfd.getX(i);
            double y = mfd.getY(i);
            if (!(y > 0.0)) continue;
            boolean hasBefore = i > 0 && mfd.getY(i - 1) > 0.0;
            boolean hasAfter = i < mfd.size() - 1 && mfd.getY(i + 1) > 0.0;
            boolean bl = neighbors = hasBefore || hasAfter;
            if (neighbors) {
                if (hasBefore) {
                    Preconditions.checkState((!first ? 1 : 0) != 0);
                    Preconditions.checkNotNull(continuation);
                    continuation.set(x, y);
                    continue;
                }
                xy = new DefaultXY_DataSet();
                if (first) {
                    xy.setName(mfd.getName());
                }
                first = false;
                xy.set(x, y);
                funcs.add(xy);
                chars.add(pChar);
                continuation = xy;
                continue;
            }
            xy = new DefaultXY_DataSet();
            if (first) {
                xy.setName(mfd.getName());
            }
            first = false;
            double lowX = x - plusMinus;
            double highX = x + plusMinus;
            xy.set(lowX, y);
            xy.set(highX, y);
            funcs.add(xy);
            chars.add(pChar);
        }
    }

    private static Range yRange(List<? extends XY_DataSet> funcs, Range defaultRange, Range maxRange, double maxOrdersMag) {
        double minLog;
        double maxLog;
        double minNonZero = defaultRange.getLowerBound();
        double max = defaultRange.getUpperBound();
        int numNonZero = 0;
        for (XY_DataSet xY_DataSet : funcs) {
            XY_DataSet[] subFuncs;
            if (xY_DataSet instanceof UncertainBoundedDiscretizedFunc) {
                UncertainBoundedDiscretizedFunc bounded = (UncertainBoundedDiscretizedFunc)xY_DataSet;
                subFuncs = new XY_DataSet[]{bounded.getLower(), bounded.getUpper()};
            } else {
                subFuncs = new XY_DataSet[]{xY_DataSet};
            }
            for (XY_DataSet subFunc : subFuncs) {
                for (Point2D pt : subFunc) {
                    if (pt.getY() > maxRange.getLowerBound()) {
                        minNonZero = Double.min(minNonZero, pt.getY() * 0.95);
                        ++numNonZero;
                    }
                    max = Double.max(max, pt.getY() * 1.05);
                }
            }
        }
        if (numNonZero == 0) {
            return null;
        }
        Preconditions.checkState((boolean)Double.isFinite(minNonZero));
        minNonZero = Math.pow(10.0, Math.floor(Math.log10(minNonZero)));
        max = Math.pow(10.0, Math.ceil(Math.log10(max)));
        if (maxRange != null) {
            minNonZero = Math.max(minNonZero, maxRange.getLowerBound());
            max = Math.min(max, maxRange.getUpperBound());
        }
        if ((maxLog = Math.log10(max)) - (minLog = Math.log10(minNonZero)) > maxOrdersMag) {
            minLog = maxLog - maxOrdersMag;
            minNonZero = Math.pow(10.0, minLog);
        }
        return new Range(minNonZero, max);
    }

    static List<String> getAlongStrikeLines(ReportMetadata meta, String faultName, List<FaultSection> faultSects, File outputDir, String topLink) throws IOException {
        Range xRange;
        String xLabel;
        boolean latX;
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        DataUtils.MinMaxAveTracker latRange = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonRange = new DataUtils.MinMaxAveTracker();
        for (FaultSection sect : faultSects) {
            for (Location loc : sect.getFaultTrace()) {
                latRange.addValue(loc.lat);
                lonRange.addValue(loc.lon);
            }
        }
        boolean bl = latX = latRange.getLength() > 0.6 * lonRange.getLength() || faultName.contains("San Andreas");
        if (latX) {
            xLabel = "Latitude (degrees)";
            xRange = new Range(latRange.getMin(), latRange.getMax());
        } else {
            xLabel = "Longitude (degrees)";
            xRange = new Range(lonRange.getMin(), lonRange.getMax());
        }
        ArrayList<XY_DataSet> emptySectFuncs = new ArrayList<XY_DataSet>();
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = 0.0;
        for (FaultSection sect : faultSects) {
            DefaultXY_DataSet func = new DefaultXY_DataSet();
            for (Location loc : sect.getFaultTrace()) {
                if (latX) {
                    func.set(loc.getLatitude(), 0.0);
                    continue;
                }
                func.set(loc.getLongitude(), 0.0);
            }
            emptySectFuncs.add(func);
            minMag = Math.min(minMag, rupSet.getMinMagForSection(sect.getSectionId()));
            maxMag = Math.max(maxMag, rupSet.getMaxMagForSection(sect.getSectionId()));
        }
        double legendRelX = 0.025;
        Map<Integer, List<FaultSection>> parentsMap = faultSects.stream().collect(Collectors.groupingBy(s -> s.getParentSectionId()));
        double[] targetSectRates = null;
        double[] targetSectRateStdDevs = null;
        boolean targetNucleation = false;
        InversionTargetMFDs targetMFDs = meta.primary.rupSet.getModule(InversionTargetMFDs.class);
        if (targetMFDs != null && targetMFDs.getOnFaultSupraSeisNucleationMFDs() != null) {
            targetNucleation = true;
            targetSectRates = new double[rupSet.getNumSections()];
            targetSectRateStdDevs = new double[rupSet.getNumSections()];
            List<? extends IncrementalMagFreqDist> targets = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
            for (FaultSection sect : faultSects) {
                int sectID = sect.getSectionId();
                IncrementalMagFreqDist target = targets.get(sectID);
                targetSectRates[sectID] = target.calcSumOfY_Vals();
                if (targetSectRateStdDevs == null) continue;
                if (target instanceof UncertainIncrMagFreqDist) {
                    Iterator<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> uncertTarget = (UncertainIncrMagFreqDist)target;
                    UncertainBoundedIncrMagFreqDist oneSigmaBoundedMFD = ((UncertainIncrMagFreqDist)((Object)uncertTarget)).estimateBounds(UncertaintyBoundType.ONE_SIGMA);
                    double upperVal = oneSigmaBoundedMFD.getUpper().calcSumOfY_Vals();
                    double lowerVal = oneSigmaBoundedMFD.getLower().calcSumOfY_Vals();
                    targetSectRateStdDevs[sectID] = UncertaintyBoundType.ONE_SIGMA.estimateStdDev(lowerVal, upperVal);
                    continue;
                }
                targetSectRateStdDevs = null;
            }
        } else {
            InversionConfiguration invConfig = null;
            if (meta.hasPrimarySol()) {
                invConfig = meta.primary.sol.getModule(InversionConfiguration.class);
            }
            if (invConfig != null && invConfig.getConstraints() != null) {
                for (InversionConstraint constraint : invConfig.getConstraints()) {
                    if (!(constraint instanceof SectionTotalRateConstraint)) continue;
                    SectionTotalRateConstraint sectConstr = (SectionTotalRateConstraint)constraint;
                    targetSectRates = sectConstr.getSectRates();
                    targetSectRateStdDevs = sectConstr.getSectRateStdDevs();
                    targetNucleation = sectConstr.isNucleation();
                    break;
                }
            }
        }
        ArrayList<AlongStrikePlot> plots = new ArrayList<AlongStrikePlot>();
        if (meta.hasPrimarySol() || !targetNucleation && targetSectRates != null) {
            plots.add(SectBySectDetailPlots.buildParticRatePlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX, (double[])(!targetNucleation ? targetSectRates : null), (double[])(!targetNucleation ? targetSectRateStdDevs : null)));
        }
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoConstraints = null;
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoSlipConstraints = null;
        PaleoseismicConstraintData paleoData = rupSet.getModule(PaleoseismicConstraintData.class);
        if (paleoData != null) {
            HashSet<Integer> sectIndexes = new HashSet<Integer>();
            for (FaultSection sect : faultSects) {
                sectIndexes.add(sect.getSectionId());
            }
            if (paleoData.hasPaleoRateConstraints()) {
                paleoConstraints = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
                for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : paleoData.getPaleoRateConstraints()) {
                    if (!sectIndexes.contains(constr.sectionIndex)) continue;
                    paleoConstraints.add(constr);
                }
                if (paleoConstraints.isEmpty()) {
                    paleoConstraints = null;
                }
            }
            if (paleoData.hasPaleoSlipConstraints()) {
                paleoSlipConstraints = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
                for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : paleoData.inferRatesFromSlipConstraints(true)) {
                    if (!sectIndexes.contains(constr.sectionIndex)) continue;
                    paleoSlipConstraints.add(constr);
                }
                if (paleoSlipConstraints.isEmpty()) {
                    paleoSlipConstraints = null;
                }
            }
        }
        if (meta.hasPrimarySol() && (paleoConstraints != null || paleoSlipConstraints != null)) {
            plots.add(SectBySectDetailPlots.buildPaleoRatePlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX, xRange, latX, paleoData, paleoConstraints, paleoSlipConstraints));
        }
        if (meta.hasPrimarySol() || targetNucleation && targetSectRates != null) {
            plots.add(SectBySectDetailPlots.buildNuclRatePlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX, (double[])(targetNucleation ? targetSectRates : null), (double[])(targetNucleation ? targetSectRateStdDevs : null)));
        }
        if (rupSet.hasModule(SlipAlongRuptureModel.class) && rupSet.hasModule(AveSlipModule.class)) {
            plots.add(SectBySectDetailPlots.buildSlipRatePlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX, true));
        }
        boolean doReductions = false;
        for (FaultSection sect : faultSects) {
            doReductions = doReductions || sect.getCouplingCoeff() != 1.0;
            doReductions = doReductions || sect.getAseismicSlipFactor() != 0.0 && sect.getAseismicSlipFactor() != 0.1;
        }
        if (doReductions) {
            plots.add(SectBySectDetailPlots.buildSlipRateReductionPlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX));
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("## Along-Strike Values");
        lines.add(topLink);
        lines.add("");
        String prefix = "sect_along_strike";
        SectBySectDetailPlots.writeAlongStrikePlots(outputDir, prefix, plots, parentsMap, latX, xLabel, xRange, faultName);
        lines.add("![Along-strike plot](" + outputDir.getName() + "/" + prefix + ".png)");
        if (meta.primary.rupSet.hasModule(AveSlipModule.class) && meta.hasPrimarySol()) {
            lines.add("### Moment-Rates and b-Values");
            lines.add(topLink);
            lines.add("");
            plots = new ArrayList();
            plots.add(SectBySectDetailPlots.buildMoRatePlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX));
            plots.add(SectBySectDetailPlots.buildBValPlot(meta, faultSects, faultName, emptySectFuncs, xLabel, legendRelX));
            prefix = "sect_along_strike_mo_b";
            SectBySectDetailPlots.writeAlongStrikePlots(outputDir, prefix, plots, parentsMap, latX, xLabel, xRange, faultName);
            lines.add("![Along-strike plot](" + outputDir.getName() + "/" + prefix + ".png)");
        }
        return lines;
    }

    static void writeAlongStrikePlots(File outputDir, String prefix, List<AlongStrikePlot> plots, Map<Integer, List<FaultSection>> parentsMap, boolean latX, String xLabel, Range xRange, String faultName) throws IOException {
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        ArrayList<Range> yRanges = new ArrayList<Range>();
        ArrayList<List<XY_DataSet>> funcLists = new ArrayList<List<XY_DataSet>>();
        ArrayList<List<PlotCurveCharacterstics>> charLists = new ArrayList<List<PlotCurveCharacterstics>>();
        ArrayList<Boolean> yLogs = new ArrayList<Boolean>();
        for (AlongStrikePlot plot : plots) {
            specs.add(plot.spec);
            yRanges.add(plot.yRange);
            funcLists.add(plot.funcs);
            charLists.add(plot.chars);
            yLogs.add(plot.yLog);
        }
        ArrayList<Integer> specWeights = null;
        int nameInerstIndex = -1;
        if (parentsMap.size() > 1) {
            HashSet<Float> boundaryLocs = new HashSet<Float>();
            HashMap<Double, String> boundaryMiddles = new HashMap<Double, String>();
            for (List<FaultSection> parentSects : parentsMap.values()) {
                double minVal = Double.POSITIVE_INFINITY;
                double maxVal = Double.NEGATIVE_INFINITY;
                String name = null;
                for (FaultSection sect : parentSects) {
                    double x2;
                    double x1;
                    if (name == null) {
                        name = sect.getParentSectionName();
                    }
                    FaultTrace trace = sect.getFaultTrace();
                    if (latX) {
                        x1 = trace.first().lat;
                        x2 = trace.last().lat;
                    } else {
                        x1 = trace.first().lon;
                        x2 = trace.last().lon;
                    }
                    minVal = Double.min(minVal, x1);
                    minVal = Double.min(minVal, x2);
                    maxVal = Double.max(maxVal, x1);
                    maxVal = Double.max(maxVal, x2);
                }
                boundaryLocs.add(Float.valueOf((float)minVal));
                boundaryLocs.add(Float.valueOf((float)maxVal));
                if (name == null) continue;
                boundaryMiddles.put(0.5 * (maxVal + minVal), name);
            }
            if (!boundaryMiddles.isEmpty()) {
                nameInerstIndex = specs.size() / 2;
                int mainWeight = 10;
                int namesWeight = 6;
                ArrayList funcs = new ArrayList();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                PlotSpec nameSpec = new PlotSpec(funcs, chars, " ", xLabel, "Section Names");
                Range yRange = new Range(0.0, 1.0);
                double y = 0.5;
                double angle = -1.5707963267948966;
                TextAnchor rotAnchor = TextAnchor.CENTER;
                TextAnchor textAnchor = TextAnchor.CENTER;
                for (Double middle : boundaryMiddles.keySet()) {
                    String label = (String)boundaryMiddles.get(middle);
                    label = NamedFaults.stripFaultNameFromSect(faultName, label);
                    XYTextAnnotation ann = new XYTextAnnotation(label + " ", middle.doubleValue(), y);
                    int fontSize = label.length() > 30 ? 14 : (label.length() > 20 ? 18 : (label.length() > 10 ? 20 : 22));
                    Font annFont = new Font("SansSerif", 1, fontSize);
                    ann.setFont(annFont);
                    ann.setTextAnchor(textAnchor);
                    ann.setRotationAnchor(rotAnchor);
                    ann.setRotationAngle(angle);
                    nameSpec.addPlotAnnotation((XYAnnotation)ann);
                }
                specWeights = new ArrayList<Integer>();
                while (specWeights.size() < specs.size()) {
                    if (specWeights.size() == nameInerstIndex) {
                        specs.add(nameInerstIndex, nameSpec);
                        yRanges.add(nameInerstIndex, yRange);
                        funcLists.add(nameInerstIndex, funcs);
                        charLists.add(nameInerstIndex, chars);
                        yLogs.add(nameInerstIndex, false);
                        specWeights.add(namesWeight);
                        continue;
                    }
                    specWeights.add(mainWeight);
                }
            }
            PlotCurveCharacterstics boundaryChar = new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.GRAY);
            for (int s = 0; s < specs.size(); ++s) {
                Range yRange = (Range)yRanges.get(s);
                if (yRange == null) {
                    yRange = new Range(0.0, 1.0);
                }
                List funcs = (List)funcLists.get(s);
                List chars = (List)charLists.get(s);
                for (Float boundary : boundaryLocs) {
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    xy.set(boundary.doubleValue(), yRange.getLowerBound());
                    xy.set(boundary.doubleValue(), yRange.getUpperBound());
                    funcs.add(xy);
                    chars.add(boundaryChar);
                }
            }
        }
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.setTickLabelFontSize(20);
        List<Boolean> xLogs = List.of(Boolean.valueOf(false));
        List<Range> xRanges = List.of(xRange);
        gp.setxAxisInverted(latX);
        gp.drawGraphPanel(specs, xLogs, yLogs, xRanges, yRanges);
        if (specWeights != null) {
            PlotUtils.setSubPlotWeights(gp, Ints.toArray(specWeights));
        }
        if (nameInerstIndex > 0) {
            XYPlot subPlot = PlotUtils.getSubPlots(gp).get(nameInerstIndex);
            subPlot.setDomainGridlinesVisible(false);
            subPlot.setRangeGridlinesVisible(false);
            subPlot.getRangeAxis().setTickLabelsVisible(false);
        }
        int height = 300 + 500 * specs.size();
        if (specWeights != null) {
            height -= 200;
        }
        int width = parentsMap.size() == 1 ? 1000 : 1400;
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, width, height, true, true, false);
    }

    private static AlongStrikePlot buildParticRatePlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX, double[] targetRates, double[] targetRateStdDevs) {
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        double minMag = Double.POSITIVE_INFINITY;
        double maxMag = 0.0;
        for (FaultSection sect : faultSects) {
            minMag = Math.min(minMag, rupSet.getMinMagForSection(sect.getSectionId()));
            maxMag = Math.max(maxMag, rupSet.getMaxMagForSection(sect.getSectionId()));
        }
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<PlotLineType> magLines = new ArrayList<PlotLineType>();
        ArrayList<Double> minMags = new ArrayList<Double>();
        minMags.add(0.0);
        magLines.add(PlotLineType.SOLID);
        if (maxMag > 9.0) {
            if (minMag < 7.0 && maxMag > 7.0) {
                minMags.add(7.0);
                magLines.add(PlotLineType.DASHED);
            }
            if (minMag < 8.0 && maxMag > 8.0) {
                minMags.add(8.0);
                magLines.add(PlotLineType.DOTTED);
            }
            if (minMag < 9.0 && maxMag > 9.0) {
                minMags.add(9.0);
                magLines.add(PlotLineType.DOTTED_AND_DASHED);
            }
        } else {
            if (minMag < 6.0 && maxMag > 6.0) {
                minMags.add(6.0);
                magLines.add(PlotLineType.DASHED);
            }
            if (minMag < 7.0 && maxMag > 7.0) {
                minMags.add(7.0);
                magLines.add(PlotLineType.DOTTED);
            }
            if (minMag < 8.0 && maxMag > 8.0) {
                minMags.add(8.0);
                magLines.add(PlotLineType.DOTTED_AND_DASHED);
            }
        }
        ArrayList<Object> magLabels = new ArrayList<Object>();
        Iterator iterator = minMags.iterator();
        while (iterator.hasNext()) {
            double myMinMag = (Double)iterator.next();
            if (myMinMag > 0.0) {
                magLabels.add("M\u2265" + optionalDigitDF.format(myMinMag));
                continue;
            }
            magLabels.add("Supra-Seis");
        }
        BranchSectParticMFDs dists = meta.hasPrimarySol() ? meta.primary.sol.getModule(BranchSectParticMFDs.class) : null;
        boolean comp = meta.hasComparisonSol() && meta.comparisonHasSameSects;
        boolean first = true;
        for (int s = 0; s < faultSects.size(); ++s) {
            PlotLineType line;
            XY_DataSet rateFunc;
            double rate;
            FaultSection sect = faultSects.get(s);
            XY_DataSet emptyFunc = emptySectFuncs.get(s);
            if (targetRates != null) {
                XY_DataSet rateFunc2 = SectBySectDetailPlots.copyAtY(emptyFunc, targetRates[sect.getSectionId()]);
                if (first) {
                    rateFunc2.setName("Target Supra-Seis");
                }
                funcs.add(rateFunc2);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, TARGET_COLOR));
                if (targetRateStdDevs != null && targetRateStdDevs[sect.getSectionId()] > 0.0) {
                    UncertainArbDiscFunc uncertFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, targetRates[sect.getSectionId()], targetRateStdDevs[sect.getSectionId()]);
                    if (first) {
                        uncertFunc.setName("\u00b1 \u03c3");
                    }
                    funcs.add(uncertFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, targetBoundsColor));
                }
            }
            if (comp) {
                for (int m = 0; m < minMags.size(); ++m) {
                    double myMinMag = (Double)minMags.get(m);
                    rate = SectBySectDetailPlots.rateAbove(myMinMag, sect.getSectionId(), meta.comparison.sol);
                    rateFunc = SectBySectDetailPlots.copyAtY(emptyFunc, rate);
                    if (first) {
                        if (comp && m == 0) {
                            rateFunc.setName("Comparison " + (String)magLabels.get(m));
                        } else {
                            rateFunc.setName((String)magLabels.get(m));
                        }
                    }
                    line = (PlotLineType)((Object)magLines.get(m));
                    funcs.add(rateFunc);
                    chars.add(new PlotCurveCharacterstics(line, 2.0f, COMP_COLOR));
                }
            }
            if (meta.hasPrimarySol()) {
                for (int m = 0; m < minMags.size(); ++m) {
                    double myMinMag = (Double)minMags.get(m);
                    rate = SectBySectDetailPlots.rateAbove(myMinMag, sect.getSectionId(), meta.primary.sol);
                    rateFunc = SectBySectDetailPlots.copyAtY(emptyFunc, rate);
                    if (first) {
                        if (comp && m == 0) {
                            rateFunc.setName("Primary " + (String)magLabels.get(m));
                        } else {
                            rateFunc.setName((String)magLabels.get(m));
                        }
                    }
                    line = (PlotLineType)((Object)magLines.get(m));
                    funcs.add(rateFunc);
                    chars.add(new PlotCurveCharacterstics(line, 3.0f, MAIN_COLOR));
                    if (m != 0 || dists == null) continue;
                    EvenlyDiscretizedFunc[] fractiles = dists.calcCumulativeSectFractiles(sect.getSectionId(), 0.0, 0.16, 0.5, 0.84, 1.0);
                    double min = fractiles[0].getY(0);
                    double p16 = fractiles[1].getY(0);
                    double p50 = fractiles[2].getY(0);
                    double p84 = fractiles[3].getY(0);
                    double max = fractiles[4].getY(0);
                    UncertainArbDiscFunc minMaxFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, p50, min, max);
                    if (first) {
                        minMaxFunc.setName("p[0,16,84,100]");
                    }
                    funcs.add(minMaxFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_BOUNDS));
                    UncertainArbDiscFunc sixyEightFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, p50, p16, p84);
                    funcs.add(sixyEightFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_68_OVERLAY));
                }
            }
            first = false;
        }
        PlotSpec magRateSpec = new PlotSpec(funcs, chars, faultName, xLabel, "Participation Rate (per year)");
        magRateSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        return new AlongStrikePlot(magRateSpec, funcs, chars, SectBySectDetailPlots.yRange(funcs, new Range(1.0E-4, 0.001), new Range(1.0E-8, 10.0), 5.0), true);
    }

    private static AlongStrikePlot buildPaleoRatePlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX, Range xRange, boolean latX, PaleoseismicConstraintData paleoData, List<UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoConstraints, List<UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoSlipConstraints) {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        PaleoProbabilityModel paleoProb = paleoConstraints != null ? paleoData.getPaleoProbModel() : null;
        PaleoSlipProbabilityModel paleoSlipProb = null;
        if (paleoSlipConstraints != null && rupSet.hasModule(AveSlipModule.class) && rupSet.hasModule(SlipAlongRuptureModel.class)) {
            paleoSlipProb = paleoData.getPaleoSlipProbModel();
        }
        ArrayList<XY_DataSet> dataFuncs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> dataChars = new ArrayList<PlotCurveCharacterstics>();
        double halfWhisker = 0.005 * xRange.getLength();
        for (boolean slip : new boolean[]{true, false}) {
            List<UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints;
            Color constrColor;
            if (slip) {
                constrColor = Color.GREEN.darker();
                constraints = paleoSlipConstraints;
            } else {
                constrColor = Color.BLACK;
                constraints = paleoConstraints;
            }
            Color whiskerColor = new Color(constrColor.getRed(), constrColor.getGreen(), constrColor.getBlue(), 127);
            if (constraints == null) continue;
            DefaultXY_DataSet dataXY = new DefaultXY_DataSet();
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint constraint : constraints) {
                double x = latX ? constraint.dataLocation.getLatitude() : constraint.dataLocation.getLongitude();
                dataXY.set(x, constraint.bestEstimate);
                BoundedUncertainty range95 = constraint.estimateUncertaintyBounds(UncertaintyBoundType.CONF_95);
                dataFuncs.add(SectBySectDetailPlots.line(x - halfWhisker, range95.upperBound, x + halfWhisker, range95.upperBound));
                dataChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, whiskerColor));
                dataFuncs.add(SectBySectDetailPlots.line(x, range95.lowerBound, x, range95.upperBound));
                dataChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, whiskerColor));
                dataFuncs.add(SectBySectDetailPlots.line(x - halfWhisker, range95.lowerBound, x + halfWhisker, range95.lowerBound));
                dataChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, whiskerColor));
            }
            if (slip) {
                dataXY.setName("Slip Data");
            } else {
                dataXY.setName("Rate Data");
            }
            dataFuncs.add(dataXY);
            dataChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 5.0f, constrColor));
        }
        boolean comp = meta.hasComparisonSol() && meta.comparisonHasSameSects;
        double[] slipRates = null;
        double[] compSlipRates = null;
        if (paleoSlipProb != null) {
            slipRates = SectBySectDetailPlots.calcPaleoRates(faultSects, meta.primary.sol, paleoSlipProb);
            if (comp && meta.comparison.rupSet.hasModule(AveSlipModule.class) && meta.comparison.rupSet.hasModule(SlipAlongRuptureModel.class)) {
                compSlipRates = SectBySectDetailPlots.calcPaleoRates(faultSects, meta.comparison.sol, paleoSlipProb);
            }
        }
        for (int s = 0; s < faultSects.size(); ++s) {
            int sectIndex = faultSects.get(s).getSectionId();
            for (boolean isComp : new boolean[]{true, false}) {
                if (isComp && !comp) continue;
                for (boolean slip : new boolean[]{true, false}) {
                    PlotCurveCharacterstics pChar;
                    double rate;
                    String funcLabel;
                    PlotLineType lineType;
                    if (isComp && slip && compSlipRates == null) continue;
                    if (slip) {
                        if (paleoSlipProb == null) continue;
                        lineType = PlotLineType.DOTTED;
                        funcLabel = "Slip-Rate-Observable";
                    } else {
                        if (paleoProb == null) continue;
                        lineType = PlotLineType.SOLID;
                        funcLabel = "Rate-Observable";
                    }
                    XY_DataSet emptyFunc = emptySectFuncs.get(s);
                    Object label = null;
                    if (isComp) {
                        rate = slip ? compSlipRates[s] : SectBySectDetailPlots.paleoRate(sectIndex, meta.comparison.sol, paleoProb);
                        label = "Comparison";
                        pChar = new PlotCurveCharacterstics(lineType, 2.0f, COMP_COLOR);
                    } else {
                        rate = slip ? slipRates[s] : SectBySectDetailPlots.paleoRate(sectIndex, meta.primary.sol, paleoProb);
                        label = comp ? "Primary " + funcLabel : funcLabel;
                        pChar = new PlotCurveCharacterstics(lineType, 3.0f, MAIN_COLOR);
                    }
                    XY_DataSet rateFunc = SectBySectDetailPlots.copyAtY(emptyFunc, rate);
                    if (s == 0) {
                        rateFunc.setName((String)label);
                    }
                    funcs.add(rateFunc);
                    chars.add(pChar);
                }
            }
        }
        funcs.addAll(0, dataFuncs);
        chars.addAll(0, dataChars);
        PlotSpec paleoSpec = new PlotSpec(funcs, chars, faultName, xLabel, "Paleo-Visible Participation Rate (per year)");
        paleoSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        return new AlongStrikePlot(paleoSpec, funcs, chars, SectBySectDetailPlots.yRange(funcs, new Range(1.0E-4, 0.001), new Range(1.0E-8, 10.0), 5.0), true);
    }

    private static AlongStrikePlot buildNuclRatePlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX, double[] targetRates, double[] targetRateStdDevs) {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        boolean comp = meta.hasComparisonSol() && meta.comparisonHasSameSects;
        BranchSectNuclMFDs dists = meta.hasPrimarySol() ? meta.primary.sol.getModule(BranchSectNuclMFDs.class) : null;
        boolean first = true;
        for (int s = 0; s < faultSects.size(); ++s) {
            XY_DataSet rateFunc;
            FaultSection sect = faultSects.get(s);
            XY_DataSet emptyFunc = emptySectFuncs.get(s);
            if (targetRates != null) {
                XY_DataSet rateFunc2 = SectBySectDetailPlots.copyAtY(emptyFunc, targetRates[sect.getSectionId()]);
                if (first) {
                    rateFunc2.setName("Target Supra-Seis Nucleation");
                }
                funcs.add(rateFunc2);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, TARGET_COLOR));
                if (targetRateStdDevs != null && targetRateStdDevs[sect.getSectionId()] > 0.0) {
                    UncertainArbDiscFunc uncertFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, targetRates[sect.getSectionId()], targetRateStdDevs[sect.getSectionId()]);
                    if (first) {
                        uncertFunc.setName("+/- \u03c3");
                    }
                    funcs.add(uncertFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, targetBoundsColor));
                }
            }
            if (comp) {
                double rate = SectBySectDetailPlots.nuclRateAbove(0.0, sect.getSectionId(), meta.comparison.sol);
                rateFunc = SectBySectDetailPlots.copyAtY(emptyFunc, rate);
                if (first) {
                    rateFunc.setName("Comparison");
                }
                funcs.add(rateFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COMP_COLOR));
            }
            if (meta.hasPrimarySol()) {
                double rate = SectBySectDetailPlots.nuclRateAbove(0.0, sect.getSectionId(), meta.primary.sol);
                rateFunc = SectBySectDetailPlots.copyAtY(emptyFunc, rate);
                if (first) {
                    if (comp) {
                        rateFunc.setName("Primary Nucleation");
                    } else {
                        rateFunc.setName("Solution Nucleation");
                    }
                }
                funcs.add(rateFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, MAIN_COLOR));
                if (dists != null) {
                    EvenlyDiscretizedFunc[] fractiles = dists.calcCumulativeSectFractiles(List.of(Integer.valueOf(sect.getSectionId())), 0.0, 0.16, 0.5, 0.84, 1.0);
                    double min = fractiles[0].getY(0);
                    double p16 = fractiles[1].getY(0);
                    double p50 = fractiles[2].getY(0);
                    double p84 = fractiles[3].getY(0);
                    double max = fractiles[4].getY(0);
                    UncertainArbDiscFunc minMaxFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, p50, min, max);
                    if (first) {
                        minMaxFunc.setName("p[0,16,84,100]");
                    }
                    funcs.add(minMaxFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_BOUNDS));
                    UncertainArbDiscFunc sixyEightFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, p50, p16, p84);
                    funcs.add(sixyEightFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_68_OVERLAY));
                }
            }
            first = false;
        }
        PlotSpec nuclRateSpec = new PlotSpec(funcs, chars, faultName, xLabel, "Nucleation Rate (per year)");
        nuclRateSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        return new AlongStrikePlot(nuclRateSpec, funcs, chars, SectBySectDetailPlots.yRange(funcs, new Range(1.0E-5, 1.0E-4), new Range(1.0E-9, 1.0), 5.0), true);
    }

    static AlongStrikePlot buildSlipRateReductionPlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX) {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        PlotCurveCharacterstics creepRedChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED.darker());
        PlotCurveCharacterstics aseisChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GREEN.darker());
        PlotCurveCharacterstics couplingChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE.darker());
        for (int s = 0; s < faultSects.size(); ++s) {
            double momentRed;
            FaultSection sect = faultSects.get(s);
            boolean first = funcs.isEmpty();
            double origSlipRate = sect.getOrigAveSlipRate();
            if (origSlipRate <= 0.0 || !Double.isFinite(origSlipRate)) {
                momentRed = 1.0;
            } else {
                double origArea = sect.getArea(false);
                double reducedArea = sect.getArea(true);
                double reducedSlipRate = sect.getReducedAveSlipRate();
                double origMoRate = FaultMomentCalc.getMoment(origArea, origSlipRate * 0.001);
                double reducedMoRate = FaultMomentCalc.getMoment(reducedArea, reducedSlipRate * 0.001);
                momentRed = (origMoRate - reducedMoRate) / origMoRate;
            }
            double aseis = sect.getAseismicSlipFactor();
            double coupling = sect.getCouplingCoeff();
            XY_DataSet emptyFunc = emptySectFuncs.get(s);
            funcs.add(SectBySectDetailPlots.copyAtY(emptyFunc, momentRed));
            chars.add(creepRedChar);
            if (first) {
                ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Fractional Moment Reduction");
            }
            funcs.add(SectBySectDetailPlots.copyAtY(emptyFunc, aseis));
            chars.add(aseisChar);
            if (first) {
                ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Aseismic Slip Factor");
            }
            funcs.add(SectBySectDetailPlots.copyAtY(emptyFunc, coupling));
            chars.add(couplingChar);
            if (!first) continue;
            ((XY_DataSet)funcs.get(funcs.size() - 1)).setName("Coupling Coefficient");
        }
        PlotSpec spec = new PlotSpec(funcs, chars, faultName, xLabel, "Creep Reduction");
        spec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        return new AlongStrikePlot(spec, funcs, chars, new Range(0.0, 1.0), false);
    }

    static AlongStrikePlot buildSlipRatePlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX, boolean logY) {
        Range yRange;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        boolean comp = meta.hasComparisonSol() && meta.comparison.rupSet.hasModule(AveSlipModule.class) && meta.comparison.rupSet.hasModule(SlipAlongRuptureModel.class) && meta.comparisonHasSameSects;
        SectSlipRates slipRates = rupSet.getModule(SectSlipRates.class);
        double[] solSlipRates = null;
        if (meta.hasPrimarySol() && meta.primary.rupSet.hasModule(AveSlipModule.class) && meta.primary.rupSet.hasModule(SlipAlongRuptureModel.class)) {
            solSlipRates = SectBySectDetailPlots.sectSolSlipRates(meta.primary.sol, faultSects);
        }
        double[] compSolSlipRates = comp ? SectBySectDetailPlots.sectSolSlipRates(meta.comparison.sol, faultSects) : null;
        double avgTarget = 0.0;
        PlotCurveCharacterstics origSlipChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK.darker());
        PlotCurveCharacterstics reducedSlipChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GRAY.darker());
        PlotCurveCharacterstics creepRateChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.ORANGE.darker());
        boolean firstCreep = true;
        for (int s = 0; s < faultSects.size(); ++s) {
            GeoJSONFaultSection geoSect;
            double creepRate;
            XY_DataSet emptyFunc = emptySectFuncs.get(s);
            FaultSection sect = faultSects.get(s);
            if (sect instanceof GeoJSONFaultSection && Double.isFinite(creepRate = (geoSect = (GeoJSONFaultSection)sect).getProperties().getDouble("CreepRate", Double.NaN))) {
                XY_DataSet creepFunc = SectBySectDetailPlots.copyAtY(emptyFunc, creepRate);
                if (firstCreep) {
                    creepFunc.setName("Creep Rate");
                }
                funcs.add(0, creepFunc);
                chars.add(0, creepRateChar);
                firstCreep = false;
            }
            double origSlip = sect.getOrigAveSlipRate();
            XY_DataSet origFunc = SectBySectDetailPlots.copyAtY(emptyFunc, origSlip);
            if (s == 0) {
                origFunc.setName("Original");
            }
            funcs.add(origFunc);
            chars.add(origSlipChar);
            double reducedSlip = sect.getReducedAveSlipRate();
            XY_DataSet reducedFunc = SectBySectDetailPlots.copyAtY(emptyFunc, reducedSlip);
            if (s == 0) {
                reducedFunc.setName("Creep Reduced");
            }
            funcs.add(reducedFunc);
            chars.add(reducedSlipChar);
            if (slipRates != null) {
                double targetSlip = slipRates.getSlipRate(sect.getSectionId()) * 1000.0;
                XY_DataSet targetFunc = SectBySectDetailPlots.copyAtY(emptyFunc, targetSlip);
                if (s == 0) {
                    targetFunc.setName("Target");
                }
                funcs.add(targetFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, TARGET_COLOR));
                double stdDev = slipRates.getSlipRateStdDev(sect.getSectionId()) * 1000.0;
                if (stdDev > 0.0) {
                    UncertainArbDiscFunc uncertFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, targetSlip, stdDev);
                    if (s == 0) {
                        uncertFunc.setName("+/- \u03c3");
                    }
                    funcs.add(uncertFunc);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, targetBoundsColor));
                }
                avgTarget += targetSlip;
            } else {
                avgTarget = solSlipRates != null ? (avgTarget += solSlipRates[s]) : (avgTarget += reducedSlip);
            }
            if (comp) {
                XY_DataSet compSolFunc = SectBySectDetailPlots.copyAtY(emptyFunc, compSolSlipRates[s] * 1000.0);
                if (s == 0) {
                    compSolFunc.setName("Comparison Solution");
                }
                funcs.add(compSolFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, COMP_COLOR.darker()));
            }
            if (solSlipRates == null) continue;
            XY_DataSet solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, solSlipRates[s] * 1000.0);
            if (s == 0) {
                solFunc.setName("Solution");
            }
            funcs.add(solFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.MAGENTA.darker()));
        }
        avgTarget /= (double)faultSects.size();
        PlotSpec slipRateSpec = new PlotSpec(funcs, chars, faultName, xLabel, "Slip Rate (mm/yr)");
        slipRateSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        if (logY) {
            Range defaultSlipRange = avgTarget > 1.0 ? new Range(1.0, 10.0) : (avgTarget > 0.1 ? new Range(0.1, 1.0) : new Range(0.01, 0.1));
            yRange = SectBySectDetailPlots.yRange(funcs, defaultSlipRange, new Range(1.0E-5, 100.0), 3.0);
        } else {
            double minSlip = Double.POSITIVE_INFINITY;
            double maxSlip = Double.NEGATIVE_INFINITY;
            for (XY_DataSet func : funcs) {
                minSlip = Math.min(minSlip, func.getMinY());
                maxSlip = Math.max(maxSlip, func.getMaxY());
            }
            double delta = maxSlip > 20.0 ? 10.0 : (maxSlip > 10.0 ? 5.0 : 1.0);
            maxSlip = Math.max(1.0, Math.ceil(maxSlip / delta) * delta);
            if ((minSlip = Math.floor(minSlip / delta) * delta) < 5.0) {
                minSlip = 0.0;
            }
            yRange = new Range(minSlip, maxSlip);
        }
        return new AlongStrikePlot(slipRateSpec, funcs, chars, yRange, logY);
    }

    private static AlongStrikePlot buildMoRatePlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX) {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        FaultSystemRupSet rupSet = meta.primary.rupSet;
        boolean comp = meta.hasComparisonSol() && meta.comparison.rupSet.hasModule(AveSlipModule.class) && meta.comparisonHasSameSects;
        SectSlipRates slipRates = rupSet.getModule(SectSlipRates.class);
        double[] rupMoRates = SectBValuePlot.calcRupMoments(meta.primary.rupSet);
        for (int r = 0; r < rupMoRates.length; ++r) {
            int n = r;
            rupMoRates[n] = rupMoRates[n] * meta.primary.sol.getRateForRup(r);
        }
        double[] compRupMoRates = null;
        if (comp) {
            compRupMoRates = SectBValuePlot.calcRupMoments(meta.comparison.rupSet);
            for (int r = 0; r < compRupMoRates.length; ++r) {
                int n = r;
                compRupMoRates[n] = compRupMoRates[n] * meta.comparison.sol.getRateForRup(r);
            }
        }
        for (int s = 0; s < faultSects.size(); ++s) {
            double nuclRate;
            XY_DataSet solFunc;
            double particRate;
            XY_DataSet emptyFunc = emptySectFuncs.get(s);
            int sectIndex = faultSects.get(s).getSectionId();
            if (slipRates != null) {
                double targetNucl = FaultMomentCalc.getMoment(rupSet.getAreaForSection(sectIndex), slipRates.getSlipRate(sectIndex));
                XY_DataSet targetFunc = SectBySectDetailPlots.copyAtY(emptyFunc, targetNucl);
                if (s == 0) {
                    targetFunc.setName("Target Nucleation");
                }
                funcs.add(targetFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, TARGET_COLOR));
            }
            if (comp) {
                particRate = SectBValuePlot.calcSectMomentRate(meta.comparison.rupSet, compRupMoRates, false, sectIndex);
                solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, particRate);
                if (s == 0) {
                    solFunc.setName("Comparison Solution Participation");
                }
                funcs.add(solFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, COMP_COLOR));
                nuclRate = SectBValuePlot.calcSectMomentRate(meta.comparison.rupSet, compRupMoRates, true, sectIndex);
                solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, nuclRate);
                if (s == 0) {
                    solFunc.setName("Nucleation");
                }
                funcs.add(solFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, COMP_COLOR));
            }
            particRate = SectBValuePlot.calcSectMomentRate(meta.primary.rupSet, rupMoRates, false, sectIndex);
            solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, particRate);
            if (s == 0) {
                if (comp) {
                    solFunc.setName("Primary Participation");
                } else {
                    solFunc.setName("Solution Participation");
                }
            }
            funcs.add(solFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, MAIN_COLOR));
            nuclRate = SectBValuePlot.calcSectMomentRate(meta.primary.rupSet, rupMoRates, true, sectIndex);
            solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, nuclRate);
            if (s == 0) {
                solFunc.setName("Nucleation");
            }
            funcs.add(solFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, MAIN_COLOR));
        }
        PlotSpec moRateSpec = new PlotSpec(funcs, chars, faultName, xLabel, "Moment Rate (N-m/yr)");
        moRateSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        return new AlongStrikePlot(moRateSpec, funcs, chars, SectBySectDetailPlots.yRange(funcs, new Range(1.0E15, 1.0E19), new Range(1.0E10, 1.0E20), 6.0), true);
    }

    private static AlongStrikePlot buildBValPlot(ReportMetadata meta, List<FaultSection> faultSects, String faultName, List<XY_DataSet> emptySectFuncs, String xLabel, double legendRelX) {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        boolean comp = meta.hasComparisonSol() && meta.comparison.rupSet.hasModule(AveSlipModule.class) && meta.comparisonHasSameSects;
        double[] rupMoRates = SectBValuePlot.calcRupMoments(meta.primary.rupSet);
        for (int r = 0; r < rupMoRates.length; ++r) {
            int n = r;
            rupMoRates[n] = rupMoRates[n] * meta.primary.sol.getRateForRup(r);
        }
        double[] compRupMoRates = null;
        if (comp) {
            compRupMoRates = SectBValuePlot.calcRupMoments(meta.comparison.rupSet);
            for (int r = 0; r < compRupMoRates.length; ++r) {
                int n = r;
                compRupMoRates[n] = compRupMoRates[n] * meta.comparison.sol.getRateForRup(r);
            }
        }
        ModSectMinMags modMinMags = meta.primary.rupSet.getModule(ModSectMinMags.class);
        RupMFDsModule rupMFDs = meta.primary.sol.getModule(RupMFDsModule.class);
        ModSectMinMags compModMinMags = comp ? meta.comparison.rupSet.getModule(ModSectMinMags.class) : null;
        RupMFDsModule compRupMFDs = comp ? meta.comparison.sol.getModule(RupMFDsModule.class) : null;
        BranchSectBVals branchBVals = meta.primary.sol.getModule(BranchSectBVals.class);
        List<? extends IncrementalMagFreqDist> sectTargetMFDs = null;
        if (meta.primary.rupSet.hasModule(InversionTargetMFDs.class)) {
            sectTargetMFDs = meta.primary.rupSet.requireModule(InversionTargetMFDs.class).getOnFaultSupraSeisNucleationMFDs();
        }
        EvenlyDiscretizedFunc refFunc = SectBValuePlot.refFunc;
        for (int s = 0; s < faultSects.size(); ++s) {
            XY_DataSet solFunc;
            XY_DataSet emptyFunc = emptySectFuncs.get(s);
            int sectIndex = faultSects.get(s).getSectionId();
            if (sectTargetMFDs != null) {
                boolean[] bins = new boolean[refFunc.size()];
                IncrementalMagFreqDist sectMFD = new IncrementalMagFreqDist(refFunc.getMinX(), refFunc.size(), refFunc.getDelta());
                IncrementalMagFreqDist target = sectTargetMFDs.get(sectIndex);
                boolean any = false;
                for (Point2D pt : target) {
                    if (!(pt.getY() > 0.0)) continue;
                    int binIndex = sectMFD.getClosestXIndex(pt.getX());
                    sectMFD.add(binIndex, pt.getY());
                    bins[binIndex] = true;
                    any = true;
                }
                if (any) {
                    double targetBVal = SectBValuePlot.estBValue((boolean[])bins, (boolean[])bins, (IncrementalMagFreqDist)sectMFD).b;
                    XY_DataSet solFunc2 = SectBySectDetailPlots.copyAtY(emptyFunc, targetBVal);
                    if (s == 0) {
                        solFunc2.setName("Target");
                    }
                    funcs.add(solFunc2);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, TARGET_COLOR));
                }
                if (branchBVals != null && branchBVals.hasTargetBVals()) {
                    double targetBVal = branchBVals.getSectTargetMeanBVal(sectIndex);
                    XY_DataSet solFunc3 = SectBySectDetailPlots.copyAtY(emptyFunc, targetBVal);
                    if (s == 0) {
                        solFunc3.setName("Mean Target");
                    }
                    funcs.add(solFunc3);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, TARGET_COLOR));
                }
            }
            if (comp) {
                double bVal = SectBySectDetailPlots.bVal(meta.comparison.sol, sectIndex, compModMinMags, compRupMFDs, refFunc);
                solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, bVal);
                if (s == 0) {
                    solFunc.setName("Comparison Solution");
                }
                funcs.add(solFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, COMP_COLOR));
            }
            double bVal = SectBySectDetailPlots.bVal(meta.primary.sol, sectIndex, modMinMags, rupMFDs, refFunc);
            solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, bVal);
            if (s == 0) {
                if (comp) {
                    solFunc.setName("Primary");
                } else {
                    solFunc.setName("Solution");
                }
            }
            funcs.add(solFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, MAIN_COLOR));
            if (branchBVals == null) continue;
            ArbDiscrEmpiricalDistFunc bValDist = branchBVals.getSectBValDist(sectIndex);
            double min = bValDist.getMinX();
            double p16 = bValDist.getInterpolatedFractile(0.16);
            double p50 = bValDist.getInterpolatedFractile(0.5);
            double p84 = bValDist.getInterpolatedFractile(0.84);
            double max = bValDist.getMaxX();
            UncertainArbDiscFunc minMaxFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, p50, min, max);
            if (s == 0) {
                minMaxFunc.setName("p[0,16,84,100]");
            }
            funcs.add(minMaxFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_BOUNDS));
            UncertainArbDiscFunc sixyEightFunc = SectBySectDetailPlots.uncertCopyAtY(emptyFunc, p50, p16, p84);
            funcs.add(sixyEightFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, PRIMARY_68_OVERLAY));
            solFunc = SectBySectDetailPlots.copyAtY(emptyFunc, branchBVals.getSectMeanBVal(sectIndex));
            if (s == 0) {
                solFunc.setName("Mean");
            }
            funcs.add(solFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, MAIN_COLOR));
        }
        PlotSpec bValSpec = new PlotSpec(funcs, chars, faultName, xLabel, "G-R Estimated b-value");
        bValSpec.setLegendInset(RectangleAnchor.BOTTOM_LEFT, legendRelX, 0.025, 0.95, false);
        return new AlongStrikePlot(bValSpec, funcs, chars, new Range(-3.0, 3.0), false);
    }

    private static double bVal(FaultSystemSolution sol, int sectIndex, ModSectMinMags modMinMags, RupMFDsModule rupMFDs, EvenlyDiscretizedFunc refFunc) {
        boolean[] binsAvail = new boolean[refFunc.size()];
        boolean[] binsUsed = new boolean[refFunc.size()];
        SectBValuePlot.calcSectMags(sectIndex, sol, modMinMags, rupMFDs, binsAvail, binsUsed);
        IncrementalMagFreqDist sectMFD = sol.calcNucleationMFD_forSect(sectIndex, refFunc.getX(0), refFunc.getX(refFunc.size() - 1), refFunc.size());
        return SectBValuePlot.estBValue((boolean[])binsAvail, (boolean[])binsUsed, (IncrementalMagFreqDist)sectMFD).b;
    }

    private static XY_DataSet line(double x1, double y1, double x2, double y2) {
        return new DefaultXY_DataSet(new double[]{x1, x2}, new double[]{y1, y2});
    }

    private static double[] sectSolSlipRates(FaultSystemSolution sol, List<FaultSection> parentSects) {
        double[] solSlipRates = new double[parentSects.size()];
        FaultSystemRupSet rupSet = sol.getRupSet();
        SlipAlongRuptureModel slipAlongs = rupSet.getModule(SlipAlongRuptureModel.class);
        AveSlipModule aveSlips = rupSet.requireModule(AveSlipModule.class);
        for (int s = 0; s < solSlipRates.length; ++s) {
            solSlipRates[s] = slipAlongs.calcSlipRateForSect(sol, aveSlips, parentSects.get(s).getSectionId());
        }
        return solSlipRates;
    }

    private static double rateAbove(double minMag, int sectIndex, FaultSystemSolution sol) {
        return sol.calcParticRateForSect(sectIndex, minMag, Double.POSITIVE_INFINITY);
    }

    private static double nuclRateAbove(double minMag, int sectIndex, FaultSystemSolution sol) {
        return sol.calcNucleationRateForSect(sectIndex, minMag, Double.POSITIVE_INFINITY);
    }

    private static double paleoRate(int sectIndex, FaultSystemSolution sol, PaleoProbabilityModel probModel) {
        double rate = 0.0;
        FaultSystemRupSet rupSet = sol.getRupSet();
        for (int rupIndex : rupSet.getRupturesForSection(sectIndex)) {
            double rupRate = sol.getRateForRup(rupIndex);
            if (!(rupRate > 0.0)) continue;
            rate += rupRate * probModel.getProbPaleoVisible(rupSet, rupIndex, sectIndex);
        }
        return rate;
    }

    private static double[] calcPaleoRates(List<FaultSection> sects, FaultSystemSolution sol, PaleoSlipProbabilityModel probModel) {
        double[] rates = new double[sects.size()];
        FaultSystemRupSet rupSet = sol.getRupSet();
        HashSet<Integer> rups = new HashSet<Integer>();
        HashMap<Integer, Integer> sectIndexMap = new HashMap<Integer, Integer>();
        for (int s = 0; s < sects.size(); ++s) {
            FaultSection sect = sects.get(s);
            rups.addAll(rupSet.getRupturesForSection(sect.getSectionId()));
            sectIndexMap.put(sect.getSectionId(), s);
        }
        AveSlipModule aveSlips = rupSet.requireModule(AveSlipModule.class);
        SlipAlongRuptureModel slipAlongs = rupSet.requireModule(SlipAlongRuptureModel.class);
        Iterator iterator = rups.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            double rupRate = sol.getRateForRup(rupIndex);
            if (!(rupRate > 0.0)) continue;
            double[] slipAlongRups = slipAlongs.calcSlipOnSectionsForRup(rupSet, aveSlips, rupIndex);
            List<Integer> sectIDs = rupSet.getSectionsIndicesForRup(rupIndex);
            for (int s = 0; s < slipAlongRups.length; ++s) {
                Integer index = (Integer)sectIndexMap.get(sectIDs.get(s));
                if (index == null) continue;
                double slipOnSect = slipAlongRups[s];
                double probVisible = probModel.getProbabilityOfObservedSlip(slipOnSect);
                int n = index;
                rates[n] = rates[n] + rupRate * probVisible;
            }
        }
        return rates;
    }

    static XY_DataSet copyAtY(XY_DataSet func, double y) {
        DefaultXY_DataSet ret = new DefaultXY_DataSet();
        for (Point2D pt : func) {
            ret.set(pt.getX(), y);
        }
        return ret;
    }

    static UncertainArbDiscFunc uncertCopyAtY(XY_DataSet func, double y, double stdDev) {
        ArbitrarilyDiscretizedFunc middleFunc = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : func) {
            middleFunc.set(pt.getX(), y);
        }
        return UncertainArbDiscFunc.forStdDev(middleFunc, stdDev, UncertaintyBoundType.ONE_SIGMA, false);
    }

    static UncertainArbDiscFunc uncertCopyAtY(XY_DataSet func, double y, double yLower, double yUpper) {
        ArbitrarilyDiscretizedFunc middleFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : func) {
            middleFunc.set(pt.getX(), y);
            lowerFunc.set(pt.getX(), yLower);
            upperFunc.set(pt.getX(), yUpper);
        }
        return new UncertainArbDiscFunc(middleFunc, lowerFunc, upperFunc);
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(ClusterRuptures.class);
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet;
        File inputFile = new File("/data/kevin/markdown/inversions/2022_02_14-U3_ZENG-Shaw09Mod-DsrUni-SupraB0.8-NuclMFD-ShawR0_3-reweight_MAD-conserve-10m//solution.zip");
        String name = "UCERF3";
        ZipFile zip = new ZipFile(inputFile);
        File outputDir = new File("/tmp/sect_by_sect");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        FaultSystemSolution sol = null;
        if (FaultSystemSolution.isSolution(zip)) {
            sol = FaultSystemSolution.load(zip);
            rupSet = sol.getRupSet();
        } else {
            rupSet = FaultSystemRupSet.load(zip);
        }
        SectBySectDetailPlots plot = new SectBySectDetailPlots();
        plot.writePlot(rupSet, sol, name, outputDir);
    }

    private class SectPageCallable
    implements Callable<String> {
        private ReportMetadata meta;
        private int parentSectIndex;
        private String parentName;
        private File parentsDir;
        private SectionDistanceAzimuthCalculator distAzCalc;
        private Map<Integer, List<FaultSection>> sectsByParent;
        private List<RupHistogramPlots.HistScalarValues> scalarVals;

        public SectPageCallable(ReportMetadata meta, int parentSectIndex, String parentName, File parentsDir, SectionDistanceAzimuthCalculator distAzCalc, Map<Integer, List<FaultSection>> sectsByParent, List<RupHistogramPlots.HistScalarValues> scalarVals) {
            this.meta = meta;
            this.parentSectIndex = parentSectIndex;
            this.parentName = parentName;
            this.parentsDir = parentsDir;
            this.distAzCalc = distAzCalc;
            this.sectsByParent = sectsByParent;
            this.scalarVals = scalarVals;
        }

        @Override
        public String call() throws Exception {
            return SectBySectDetailPlots.this.buildSectionPage(this.meta, this.parentSectIndex, this.parentName, this.parentsDir, this.distAzCalc, this.sectsByParent, this.scalarVals);
        }
    }

    private static class RupConnectionsData {
        private Map<Integer, List<Integer>> parentCoruptures = new HashMap<Integer, List<Integer>>();
        private HashSet<Integer> directlyConnectedParents = new HashSet();
        private Map<Integer, Double> parentCoruptureRates;
        private Map<Integer, DataUtils.MinMaxAveTracker> parentCoruptureMags;
        private Map<Integer, Integer> sectCoruptureCounts;
        private Map<Integer, Double> sectCoruptureRates;

        public RupConnectionsData(int parentSectIndex, ClusterRuptures clusterRups, FaultSystemRupSet rupSet, FaultSystemSolution sol) {
            this.parentCoruptureRates = sol == null ? null : new HashMap();
            this.sectCoruptureCounts = new HashMap<Integer, Integer>();
            this.parentCoruptureMags = new HashMap<Integer, DataUtils.MinMaxAveTracker>();
            this.sectCoruptureRates = sol == null ? null : new HashMap();
            for (int rupIndex : rupSet.getRupturesForParentSection(parentSectIndex)) {
                ClusterRupture rup = clusterRups.get(rupIndex);
                double rate = this.sectCoruptureRates == null ? Double.NaN : sol.getRateForRup(rupIndex);
                double mag = rupSet.getMagForRup(rupIndex);
                RuptureTreeNavigator nav = rup.getTreeNavigator();
                for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                    if (cluster.parentSectionID == parentSectIndex) {
                        FaultSubsectionCluster pred = nav.getPredecessor(cluster);
                        if (pred != null) {
                            this.directlyConnectedParents.add(pred.parentSectionID);
                        }
                        for (FaultSubsectionCluster desc : nav.getDescendants(cluster)) {
                            this.directlyConnectedParents.add(desc.parentSectionID);
                        }
                        continue;
                    }
                    List<Integer> coruptures = this.parentCoruptures.get(cluster.parentSectionID);
                    if (coruptures == null) {
                        coruptures = new ArrayList<Integer>();
                        this.parentCoruptures.put(cluster.parentSectionID, coruptures);
                        if (this.parentCoruptureRates != null) {
                            this.parentCoruptureRates.put(cluster.parentSectionID, rate);
                        }
                        this.parentCoruptureMags.put(cluster.parentSectionID, new DataUtils.MinMaxAveTracker());
                    } else if (this.parentCoruptureRates != null) {
                        this.parentCoruptureRates.put(cluster.parentSectionID, this.parentCoruptureRates.get(cluster.parentSectionID) + rate);
                    }
                    this.parentCoruptureMags.get(cluster.parentSectionID).addValue(mag);
                    coruptures.add(rupIndex);
                    for (FaultSection sect : cluster.subSects) {
                        Integer id = sect.getSectionId();
                        if (this.sectCoruptureCounts.containsKey(id)) {
                            this.sectCoruptureCounts.put(id, this.sectCoruptureCounts.get(id) + 1);
                            if (this.sectCoruptureRates == null) continue;
                            this.sectCoruptureRates.put(id, this.sectCoruptureRates.get(id) + rate);
                            continue;
                        }
                        this.sectCoruptureCounts.put(id, 1);
                        if (this.sectCoruptureRates == null) continue;
                        this.sectCoruptureRates.put(id, rate);
                    }
                }
            }
        }
    }

    private static class FullConnectionOneWayFilter
    implements PlausibilityFilter {
        private FaultSubsectionCluster from;
        private FaultSubsectionCluster to;
        private HashSet<FaultSection> validStarts;
        private HashSet<FaultSection> validEnds;

        public FullConnectionOneWayFilter(FaultSubsectionCluster from, FaultSubsectionCluster to) {
            this.from = from;
            this.to = to;
            this.validStarts = new HashSet();
            this.validStarts.add(from.startSect);
            this.validStarts.add((FaultSection)from.subSects.get(from.subSects.size() - 1));
            this.validEnds = new HashSet();
            this.validEnds.add(to.startSect);
            this.validEnds.add((FaultSection)to.subSects.get(to.subSects.size() - 1));
        }

        @Override
        public String getShortName() {
            return "One Way";
        }

        @Override
        public String getName() {
            return "One Way";
        }

        @Override
        public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
            if (rupture.clusters.length > 2) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            FaultSubsectionCluster firstCluster = rupture.clusters[0];
            if (firstCluster.parentSectionID != this.from.parentSectionID) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (!this.validStarts.contains(firstCluster.startSect)) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (rupture.clusters.length < 2) {
                return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
            }
            FaultSubsectionCluster secondCluster = rupture.clusters[1];
            if (secondCluster.parentSectionID != this.to.parentSectionID) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (!this.validEnds.contains(secondCluster.subSects.get(secondCluster.subSects.size() - 1))) {
                return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
            }
            return PlausibilityResult.PASS;
        }
    }

    static class AlongStrikePlot {
        private PlotSpec spec;
        private List<XY_DataSet> funcs;
        private List<PlotCurveCharacterstics> chars;
        private Range yRange;
        private boolean yLog;

        public AlongStrikePlot(PlotSpec spec, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, Range yRange, boolean yLog) {
            this.spec = spec;
            this.funcs = funcs;
            this.chars = chars;
            this.yRange = yRange;
            this.yLog = yLog;
        }
    }
}

