/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SlipRateSegmentationConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SegmentationCalculator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;

public class SegmentationPlot
extends AbstractSolutionPlot {
    private SegmentationCalculator.Scalars[] scalars;
    private double[] minMags;

    public static SegmentationCalculator.Scalars[] noCoulombScalars() {
        ArrayList<SegmentationCalculator.Scalars> newScalars = new ArrayList<SegmentationCalculator.Scalars>();
        for (SegmentationCalculator.Scalars scalar : SegmentationCalculator.Scalars.values()) {
            if (scalar.name().contains("CFF")) continue;
            newScalars.add(scalar);
        }
        return newScalars.toArray(new SegmentationCalculator.Scalars[0]);
    }

    public SegmentationPlot() {
        this(SegmentationPlot.noCoulombScalars(), null);
    }

    public SegmentationPlot(SegmentationCalculator.Scalars[] scalars, double[] minMags) {
        if (scalars == null) {
            scalars = new SegmentationCalculator.Scalars[]{};
        }
        this.scalars = scalars;
        this.minMags = minMags;
    }

    @Override
    public String getName() {
        return "Fault Segmentation";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        JumpProbabilityCalc segModel;
        String compName;
        ArrayList<String> lines = new ArrayList<String>();
        double minMag = sol.getRupSet().getMinMag();
        double[] minMags = this.minMags;
        if (minMags == null) {
            minMags = minMag >= 7.5 ? new double[]{7.5} : (minMag >= 7.0 ? new double[]{7.0, 7.5} : (minMag >= 6.5 ? new double[]{6.5, 7.0} : new double[]{0.0, 7.0}));
        }
        lines.add("The following plots show implied segmentation from the rates of this fault system solution.");
        lines.add("");
        List<ClusterRupture> inputRups = sol.getRupSet().requireModule(ClusterRuptures.class).getAll();
        PlausibilityConfiguration inputConfig = sol.getRupSet().requireModule(PlausibilityConfiguration.class);
        SectionDistanceAzimuthCalculator distAzCalc = inputConfig.getDistAzCalc();
        SegmentationCalculator inputSegCalc = new SegmentationCalculator(sol, inputRups, inputConfig.getConnectionStrategy(), distAzCalc, minMags);
        SegmentationCalculator compSegCalc = null;
        if (meta.comparison != null && meta.comparison.sol != null && meta.comparisonHasSameSects && meta.comparison.rupSet.hasAllModules(this.getRequiredModules())) {
            List<ClusterRupture> compRups = meta.comparison.rupSet.requireModule(ClusterRuptures.class).getAll();
            PlausibilityConfiguration compConfig = meta.comparison.rupSet.requireModule(PlausibilityConfiguration.class);
            compSegCalc = new SegmentationCalculator(meta.comparison.sol, compRups, compConfig.getConnectionStrategy(), distAzCalc, minMags);
        }
        String string = compName = meta.comparison == null ? null : meta.comparison.name;
        if (inputSegCalc.areMultipleJumpsPerParent() || compSegCalc != null && compSegCalc.areMultipleJumpsPerParent()) {
            PlausibilityConfiguration compConfig;
            Object names = null;
            if (inputSegCalc.areMultipleJumpsPerParent() && (inputConfig.getFilters() == null || inputConfig.getFilters().isEmpty())) {
                names = meta.primary.name;
                inputSegCalc = inputSegCalc.combineMultiJumps(true);
            }
            if (compSegCalc != null && compSegCalc.areMultipleJumpsPerParent() && ((compConfig = meta.comparison.rupSet.requireModule(PlausibilityConfiguration.class)).getFilters() == null || compConfig.getFilters().isEmpty())) {
                names = names == null ? compName : "both " + (String)names + " and " + compName;
                compSegCalc = compSegCalc.combineMultiJumps(true);
            }
            if (names != null) {
                lines.add("NOTE: " + (String)names + " has multiple jumping points between parent sections. We consolidate all jumps to occur at a single jumping point (with the highest jumping rate) and average quantities on either side of the jump (participation/slip rates)");
                lines.add("");
            }
        }
        String combiners = new SlipRateSegmentationConstraint.RateCombiner[]{SlipRateSegmentationConstraint.RateCombiner.MIN};
        File[] inputConnRates = inputSegCalc.plotConnectionRates(resourcesDir, "conn_rates", meta.primary.name);
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> inputPassthroughRates = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
        for (SlipRateSegmentationConstraint.RateCombiner combiner : combiners) {
            inputPassthroughRates.put(combiner, inputSegCalc.plotConnectionFracts(resourcesDir, "conn_passthrough_" + combiner.name(), "Connection Passthrough Rates, Relative to " + String.valueOf((Object)combiner), combiner));
        }
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> shawComps = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> shawLogComps = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
        File[] shawCompComps = null;
        File[] shawLogCompComps = null;
        for (SlipRateSegmentationConstraint.RateCombiner combiner : combiners) {
            shawComps.put(combiner, inputSegCalc.plotDistDependComparison(resourcesDir, "conn_passthrough_dist_depend", false, combiner));
            shawLogComps.put(combiner, inputSegCalc.plotDistDependComparison(resourcesDir, "conn_passthrough_dist_depend_log", true, combiner));
            if (((SlipRateSegmentationConstraint.RateCombiner[])combiners).length != 1 || compSegCalc == null) continue;
            shawCompComps = compSegCalc.plotDistDependComparison(resourcesDir, "conn_comp_passthrough_dist_depend", false, combiners[0]);
            shawLogCompComps = compSegCalc.plotDistDependComparison(resourcesDir, "conn_comp_passthrough_dist_depend_log", true, combiners[0]);
        }
        HashMap<SegmentationCalculator.Scalars, File[]> inputScalarPassthroughs = new HashMap<SegmentationCalculator.Scalars, File[]>();
        HashMap<SegmentationCalculator.Scalars, File[]> inputScalarLogPassthroughs = new HashMap<SegmentationCalculator.Scalars, File[]>();
        for (SegmentationCalculator.Scalars scalar : this.scalars) {
            inputScalarPassthroughs.put(scalar, inputSegCalc.plotFractVsScalars(resourcesDir, "conn_passthrough_" + scalar.name(), scalar, false, (SlipRateSegmentationConstraint.RateCombiner[])combiners));
            inputScalarLogPassthroughs.put(scalar, inputSegCalc.plotFractVsScalars(resourcesDir, "conn_passthrough_" + scalar.name() + "_log", scalar, true, (SlipRateSegmentationConstraint.RateCombiner[])combiners));
        }
        File[] compConnRates = null;
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> compPassthroughRates = null;
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> compPassthroughRatios = null;
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> compPassthroughDiffs = null;
        HashMap<Enum, File[]> compScalarPassthroughs = null;
        HashMap<Enum, File[]> compScalarLogPassthroughs = null;
        if (compSegCalc != null) {
            compConnRates = compSegCalc.plotConnectionRates(resourcesDir, "comp_conn_rates", compName);
            compPassthroughRates = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
            compPassthroughDiffs = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
            compPassthroughRatios = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
            for (SlipRateSegmentationConstraint.RateCombiner rateCombiner : combiners) {
                compPassthroughRates.put(rateCombiner, compSegCalc.plotConnectionFracts(resourcesDir, "comp_conn_passthrough_" + rateCombiner.name(), "Connection Passthrough Rates, Relative to " + String.valueOf((Object)rateCombiner), rateCombiner));
                compPassthroughDiffs.put(rateCombiner, inputSegCalc.plotConnectionDiffs(resourcesDir, "conn_passthrough_diff_" + rateCombiner.name(), "Connection Passthrough Differences", rateCombiner, compSegCalc));
                compPassthroughRatios.put(rateCombiner, inputSegCalc.plotConnectionLogRatios(resourcesDir, "conn_passthrough_ratio_" + rateCombiner.name(), "Connection Passthrough Ratios", rateCombiner, compSegCalc));
            }
            compScalarPassthroughs = new HashMap<Enum, File[]>();
            compScalarLogPassthroughs = new HashMap<Enum, File[]>();
            for (Enum enum_ : this.scalars) {
                compScalarPassthroughs.put(enum_, compSegCalc.plotFractVsScalars(resourcesDir, "comp_conn_passthrough_" + enum_.name(), (SegmentationCalculator.Scalars)enum_, false, (SlipRateSegmentationConstraint.RateCombiner[])combiners));
                compScalarLogPassthroughs.put(enum_, compSegCalc.plotFractVsScalars(resourcesDir, "comp_conn_passthrough_" + enum_.name() + "_log", (SegmentationCalculator.Scalars)enum_, true, (SlipRateSegmentationConstraint.RateCombiner[])combiners));
            }
        }
        String segModelName = (segModel = this.getBranchSegModel(sol.getRupSet())) == null ? null : this.getBranchSegModelChoice(sol.getRupSet()).getName();
        JumpProbabilityCalc compSegModel = compSegCalc != null ? this.getBranchSegModel(meta.comparison.rupSet) : null;
        String string2 = compSegModel == null ? null : this.getBranchSegModelChoice(meta.comparison.rupSet).getName();
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> modelCompPassthroughs = null;
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> modelCompLogPassthroughs = null;
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> compModelCompPassthroughs = null;
        HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]> compModelCompLogPassthroughs = null;
        if (segModel != null) {
            modelCompPassthroughs = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
            modelCompLogPassthroughs = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
            if (compSegModel != null) {
                compModelCompPassthroughs = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
                compModelCompLogPassthroughs = new HashMap<SlipRateSegmentationConstraint.RateCombiner, File[]>();
            }
            for (SlipRateSegmentationConstraint.RateCombiner combiner : combiners) {
                modelCompPassthroughs.put(combiner, inputSegCalc.plotConnectionModelDiffs(resourcesDir, "conn_passthrough_model_diff_" + combiner.name(), "Solution - " + segModelName, combiner, segModel));
                modelCompLogPassthroughs.put(combiner, inputSegCalc.plotConnectionModelLogRatios(resourcesDir, "conn_passthrough_model_ratio_" + combiner.name(), "Solution / " + segModelName, combiner, segModel));
                if (compSegModel == null) continue;
                compModelCompPassthroughs.put(combiner, compSegCalc.plotConnectionModelDiffs(resourcesDir, "comp_conn_passthrough_model_diff_" + combiner.name(), "Comparison Solution - " + string2, combiner, compSegModel));
                compModelCompLogPassthroughs.put(combiner, compSegCalc.plotConnectionModelLogRatios(resourcesDir, "comp_conn_passthrough_model_ratio_" + combiner.name(), "Comparison Solution / " + string2, combiner, compSegModel));
            }
        }
        for (int m = 0; m < minMags.length; ++m) {
            SegmentationCalculator.Scalars[] csvFile;
            int n;
            String relGeoPath;
            MarkdownUtils.TableBuilder table;
            if (minMags.length > 1) {
                if (minMags[m] > 0.0) {
                    lines.add(this.getSubHeading() + " M&ge;" + (float)minMags[m] + " Fault Segmentation");
                } else {
                    lines.add(this.getSubHeading() + " Supra-Seismogenic Fault Segmentation");
                }
                lines.add(topLink);
                lines.add("");
            }
            lines.add("**Connection Rates**");
            lines.add("");
            lines.add("This shows the rate at which each connection is taken.");
            lines.add("");
            if (compConnRates == null) {
                table = MarkdownUtils.tableBuilder();
                table.addLine("![Rates](" + relPathToResources + "/" + inputConnRates[m].getName() + ")");
                relGeoPath = relPathToResources + "/" + inputConnRates[m].getName().replace(".png", ".geojson");
                table.addLine(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath) + " [Download GeoJSON](" + relGeoPath + ")");
                lines.addAll(table.build());
                lines.add("");
            } else {
                table = MarkdownUtils.tableBuilder();
                table.addLine(meta.primary.name, compName);
                table.initNewLine();
                table.addColumn("![Rates](" + relPathToResources + "/" + inputConnRates[m].getName() + ")");
                table.addColumn("![Rates](" + relPathToResources + "/" + compConnRates[m].getName() + ")");
                table.finalizeLine();
                table.initNewLine();
                relGeoPath = relPathToResources + "/" + inputConnRates[m].getName().replace(".png", ".geojson");
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath) + " [Download GeoJSON](" + relGeoPath + ")");
                relGeoPath = relPathToResources + "/" + compConnRates[m].getName().replace(".png", ".geojson");
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath) + " [Download GeoJSON](" + relGeoPath + ")");
                table.finalizeLine();
                lines.addAll(table.build());
            }
            lines.add("");
            lines.add("**Connection Passthrough Rates**");
            lines.add("");
            lines.add(topLink);
            lines.add("");
            lines.add("Passthrough rates refer to the ratio of the jumping rate to the rates on either side of the jump. The denominator of that ratio can be either the minimum, maximum, or average of the subsection rates on either side of the jump. Each choice of denomiator is plotted separately.");
            lines.add("");
            if (segModel != null) {
                String line = "Results are also plotted relative to the chosen segmentaion model, " + segModel.getName() + ".";
                if (compSegModel != null) {
                    line = line + " The comparison model is shown relative to its own segmentation model, " + compSegModel.getName() + ".";
                }
                lines.add(line);
                lines.add("");
            }
            table = MarkdownUtils.tableBuilder();
            if (compSegCalc != null) {
                table.addLine(meta.primary.name, compName);
            }
            for (SlipRateSegmentationConstraint.RateCombiner combiner2 : combiners) {
                table.initNewLine();
                table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])inputPassthroughRates.get((Object)combiner2))[m].getName() + ")");
                if (compSegCalc == null) {
                    table.finalizeLine();
                    table.initNewLine();
                    String relGeoPath2 = relPathToResources + "/" + ((File[])inputPassthroughRates.get((Object)combiner2))[m].getName().replace(".png", ".geojson");
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath2) + " [Download GeoJSON](" + relGeoPath2 + ")");
                    table.finalizeLine();
                } else {
                    table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])compPassthroughRates.get((Object)combiner2))[m].getName() + ")");
                    table.finalizeLine();
                    table.initNewLine();
                    String relGeoPath2 = relPathToResources + "/" + ((File[])inputPassthroughRates.get((Object)combiner2))[m].getName().replace(".png", ".geojson");
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath2) + " [Download GeoJSON](" + relGeoPath2 + ")");
                    relGeoPath2 = relPathToResources + "/" + ((File[])compPassthroughRates.get((Object)combiner2))[m].getName().replace(".png", ".geojson");
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath2) + " [Download GeoJSON](" + relGeoPath2 + ")");
                    table.finalizeLine();
                    table.initNewLine();
                    table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])compPassthroughRatios.get((Object)combiner2))[m].getName() + ")");
                    table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])compPassthroughDiffs.get((Object)combiner2))[m].getName() + ")");
                    table.finalizeLine();
                }
                if (segModel == null) continue;
                File[] diffs = (File[])modelCompPassthroughs.get((Object)combiner2);
                File[] ratios = (File[])modelCompLogPassthroughs.get((Object)combiner2);
                File[] compDiffs = compSegModel == null ? null : (File[])compModelCompPassthroughs.get((Object)combiner2);
                File[] compRatios = compSegModel == null ? null : (File[])compModelCompLogPassthroughs.get((Object)combiner2);
                for (boolean ratio : new boolean[]{false, true}) {
                    File[] primary = ratio ? ratios : diffs;
                    File[] comp = ratio ? compRatios : compDiffs;
                    table.initNewLine();
                    table.addColumn("![Comparison](" + relPathToResources + "/" + primary[m].getName() + ")");
                    if (compSegCalc != null) {
                        if (comp == null) {
                            table.addColumn("_(N/A)_");
                        } else {
                            table.addColumn("![Comparison](" + relPathToResources + "/" + comp[m].getName() + ")");
                        }
                    }
                    table.finalizeLine();
                    table.initNewLine();
                    String relGeoPath3 = relPathToResources + "/" + primary[m].getName().replace(".png", ".geojson");
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath3) + " [Download GeoJSON](" + relGeoPath3 + ")");
                    if (compSegCalc != null) {
                        if (comp == null) {
                            table.addColumn("");
                        } else {
                            relGeoPath3 = relPathToResources + "/" + comp[m].getName().replace(".png", ".geojson");
                            table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relGeoPath3) + " [Download GeoJSON](" + relGeoPath3 + ")");
                        }
                    }
                    table.finalizeLine();
                }
            }
            lines.addAll(table.build());
            lines.add("");
            lines.add("**Connection Passthrough Rates vs Distance**");
            lines.add("");
            lines.add(topLink);
            lines.add("");
            lines.add("This plots passthrough rates versus distance, either comparing with the relationship established in Shaw and Dieterich (2007), or distance-dependent segmentation models for this model's logic tree.");
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.addLine("Linear", "Log10");
            relGeoPath = combiners;
            int combiner = ((SlipRateSegmentationConstraint.RateCombiner[])relGeoPath).length;
            for (n = 0; n < combiner; ++n) {
                SlipRateSegmentationConstraint.RateCombiner combiner2 = relGeoPath[n];
                table.initNewLine();
                table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])shawComps.get((Object)combiner2))[m].getName() + ")");
                table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])shawLogComps.get((Object)combiner2))[m].getName() + ")");
                table.finalizeLine();
            }
            if (((SlipRateSegmentationConstraint.RateCombiner[])combiners).length == 1 && compSegCalc != null) {
                table.addLine(MarkdownUtils.boldCentered("Comparison Linear"), MarkdownUtils.boldCentered("Comparison Log10"));
                table.initNewLine();
                table.addColumn("![Rates](" + relPathToResources + "/" + shawCompComps[m].getName() + ")");
                table.addColumn("![Rates](" + relPathToResources + "/" + shawLogCompComps[m].getName() + ")");
                table.finalizeLine();
            }
            lines.addAll(table.build());
            lines.add("");
            if (((SlipRateSegmentationConstraint.RateCombiner[])combiners).length == 1) {
                csvFile = ((File[])shawComps.get((Object)combiners[0]))[m];
                csvFile = new File(csvFile.getParentFile(), csvFile.getName().replaceAll(".png", ".csv"));
                Preconditions.checkState((boolean)csvFile.exists());
                if (compSegCalc == null) {
                    lines.add("Download CSV file: [" + csvFile.getName() + "](" + relPathToResources + "/" + csvFile.getName() + ")");
                } else {
                    File csvCompFile = shawCompComps[m];
                    csvCompFile = new File(csvCompFile.getParentFile(), csvCompFile.getName().replaceAll(".png", ".csv"));
                    Preconditions.checkState((boolean)csvCompFile.exists());
                    lines.add("Download CSV files: [" + meta.primary.name + "](" + relPathToResources + "/" + csvFile.getName() + ") [" + meta.comparison.name + "](" + relPathToResources + "/" + csvCompFile.getName() + ")");
                }
                lines.add("");
            }
            if (this.scalars.length > 0) {
                lines.add("**Connection Passthrough Rates vs Scalars**");
                lines.add("");
                lines.add(topLink);
                lines.add("");
                lines.add("This plots passthrough rates versus various scalar values (for each rate combiniation type).");
                lines.add("");
                csvFile = this.scalars;
                int csvCompFile = csvFile.length;
                for (n = 0; n < csvCompFile; ++n) {
                    SegmentationCalculator.Scalars scalar = csvFile[n];
                    table = MarkdownUtils.tableBuilder();
                    table.initNewLine();
                    if (compSegCalc != null) {
                        table.addColumn("");
                    }
                    String scalarName = scalar.toString().replace("|", "\\|");
                    table.addColumn(scalarName).addColumn(scalarName + " (Log10 Rates)");
                    table.finalizeLine();
                    table.initNewLine();
                    if (compSegCalc != null) {
                        table.addColumn("**" + meta.primary.name + "**");
                    }
                    table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])inputScalarPassthroughs.get((Object)scalar))[m].getName() + ")");
                    table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])inputScalarLogPassthroughs.get((Object)scalar))[m].getName() + ")");
                    table.finalizeLine();
                    if (compSegCalc != null) {
                        table.initNewLine();
                        table.addColumn("**" + compName + "**");
                        table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])compScalarPassthroughs.get((Object)scalar))[m].getName() + ")");
                        table.addColumn("![Rates](" + relPathToResources + "/" + ((File[])compScalarLogPassthroughs.get((Object)scalar))[m].getName() + ")");
                        table.finalizeLine();
                    }
                    lines.addAll(table.build());
                    lines.add("");
                }
            }
            if (((SlipRateSegmentationConstraint.RateCombiner[])combiners).length <= 1) continue;
            lines.add("**Connection Passthrough Rates for Different Rate Combiners**");
            lines.add("");
            lines.add(topLink);
            lines.add("");
            lines.add("This comapres " + meta.primary.name + " passthrough rates for each rate combiniation type. Linear on the left, log10 on the right.");
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.addLine("Linear Passthrough Rates", "Log10 Passthrough Rates");
            for (int c1 = 0; c1 < ((SlipRateSegmentationConstraint.RateCombiner[])combiners).length; ++c1) {
                for (int c2 = c1 + 1; c2 < ((SlipRateSegmentationConstraint.RateCombiner[])combiners).length; ++c2) {
                    table.initNewLine();
                    String prefix = "conn_rates_" + combiners[c1].name() + "_vs_" + combiners[c2].name();
                    File linearPlot = inputSegCalc.plotCombinerScatter(resourcesDir, prefix, false, m, combiners[c1], combiners[c2]);
                    File logPlot = inputSegCalc.plotCombinerScatter(resourcesDir, prefix + "_log", true, m, combiners[c1], combiners[c2]);
                    table.addColumn("![Scatter](" + relPathToResources + "/" + linearPlot.getName() + ")");
                    table.addColumn("![Scatter](" + relPathToResources + "/" + logPlot.getName() + ")");
                    table.finalizeLine();
                }
            }
            lines.addAll(table.build());
            lines.add("");
        }
        if (minMags.length > 1) {
            lines.add(this.getSubHeading() + " Magnitude Connection Rate Comparisons");
            lines.add(topLink);
            lines.add("");
            lines.add("This comapres " + meta.primary.name + " passthrough rates across magniutdes (and also for each rate combiniation type). Linear on the left, log10 on the right.");
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            table.addLine("Linear Passthrough Rates", "Log10 Passthrough Rates");
            for (int m1 = 0; m1 < minMags.length; ++m1) {
                for (int m2 = m1 + 1; m2 < minMags.length; ++m2) {
                    table.initNewLine();
                    String prefix = "conn_rates_" + SegmentationCalculator.getMagPrefix(minMags[m1]) + "_vs_" + SegmentationCalculator.getMagPrefix(minMags[m2]);
                    File linearPlot = inputSegCalc.plotMagScatter(resourcesDir, prefix, false, m1, m2, (SlipRateSegmentationConstraint.RateCombiner[])combiners);
                    File logPlot = inputSegCalc.plotMagScatter(resourcesDir, prefix + "_log", true, m1, m2, (SlipRateSegmentationConstraint.RateCombiner[])combiners);
                    table.addColumn("![Scatter](" + relPathToResources + "/" + linearPlot.getName() + ")");
                    table.addColumn("![Scatter](" + relPathToResources + "/" + logPlot.getName() + ")");
                    table.finalizeLine();
                }
            }
            lines.addAll(table.build());
            lines.add("");
        }
        return lines;
    }

    private SegmentationModelBranchNode getBranchSegModelChoice(FaultSystemRupSet rupSet) {
        LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        return branch.getValue(SegmentationModelBranchNode.class);
    }

    private JumpProbabilityCalc getBranchSegModel(FaultSystemRupSet rupSet) {
        SegmentationModelBranchNode segModelChoice;
        LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        if (branch != null && branch.hasValue(SegmentationModelBranchNode.class) && (segModelChoice = branch.getValue(SegmentationModelBranchNode.class)) != null) {
            return segModelChoice.getModel(rupSet, branch);
        }
        return null;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(ClusterRuptures.class, PlausibilityConfiguration.class);
    }
}

