/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchRegionalMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchSectNuclMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public class SolMFDPlot
extends AbstractRupSetPlot {
    public static final Color OBSERVED_COLOR = Color.PINK.darker();
    public static final Color SUB_SEIS_TARGET_COLOR = Color.MAGENTA.darker();
    public static final Color SUPRA_SEIS_TARGET_COLOR = Color.CYAN.darker();
    public static final double[] standardFractiles = new double[]{0.0, 0.025, 0.16, 0.84, 0.975, 1.0};
    public static final String fractileLabel = "p[0,2.5,16,84,97.5,100]";

    @Override
    public String getName() {
        return "Solution MFDs";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        void var24_28;
        if (sol == null && !rupSet.hasModule(InversionTargetMFDs.class)) {
            return null;
        }
        ArrayList<MFD_Plot> plots = new ArrayList<MFD_Plot>();
        DataUtils.MinMaxAveTracker magTrack = SolMFDPlot.rupSetMagTrack(rupSet, meta);
        System.out.println("Rup set mags: " + String.valueOf(magTrack));
        IncrementalMagFreqDist defaultMFD = SolMFDPlot.initDefaultMFD(magTrack.getMin(), magTrack.getMax());
        Range xRange = SolMFDPlot.xRange(defaultMFD);
        GridSourceProvider gridProv = sol == null ? null : sol.getGridSourceProvider();
        Region modelRegion = null;
        if (gridProv != null && gridProv.getGriddedRegion() != null) {
            modelRegion = gridProv.getGriddedRegion();
        } else if (rupSet.hasModule(ModelRegion.class)) {
            modelRegion = rupSet.getModule(ModelRegion.class).getRegion();
        }
        boolean allInside = false;
        if (modelRegion != null) {
            GriddedRegion gridReg;
            allInside = true;
            if (!(gridProv == null || (gridReg = sol.getGridSourceProvider().getGriddedRegion()) != null && modelRegion.equalsRegion(gridReg))) {
                for (int n = 0; allInside && n < gridProv.getNumLocations(); ++n) {
                    allInside = modelRegion.contains(gridProv.getLocation(n));
                }
            }
            double[] fracts = rupSet.getFractSectsInsideRegion(modelRegion, false);
            for (int s = 0; allInside && s < fracts.length; ++s) {
                allInside = fracts[s] == 1.0;
            }
        }
        MFD_Plot totalPlot = allInside ? new MFD_Plot("Total Model Region MFDs", modelRegion, null) : new MFD_Plot("Total MFDs", null, null);
        plots.add(totalPlot);
        double minY = 1.0E-6;
        double maxY = 10.0;
        InversionTargetMFDs targetMFDs = rupSet.getModule(InversionTargetMFDs.class);
        List<? extends IncrementalMagFreqDist> supraSeisSectNuclMFDs = null;
        SubSeismoOnFaultMFDs subSeisSectMFDs = null;
        if (targetMFDs != null) {
            supraSeisSectNuclMFDs = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
            subSeisSectMFDs = targetMFDs.getOnFaultSubSeisMFDs();
            totalPlot.addComp(targetMFDs.getTotalRegionalMFD(), Color.GREEN.darker(), "Total Target");
            totalPlot.addComp(targetMFDs.getTotalGriddedSeisMFD(), Color.GRAY, "Target Gridded");
            totalPlot.addComp(targetMFDs.getTotalOnFaultSubSeisMFD(), SUB_SEIS_TARGET_COLOR, "Target Sub-Seis");
            totalPlot.addComp(targetMFDs.getTotalOnFaultSupraSeisMFD(), SUPRA_SEIS_TARGET_COLOR, "Target Supra-Seis");
            List<? extends IncrementalMagFreqDist> constraints = targetMFDs.getMFD_Constraints();
            for (IncrementalMagFreqDist incrementalMagFreqDist : constraints) {
                Region region = incrementalMagFreqDist.getRegion();
                Object name = region == null || region.getName() == null || region.getName().isBlank() ? (constraints.size() == 1 ? "MFD Constraint" : "MFD Constraint " + plots.size()) : region.getName();
                if (incrementalMagFreqDist.equals(targetMFDs.getTotalOnFaultSupraSeisMFD())) {
                    totalPlot.region = region;
                } else {
                    MFD_Plot mFD_Plot = new MFD_Plot((String)name, region, null);
                    mFD_Plot.addComp(incrementalMagFreqDist, SUPRA_SEIS_TARGET_COLOR, "Target Supra-Seis");
                    plots.add(mFD_Plot);
                }
                for (Point2D pt : incrementalMagFreqDist) {
                    if (!(pt.getY() > 1.0E-10) || !xRange.contains(pt.getX())) continue;
                    minY = Math.min(minY, Math.pow(10.0, Math.floor(Math.log10(pt.getY()) + 0.1)));
                }
                for (Point2D pt : incrementalMagFreqDist.getCumRateDistWithOffset()) {
                    if (!xRange.contains(pt.getX())) continue;
                    maxY = Math.max(maxY, Math.pow(10.0, Math.ceil(Math.log10(pt.getY()) - 0.1)));
                }
            }
        }
        if (modelRegion != null && !allInside) {
            String name = modelRegion.getName();
            if (modelRegion.getName() == null || modelRegion.getName().isBlank()) {
                name = "Model Region";
            }
            MFD_Plot plot = new MFD_Plot(name, modelRegion, null);
            this.addImpliedTargets(rupSet, supraSeisSectNuclMFDs, subSeisSectMFDs, modelRegion, plot);
        }
        if (rupSet.hasModule(RegionsOfInterest.class)) {
            RegionsOfInterest roi = rupSet.getModule(RegionsOfInterest.class);
            List<Region> regions = roi.getRegions();
            List<IncrementalMagFreqDist> list = roi.getMFDs();
            List<TectonicRegionType> regionTRTs = roi.getTRTs();
            for (int i = 0; i < regions.size(); ++i) {
                IncrementalMagFreqDist mfd;
                Region region = regions.get(i);
                Object name = region.getName();
                if (name == null || ((String)name).isBlank()) {
                    name = "Region Of Interest " + i;
                }
                boolean duplicate = false;
                for (MFD_Plot mFD_Plot : plots) {
                    if (mFD_Plot.region == null || !mFD_Plot.region.equalsRegion(region)) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    System.out.println("Skipping duplicate region from ROI list: " + (String)name);
                    continue;
                }
                TectonicRegionType trt = regionTRTs == null ? null : regionTRTs.get(i);
                MFD_Plot mFD_Plot = new MFD_Plot((String)name, region, trt);
                if (list != null && (mfd = list.get(i)) != null) {
                    String mfdName = mfd.getName();
                    if (mfdName == null || mfdName.isBlank() || mfdName.equals(mfd.getDefaultName())) {
                        mfdName = "Observed";
                    }
                    mFD_Plot.addComp(mfd, OBSERVED_COLOR, mfdName);
                }
                this.addImpliedTargets(rupSet, supraSeisSectNuclMFDs, subSeisSectMFDs, region, mFD_Plot);
                plots.add(mFD_Plot);
            }
        }
        ArrayList<PlotSpec> incrSpecs = new ArrayList<PlotSpec>();
        ArrayList<PlotSpec> cmlSpecs = new ArrayList<PlotSpec>();
        Object var24_26 = null;
        ArrayList<PlotSpec[]> gridRangeCmlSpecs = null;
        if (sol != null && sol.hasModule(BranchRegionalMFDs.class) && sol.requireModule(BranchRegionalMFDs.class).hasGridded()) {
            ArrayList arrayList = new ArrayList();
            gridRangeCmlSpecs = new ArrayList<PlotSpec[]>();
        }
        for (MFD_Plot mFD_Plot : plots) {
            System.out.println("Plotting MFDs for " + mFD_Plot.name);
            ArrayList<IncrementalMagFreqDist> incrFuncs = new ArrayList<IncrementalMagFreqDist>();
            ArrayList<DiscretizedFunc> cmlFuncs = new ArrayList<DiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> incrChars = new ArrayList<PlotCurveCharacterstics>();
            ArrayList<PlotCurveCharacterstics> arrayList = new ArrayList<PlotCurveCharacterstics>();
            for (int c = 0; c < mFD_Plot.comps.size(); ++c) {
                IncrementalMagFreqDist comp = mFD_Plot.comps.get(c);
                if (comp == null) continue;
                Color color = mFD_Plot.compColors.get(c);
                comp.setName(mFD_Plot.compNames.get(c));
                incrFuncs.add(comp);
                EvenlyDiscretizedFunc cumulative = comp.getCumRateDistWithOffset();
                cmlFuncs.add(cumulative);
                PlotCurveCharacterstics pChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color);
                incrChars.add(pChar);
                arrayList.add(pChar);
                if (!(comp instanceof UncertainIncrMagFreqDist)) continue;
                UncertainBoundedIncrMagFreqDist bounded = comp instanceof UncertainBoundedIncrMagFreqDist ? ((UncertainBoundedIncrMagFreqDist)comp).deepClone() : ((UncertainIncrMagFreqDist)comp).estimateBounds(UncertaintyBoundType.ONE_SIGMA);
                bounded.setName(bounded.getBoundName());
                incrFuncs.add(bounded);
                incrChars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(color.getRed(), color.getGreen(), color.getBlue(), 60)));
                EvenlyDiscretizedFunc evenlyDiscretizedFunc = bounded.getUpper().getCumRateDistWithOffset();
                EvenlyDiscretizedFunc lowerCumulative = bounded.getLower().getCumRateDistWithOffset();
                Preconditions.checkState((cumulative.size() == evenlyDiscretizedFunc.size() ? 1 : 0) != 0);
                for (int i = 0; i < cumulative.size(); ++i) {
                    evenlyDiscretizedFunc.set(i, Math.max(cumulative.getY(i), evenlyDiscretizedFunc.getY(i)));
                    lowerCumulative.set(i, Math.max(0.0, Math.min(cumulative.getY(i), lowerCumulative.getY(i))));
                }
                UncertainArbDiscFunc cmlBounded = new UncertainArbDiscFunc(cumulative, lowerCumulative, evenlyDiscretizedFunc);
                cmlBounded.setName(bounded.getName());
                cmlFuncs.add(cmlBounded);
                arrayList.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(color.getRed(), color.getGreen(), color.getBlue(), 60)));
            }
            if (meta.comparison != null && meta.comparison.sol != null) {
                SolMFDPlot.addSolMFDs(meta.comparison.sol, "Comparison", COMP_COLOR, mFD_Plot.region, incrFuncs, cmlFuncs, incrChars, arrayList, defaultMFD, xRange, null, null, null, -1, mFD_Plot.trt);
            }
            if (sol != null) {
                int n;
                ArrayList origIncrFuncs = new ArrayList(incrFuncs);
                ArrayList origIncrChars = new ArrayList(incrChars);
                ArrayList origCmlFuncs = new ArrayList(cmlFuncs);
                ArrayList origCmlChars = new ArrayList(arrayList);
                BranchSectNuclMFDs sectDists = null;
                BranchRegionalMFDs branchMFDsModule = sol.getModule(BranchRegionalMFDs.class);
                int n2 = -1;
                if (mFD_Plot.region != null && branchMFDsModule != null) {
                    RegionsOfInterest roi = sol.getRupSet().getModule(RegionsOfInterest.class);
                    if (roi == null || !branchMFDsModule.hasRegionalMFDs()) {
                        if (mFD_Plot.region != modelRegion || !allInside) {
                            branchMFDsModule = null;
                        }
                    } else {
                        for (int r = 0; r < roi.getRegions().size(); ++r) {
                            Region testReg = roi.getRegions().get(r);
                            if (!mFD_Plot.region.equalsRegion(testReg)) continue;
                            n = r;
                            break;
                        }
                        if (n < 0) {
                            if (mFD_Plot.region != modelRegion || !allInside) {
                                branchMFDsModule = null;
                            }
                        } else {
                            System.out.println("Matched region with name '" + mFD_Plot.name + " to ROI " + n);
                        }
                    }
                }
                if (branchMFDsModule == null) {
                    sectDists = sol.getModule(BranchSectNuclMFDs.class);
                }
                double myMax = SolMFDPlot.addSolMFDs(sol, "Solution", MAIN_COLOR, mFD_Plot.region, incrFuncs, cmlFuncs, incrChars, arrayList, defaultMFD, xRange, sectDists, branchMFDsModule, BranchRegionalMFDs.MFDType.SUPRA_ONLY, n, mFD_Plot.trt);
                maxY = Math.max(maxY, Math.pow(10.0, Math.ceil(Math.log10(myMax) - 0.1)));
                if (branchMFDsModule != null && branchMFDsModule.hasGridded()) {
                    ArrayList<IncrementalMagFreqDist> gridOnlyIncrFuncs = new ArrayList<IncrementalMagFreqDist>(origIncrFuncs);
                    ArrayList<PlotCurveCharacterstics> gridOnlyIncrChars = new ArrayList<PlotCurveCharacterstics>(origIncrChars);
                    ArrayList<DiscretizedFunc> gridOnlyCmlFuncs = new ArrayList<DiscretizedFunc>(origCmlFuncs);
                    ArrayList<PlotCurveCharacterstics> gridOnlyCmlChars = new ArrayList<PlotCurveCharacterstics>(origCmlChars);
                    myMax = SolMFDPlot.addSolMFDs(sol, "Solution", MAIN_COLOR, mFD_Plot.region, gridOnlyIncrFuncs, gridOnlyCmlFuncs, gridOnlyIncrChars, gridOnlyCmlChars, defaultMFD, xRange, sectDists, branchMFDsModule, BranchRegionalMFDs.MFDType.GRID_ONLY, n, mFD_Plot.trt);
                    maxY = Math.max(maxY, Math.pow(10.0, Math.ceil(Math.log10(myMax) - 0.1)));
                    PlotSpec gridOnlyIncrSpec = new PlotSpec(gridOnlyIncrFuncs, gridOnlyIncrChars, mFD_Plot.name, "Magnitude", "Incremental Rate (per yr)");
                    PlotSpec gridOnlyCmlSpec = new PlotSpec(gridOnlyCmlFuncs, gridOnlyCmlChars, mFD_Plot.name, "Magnitude", "Cumulative Rate (per yr)");
                    gridOnlyIncrSpec.setLegendInset(true);
                    gridOnlyCmlSpec.setLegendInset(true);
                    ArrayList<IncrementalMagFreqDist> totalIncrFuncs = new ArrayList<IncrementalMagFreqDist>(origIncrFuncs);
                    ArrayList<PlotCurveCharacterstics> totalIncrChars = new ArrayList<PlotCurveCharacterstics>(origIncrChars);
                    ArrayList totalCmlFuncs = new ArrayList(origCmlFuncs);
                    ArrayList<PlotCurveCharacterstics> totalCmlChars = new ArrayList<PlotCurveCharacterstics>(origCmlChars);
                    myMax = SolMFDPlot.addSolMFDs(sol, "Solution", MAIN_COLOR, mFD_Plot.region, totalIncrFuncs, totalCmlFuncs, totalIncrChars, totalCmlChars, defaultMFD, xRange, sectDists, branchMFDsModule, BranchRegionalMFDs.MFDType.SUM, n, mFD_Plot.trt);
                    maxY = Math.max(maxY, Math.pow(10.0, Math.ceil(Math.log10(myMax) - 0.1)));
                    PlotSpec totalIncrSpec = new PlotSpec(totalIncrFuncs, totalIncrChars, mFD_Plot.name, "Magnitude", "Incremental Rate (per yr)");
                    PlotSpec totalCmlSpec = new PlotSpec(totalCmlFuncs, totalCmlChars, mFD_Plot.name, "Magnitude", "Cumulative Rate (per yr)");
                    totalIncrSpec.setLegendInset(true);
                    totalCmlSpec.setLegendInset(true);
                    var24_28.add(new PlotSpec[]{gridOnlyIncrSpec, totalIncrSpec});
                    gridRangeCmlSpecs.add(new PlotSpec[]{gridOnlyCmlSpec, totalCmlSpec});
                    if (meta.hasComparisonSol() && meta.comparison.sol.hasModule(GridSourceProvider.class)) {
                        this.removeByName(incrFuncs, incrChars, "Comparison Gridded");
                        this.removeByName(incrFuncs, incrChars, "Comparison Total");
                        this.removeByName(cmlFuncs, arrayList, "Comparison Gridded");
                        this.removeByName(cmlFuncs, arrayList, "Comparison Total");
                        this.removeByName(gridOnlyIncrFuncs, gridOnlyIncrChars, "Comparison Total");
                        this.removeByName(gridOnlyCmlFuncs, gridOnlyCmlChars, "Comparison Total");
                        this.removeByName(totalIncrFuncs, totalIncrChars, "Comparison Gridded");
                        this.removeByName(totalCmlFuncs, totalCmlChars, "Comparison Gridded");
                    }
                } else if (gridRangeCmlSpecs != null) {
                    var24_28.add(null);
                    gridRangeCmlSpecs.add(null);
                }
            }
            PlotSpec incrSpec = new PlotSpec(incrFuncs, incrChars, mFD_Plot.name, "Magnitude", "Incremental Rate (per yr)");
            PlotSpec cmlSpec = new PlotSpec(cmlFuncs, arrayList, mFD_Plot.name, "Magnitude", "Cumulative Rate (per yr)");
            incrSpec.setLegendInset(true);
            cmlSpec.setLegendInset(true);
            incrSpecs.add(incrSpec);
            cmlSpecs.add(cmlSpec);
        }
        System.out.println("MFD Y-Range: " + minY + " " + maxY);
        Range yRange = new Range(minY, maxY);
        ArrayList<Region> arrayList = new ArrayList<Region>();
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < plots.size(); ++i) {
            Iterator<FaultSection> rangeIncrSpecs;
            MFD_Plot plot = (MFD_Plot)plots.get(i);
            if (plots.size() > 1) {
                if (!lines.isEmpty()) {
                    lines.add("");
                }
                lines.add(this.getSubHeading() + " " + plot.name);
                lines.add(topLink);
                lines.add("");
                if (i == 0 && plot.region == null) {
                    lines.add("This section contains MFDs for all sources included in the model. Subsequent sections show MFDs for subsets of the model that lie in subregions.");
                    lines.add("");
                }
            }
            MarkdownUtils.TableBuilder tableBuilder = MarkdownUtils.tableBuilder();
            tableBuilder.addLine("Incremental MFDs", "Cumulative MFDs");
            if (plot.region != null) {
                arrayList.add(plot.region);
            }
            String prefix = "mfd_plot_" + SolMFDPlot.getFileSafe(plot.name);
            HeadlessGraphPanel gp = PlotUtils.initHeadless();
            gp.setTickLabelFontSize(20);
            double tick = xRange.getLength() > 3.5 ? 0.5 : (xRange.getLength() > 1.5 ? 0.25 : 0.1);
            tableBuilder.initNewLine();
            gp.drawGraphPanel((PlotSpec)incrSpecs.get(i), false, true, xRange, yRange);
            PlotUtils.setXTick(gp, tick);
            PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 1000, 850, true, true, true);
            tableBuilder.addColumn("![Incremental Plot](" + relPathToResources + "/" + prefix + ".png)");
            String cmlPrefix = prefix + "_cumulative";
            gp.drawGraphPanel((PlotSpec)cmlSpecs.get(i), false, true, xRange, yRange);
            PlotUtils.setXTick(gp, tick);
            PlotUtils.writePlots(resourcesDir, cmlPrefix, (GraphPanel)gp, 1000, 850, true, true, true);
            tableBuilder.addColumn("![Cumulative Plot](" + relPathToResources + "/" + cmlPrefix + ".png)");
            tableBuilder.finalizeLine();
            if (var24_28 != null && var24_28.get(i) != null && (rangeIncrSpecs = (PlotSpec[])var24_28.get(i)) != null) {
                PlotSpec[] plotSpecArray = (PlotSpec[])gridRangeCmlSpecs.get(i);
                tableBuilder.addLine(MarkdownUtils.boldCentered("Distribution of Gridded Seismicity"), "");
                tableBuilder.initNewLine();
                gp.drawGraphPanel((PlotSpec)((Object)rangeIncrSpecs[0]), false, true, xRange, yRange);
                PlotUtils.setXTick(gp, tick);
                String myPrefix = prefix + "_grid_only_dists";
                PlotUtils.writePlots(resourcesDir, myPrefix, (GraphPanel)gp, 1000, 850, true, true, true);
                tableBuilder.addColumn("![Incremental Plot](" + relPathToResources + "/" + myPrefix + ".png)");
                myPrefix = myPrefix + "_cumulative";
                gp.drawGraphPanel(plotSpecArray[0], false, true, xRange, yRange);
                PlotUtils.setXTick(gp, tick);
                PlotUtils.writePlots(resourcesDir, myPrefix, (GraphPanel)gp, 1000, 850, true, true, true);
                tableBuilder.addColumn("![Cumulative Plot](" + relPathToResources + "/" + myPrefix + ".png)");
                tableBuilder.finalizeLine();
                tableBuilder.addLine(MarkdownUtils.boldCentered("Distribution of Sum (Supra-Seis + Gridded)"), "");
                tableBuilder.initNewLine();
                gp.drawGraphPanel((PlotSpec)((Object)rangeIncrSpecs[1]), false, true, xRange, yRange);
                PlotUtils.setXTick(gp, tick);
                myPrefix = prefix + "_grid_sum_dists";
                PlotUtils.writePlots(resourcesDir, myPrefix, (GraphPanel)gp, 1000, 850, true, true, true);
                tableBuilder.addColumn("![Incremental Plot](" + relPathToResources + "/" + myPrefix + ".png)");
                myPrefix = myPrefix + "_cumulative";
                gp.drawGraphPanel(plotSpecArray[1], false, true, xRange, yRange);
                PlotUtils.setXTick(gp, tick);
                PlotUtils.writePlots(resourcesDir, myPrefix, (GraphPanel)gp, 1000, 850, true, true, true);
                tableBuilder.addColumn("![Cumulative Plot](" + relPathToResources + "/" + myPrefix + ".png)");
                tableBuilder.finalizeLine();
            }
            lines.addAll(tableBuilder.build());
        }
        if (!arrayList.isEmpty()) {
            double minLat = Double.POSITIVE_INFINITY;
            double d = Double.POSITIVE_INFINITY;
            double maxLat = Double.NEGATIVE_INFINITY;
            double maxLon = Double.NEGATIVE_INFINITY;
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                for (Location loc : faultSection.getFaultTrace()) {
                    minLat = Math.min(minLat, loc.getLatitude());
                    maxLat = Math.max(maxLat, loc.getLatitude());
                    d = Math.min(d, loc.getLongitude());
                    maxLon = Math.max(maxLon, loc.getLongitude());
                }
            }
            for (Region region : arrayList) {
                minLat = Math.min(minLat, region.getMinLat());
                maxLat = Math.max(maxLat, region.getMaxLat());
                d = Math.min(d, region.getMinLon());
                maxLon = Math.max(maxLon, region.getMaxLon());
            }
            double latSpan = maxLat - minLat;
            double lonSpan = maxLon - d;
            double span = Math.max(latSpan, lonSpan);
            double buffer = span > 10.0 ? 0.5 : (span > 5.0 ? 0.2 : 0.1);
            minLat = Math.max(-90.0, minLat - buffer);
            maxLat = Math.min(90.0, maxLat + buffer);
            d = Math.max(-180.0, d - buffer);
            maxLon = Math.min(d < 0.0 ? 180.0 : 360.0, maxLon + buffer);
            Region plotReg = new Region(new Location(minLat, d), new Location(maxLat, maxLon));
            RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, plotReg);
            mapMaker.plotInsetRegions(arrayList, new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK), new Color(100, 100, 200), 0.1);
            mapMaker.setWriteGeoJSON(true);
            mapMaker.setWritePDFs(true);
            mapMaker.plot(resourcesDir, "mfd_regions", "MFD Regions", lonSpan > 20.0 ? 1200 : 800);
            String relPrefix = relPathToResources + "/mfd_regions";
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Region reg : arrayList) {
                features.add(reg.toFeature());
            }
            FeatureCollection.write(new FeatureCollection(features), new File(resourcesDir, "mfd_regions_raw.geojson"));
            ArrayList<Object> regLines = new ArrayList<Object>();
            MarkdownUtils.TableBuilder linksTable = MarkdownUtils.tableBuilder().initNewLine();
            if (arrayList.size() > 1) {
                regLines.add(this.getSubHeading() + " MFD Regions");
                regLines.add(topLink);
                regLines.add("");
                regLines.add("![Regions plot](" + relPrefix + ".png)");
            } else {
                linksTable.addColumn("[View Map](" + relPrefix + ".png)");
                regLines.add("__MFD Regions:__");
            }
            linksTable.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPrefix + ".geojson"));
            linksTable.addColumn("[Download GeoJSON w/ Faults](" + relPrefix + ".geojson)");
            linksTable.addColumn("[Download Raw GeoJSON](" + relPrefix + "_raw.geojson)");
            linksTable.finalizeLine();
            regLines.add("");
            regLines.addAll(linksTable.build());
            regLines.add("");
            lines.addAll(0, regLines);
        }
        return lines;
    }

    private void removeByName(List<? extends DiscretizedFunc> funcs, List<PlotCurveCharacterstics> chars, String name) {
        int i = funcs.size();
        while (--i >= 0) {
            String funcName = funcs.get(i).getName();
            if (funcName == null || !funcName.equals(name)) continue;
            funcs.remove(i);
            chars.remove(i);
        }
    }

    private void addImpliedTargets(FaultSystemRupSet rupSet, List<? extends IncrementalMagFreqDist> supraSeisSectNuclMFDs, SubSeismoOnFaultMFDs subSeisSectMFDs, Region region, MFD_Plot plot) {
        SummedMagFreqDist target;
        if (subSeisSectMFDs != null && subSeisSectMFDs.size() == rupSet.getNumSections()) {
            System.out.println("Looking for subsection sub-seis MFDs in region: " + region.getName());
            target = SolMFDPlot.sumSectMFDsInRegion(region, rupSet, subSeisSectMFDs.getAll(), plot.trt);
            if (target != null) {
                System.out.println("Found total sub-seis rate of " + target.calcSumOfY_Vals());
                plot.addComp(target, SUB_SEIS_TARGET_COLOR, "Implied Target Sub-Seis");
            }
        }
        if (supraSeisSectNuclMFDs != null && supraSeisSectNuclMFDs.size() == rupSet.getNumSections()) {
            System.out.println("Looking for subsection nucleation MFDs in region: " + region.getName());
            target = SolMFDPlot.sumSectMFDsInRegion(region, rupSet, supraSeisSectNuclMFDs, plot.trt);
            if (target != null) {
                System.out.println("Found total supra-seis rate of " + target.calcSumOfY_Vals());
                plot.addComp(target, SUPRA_SEIS_TARGET_COLOR, "Implied Target Supra-Seis");
            }
        }
    }

    public static IncrementalMagFreqDist initDefaultMFD(double minMag, double maxMag) {
        double defaultMin = minMag > 7.0 ? 6.0 : 5.0;
        double defaultMax = maxMag > 8.8 ? 10.0 : (maxMag < 7.0 ? 8.0 : 9.0);
        return SolMFDPlot.initDefaultMFD(defaultMin, defaultMax, minMag, maxMag);
    }

    public static IncrementalMagFreqDist initDefaultMFD(double defaultMinMag, double defaultMaxMag, double minMag, double maxMag) {
        minMag = Math.min(defaultMinMag, Math.floor(minMag));
        maxMag = Math.max(defaultMaxMag, Math.ceil(maxMag));
        double delta = 0.1;
        int num = (int)(((maxMag -= 0.5 * delta) - (minMag += 0.5 * delta)) / delta + 0.5) + 1;
        if (num == 1) {
            maxMag = minMag;
        }
        return new IncrementalMagFreqDist(minMag, maxMag, num);
    }

    private static SummedMagFreqDist sumSectMFDsInRegion(Region region, FaultSystemRupSet rupSet, List<? extends IncrementalMagFreqDist> sectMFDs, TectonicRegionType targetTRT) {
        double[] fracts = rupSet.getFractSectsInsideRegion(region, false);
        Preconditions.checkState((fracts.length == sectMFDs.size() ? 1 : 0) != 0);
        double minX = Double.NaN;
        int maxSize = 0;
        boolean[] sectTRTmatch = null;
        if (targetTRT != null) {
            RupSetTectonicRegimes rupTRTs = rupSet.getModule(RupSetTectonicRegimes.class);
            if (rupTRTs == null) {
                return null;
            }
            sectTRTmatch = new boolean[rupSet.getNumSections()];
            for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
                if (rupTRTs.get(rupIndex) != targetTRT) continue;
                for (int sectIndex : rupSet.getSectionsIndicesForRup(rupIndex)) {
                    sectTRTmatch[sectIndex] = true;
                }
            }
        }
        for (int s = 0; s < sectMFDs.size(); ++s) {
            IncrementalMagFreqDist sectMFD = sectMFDs.get(s);
            if (sectMFD == null || targetTRT != null && !sectTRTmatch[s]) continue;
            if (Double.isNaN(minX)) {
                minX = sectMFD.getMinX();
            } else {
                Preconditions.checkState(((float)minX == (float)sectMFD.getMinX() ? 1 : 0) != 0);
            }
            maxSize = Integer.max(maxSize, sectMFD.size());
        }
        if (maxSize > 0) {
            AbstractDiscretizedFunc target = null;
            for (int s = 0; s < sectMFDs.size(); ++s) {
                IncrementalMagFreqDist sectMFD = sectMFDs.get(s);
                if (!(fracts[s] > 0.0) || sectMFD == null || targetTRT != null && !sectTRTmatch[s]) continue;
                if (target == null) {
                    target = new SummedMagFreqDist(minX, maxSize, sectMFD.getDelta());
                }
                if (fracts[s] != 1.0) {
                    sectMFD = sectMFD.deepClone();
                    sectMFD.scale(fracts[s]);
                }
                ((SummedMagFreqDist)target).addIncrementalMagFreqDist(sectMFD);
            }
            if (target != null && target.calcSumOfY_Vals() > 0.0) {
                return target;
            }
        }
        return null;
    }

    static Range xRange(IncrementalMagFreqDist mfd) {
        return new Range(mfd.getMinX() - 0.5 * mfd.getDelta(), mfd.getMaxX() + 0.5 * mfd.getDelta());
    }

    private static DataUtils.MinMaxAveTracker rupSetMagTrack(FaultSystemRupSet rupSet, ReportMetadata meta) {
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        track.addValue(rupSet.getMinMag());
        track.addValue(rupSet.getMaxMag());
        if (meta.comparison != null && meta.comparison.sol != null) {
            track.addValue(meta.comparison.rupSet.getMinMag());
            track.addValue(meta.comparison.rupSet.getMaxMag());
        }
        return track;
    }

    private static Color avg(Color c1, Color c2) {
        int r = c1.getRed() + c2.getRed();
        int g = c1.getGreen() + c2.getGreen();
        int b = c1.getBlue() + c2.getBlue();
        return new Color((int)Math.round((double)r * 0.5), (int)Math.round((double)g * 0.5), (int)Math.round((double)b * 0.5));
    }

    private static double addSolMFDs(FaultSystemSolution sol, String name, Color color, Region region, List<IncrementalMagFreqDist> incrFuncs, List<DiscretizedFunc> cmlFuncs, List<PlotCurveCharacterstics> incrChars, List<PlotCurveCharacterstics> cmlChars, IncrementalMagFreqDist defaultMFD, Range rangeForMax, BranchSectNuclMFDs sectDists, BranchRegionalMFDs regMFDModule, BranchRegionalMFDs.MFDType regType, int regionalIndex, TectonicRegionType trt) {
        int transAlpha = 30;
        IncrementalMagFreqDist mfd = sol.calcNucleationMFD_forRegion(region, defaultMFD.getMinX(), defaultMFD.getMaxX(), defaultMFD.size(), false, trt);
        if (sol.hasModule(GridSourceProvider.class)) {
            GridSourceProvider prov = sol.getGridSourceProvider();
            if (trt == null || prov.getTectonicRegionTypes().contains(trt)) {
                EvenlyDiscretizedFunc gridMFD = null;
                GriddedRegion gridReg = prov.getGriddedRegion();
                boolean regionTest = region != null && (gridReg == null || region != gridReg && !region.getBorder().equals(gridReg.getBorder()));
                for (int i = 0; i < prov.getNumLocations(); ++i) {
                    IncrementalMagFreqDist nodeMFD = prov.getMFD(trt, i);
                    if (nodeMFD == null || regionTest && !region.contains(prov.getLocation(i))) continue;
                    if (gridMFD == null) {
                        gridMFD = new SummedMagFreqDist(nodeMFD.getMinX(), nodeMFD.getMaxX(), nodeMFD.size());
                    } else {
                        Preconditions.checkState(((float)gridMFD.getMinX() == (float)nodeMFD.getMinX() ? 1 : 0) != 0);
                        if (gridMFD.size() < nodeMFD.size()) {
                            SummedMagFreqDist tempMFD = new SummedMagFreqDist(nodeMFD.getMinX(), nodeMFD.getMaxX(), nodeMFD.size());
                            tempMFD.addIncrementalMagFreqDist(gridMFD);
                            gridMFD = tempMFD;
                        }
                    }
                    ((SummedMagFreqDist)gridMFD).addIncrementalMagFreqDist(nodeMFD);
                }
                if (gridMFD != null) {
                    boolean includeTotal = true;
                    boolean includeGridOnly = true;
                    if (regMFDModule != null && regMFDModule.hasGridded()) {
                        includeTotal = regType == BranchRegionalMFDs.MFDType.SUM;
                        boolean bl = includeGridOnly = regType == BranchRegionalMFDs.MFDType.GRID_ONLY;
                    }
                    if (includeGridOnly) {
                        ((IncrementalMagFreqDist)gridMFD).setName((String)name + " Gridded");
                        incrFuncs.add((IncrementalMagFreqDist)gridMFD);
                        EvenlyDiscretizedFunc cmlFunc = ((IncrementalMagFreqDist)gridMFD).getCumRateDistWithOffset();
                        cmlFuncs.add(cmlFunc);
                        Color color2 = SolMFDPlot.avg(color, Color.WHITE);
                        PlotCurveCharacterstics pChar = new PlotCurveCharacterstics(PlotLineType.DASHED, regType == BranchRegionalMFDs.MFDType.GRID_ONLY ? 5.0f : 3.0f, color2);
                        incrChars.add(pChar);
                        cmlChars.add(pChar);
                        if (regMFDModule != null && regType == BranchRegionalMFDs.MFDType.GRID_ONLY && regMFDModule.hasGridded()) {
                            SolMFDPlot.addFromRegMFDs(color, incrFuncs, cmlFuncs, incrChars, cmlChars, regMFDModule, regType, regionalIndex, (IncrementalMagFreqDist)gridMFD, cmlFunc, pChar, color2, transAlpha);
                        }
                    }
                    if (includeTotal) {
                        SummedMagFreqDist totalMFD = new SummedMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
                        totalMFD.addIncrementalMagFreqDist(mfd);
                        totalMFD.addIncrementalMagFreqDist(gridMFD);
                        totalMFD.setName((String)name + " Total");
                        incrFuncs.add(totalMFD);
                        EvenlyDiscretizedFunc evenlyDiscretizedFunc = totalMFD.getCumRateDistWithOffset();
                        cmlFuncs.add(evenlyDiscretizedFunc);
                        Color myColor = color.darker();
                        PlotCurveCharacterstics pChar = new PlotCurveCharacterstics(PlotLineType.DASHED, regType == BranchRegionalMFDs.MFDType.SUM ? 5.0f : 3.0f, myColor);
                        incrChars.add(pChar);
                        cmlChars.add(pChar);
                        if (regMFDModule != null && regType == BranchRegionalMFDs.MFDType.SUM && regMFDModule.hasGridded()) {
                            SolMFDPlot.addFromRegMFDs(color, incrFuncs, cmlFuncs, incrChars, cmlChars, regMFDModule, regType, regionalIndex, totalMFD, evenlyDiscretizedFunc, pChar, myColor, transAlpha);
                        }
                    }
                    name = (String)name + " Supra-Seis";
                }
            }
        }
        mfd.setName((String)name);
        incrFuncs.add(mfd);
        EvenlyDiscretizedFunc cmlFunc = mfd.getCumRateDistWithOffset();
        cmlFuncs.add(cmlFunc);
        PlotCurveCharacterstics pChar = new PlotCurveCharacterstics(PlotLineType.SOLID, regType == null || regType == BranchRegionalMFDs.MFDType.SUPRA_ONLY ? 5.0f : 3.0f, color);
        incrChars.add(pChar);
        cmlChars.add(pChar);
        if (sectDists != null) {
            double[] sectFracts = null;
            if (region != null) {
                sectFracts = sol.getRupSet().getFractSectsInsideRegion(region, false);
            }
            IncrementalMagFreqDist[] incrPercentiles = sectDists.calcIncrementalFractiles(sectFracts, standardFractiles);
            Color transColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), transAlpha);
            PlotCurveCharacterstics minMaxChar = new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, transColor);
            for (IncrementalMagFreqDist incrementalMagFreqDist : SolMFDPlot.processIncrFractiles(incrPercentiles)) {
                incrFuncs.add(incrementalMagFreqDist);
                incrChars.add(minMaxChar);
            }
            EvenlyDiscretizedFunc[] cmlPercentiles = sectDists.calcCumulativeFractiles(sectFracts, standardFractiles);
            for (UncertainArbDiscFunc cmlBounds : SolMFDPlot.processCmlFractiles(cmlPercentiles, cmlFunc.getMinX())) {
                cmlFuncs.add(cmlBounds);
                cmlChars.add(minMaxChar);
            }
            IncrementalMagFreqDist incrementalMagFreqDist = mfd.deepClone();
            incrementalMagFreqDist.setName(null);
            incrFuncs.add(incrementalMagFreqDist);
            incrChars.add(pChar);
            EvenlyDiscretizedFunc mfd2c = cmlFunc.deepClone();
            mfd2c.setName(null);
            cmlFuncs.add(mfd2c);
            cmlChars.add(pChar);
        }
        if (regMFDModule != null && regType == BranchRegionalMFDs.MFDType.SUPRA_ONLY) {
            SolMFDPlot.addFromRegMFDs(color, incrFuncs, cmlFuncs, incrChars, cmlChars, regMFDModule, regType, regionalIndex, mfd, cmlFunc, pChar, color, transAlpha);
        }
        double maxY = 0.0;
        for (Point2D pt : cmlFunc) {
            if (!rangeForMax.contains(pt.getX())) continue;
            maxY = Math.max(maxY, pt.getY());
        }
        double minIncrMag = Double.POSITIVE_INFINITY;
        for (Point2D point2D : mfd) {
            if (!(point2D.getY() > 0.0)) continue;
            minIncrMag = point2D.getX();
            break;
        }
        if (Double.isFinite(minIncrMag)) {
            for (DiscretizedFunc discretizedFunc : cmlFuncs) {
                if (!(discretizedFunc.getMinX() < minIncrMag) || !(discretizedFunc.getMaxX() > minIncrMag)) continue;
                maxY = Math.max(maxY, discretizedFunc.getInterpolatedY_inLogYDomain(minIncrMag));
                if (!(discretizedFunc instanceof UncertainBoundedDiscretizedFunc)) continue;
                DiscretizedFunc upper = ((UncertainBoundedDiscretizedFunc)discretizedFunc).getUpper();
                maxY = Math.max(maxY, upper.getInterpolatedY_inLogYDomain(minIncrMag));
            }
        }
        return maxY;
    }

    public static void addFromRegMFDs(Color color, List<IncrementalMagFreqDist> incrFuncs, List<DiscretizedFunc> cmlFuncs, List<PlotCurveCharacterstics> incrChars, List<PlotCurveCharacterstics> cmlChars, BranchRegionalMFDs regMFDModule, BranchRegionalMFDs.MFDType regType, int regionalIndex, IncrementalMagFreqDist mfd, EvenlyDiscretizedFunc cmlFunc, PlotCurveCharacterstics pChar, Color refColor, int transAlpha) {
        EvenlyDiscretizedFunc[] cmlPercentiles;
        IncrementalMagFreqDist[] incrPercentiles;
        Preconditions.checkState((regType != null ? 1 : 0) != 0);
        if (regionalIndex >= 0) {
            incrPercentiles = regMFDModule.calcRegionalIncrementalFractiles(regType, regionalIndex, standardFractiles);
            cmlPercentiles = regMFDModule.calcRegionalCumulativeFractiles(regType, regionalIndex, standardFractiles);
        } else {
            incrPercentiles = regMFDModule.calcTotalIncrementalFractiles(regType, standardFractiles);
            cmlPercentiles = regMFDModule.calcTotalCumulativeFractiles(regType, standardFractiles);
        }
        Color transColor = new Color(refColor.getRed(), refColor.getGreen(), refColor.getBlue(), transAlpha);
        PlotCurveCharacterstics minMaxChar = new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, transColor);
        for (IncrementalMagFreqDist incrementalMagFreqDist : SolMFDPlot.processIncrFractiles(incrPercentiles)) {
            incrFuncs.add(incrementalMagFreqDist);
            incrChars.add(minMaxChar);
        }
        for (UncertainArbDiscFunc uncertainArbDiscFunc : SolMFDPlot.processCmlFractiles(cmlPercentiles, regType == BranchRegionalMFDs.MFDType.SUPRA_ONLY ? cmlFunc.getMinX() : Double.POSITIVE_INFINITY)) {
            cmlFuncs.add(uncertainArbDiscFunc);
            cmlChars.add(minMaxChar);
        }
        IncrementalMagFreqDist mfd2 = mfd.deepClone();
        mfd2.setName(null);
        incrFuncs.add(mfd2);
        incrChars.add(pChar);
        EvenlyDiscretizedFunc evenlyDiscretizedFunc = cmlFunc.deepClone();
        evenlyDiscretizedFunc.setName(null);
        cmlFuncs.add(evenlyDiscretizedFunc);
        cmlChars.add(pChar);
    }

    public static List<UncertainIncrMagFreqDist> processIncrFractiles(IncrementalMagFreqDist[] incrPercentiles) {
        ArrayList<UncertainIncrMagFreqDist> ret = new ArrayList<UncertainIncrMagFreqDist>();
        int cnt = 0;
        IncrementalMagFreqDist incrMin = incrPercentiles[cnt++];
        IncrementalMagFreqDist incrP025 = incrPercentiles[cnt++];
        IncrementalMagFreqDist incrP16 = incrPercentiles[cnt++];
        IncrementalMagFreqDist incrP84 = incrPercentiles[cnt++];
        IncrementalMagFreqDist incrP975 = incrPercentiles[cnt++];
        IncrementalMagFreqDist incrMax = incrPercentiles[cnt++];
        UncertainBoundedIncrMagFreqDist bounds = new UncertainBoundedIncrMagFreqDist(SolMFDPlot.getAvg(incrMin, incrMax), incrMin, incrMax, null);
        UncertainBoundedIncrMagFreqDist bounds95 = new UncertainBoundedIncrMagFreqDist(SolMFDPlot.getAvg(incrP025, incrP975), incrP025, incrP975, null);
        UncertainBoundedIncrMagFreqDist bounds68 = new UncertainBoundedIncrMagFreqDist(SolMFDPlot.getAvg(incrP16, incrP84), incrP16, incrP84, null);
        bounds.setName(fractileLabel);
        bounds95.setName(null);
        bounds68.setName(null);
        ret.add(bounds);
        ret.add(bounds95);
        ret.add(bounds68);
        return ret;
    }

    public static IncrementalMagFreqDist getAvg(IncrementalMagFreqDist lower, IncrementalMagFreqDist upper) {
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(lower.getMinX(), lower.size(), lower.getDelta());
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, 0.5 * (lower.getY(i) + upper.getY(i)));
        }
        return ret;
    }

    public static List<UncertainArbDiscFunc> processCmlFractiles(EvenlyDiscretizedFunc[] cmlPercentiles, double minX) {
        ArrayList<UncertainArbDiscFunc> ret = new ArrayList<UncertainArbDiscFunc>();
        int cnt = 0;
        EvenlyDiscretizedFunc cmlMin = cmlPercentiles[cnt++];
        EvenlyDiscretizedFunc cmlP025 = cmlPercentiles[cnt++];
        EvenlyDiscretizedFunc cmlP16 = cmlPercentiles[cnt++];
        EvenlyDiscretizedFunc cmlP84 = cmlPercentiles[cnt++];
        EvenlyDiscretizedFunc cmlP975 = cmlPercentiles[cnt++];
        EvenlyDiscretizedFunc cmlMax = cmlPercentiles[cnt++];
        UncertainArbDiscFunc cmlBounds = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(SolMFDPlot.getAvg(cmlMin, cmlMax), minX), SolMFDPlot.extendCumulativeToLowerBound(cmlMin, minX), SolMFDPlot.extendCumulativeToLowerBound(cmlMax, minX));
        UncertainArbDiscFunc cml95 = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(SolMFDPlot.getAvg(cmlP025, cmlP975), minX), SolMFDPlot.extendCumulativeToLowerBound(cmlP025, minX), SolMFDPlot.extendCumulativeToLowerBound(cmlP975, minX));
        UncertainArbDiscFunc cml68 = new UncertainArbDiscFunc(SolMFDPlot.extendCumulativeToLowerBound(SolMFDPlot.getAvg(cmlP16, cmlP84), minX), SolMFDPlot.extendCumulativeToLowerBound(cmlP16, minX), SolMFDPlot.extendCumulativeToLowerBound(cmlP84, minX));
        cmlBounds.setName(fractileLabel);
        cml95.setName(null);
        cml68.setName(null);
        ret.add(cmlBounds);
        ret.add(cml95);
        ret.add(cml68);
        return ret;
    }

    private static EvenlyDiscretizedFunc getAvg(EvenlyDiscretizedFunc lower, EvenlyDiscretizedFunc upper) {
        EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(lower.getMinX(), lower.size(), lower.getDelta());
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, 0.5 * (lower.getY(i) + upper.getY(i)));
        }
        return ret;
    }

    static DiscretizedFunc extendCumulativeToLowerBound(EvenlyDiscretizedFunc func, double minX) {
        if ((float)func.getMinX() <= (float)minX) {
            return func;
        }
        ArbitrarilyDiscretizedFunc ret = new ArbitrarilyDiscretizedFunc();
        ret.set(minX, func.getY(0));
        for (Point2D pt : func) {
            ret.set(pt);
        }
        return ret;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return null;
    }

    private static class MFD_Plot {
        private String name;
        private Region region;
        private TectonicRegionType trt;
        private List<IncrementalMagFreqDist> comps;
        private List<Color> compColors;
        private List<String> compNames;

        public MFD_Plot(String name, Region region, TectonicRegionType trt) {
            this.name = name;
            this.region = region;
            this.trt = trt;
            this.comps = new ArrayList<IncrementalMagFreqDist>();
            this.compColors = new ArrayList<Color>();
            this.compNames = new ArrayList<String>();
        }

        public void addComp(IncrementalMagFreqDist comp, Color color, String name) {
            this.comps.add(comp);
            this.compColors.add(color);
            this.compNames.add(name);
        }
    }
}

