/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.ComplexRuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SingleStrandRuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.faultSurface.FaultSection;

public class ClusterRupture {
    public final FaultSubsectionCluster[] clusters;
    public final ImmutableList<Jump> internalJumps;
    public final ImmutableMap<Jump, ClusterRupture> splays;
    public final UniqueRupture unique;
    private RuptureTreeNavigator navigator;
    public final UniqueRupture internalUnique;
    public final boolean singleStrand;
    private static final boolean inv_d = false;

    public ClusterRupture(FaultSubsectionCluster cluster) {
        this(new FaultSubsectionCluster[]{cluster}, (ImmutableList<Jump>)ImmutableList.of(), (ImmutableMap<Jump, ClusterRupture>)ImmutableMap.of(), cluster.unique, cluster.unique, true);
    }

    protected ClusterRupture(FaultSubsectionCluster[] clusters, ImmutableList<Jump> internalJumps, ImmutableMap<Jump, ClusterRupture> splays, UniqueRupture unique, UniqueRupture internalUnique, boolean singleStrand) {
        this.clusters = clusters;
        this.internalJumps = internalJumps;
        this.splays = splays;
        this.unique = unique;
        this.internalUnique = internalUnique;
        this.singleStrand = singleStrand;
        Preconditions.checkState((internalUnique.size() <= unique.size() ? 1 : 0) != 0);
        int expectedJumps = clusters.length - 1;
        Preconditions.checkState((internalJumps.size() == expectedJumps ? 1 : 0) != 0, (String)"Expected %s internal jumps but have %s. Rupture: %s", (Object)expectedJumps, (Object)internalJumps.size(), (Object)this);
    }

    public boolean containsInternal(FaultSection sect) {
        return this.internalUnique.contains(sect.getSectionId());
    }

    public boolean contains(FaultSection sect) {
        if (this.containsInternal(sect)) {
            return true;
        }
        for (ClusterRupture splay : this.splays.values()) {
            if (!splay.contains(sect)) continue;
            return true;
        }
        return false;
    }

    public int getTotalNumSects() {
        return this.unique.size();
    }

    public int getNumInternalSects() {
        return this.internalUnique.size();
    }

    public int getTotalNumJumps() {
        int tot = this.internalJumps.size() + this.splays.size();
        for (ClusterRupture splay : this.splays.values()) {
            tot += splay.getTotalNumJumps();
        }
        return tot;
    }

    public int getTotalNumClusters() {
        int tot = this.clusters.length;
        for (ClusterRupture splay : this.splays.values()) {
            tot += splay.getTotalNumClusters();
        }
        return tot;
    }

    public int getTotalNumSplays() {
        int tot = this.splays.size();
        for (ClusterRupture splay : this.splays.values()) {
            tot += splay.getTotalNumSplays();
        }
        return tot;
    }

    public ClusterRupture take(Jump jump) {
        boolean newSingleStrand;
        Preconditions.checkState((boolean)this.contains(jump.fromSection), (String)"Cannot take jump because this rupture doesn't have the fromSection: %s", (Object)jump);
        Preconditions.checkState((!this.contains(jump.toSection) ? 1 : 0) != 0, (String)"Cannot take jump because this rupture already has the toSection: %s", (Object)jump);
        Preconditions.checkState((boolean)jump.toSection.equals(jump.toCluster.startSect), (String)"Jump toSection is not the start section of the toCluster: jump=%s, toCluster=%s", (Object)jump, (Object)jump.toCluster);
        UniqueRupture newUnique = UniqueRupture.add(this.unique, jump.toCluster.unique);
        int expectedCount = this.unique.size() + jump.toCluster.subSects.size();
        Preconditions.checkState((newUnique.size() == expectedCount ? 1 : 0) != 0, (String)"Duplicate subsections. Have %s unique, %s total", (int)newUnique.size(), (int)expectedCount);
        boolean bl = newSingleStrand = this.singleStrand && ((FaultSection)jump.toCluster.subSects.get(0)).equals(jump.toSection);
        if (this.containsInternal(jump.fromSection)) {
            UniqueRupture newInternalUnique;
            ImmutableList newInternalJumps;
            ImmutableMap newSplays;
            FaultSubsectionCluster[] newClusters;
            FaultSubsectionCluster lastCluster = this.clusters[this.clusters.length - 1];
            if (lastCluster.endSects.contains((Object)jump.fromSection)) {
                Preconditions.checkState((boolean)lastCluster.equals(jump.fromCluster), (String)"Cannot take jump %s: it's from a section on the last cluster, but fromCluster=%s doesn't match lastCluster=%s", (Object)jump, (Object)jump.fromCluster, (Object)lastCluster);
                newClusters = Arrays.copyOf(this.clusters, this.clusters.length + 1);
                newClusters[this.clusters.length] = jump.toCluster;
                newSplays = this.splays;
                ImmutableList.Builder internalJumpBuild = ImmutableList.builderWithExpectedSize((int)(this.internalJumps.size() + 1));
                internalJumpBuild.addAll(this.internalJumps);
                internalJumpBuild.add((Object)jump);
                newInternalJumps = internalJumpBuild.build();
                newInternalUnique = UniqueRupture.add(this.internalUnique, jump.toCluster.unique);
                newSingleStrand = newSingleStrand && ((FaultSection)lastCluster.subSects.get(lastCluster.subSects.size() - 1)).equals(jump.fromSection);
            } else {
                boolean found = false;
                for (FaultSubsectionCluster cluster : this.clusters) {
                    if (!cluster.equals(jump.fromCluster)) continue;
                    found = true;
                    break;
                }
                Preconditions.checkState((boolean)found, (String)"Cannot take jump=%s: fromCluster=%s not found in rupture: %s", (Object)jump, (Object)jump.fromCluster, (Object)this);
                newClusters = this.clusters;
                ImmutableMap.Builder splayBuilder = ImmutableMap.builder();
                splayBuilder.putAll(this.splays);
                splayBuilder.put((Object)jump, (Object)new ClusterRupture(jump.toCluster));
                newSplays = splayBuilder.build();
                newInternalJumps = this.internalJumps;
                newInternalUnique = this.internalUnique;
                newSingleStrand = false;
            }
            return new ClusterRupture(newClusters, (ImmutableList<Jump>)newInternalJumps, (ImmutableMap<Jump, ClusterRupture>)newSplays, newUnique, newInternalUnique, newSingleStrand);
        }
        newSingleStrand = false;
        boolean found = false;
        ImmutableMap.Builder splayBuilder = ImmutableMap.builder();
        for (Jump splayJump : this.splays.keySet()) {
            ClusterRupture splay = (ClusterRupture)this.splays.get((Object)splayJump);
            if (splay.contains(jump.fromSection)) {
                Preconditions.checkState((!found ? 1 : 0) != 0);
                found = true;
                ClusterRupture newSplay = splay.take(jump);
                splayBuilder.put((Object)splayJump, (Object)newSplay);
                continue;
            }
            splayBuilder.put((Object)splayJump, (Object)splay);
        }
        Preconditions.checkState((boolean)found, (String)"From section for jump not found in rupture (including splays): %s", (Object)jump);
        return new ClusterRupture(this.clusters, this.internalJumps, (ImmutableMap<Jump, ClusterRupture>)splayBuilder.build(), newUnique, this.internalUnique, newSingleStrand);
    }

    public List<FaultSection> buildOrderedSectionList() {
        HashMultimap splayBranchPoints = HashMultimap.create();
        for (Jump splayJump : this.splays.keySet()) {
            ClusterRupture splay = (ClusterRupture)this.splays.get((Object)splayJump);
            splayBranchPoints.put((Object)splayJump.fromSection, (Object)splay);
        }
        ArrayList<FaultSection> ret = new ArrayList<FaultSection>();
        for (FaultSubsectionCluster cluster : this.clusters) {
            ret.addAll((Collection<FaultSection>)cluster.subSects);
            for (FaultSection sect : cluster.subSects) {
                for (ClusterRupture splay : splayBranchPoints.get((Object)sect)) {
                    ret.addAll(splay.buildOrderedSectionList());
                }
            }
        }
        return ret;
    }

    public ClusterRupture reversed() {
        Preconditions.checkState((boolean)this.singleStrand, (Object)"Can only reverse single strand ruptures");
        ArrayList<FaultSubsectionCluster> clusterList = new ArrayList<FaultSubsectionCluster>();
        int i = this.clusters.length;
        while (--i >= 0) {
            clusterList.add(this.clusters[i].reversed());
        }
        HashBasedTable jumpsTable = HashBasedTable.create();
        for (Jump jump : this.internalJumps) {
            jumpsTable.put((Object)jump.fromSection, (Object)jump.toSection, (Object)jump);
        }
        ImmutableList.Builder jumpsBuilder = ImmutableList.builder();
        for (int i2 = 1; i2 < clusterList.size(); ++i2) {
            FaultSubsectionCluster fromCluster = (FaultSubsectionCluster)clusterList.get(i2 - 1);
            FaultSection fromSection = (FaultSection)fromCluster.subSects.get(fromCluster.subSects.size() - 1);
            FaultSubsectionCluster toCluster = (FaultSubsectionCluster)clusterList.get(i2);
            FaultSection toSection = toCluster.startSect;
            Jump jump = (Jump)jumpsTable.get((Object)toSection, (Object)fromSection);
            Preconditions.checkNotNull((Object)jump, (String)"No jump found from %s to %s in rupture:\n\t%s\n\tAvailable jumps:%s", (Object)toSection.getSectionId(), (Object)fromSection.getSectionId(), (Object)this, (Object)jumpsTable);
            jumpsBuilder.add((Object)new Jump(fromSection, fromCluster, toSection, toCluster, jump.distance));
        }
        return new ClusterRupture(clusterList.toArray(new FaultSubsectionCluster[0]), (ImmutableList<Jump>)jumpsBuilder.build(), (ImmutableMap<Jump, ClusterRupture>)ImmutableMap.of(), this.unique, this.internalUnique, this.singleStrand);
    }

    public List<ClusterRupture> getPreferredAltRepresentations(RuptureConnectionSearch connSearch) {
        return this.getPreferredAltRepresentations(connSearch, false);
    }

    public List<ClusterRupture> getPreferredAltRepresentations(RuptureConnectionSearch connSearch, boolean debug) {
        ArrayList<ClusterRupture> inversions = new ArrayList<ClusterRupture>();
        if (this.singleStrand) {
            inversions.add(this.reversed());
            return inversions;
        }
        ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>();
        for (FaultSubsectionCluster faultSubsectionCluster : this.getClustersIterable()) {
            clusters.add(faultSubsectionCluster);
        }
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        for (Jump jump : this.getJumpsIterable()) {
            jumps.add(jump);
        }
        int n = this.getTotalNumClusters();
        for (FaultSubsectionCluster newStart : clusters) {
            ClusterRupture inversion = connSearch.buildClusterRupture(clusters, jumps, debug, newStart);
            Preconditions.checkState((inversion.getTotalNumClusters() == n ? 1 : 0) != 0);
            inversions.add(inversion);
        }
        return inversions;
    }

    public List<ClusterRupture> getAllAltRepresentations(ClusterConnectionStrategy connStrat, int maxNumSplays) {
        ArrayList<ClusterRupture> inversions = new ArrayList<ClusterRupture>();
        if (this.getTotalNumClusters() == 1 || this.singleStrand) {
            inversions.add(this.reversed());
            return inversions;
        }
        HashSet<FaultSubsectionCluster> availableClusters = new HashSet<FaultSubsectionCluster>();
        for (FaultSubsectionCluster cluster : this.getClustersIterable()) {
            availableClusters.add(cluster);
        }
        for (FaultSubsectionCluster startCluster : availableClusters) {
            HashSet<FaultSubsectionCluster> nextAvailable = new HashSet<FaultSubsectionCluster>();
            for (FaultSubsectionCluster avail : availableClusters) {
                if (avail == startCluster) continue;
                nextAvailable.add(avail);
            }
            this.buildAltRepsRecursive(inversions, new ClusterRupture(startCluster), nextAvailable, connStrat, maxNumSplays);
            if (startCluster.subSects.size() <= 1) continue;
            this.buildAltRepsRecursive(inversions, new ClusterRupture(startCluster.reversed()), nextAvailable, connStrat, maxNumSplays);
        }
        return inversions;
    }

    private void buildAltRepsRecursive(List<ClusterRupture> inversions, ClusterRupture curRupture, HashSet<FaultSubsectionCluster> availableClusters, ClusterConnectionStrategy connStrat, int maxNumSplays) {
        if (availableClusters.isEmpty()) {
            Preconditions.checkState((boolean)curRupture.unique.equals(this.unique));
            inversions.add(curRupture);
            return;
        }
        for (FaultSubsectionCluster nextCluster : availableClusters) {
            int numSects = nextCluster.subSects.size();
            HashSet<FaultSubsectionCluster> nextAvailable = new HashSet<FaultSubsectionCluster>();
            for (FaultSubsectionCluster avail : availableClusters) {
                if (avail == nextCluster) continue;
                nextAvailable.add(avail);
            }
            for (int i = 0; i < numSects; ++i) {
                FaultSection toSect = (FaultSection)nextCluster.subSects.get(i);
                for (Jump jump : connStrat.getJumpsFrom(toSect)) {
                    Preconditions.checkState((boolean)jump.fromSection.equals(toSect));
                    if (!curRupture.contains(jump.toSection)) continue;
                    jump = jump.reverse();
                    FaultSubsectionCluster fromCluster = null;
                    for (FaultSubsectionCluster cluster : curRupture.getClustersIterable()) {
                        if (!cluster.contains(jump.fromSection)) continue;
                        fromCluster = cluster;
                        break;
                    }
                    Preconditions.checkNotNull(fromCluster);
                    int numFromEnd = numSects - i - 1;
                    jump = numFromEnd < i || nextCluster.endSects.contains((Object)jump.toSection) ? new Jump(jump.fromSection, fromCluster, jump.toSection, nextCluster.reversed(jump.toSection), jump.distance) : new Jump(jump.fromSection, fromCluster, jump.toSection, nextCluster, jump.distance);
                    if (jump.toCluster.startSect != jump.toSection) {
                        FaultSubsectionCluster modToCluster = new FaultSubsectionCluster((List<? extends FaultSection>)jump.toCluster.subSects, jump.toSection, (Collection<FaultSection>)jump.toCluster.endSects);
                        jump = new Jump(jump.fromSection, jump.fromCluster, jump.toSection, modToCluster, jump.distance);
                    }
                    ClusterRupture nextRupture = curRupture.take(jump);
                    if (maxNumSplays >= 0 && nextRupture.getTotalNumSplays() > maxNumSplays) continue;
                    this.buildAltRepsRecursive(inversions, nextRupture, nextAvailable, connStrat, maxNumSplays);
                }
            }
        }
    }

    public RuptureTreeNavigator getTreeNavigator() {
        if (this.navigator == null) {
            this.navigator = this.singleStrand ? new SingleStrandRuptureTreeNavigator(this) : new ComplexRuptureTreeNavigator(this);
        }
        return this.navigator;
    }

    public static ClusterRupture forOrderedSingleStrandRupture(List<? extends FaultSection> sects, SectionDistanceAzimuthCalculator distCalc) {
        ArrayList<FaultSubsectionCluster> clusterList = new ArrayList<FaultSubsectionCluster>();
        ArrayList<FaultSection> curSects = null;
        int curParent = -2;
        HashSet<Integer> sectIDs = new HashSet<Integer>();
        for (FaultSection faultSection : sects) {
            if (faultSection.getParentSectionId() != curParent) {
                if (curSects != null) {
                    clusterList.add(new FaultSubsectionCluster(curSects));
                }
                curSects = new ArrayList<FaultSection>();
                curParent = faultSection.getParentSectionId();
            }
            curSects.add(faultSection);
            sectIDs.add(faultSection.getSectionId());
        }
        clusterList.add(new FaultSubsectionCluster(curSects));
        FaultSubsectionCluster[] clusters = clusterList.toArray(new FaultSubsectionCluster[0]);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 1; i < clusters.length; ++i) {
            double distance;
            FaultSubsectionCluster fromCluster = clusters[i - 1];
            FaultSection fromSect = (FaultSection)fromCluster.subSects.get(fromCluster.subSects.size() - 1);
            FaultSubsectionCluster toCluster = clusters[i];
            FaultSection toSect = toCluster.startSect;
            if (distCalc == null) {
                distance = Double.NaN;
            } else {
                distance = Double.POSITIVE_INFINITY;
                for (FaultSection s1 : fromCluster.subSects) {
                    for (FaultSection s2 : toCluster.subSects) {
                        distance = Double.min(distance, distCalc.getDistance(s1, s2));
                    }
                }
            }
            Jump jump = new Jump(fromSect, fromCluster, toSect, toCluster, distance);
            builder.add((Object)jump);
            fromCluster.addConnection(jump);
            toCluster.addConnection(jump.reverse());
        }
        UniqueRupture unique = UniqueRupture.forClusters(clusters);
        return new ClusterRupture(clusters, (ImmutableList<Jump>)builder.build(), (ImmutableMap<Jump, ClusterRupture>)ImmutableMap.of(), unique, unique, true);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder str = new StringBuilder();
        if (this.singleStrand) {
            for (FaultSubsectionCluster cluster : this.clusters) {
                str.append(cluster.toString(verbose));
            }
        } else {
            RuptureTreeNavigator nav = this.getTreeNavigator();
            for (int i = 0; i < this.clusters.length; ++i) {
                FaultSubsectionCluster cluster = this.clusters[i];
                if (i > 0) {
                    int toID = nav.getJump((FaultSubsectionCluster)this.clusters[i - 1], (FaultSubsectionCluster)cluster).toSection.getSectionId();
                    if (toID == ((FaultSection)cluster.subSects.get(0)).getSectionId()) {
                        toID = -1;
                    }
                    str.append(cluster.toString(verbose, toID));
                    continue;
                }
                str.append(cluster.toString(verbose));
            }
        }
        for (Jump jump : this.splays.keySet()) {
            ClusterRupture splay = (ClusterRupture)this.splays.get((Object)jump);
            str.append("\n\t--splay from [").append(jump.fromCluster.parentSectionID);
            if (verbose) {
                str.append(". ").append(jump.fromCluster.parentSectionName);
            }
            str.append(":").append(jump.fromSection.getSectionId()).append("]: " + String.valueOf(splay));
        }
        return str.toString();
    }

    public Iterable<Jump> getJumpsIterable() {
        if (this.splays.isEmpty()) {
            return this.internalJumps;
        }
        ArrayList<Object> iterables = new ArrayList<Object>();
        iterables.add(this.internalJumps);
        iterables.add(this.splays.keySet());
        for (ClusterRupture splay : this.splays.values()) {
            iterables.add(splay.getJumpsIterable());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<FaultSubsectionCluster> getClustersIterable() {
        if (this.splays.isEmpty()) {
            return Lists.newArrayList((Object[])this.clusters);
        }
        ArrayList<Iterable<FaultSubsectionCluster>> iterables = new ArrayList<Iterable<FaultSubsectionCluster>>();
        iterables.add(Lists.newArrayList((Object[])this.clusters));
        for (ClusterRupture splay : this.splays.values()) {
            iterables.add(splay.getClustersIterable());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<ClusterRupture> getStrandsIterable() {
        if (this.splays.isEmpty()) {
            return Lists.newArrayList((Object[])new ClusterRupture[]{this});
        }
        ArrayList<Iterable<ClusterRupture>> iterables = new ArrayList<Iterable<ClusterRupture>>();
        iterables.add(Lists.newArrayList((Object[])new ClusterRupture[]{this}));
        for (ClusterRupture splay : this.splays.values()) {
            iterables.add(splay.getStrandsIterable());
        }
        return Iterables.concat(iterables);
    }

    public static void writeJSON(File jsonFile, List<ClusterRupture> ruptures, List<? extends FaultSection> subSects) throws IOException {
        Gson gson = ClusterRupture.buildGson(subSects, ruptures.size() < 1000);
        FileWriter fw = new FileWriter(jsonFile);
        Type listType = new TypeToken<List<ClusterRupture>>(){}.getType();
        gson.toJson(ruptures, listType, (Appendable)fw);
        fw.write("\n");
        fw.close();
    }

    public static List<ClusterRupture> readJSON(File jsonFile, List<? extends FaultSection> subSects) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return ClusterRupture.readJSON(reader, subSects);
    }

    public static List<ClusterRupture> readJSON(String json, List<? extends FaultSection> subSects) {
        return ClusterRupture.readJSON(new StringReader(json), subSects);
    }

    public static List<ClusterRupture> readJSON(Reader json, List<? extends FaultSection> subSects) {
        Gson gson = ClusterRupture.buildGson(subSects, false);
        Type listType = new TypeToken<List<ClusterRupture>>(){}.getType();
        List ruptures = (List)gson.fromJson(json, listType);
        try {
            json.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ruptures;
    }

    public static Gson buildGson(List<? extends FaultSection> subSects, boolean pretty) {
        GsonBuilder builder = new GsonBuilder();
        if (pretty) {
            builder.setPrettyPrinting();
        }
        builder.registerTypeAdapter(ClusterRupture.class, (Object)new Adapter(subSects));
        Gson gson = builder.create();
        return gson;
    }

    public static class Adapter
    extends TypeAdapter<ClusterRupture> {
        private List<? extends FaultSection> subSects;
        private HashMap<FaultSubsectionCluster, FaultSubsectionCluster> prevClustersMap;

        public Adapter(List<? extends FaultSection> subSects) {
            this.subSects = subSects;
            this.prevClustersMap = new HashMap();
        }

        public void write(JsonWriter out, ClusterRupture rupture) throws IOException {
            out.beginObject();
            out.name("clusters").beginArray();
            for (FaultSubsectionCluster cluster : rupture.clusters) {
                FaultSubsectionCluster newCluster = new FaultSubsectionCluster((List<? extends FaultSection>)cluster.subSects, (Collection<FaultSection>)cluster.endSects);
                for (Jump jump : rupture.internalJumps) {
                    if (jump.fromCluster != cluster) continue;
                    newCluster.addConnection(new Jump(jump.fromSection, newCluster, jump.toSection, jump.toCluster, jump.distance));
                }
                for (Jump jump : rupture.splays.keySet()) {
                    if (jump.fromCluster != cluster) continue;
                    newCluster.addConnection(new Jump(jump.fromSection, newCluster, jump.toSection, jump.toCluster, jump.distance));
                }
                newCluster.writeJSON(out);
            }
            out.endArray();
            if (!rupture.splays.isEmpty()) {
                out.name("splays").beginArray();
                for (ClusterRupture splay : rupture.splays.values()) {
                    this.write(out, splay);
                }
                out.endArray();
            }
            out.endObject();
        }

        public ClusterRupture read(JsonReader in) throws IOException {
            UniqueRupture unique;
            ImmutableMap splays;
            ArrayList<FaultSubsectionCluster> targetClusters;
            ArrayList<FaultSubsectionCluster> internalClusterList = null;
            ArrayList<ClusterRupture> splayList = null;
            HashMap<FaultSubsectionCluster, List<FaultSubsectionCluster.JumpStub>> jumpStubsMap = new HashMap<FaultSubsectionCluster, List<FaultSubsectionCluster.JumpStub>>();
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "clusters": {
                        internalClusterList = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            internalClusterList.add(FaultSubsectionCluster.readJSON(in, this.subSects, jumpStubsMap, this.prevClustersMap));
                        }
                        in.endArray();
                        break;
                    }
                    case "splays": {
                        splayList = new ArrayList<ClusterRupture>();
                        in.beginArray();
                        while (in.hasNext()) {
                            splayList.add(this.read(in));
                        }
                        in.endArray();
                        break;
                    }
                }
            }
            in.endObject();
            if (splayList == null) {
                targetClusters = internalClusterList;
            } else {
                targetClusters = new ArrayList<FaultSubsectionCluster>(internalClusterList);
                for (ClusterRupture splay : splayList) {
                    targetClusters.add(splay.clusters[0]);
                }
            }
            FaultSubsectionCluster.buildJumpsFromStubs(targetClusters, jumpStubsMap);
            ImmutableList.Builder internalJumpsBuilder = ImmutableList.builder();
            UnmodifiableIterator clusters = internalClusterList.toArray(new FaultSubsectionCluster[0]);
            boolean singleStrand = true;
            for (int i = 0; i < ((FaultSubsectionCluster[])clusters).length - 1; ++i) {
                FaultSubsectionCluster cluster = clusters[i];
                FaultSubsectionCluster nextCluster = clusters[i + 1];
                Collection<Jump> connections = cluster.getConnectionsTo(clusters[i + 1]);
                Preconditions.checkState((connections.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 jump from %s to %s, have %s?", (Object)cluster, (Object)nextCluster, (Object)connections.size());
                Jump jump = connections.iterator().next();
                singleStrand = singleStrand && jump.fromSection.equals(cluster.subSects.get(cluster.subSects.size() - 1)) && jump.toSection.equals(nextCluster.subSects.get(0));
                internalJumpsBuilder.add((Object)jump);
            }
            ImmutableList internalJumps = internalJumpsBuilder.build();
            UniqueRupture internalUnique = UniqueRupture.forClusters((FaultSubsectionCluster[])clusters);
            if (splayList == null || splayList.isEmpty()) {
                splays = ImmutableMap.of();
                unique = internalUnique;
            } else {
                singleStrand = false;
                ImmutableMap.Builder splayBuilder = ImmutableMap.builder();
                Collections.reverse(splayList);
                for (FaultSubsectionCluster cluster : clusters) {
                    int i = splayList.size();
                    while (--i >= 0) {
                        ClusterRupture splay = (ClusterRupture)splayList.get(i);
                        Collection<Jump> connections = cluster.getConnectionsTo(splay.clusters[0]);
                        if (connections.isEmpty()) continue;
                        Preconditions.checkState((connections.size() == 1 ? 1 : 0) != 0);
                        Jump splayJump = connections.iterator().next();
                        splayBuilder.put((Object)splayJump, (Object)splay);
                        splayList.remove(i);
                    }
                    if (splayList.isEmpty()) break;
                }
                Preconditions.checkState((boolean)splayList.isEmpty(), (String)"No jumps found to %s splay(s)?", (int)splayList.size());
                splays = splayBuilder.build();
                unique = internalUnique;
                for (ClusterRupture splay : splays.values()) {
                    unique = UniqueRupture.add(unique, splay.unique);
                }
            }
            return new ClusterRupture((FaultSubsectionCluster[])clusters, (ImmutableList<Jump>)internalJumps, (ImmutableMap<Jump, ClusterRupture>)splays, unique, internalUnique, singleStrand);
        }
    }
}

