/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.faultSurface.FaultSection;

public class FaultSubsectionCluster
implements Comparable<FaultSubsectionCluster> {
    public final int parentSectionID;
    public final String parentSectionName;
    public final ImmutableList<FaultSection> subSects;
    public final FaultSection startSect;
    public final ImmutableSet<FaultSection> endSects;
    public final UniqueRupture unique;
    private final List<Jump> possibleJumps;

    public FaultSubsectionCluster(List<? extends FaultSection> subSects) {
        this(subSects, null);
    }

    public FaultSubsectionCluster(List<? extends FaultSection> subSects, Collection<FaultSection> endSects) {
        this(subSects, subSects.get(0), endSects);
    }

    public FaultSubsectionCluster(List<? extends FaultSection> subSects, FaultSection startSect, Collection<FaultSection> endSects) {
        Preconditions.checkArgument((!subSects.isEmpty() ? 1 : 0) != 0, (Object)"Must supply at least 1 subsection");
        this.subSects = ImmutableList.copyOf(subSects);
        this.startSect = startSect;
        if (endSects == null) {
            this.endSects = ImmutableSet.of((Object)subSects.get(subSects.size() - 1));
        } else {
            ImmutableSet.Builder endBuilder = ImmutableSet.builderWithExpectedSize((int)endSects.size());
            endBuilder.addAll(endSects);
            this.endSects = endBuilder.build();
        }
        this.unique = UniqueRupture.forSects(subSects);
        int parentSectionID = -1;
        String parentSectionName = null;
        for (FaultSection faultSection : subSects) {
            Preconditions.checkNotNull((Object)faultSection);
            if (parentSectionID < 0) {
                parentSectionID = faultSection.getParentSectionId();
                parentSectionName = faultSection.getParentSectionName();
                continue;
            }
            Preconditions.checkState((faultSection.getParentSectionId() == parentSectionID ? 1 : 0) != 0, (Object)"Cluster subSects list has sedctios with multiple parentSectionIDs");
        }
        this.parentSectionID = parentSectionID;
        this.parentSectionName = parentSectionName;
        this.possibleJumps = new ArrayList<Jump>();
    }

    public void addConnection(Jump jump) {
        Preconditions.checkState((jump.fromCluster == this ? 1 : 0) != 0);
        Preconditions.checkState((jump.fromSection.getParentSectionId() == this.parentSectionID ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.contains(jump.fromSection));
        for (Jump existing : this.possibleJumps) {
            if (!existing.toCluster.equals(jump.toCluster) || !existing.toSection.equals(jump.toSection) || !existing.fromSection.equals(jump.fromSection)) continue;
            return;
        }
        this.possibleJumps.add(jump);
    }

    public boolean contains(FaultSection sect) {
        return this.unique.contains(sect.getSectionId());
    }

    public Set<FaultSection> getExitPoints() {
        HashSet<FaultSection> exitPoints = new HashSet<FaultSection>();
        for (Jump jump : this.possibleJumps) {
            exitPoints.add(jump.fromSection);
        }
        return exitPoints;
    }

    public Set<FaultSubsectionCluster> getConnectedClusters() {
        HashSet<FaultSubsectionCluster> set = new HashSet<FaultSubsectionCluster>();
        for (Jump jump : this.possibleJumps) {
            set.add(jump.toCluster);
        }
        return set;
    }

    public List<FaultSubsectionCluster> getDistSortedConnectedClusters() {
        HashMap<FaultSubsectionCluster, Double> distMap = new HashMap<FaultSubsectionCluster, Double>();
        for (Jump jump : this.possibleJumps) {
            Double prevDist = (Double)distMap.get(jump.toCluster);
            if (prevDist == null) {
                distMap.put(jump.toCluster, jump.distance);
                continue;
            }
            if (!(jump.distance < prevDist)) continue;
            distMap.put(jump.toCluster, jump.distance);
        }
        return ComparablePairing.getSortedData(distMap);
    }

    public Collection<Jump> getConnectionsTo(FaultSubsectionCluster cluster) {
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        for (Jump jump : this.possibleJumps) {
            if (!jump.toCluster.equals(cluster)) continue;
            jumps.add(jump);
        }
        return jumps;
    }

    public List<Jump> getConnections() {
        return Collections.unmodifiableList(this.possibleJumps);
    }

    public Collection<Jump> getConnections(FaultSection exitPoint) {
        Preconditions.checkState((boolean)this.contains(exitPoint), (Object)"Given section is not part of this cluster");
        ArrayList<Jump> jumps = new ArrayList<Jump>();
        for (Jump jump : this.possibleJumps) {
            if (!jump.fromSection.equals(exitPoint)) continue;
            jumps.add(jump);
        }
        return jumps;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        int jumpToID = -1;
        if (this.startSect != this.subSects.get(0)) {
            jumpToID = this.startSect.getSectionId();
        }
        return this.toString(verbose, jumpToID);
    }

    public String toString(boolean verbose, int jumpToID) {
        StringBuilder str = null;
        for (FaultSection sect : this.subSects) {
            if (str == null) {
                str = verbose && this.parentSectionName != null && !this.parentSectionName.isBlank() ? new StringBuilder("[").append(this.parentSectionID).append(". ").append(this.parentSectionName).append(": ") : new StringBuilder("[").append(this.parentSectionID).append(":");
            } else {
                str.append(",");
            }
            if (sect.getSectionId() == jumpToID) {
                str.append("->");
            }
            str.append(sect.getSectionId());
        }
        return str.append("]").toString();
    }

    public FaultSubsectionCluster reversed() {
        return this.reversed(null);
    }

    public FaultSubsectionCluster reversed(FaultSection newStartSect) {
        ArrayList<FaultSection> sects = new ArrayList<FaultSection>((Collection<FaultSection>)this.subSects);
        Collections.reverse(sects);
        if (newStartSect == null) {
            newStartSect = (FaultSection)sects.get(0);
        }
        FaultSubsectionCluster reversed = new FaultSubsectionCluster(sects, newStartSect, null);
        for (Jump jump : this.possibleJumps) {
            reversed.addConnection(new Jump(jump.fromSection, reversed, jump.toSection, jump.toCluster, jump.distance));
        }
        return reversed;
    }

    @Override
    public int compareTo(FaultSubsectionCluster o) {
        int cmp = Integer.compare(this.parentSectionID, o.parentSectionID);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(this.subSects.size(), o.subSects.size());
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.subSects.size(); ++i) {
            cmp = Integer.compare(((FaultSection)this.subSects.get(i)).getSectionId(), ((FaultSection)o.subSects.get(i)).getSectionId());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endSects.hashCode();
        result = 31 * result + this.parentSectionID;
        result = 31 * result + this.startSect.hashCode();
        result = 31 * result + this.subSects.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FaultSubsectionCluster other = (FaultSubsectionCluster)obj;
        if (this.parentSectionID != other.parentSectionID) {
            return false;
        }
        if (!this.startSect.equals(other.startSect)) {
            return false;
        }
        if (!this.endSects.equals(other.endSects)) {
            return false;
        }
        return this.subSects.equals(other.subSects);
    }

    public void writeJSON(JsonWriter out) throws IOException {
        boolean simpleEndSects;
        out.beginObject();
        out.name("parentID").value((long)this.parentSectionID);
        if (!this.startSect.equals(this.subSects.get(0))) {
            out.name("startSectID").value((long)this.startSect.getSectionId());
        }
        out.name("subSectIDs").beginArray();
        for (FaultSection sect : this.subSects) {
            out.value((long)sect.getSectionId());
        }
        out.endArray();
        boolean bl = simpleEndSects = this.endSects.size() == 1;
        if (simpleEndSects) {
            simpleEndSects = ((FaultSection)this.endSects.iterator().next()).equals(this.subSects.get(this.subSects.size() - 1));
        }
        if (!simpleEndSects) {
            out.name("endSectIDs").beginArray();
            for (FaultSection sect : this.endSects) {
                out.value((long)sect.getSectionId());
            }
            out.endArray();
        }
        if (this.possibleJumps != null && !this.possibleJumps.isEmpty()) {
            out.name("connections").beginArray();
            for (Jump jump : this.possibleJumps) {
                out.beginObject();
                out.name("fromSectID").value((long)jump.fromSection.getSectionId());
                out.name("toParentID").value((long)jump.toSection.getParentSectionId());
                out.name("toSectID").value((long)jump.toSection.getSectionId());
                out.name("distance").value(jump.distance);
                out.endObject();
            }
            out.endArray();
        }
        out.endObject();
    }

    private static FaultSection getSect(List<? extends FaultSection> allSects, int sectID) {
        Preconditions.checkState((sectID >= 0 && sectID < allSects.size() ? 1 : 0) != 0, (String)"sectID=%s outside valid range: [0,%s]", (int)sectID, (int)(allSects.size() - 1));
        FaultSection sect = allSects.get(sectID);
        Preconditions.checkState((sect.getSectionId() == sectID ? 1 : 0) != 0, (String)"Subsection indexing mismatch. Section at index %s has sectID=%s", (int)sectID, (int)sect.getSectionId());
        return sect;
    }

    public static FaultSubsectionCluster readJSON(JsonReader in, List<? extends FaultSection> allSects, Map<FaultSubsectionCluster, List<JumpStub>> jumpStubsMap, Map<FaultSubsectionCluster, FaultSubsectionCluster> prevClustersMap) throws IOException {
        in.beginObject();
        Integer parentID = null;
        FaultSection startSect = null;
        ArrayList<FaultSection> subSects = null;
        ArrayList<FaultSection> endSects = null;
        ArrayList<JumpStub> jumps = null;
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "parentID": {
                    parentID = in.nextInt();
                    break;
                }
                case "startSectID": {
                    startSect = FaultSubsectionCluster.getSect(allSects, in.nextInt());
                    break;
                }
                case "subSectIDs": {
                    in.beginArray();
                    subSects = new ArrayList<FaultSection>();
                    while (in.hasNext()) {
                        subSects.add(FaultSubsectionCluster.getSect(allSects, in.nextInt()));
                    }
                    in.endArray();
                    break;
                }
                case "endSectIDs": {
                    in.beginArray();
                    endSects = new ArrayList<FaultSection>();
                    while (in.hasNext()) {
                        endSects.add(FaultSubsectionCluster.getSect(allSects, in.nextInt()));
                    }
                    in.endArray();
                    break;
                }
                case "connections": {
                    in.beginArray();
                    jumps = new ArrayList<JumpStub>();
                    while (in.hasNext()) {
                        in.beginObject();
                        FaultSection fromSect = null;
                        FaultSection toSect = null;
                        Double distance = null;
                        Integer toParentID = null;
                        while (in.hasNext()) {
                            switch (in.nextName()) {
                                case "fromSectID": {
                                    fromSect = FaultSubsectionCluster.getSect(allSects, in.nextInt());
                                    break;
                                }
                                case "toSectID": {
                                    toSect = FaultSubsectionCluster.getSect(allSects, in.nextInt());
                                    break;
                                }
                                case "toParentID": {
                                    toParentID = in.nextInt();
                                    break;
                                }
                                case "distance": {
                                    distance = in.nextDouble();
                                    break;
                                }
                            }
                        }
                        Preconditions.checkNotNull(fromSect, (Object)"Jump fromSectID not specified");
                        Preconditions.checkNotNull(toSect, (Object)"Jump toSectID not specified");
                        Preconditions.checkNotNull(toParentID, (Object)"Jump toParentSectID not specified");
                        Preconditions.checkState((toParentID.intValue() == toSect.getParentSectionId() ? 1 : 0) != 0, (String)"toParentID=%s but toSect.getParentSectionId()=%s", (Object)toParentID, (int)toSect.getParentSectionId());
                        Preconditions.checkNotNull((Object)distance, (Object)"Jump distance not specified");
                        jumps.add(new JumpStub(fromSect, toSect, distance));
                        in.endObject();
                    }
                    in.endArray();
                    break;
                }
            }
        }
        Preconditions.checkNotNull(parentID, (Object)"Cluster parentID not specified");
        Preconditions.checkNotNull(subSects, (Object)"Cluster subSects not specified");
        if (startSect == null) {
            startSect = (FaultSection)subSects.get(0);
        }
        FaultSubsectionCluster cluster = new FaultSubsectionCluster(subSects, startSect, endSects);
        if (prevClustersMap != null) {
            if (prevClustersMap.containsKey(cluster)) {
                cluster = prevClustersMap.get(cluster);
            } else {
                prevClustersMap.put(cluster, cluster);
            }
        }
        if (jumps != null) {
            if (jumpStubsMap == null) {
                System.err.println("WARNING: skipping loading all jumps (jumpStubsMap is null)");
            } else {
                jumpStubsMap.put(cluster, jumps);
            }
        }
        in.endObject();
        return cluster;
    }

    public static void buildJumpsFromStubs(Collection<FaultSubsectionCluster> clusters, Map<FaultSubsectionCluster, List<JumpStub>> jumpStubsMap) {
        if (jumpStubsMap.isEmpty()) {
            return;
        }
        HashMap<Integer, ArrayList<FaultSubsectionCluster>> parentIDsMap = new HashMap<Integer, ArrayList<FaultSubsectionCluster>>();
        for (FaultSubsectionCluster cluster : clusters) {
            ArrayList<FaultSubsectionCluster> parentClusters = (ArrayList<FaultSubsectionCluster>)parentIDsMap.get(cluster.parentSectionID);
            if (parentClusters == null) {
                parentClusters = new ArrayList<FaultSubsectionCluster>();
                parentIDsMap.put(cluster.parentSectionID, parentClusters);
            }
            parentClusters.add(cluster);
        }
        for (FaultSubsectionCluster fromCluster : jumpStubsMap.keySet()) {
            List<JumpStub> jumpStubs = jumpStubsMap.get(fromCluster);
            for (JumpStub stub : jumpStubs) {
                int toParent = stub.toSection.getParentSectionId();
                FaultSubsectionCluster toCluster = null;
                for (FaultSubsectionCluster possible : (List)parentIDsMap.get(toParent)) {
                    if (!possible.contains(stub.toSection)) continue;
                    toCluster = possible;
                    break;
                }
                Preconditions.checkNotNull(toCluster, (String)"Jump to a non-existent cluster with parentID=%s", (int)toParent);
                Preconditions.checkState((stub.fromSection.getParentSectionId() == fromCluster.parentSectionID ? 1 : 0) != 0, (Object)"Jump fromSect is from an unexpected parent section");
                Preconditions.checkState((boolean)fromCluster.contains(stub.fromSection), (Object)"Jump fromSect is from an unexpected parent section");
                fromCluster.addConnection(new Jump(stub.fromSection, fromCluster, stub.toSection, toCluster, stub.distance));
            }
        }
    }

    public static class JumpStub {
        final FaultSection fromSection;
        final FaultSection toSection;
        final double distance;

        public JumpStub(FaultSection fromSection, FaultSection toSection, double distance) {
            this.fromSection = fromSection;
            this.toSection = toSection;
            this.distance = distance;
        }
    }
}

