/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Objects;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.faultSurface.FaultSection;

public class Jump {
    public final FaultSection fromSection;
    public final FaultSubsectionCluster fromCluster;
    public final FaultSection toSection;
    public final FaultSubsectionCluster toCluster;
    public final double distance;
    private static final DecimalFormat distDF = new DecimalFormat("0.0");
    public static final Comparator<Jump> id_comparator = new Comparator<Jump>(){

        @Override
        public int compare(Jump o1, Jump o2) {
            int cmp = Jump.compareIDs(o1.fromCluster, o1.fromSection, o2.fromCluster, o2.fromSection);
            if (cmp == 0) {
                cmp = Jump.compareIDs(o1.toCluster, o1.toSection, o2.toCluster, o2.toSection);
            }
            return cmp;
        }
    };
    public static final Comparator<Jump> dist_comparator = new Comparator<Jump>(){

        @Override
        public int compare(Jump o1, Jump o2) {
            return Double.compare(o1.distance, o2.distance);
        }
    };

    public Jump(FaultSection fromSection, FaultSubsectionCluster fromCluster, FaultSection toSection, FaultSubsectionCluster toCluster, double distance) {
        if (fromSection == null || fromCluster == null || toSection == null || toCluster == null) {
            throw new IllegalArgumentException("Nulls not allowed in Jump constructor");
        }
        this.fromSection = fromSection;
        this.fromCluster = fromCluster;
        this.toSection = toSection;
        this.toCluster = toCluster;
        this.distance = distance;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.fromCluster.parentSectionID).append("[").append(this.fromSection.getSectionId()).append("]=>");
        str.append(this.toCluster.parentSectionID).append("[").append(this.toSection.getSectionId()).append("]");
        str.append(", ").append(distDF.format(this.distance)).append(" km");
        return str.toString();
    }

    public Jump reverse() {
        return new Jump(this.toSection, this.toCluster, this.fromSection, this.fromCluster, this.distance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromCluster.parentSectionID;
        result = 31 * result + this.fromSection.getSectionId();
        result = 31 * result + this.toCluster.parentSectionID;
        result = 31 * result + this.toSection.getSectionId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Jump other = (Jump)obj;
        if (this.fromCluster.parentSectionID != other.fromCluster.parentSectionID) {
            return false;
        }
        if (this.fromSection.getSectionId() != other.fromSection.getSectionId()) {
            return false;
        }
        if (this.toCluster.parentSectionID != other.toCluster.parentSectionID) {
            return false;
        }
        return this.toSection.getSectionId() == other.toSection.getSectionId();
    }

    private static int compareIDs(FaultSubsectionCluster cluster1, FaultSection jumpSect1, FaultSubsectionCluster cluster2, FaultSection jumpSect2) {
        int cmp = Integer.compare(cluster1.parentSectionID, cluster2.parentSectionID);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(jumpSect1.getSectionId(), jumpSect2.getSectionId());
        if (cmp != 0) {
            return cmp;
        }
        return cluster1.compareTo(cluster2);
    }

    public static class UniqueDistJump
    extends Jump {
        public UniqueDistJump(Jump jump) {
            this(jump.fromSection, jump.fromCluster, jump.toSection, jump.toCluster, jump.distance);
        }

        public UniqueDistJump(FaultSection fromSection, FaultSubsectionCluster fromCluster, FaultSection toSection, FaultSubsectionCluster toCluster, double distance) {
            super(fromSection, fromCluster, toSection, toCluster, distance);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(Float.valueOf((float)this.distance));
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueDistJump other = (UniqueDistJump)obj;
            return Float.floatToIntBits((float)this.distance) == Float.floatToIntBits((float)other.distance);
        }

        @Override
        public UniqueDistJump reverse() {
            return new UniqueDistJump(this.toSection, this.toCluster, this.fromSection, this.fromCluster, this.distance);
        }
    }
}

