/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility;

import com.google.common.base.Preconditions;

public enum PlausibilityResult {
    PASS(true, true),
    FAIL_FUTURE_POSSIBLE(false, true),
    FAIL_HARD_STOP(false, false);

    private boolean pass;
    private boolean cont;

    private PlausibilityResult(boolean pass, boolean cont) {
        if (pass) {
            Preconditions.checkState((boolean)cont);
        }
        this.pass = pass;
        this.cont = cont;
    }

    public boolean isPass() {
        return this.pass;
    }

    public boolean canContinue() {
        return this.cont;
    }

    public PlausibilityResult logicalAnd(PlausibilityResult result) {
        boolean newCont;
        boolean newPass = this.pass && result.pass;
        boolean bl = newCont = this.cont && result.cont;
        if (newPass) {
            return PASS;
        }
        if (newCont) {
            return FAIL_FUTURE_POSSIBLE;
        }
        return FAIL_HARD_STOP;
    }

    public PlausibilityResult logicalOr(PlausibilityResult result) {
        boolean newCont;
        boolean newPass = this.pass || result.pass;
        boolean bl = newCont = this.cont || result.cont;
        if (newPass) {
            return PASS;
        }
        if (newCont) {
            return FAIL_FUTURE_POSSIBLE;
        }
        return FAIL_HARD_STOP;
    }
}

