/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import java.util.ArrayList;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.faultSurface.FaultSection;

abstract class AbstractClusterSizeFilter
implements PlausibilityFilter {
    boolean allowIfNoDirect;
    boolean allowChained;
    ClusterConnectionStrategy connStrategy;

    AbstractClusterSizeFilter(boolean allowIfNoDirect, boolean allowChained, ClusterConnectionStrategy connStrategy) {
        this.allowIfNoDirect = allowIfNoDirect;
        this.allowChained = allowChained;
        this.connStrategy = connStrategy;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        PlausibilityResult result = this.apply(rupture.clusters, verbose);
        if (result.canContinue()) {
            for (Jump jump : rupture.splays.keySet()) {
                ClusterRupture splay = (ClusterRupture)rupture.splays.get((Object)jump);
                FaultSubsectionCluster[] strand = splay.clusters;
                if (this.allowIfNoDirect && !this.isClusterSufficient(strand[0]) && strand.length > 1) {
                    ArrayList<FaultSection> beforeSects = new ArrayList<FaultSection>();
                    for (FaultSection sect : jump.fromCluster.subSects) {
                        beforeSects.add(sect);
                        if (!sect.equals(jump.fromSection)) continue;
                        break;
                    }
                    FaultSubsectionCluster[] newStrand = new FaultSubsectionCluster[strand.length + 1];
                    newStrand[0] = new FaultSubsectionCluster(beforeSects);
                    System.arraycopy(strand, 0, newStrand, 1, strand.length);
                    strand = newStrand;
                }
                result = result.logicalAnd(this.apply(strand, verbose));
            }
        }
        return result;
    }

    abstract boolean isClusterSufficient(FaultSubsectionCluster var1);

    abstract String getQuantityStr(FaultSubsectionCluster var1);

    private boolean isDirectPossible(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        return this.connStrategy.areParentSectsConnected(from.parentSectionID, to.parentSectionID);
    }

    private PlausibilityResult apply(FaultSubsectionCluster[] clusters, boolean verbose) {
        if (!this.isClusterSufficient(clusters[0])) {
            if (verbose) {
                System.out.println("First cluster (" + String.valueOf(clusters[0]) + ") fails with " + this.getQuantityStr(clusters[0]));
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        if (this.allowIfNoDirect) {
            int streak = 0;
            for (int i = 1; i < clusters.length; ++i) {
                if (!this.isClusterSufficient(clusters[i])) {
                    if (verbose) {
                        System.out.println("Cluster " + i + " (" + String.valueOf(clusters[i]) + ") fails with " + this.getQuantityStr(clusters[i]));
                    }
                    if (++streak > 1) {
                        if (!this.allowChained) {
                            return PlausibilityResult.FAIL_HARD_STOP;
                        }
                        if (this.isDirectPossible(clusters[i - streak], clusters[i])) {
                            return PlausibilityResult.FAIL_HARD_STOP;
                        }
                    }
                    if (!this.allowChained) {
                        if (streak > 1) {
                            return PlausibilityResult.FAIL_HARD_STOP;
                        }
                    } else if (streak > 1) {
                        // empty if block
                    }
                    if (i == clusters.length - 1) {
                        return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
                    }
                    if (this.isDirectPossible(clusters[i - 1], clusters[i + 1])) {
                        return PlausibilityResult.FAIL_HARD_STOP;
                    }
                    if (streak <= 1 || !this.isDirectPossible(clusters[i - streak], clusters[i + 1])) continue;
                    return PlausibilityResult.FAIL_HARD_STOP;
                }
                streak = 0;
            }
            return PlausibilityResult.PASS;
        }
        for (int i = 1; i < clusters.length - 1; ++i) {
            if (this.isClusterSufficient(clusters[i])) continue;
            if (verbose) {
                System.out.println("Cluster " + i + " (" + String.valueOf(clusters[i]) + ") fails with " + this.getQuantityStr(clusters[i]));
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        if (!this.isClusterSufficient(clusters[clusters.length - 1])) {
            if (verbose) {
                System.out.println("Cluster " + (clusters.length - 1) + " (" + String.valueOf(clusters[clusters.length - 1]) + ") fails with " + this.getQuantityStr(clusters[clusters.length - 1]));
            }
            return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
        }
        return PlausibilityResult.PASS;
    }
}

