/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.text.DecimalFormat;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class CumulativeAzimuthChangeFilter
implements ScalarValuePlausibiltyFilter<Float> {
    private JumpAzimuthChangeFilter.AzimuthCalc azCalc;
    private float threshold;
    private static final DecimalFormat df = new DecimalFormat("0.#");

    public CumulativeAzimuthChangeFilter(JumpAzimuthChangeFilter.AzimuthCalc calc, float threshold) {
        this.azCalc = calc;
        this.threshold = threshold;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.getTotalNumSects() < 3) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing with <3 sects");
            }
            return PlausibilityResult.PASS;
        }
        RuptureTreeNavigator navigator = rupture.getTreeNavigator();
        double tot = this.calc(navigator, rupture.clusters[0].startSect, null, null, verbose);
        if ((float)tot <= this.threshold) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing with tot=" + tot);
            }
            return PlausibilityResult.PASS;
        }
        if (verbose) {
            System.out.println(this.getShortName() + ": failing with tot=" + tot);
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    private double calc(RuptureTreeNavigator navigator, FaultSection sect1, FaultSection sect2, FaultSection sect3, boolean verbose) {
        Preconditions.checkNotNull((Object)sect1);
        if (sect2 == null) {
            double tot = 0.0;
            for (FaultSection descendant : navigator.getDescendants(sect1)) {
                tot += this.calc(navigator, sect1, descendant, null, verbose);
            }
            return tot;
        }
        if (sect3 == null) {
            double tot = 0.0;
            for (FaultSection descendant : navigator.getDescendants(sect2)) {
                if (!((float)(tot += this.calc(navigator, sect1, sect2, descendant, verbose)) > this.threshold) || verbose) continue;
                return tot;
            }
            return tot;
        }
        double tot = this.doCalc(sect1, sect2, sect3, verbose);
        if ((float)tot > this.threshold) {
            return tot;
        }
        for (FaultSection descendant : navigator.getDescendants(sect3)) {
            if (!((float)(tot += this.calc(navigator, sect2, sect3, descendant, verbose)) > this.threshold) || verbose) continue;
            return tot;
        }
        return tot;
    }

    private double doCalc(FaultSection sect1, FaultSection sect2, FaultSection sect3, boolean verbose) {
        double beforeAz = this.azCalc.calcAzimuth(sect1, sect2);
        double afterAz = this.azCalc.calcAzimuth(sect2, sect3);
        double val = Math.abs(JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz));
        if (verbose && (float)val > 0.0f) {
            System.out.println(this.getShortName() + ": [" + sect1.getSectionId() + "=>" + sect2.getSectionId() + "]=" + beforeAz + "\t[" + sect2.getSectionId() + "=>" + sect3.getSectionId() + "]=" + afterAz + ",\tdiff=" + val);
        }
        return val;
    }

    @Override
    public String getShortName() {
        return "CumAzimuth\u2264" + df.format(this.threshold);
    }

    @Override
    public String getName() {
        return "Cumulative Azimuth \u2264" + df.format(this.threshold);
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        if (rupture.getTotalNumSects() < 3) {
            return Float.valueOf(0.0f);
        }
        RuptureTreeNavigator navigator = rupture.getTreeNavigator();
        return Float.valueOf((float)this.calc(navigator, rupture.clusters[0].startSect, null, null, false));
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atMost((Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public String getScalarName() {
        return "Cumulative Azimuth Change";
    }

    @Override
    public String getScalarUnits() {
        return "Degrees";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

