/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class DirectPathPlausibilityFilter
implements PlausibilityFilter {
    private transient HashMap<IDPairing, Double> sectJumps;
    private boolean onlyLargerDist;

    public DirectPathPlausibilityFilter(ClusterConnectionStrategy connStrat, boolean onlyLargerDist) {
        this.onlyLargerDist = onlyLargerDist;
        this.sectJumps = new HashMap();
        for (Jump jump : connStrat.getAllPossibleJumps()) {
            this.sectJumps.put(this.pairing(jump.fromSection, jump.toSection), jump.distance);
        }
    }

    private IDPairing pairing(FaultSection from, FaultSection to) {
        int id2;
        int id1 = from.getSectionId();
        if (id1 < (id2 = to.getSectionId())) {
            return new IDPairing(id1, id2);
        }
        return new IDPairing(id2, id1);
    }

    @Override
    public String getShortName() {
        return "NoIndirect";
    }

    @Override
    public String getName() {
        return "No Indirect Connections";
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        PlausibilityResult result = this.evaluate(rupture, new ArrayList<FaultSection>(), verbose);
        for (Jump splayJump : rupture.splays.keySet()) {
            ClusterRupture splay = (ClusterRupture)rupture.splays.get((Object)splayJump);
            result = result.logicalAnd(this.evaluate(splay, Lists.newArrayList((Object[])new FaultSection[]{splayJump.fromSection}), verbose));
        }
        return result;
    }

    private double calcJumpDistBetween(RuptureTreeNavigator nav, FaultSection from, FaultSection to) {
        double dist = 0.0;
        FaultSection sect = to;
        while (true) {
            FaultSection predecessor = nav.getPredecessor(sect);
            Preconditions.checkNotNull((Object)predecessor, (String)"Didn't find path between %s and %s, stalled out at %s", (Object)from.getSectionId(), (Object)to.getSectionId(), (Object)sect.getSectionId());
            if (predecessor.getParentSectionId() != sect.getParentSectionId()) {
                dist += nav.getJump((FaultSection)predecessor, (FaultSection)sect).distance;
            }
            if (predecessor.equals(from)) break;
            sect = predecessor;
        }
        return dist;
    }

    private PlausibilityResult evaluate(ClusterRupture rupture, List<FaultSection> prevFroms, boolean verbose) {
        PlausibilityResult result = PlausibilityResult.PASS;
        for (Jump jump : rupture.internalJumps) {
            block1: for (FaultSection prevFrom : prevFroms) {
                FaultSection[] dests = ((FaultSection)jump.toCluster.subSects.get(0)).equals(jump.toSection) ? new FaultSection[]{jump.toSection} : new FaultSection[]{jump.toSection, (FaultSection)jump.toCluster.subSects.get(0)};
                for (FaultSection dest : dests) {
                    IDPairing pair = this.pairing(prevFrom, dest);
                    if (this.sectJumps.containsKey(pair)) {
                        double myDist;
                        double directDist;
                        if (this.onlyLargerDist && (float)(directDist = this.sectJumps.get(pair).doubleValue()) > 0.0f && (float)(myDist = this.calcJumpDistBetween(rupture.getTreeNavigator(), prevFrom, dest)) < (float)directDist) {
                            if (!verbose) continue;
                            System.out.println(this.getShortName() + ": loopback detected but it used shorter jumps (" + (float)myDist + " km) than the direct path (" + (float)directDist + " km) between" + prevFrom.getSectionId() + " and " + jump.toSection.getSectionId() + ", so it's allowed");
                            continue;
                        }
                        result = PlausibilityResult.FAIL_HARD_STOP;
                        if (!verbose) continue block1;
                        System.out.println(this.getShortName() + ": loopback detected. Could have jumped directly from " + prevFrom.getSectionId() + " to " + jump.toSection.getSectionId());
                    }
                    if (prevFrom.getParentSectionId() != jump.toSection.getParentSectionId() || pair.getID2() != pair.getID1() + 1) continue;
                    result = PlausibilityResult.FAIL_HARD_STOP;
                    if (!verbose) continue block1;
                    System.out.println(this.getShortName() + ": loopback detected. " + prevFrom.getSectionId() + " to " + jump.toSection.getSectionId() + " are neighbors on the same parent, but we took a circuitous route.");
                }
            }
            prevFroms.add(jump.fromSection);
        }
        return result;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private ClusterConnectionStrategy connStrategy;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            out.beginObject();
            out.name("onlyLargerDist").value(((DirectPathPlausibilityFilter)value).onlyLargerDist);
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            in.beginObject();
            boolean onlyLargerDist = false;
            if (in.peek() == JsonToken.NAME) {
                Preconditions.checkState((boolean)in.nextName().equals("onlyLargerDist"));
                onlyLargerDist = in.nextBoolean();
            }
            in.endObject();
            return new DirectPathPlausibilityFilter(this.connStrategy, onlyLargerDist);
        }
    }
}

