/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;

public class MultiDirectionalPlausibilityFilter
implements PlausibilityFilter {
    private PlausibilityFilter filter;
    private boolean onlyWhenSplayed;
    private RuptureConnectionSearch connSearch;
    private PlausibilityConfiguration plausibilityConfig;

    public MultiDirectionalPlausibilityFilter(PlausibilityFilter filter, PlausibilityConfiguration plausibilityConfig, boolean onlyWhenSplayed) {
        this.filter = filter;
        this.plausibilityConfig = plausibilityConfig;
        this.onlyWhenSplayed = onlyWhenSplayed;
    }

    public MultiDirectionalPlausibilityFilter(PlausibilityFilter filter, RuptureConnectionSearch connSearch, boolean onlyWhenSplayed) {
        this.filter = filter;
        this.connSearch = connSearch;
        this.onlyWhenSplayed = onlyWhenSplayed;
    }

    public PlausibilityFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getShortName() {
        return this.filter.getShortName();
    }

    @Override
    public String getName() {
        return this.filter.getName();
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        PlausibilityResult result;
        RuntimeException error = null;
        try {
            result = this.filter.apply(rupture, verbose);
            if (result.isPass() || this.onlyWhenSplayed && rupture.splays.isEmpty()) {
                return result;
            }
        }
        catch (RuntimeException e) {
            if (this.onlyWhenSplayed && rupture.splays.isEmpty()) {
                throw e;
            }
            result = null;
            error = e;
        }
        List<ClusterRupture> inversions = this.getInversions(rupture);
        if (verbose) {
            System.out.println("MultiDirectional " + this.getShortName() + ": trying " + inversions.size() + " inversions with original result=" + String.valueOf((Object)result));
        }
        for (ClusterRupture altRupture : inversions) {
            try {
                if (verbose) {
                    System.out.println("MultiDirectional " + this.getShortName() + ": inversion=" + String.valueOf(altRupture));
                }
                result = this.filter.apply(altRupture, verbose);
                if (verbose) {
                    System.out.println("MultiDirectional " + this.getShortName() + ": inversion result=" + String.valueOf((Object)result));
                }
                if (!result.isPass()) continue;
                return result;
            }
            catch (RuntimeException e) {
                error = e;
            }
        }
        if (result == null && error != null) {
            throw error;
        }
        return result;
    }

    private List<ClusterRupture> getInversions(ClusterRupture rupture) {
        if (this.plausibilityConfig != null) {
            return rupture.getAllAltRepresentations(this.plausibilityConfig.getConnectionStrategy(), this.plausibilityConfig.getMaxNumSplays());
        }
        Preconditions.checkNotNull((Object)this.connSearch);
        return rupture.getPreferredAltRepresentations(this.connSearch);
    }

    public static class Scalar<E extends Number>
    extends MultiDirectionalPlausibilityFilter
    implements ScalarValuePlausibiltyFilter<E> {
        private ScalarValuePlausibiltyFilter<E> filter;
        private Range<E> range;
        private Double lower;
        private Double upper;

        public Scalar(ScalarValuePlausibiltyFilter<E> filter, RuptureConnectionSearch connSearch, boolean onlyWhenSplayed) {
            super(filter, connSearch, onlyWhenSplayed);
            this.filter = filter;
            this.range = filter.getAcceptableRange();
            if (this.range != null) {
                if (this.range.hasLowerBound()) {
                    this.lower = ((Number)((Object)this.range.lowerEndpoint())).doubleValue();
                }
                if (this.range.hasUpperBound()) {
                    this.upper = ((Number)((Object)this.range.upperEndpoint())).doubleValue();
                }
            }
        }

        public Scalar(ScalarValuePlausibiltyFilter<E> filter, PlausibilityConfiguration plausibilityConfig, boolean onlyWhenSplayed) {
            super(filter, plausibilityConfig, onlyWhenSplayed);
            this.filter = filter;
            this.range = filter.getAcceptableRange();
            if (this.range != null) {
                if (this.range.hasLowerBound()) {
                    this.lower = ((Number)((Object)this.range.lowerEndpoint())).doubleValue();
                }
                if (this.range.hasUpperBound()) {
                    this.upper = ((Number)((Object)this.range.upperEndpoint())).doubleValue();
                }
            }
        }

        @Override
        public E getValue(ClusterRupture rupture) {
            E scalar = this.filter.getValue(rupture);
            if (this.onlyWhenSplayed && rupture.splays.isEmpty() || this.range == null) {
                return scalar;
            }
            for (ClusterRupture inversion : super.getInversions(rupture)) {
                boolean better;
                E altScalar = this.filter.getValue(inversion);
                boolean bl = better = altScalar != null && (scalar == null || this.isValueBetter(altScalar, scalar));
                if (altScalar == null || !better) continue;
                scalar = altScalar;
            }
            return scalar;
        }

        @Override
        public Range<E> getAcceptableRange() {
            return this.filter.getAcceptableRange();
        }

        @Override
        public String getScalarName() {
            return this.filter.getScalarName();
        }

        @Override
        public String getScalarUnits() {
            return this.filter.getScalarUnits();
        }
    }
}

