/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class U3CompatibleCumulativeRakeChangeFilter
implements ScalarValuePlausibiltyFilter<Double> {
    private double threshold;

    public U3CompatibleCumulativeRakeChangeFilter(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.getTotalNumSects() < 2) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing with <2 sects");
            }
            return PlausibilityResult.PASS;
        }
        FaultSection stopAt = rupture.clusters[rupture.clusters.length - 1].startSect;
        double tot = this.calc(rupture.getTreeNavigator(), rupture.clusters[0].startSect, stopAt, 0.0, verbose, !verbose);
        if (tot <= this.threshold) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing with tot=" + tot);
            }
            return PlausibilityResult.PASS;
        }
        if (verbose) {
            System.out.println(this.getShortName() + ": failing with tot=" + tot);
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    private double calc(RuptureTreeNavigator navigator, FaultSection sect1, FaultSection stopAt, double tot, boolean verbose, boolean shortCircuit) {
        double rake1 = sect1.getAveRake();
        for (FaultSection sect2 : navigator.getDescendants(sect1)) {
            double rake2 = sect2.getAveRake();
            double diff = U3CompatibleCumulativeRakeChangeFilter.rakeDiff(rake1, rake2);
            tot += diff;
            if (verbose && diff != 0.0) {
                System.out.println(this.getShortName() + ": " + sect1.getSectionId() + "=" + (float)rake1 + " => " + sect2.getSectionId() + "=" + (float)rake2 + " = " + diff);
            }
            if (tot > this.threshold && shortCircuit) {
                return tot;
            }
            if (sect2 == stopAt) break;
            tot = this.calc(navigator, sect2, stopAt, tot, verbose, shortCircuit);
        }
        return tot;
    }

    static double rakeDiff(double rake1, double rake2) {
        double rakeDiff = Math.abs(rake1 - rake2);
        if (rakeDiff > 180.0) {
            rakeDiff = 360.0 - rakeDiff;
        }
        Preconditions.checkState((rakeDiff >= 0.0 ? 1 : 0) != 0);
        return rakeDiff;
    }

    @Override
    public String getShortName() {
        return "U3CumRake";
    }

    @Override
    public String getName() {
        return "UCERF3 Cumulative Rake Filter";
    }

    @Override
    public Double getValue(ClusterRupture rupture) {
        if (rupture.getTotalNumSects() < 2) {
            return 0.0;
        }
        FaultSection stopAt = rupture.clusters[rupture.clusters.length - 1].startSect;
        return this.calc(rupture.getTreeNavigator(), rupture.clusters[0].startSect, stopAt, 0.0, false, false);
    }

    @Override
    public Range<Double> getAcceptableRange() {
        return Range.atMost((Comparable)Double.valueOf(this.threshold));
    }

    @Override
    public String getScalarName() {
        return "Cumulative Rake Change";
    }

    @Override
    public String getScalarUnits() {
        return "Degrees";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

