/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarCoulombPlausibilityFilter;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class NetClusterCoulombFilter
implements ScalarCoulombPlausibilityFilter {
    private AggregatedStiffnessCalculator aggCalc;
    private float threshold;

    public NetClusterCoulombFilter(AggregatedStiffnessCalculator aggCalc, float threshold) {
        this.aggCalc = aggCalc;
        this.threshold = threshold;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        PlausibilityResult result;
        if (rupture.getTotalNumClusters() == 1) {
            return PlausibilityResult.PASS;
        }
        float val = this.getValue(rupture).floatValue();
        PlausibilityResult plausibilityResult = result = val < this.threshold ? PlausibilityResult.FAIL_HARD_STOP : PlausibilityResult.PASS;
        if (verbose) {
            System.out.println(this.getShortName() + ": val=" + val + ", result=" + String.valueOf((Object)result));
        }
        return result;
    }

    @Override
    public String getShortName() {
        if (this.threshold == 0.0f) {
            return "NetClusterCFF\u22650";
        }
        return "NetClusterCFF\u2265" + this.threshold;
    }

    @Override
    public String getName() {
        return "Net Cluster Coulomb  \u2265 " + this.threshold;
    }

    private float getMinValue(List<FaultSubsectionCluster> clusters) {
        ArrayList<FaultSection> allSects = new ArrayList<FaultSection>();
        for (FaultSubsectionCluster cluster : clusters) {
            allSects.addAll((Collection<FaultSection>)cluster.subSects);
        }
        float minVal = Float.POSITIVE_INFINITY;
        for (FaultSubsectionCluster cluster : clusters) {
            List sources = allSects.stream().filter(s -> !cluster.contains((FaultSection)s)).collect(Collectors.toList());
            double val = this.aggCalc.calc((Collection<? extends FaultSection>)sources, (Collection<? extends FaultSection>)cluster.subSects);
            minVal = Float.min(minVal, (float)val);
        }
        return minVal;
    }

    private List<FaultSubsectionCluster> getClusterList(ClusterRupture rupture) {
        ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>(rupture.getTotalNumClusters());
        for (FaultSubsectionCluster cluster : rupture.getClustersIterable()) {
            clusters.add(cluster);
        }
        return clusters;
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        if (rupture.getTotalNumClusters() == 1) {
            return null;
        }
        return Float.valueOf(this.getMinValue(this.getClusterList(rupture)));
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atLeast((Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public AggregatedStiffnessCalculator getAggregator() {
        return this.aggCalc;
    }
}

