/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarCoulombPlausibilityFilter;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class NetRuptureCoulombFilter
implements ScalarCoulombPlausibilityFilter {
    private AggregatedStiffnessCalculator aggCalc;
    private Range<Float> acceptableRange;
    private static EnumSet<AggregatedStiffnessCalculator.AggregationMethod> filterDataAggMethods = EnumSet.complementOf(EnumSet.of(AggregatedStiffnessCalculator.AggregationMethod.GREATER_MEAN_MEDIAN, AggregatedStiffnessCalculator.AggregationMethod.GREATER_SUM_MEDIAN, AggregatedStiffnessCalculator.AggregationMethod.MEDIAN));

    public NetRuptureCoulombFilter(AggregatedStiffnessCalculator aggCalc, float threshold) {
        this(aggCalc, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(threshold)));
    }

    public NetRuptureCoulombFilter(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange) {
        this.aggCalc = aggCalc;
        Preconditions.checkArgument((acceptableRange.hasLowerBound() || acceptableRange.hasUpperBound() ? 1 : 0) != 0);
        this.acceptableRange = acceptableRange;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        PlausibilityResult result;
        if (rupture.getTotalNumJumps() == 0) {
            return PlausibilityResult.PASS;
        }
        float val = this.getValue(rupture).floatValue();
        PlausibilityResult plausibilityResult = result = this.acceptableRange.contains((Comparable)Float.valueOf(val)) ? PlausibilityResult.PASS : PlausibilityResult.FAIL_HARD_STOP;
        if (verbose) {
            System.out.println(this.getShortName() + ": val=" + val + ", result=" + String.valueOf((Object)result));
        }
        return result;
    }

    @Override
    public String getShortName() {
        String name = this.aggCalc.getScalarShortName();
        return name + this.getRangeStr();
    }

    @Override
    public String getName() {
        String name = "Net Rupture [" + this.aggCalc.getScalarName() + "]";
        return name + this.getRangeStr();
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        if (rupture.getTotalNumSects() == 1) {
            return null;
        }
        ArrayList<FaultSection> allSects = new ArrayList<FaultSection>();
        for (FaultSubsectionCluster cluster : rupture.getClustersIterable()) {
            allSects.addAll((Collection<FaultSection>)cluster.subSects);
        }
        return Float.valueOf((float)this.aggCalc.calc(allSects, allSects));
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return this.acceptableRange;
    }

    @Override
    public AggregatedStiffnessCalculator getAggregator() {
        return this.aggCalc;
    }

    private static class FilterData {
        private final ClusterRupture prevRupture;
        private final AggregatedStiffnessCalculator.StiffnessAggregation prevAggregation;

        public FilterData(ClusterRupture prevRupture, AggregatedStiffnessCalculator.StiffnessAggregation prevAggregation) {
            this.prevRupture = prevRupture;
            this.prevAggregation = prevAggregation;
        }
    }
}

