/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb;

import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.JumpPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarCoulombPlausibilityFilter;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class ParentCoulombCompatibilityFilter
extends JumpPlausibilityFilter
implements ScalarCoulombPlausibilityFilter {
    private AggregatedStiffnessCalculator aggCalc;
    private float threshold;
    private Directionality directionality;
    private transient Map<IDPairing, Boolean> passCache;
    private transient Map<Integer, List<FaultSection>> parentSectsMap;

    public ParentCoulombCompatibilityFilter(AggregatedStiffnessCalculator aggCalc, float threshold, Directionality directionality) {
        this.aggCalc = aggCalc;
        this.threshold = threshold;
        this.directionality = directionality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlausibilityResult testJump(ClusterRupture rupture, Jump newJump, boolean verbose) {
        int id2;
        int id1;
        if (this.passCache == null) {
            ParentCoulombCompatibilityFilter parentCoulombCompatibilityFilter = this;
            synchronized (parentCoulombCompatibilityFilter) {
                if (this.passCache == null) {
                    this.passCache = new HashMap<IDPairing, Boolean>();
                }
            }
        }
        if (newJump.fromCluster.parentSectionID < newJump.toCluster.parentSectionID) {
            id1 = newJump.fromCluster.parentSectionID;
            id2 = newJump.toCluster.parentSectionID;
        } else {
            id2 = newJump.fromCluster.parentSectionID;
            id1 = newJump.toCluster.parentSectionID;
        }
        if (id1 == id2) {
            return PlausibilityResult.PASS;
        }
        IDPairing pair = new IDPairing(id1, id2);
        Boolean result = this.passCache.get(pair);
        if (result == null || verbose) {
            int fromID = newJump.fromCluster.parentSectionID;
            int toID = newJump.toCluster.parentSectionID;
            double forward = this.calc(fromID, toID);
            if (verbose) {
                System.out.println(this.getShortName() + ": forward, " + fromID + "=>" + toID + " = " + forward);
            }
            if (this.directionality == Directionality.EITHER && (float)forward >= this.threshold && !verbose) {
                result = true;
            } else {
                double reversed = this.calc(toID, fromID);
                if (verbose) {
                    System.out.println(this.getShortName() + ": reversed, " + toID + "=>" + fromID + " = " + reversed);
                }
                switch (this.directionality.ordinal()) {
                    case 1: {
                        result = (float)reversed >= this.threshold && (float)forward >= this.threshold;
                        break;
                    }
                    case 0: {
                        result = (float)reversed >= this.threshold || (float)forward >= this.threshold;
                        break;
                    }
                    case 2: {
                        result = (float)(reversed + forward) >= this.threshold;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            Map<IDPairing, Boolean> map = this.passCache;
            synchronized (map) {
                this.passCache.put(pair, result);
            }
        }
        return result != false ? PlausibilityResult.PASS : PlausibilityResult.FAIL_HARD_STOP;
    }

    private synchronized List<FaultSection> getSectsForParent(int parentID) {
        List<FaultSection> sects;
        if (this.parentSectsMap == null) {
            this.parentSectsMap = new HashMap<Integer, List<FaultSection>>();
        }
        if ((sects = this.parentSectsMap.get(parentID)) == null) {
            sects = this.aggCalc.getCalc().getSubSects().stream().filter(s -> s.getParentSectionId() == parentID).collect(Collectors.toList());
            this.parentSectsMap.put(parentID, sects);
        }
        return sects;
    }

    private double calc(int sourceID, int receiverID) {
        return this.aggCalc.calc(this.getSectsForParent(sourceID), this.getSectsForParent(receiverID));
    }

    @Override
    public String getShortName() {
        if (this.threshold == 0.0f) {
            return "ParentCFF\u22650";
        }
        return "ParentCFF\u2265" + this.threshold;
    }

    @Override
    public String getName() {
        return "Parent Section Coulomb \u2265 " + this.threshold;
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        if (rupture.getTotalNumJumps() == 0) {
            return null;
        }
        float min = Float.POSITIVE_INFINITY;
        for (Jump jump : rupture.getJumpsIterable()) {
            min = Float.min(min, this.getValue(rupture, jump).floatValue());
        }
        return Float.valueOf(min);
    }

    private Float getValue(ClusterRupture rupture, Jump newJump) {
        int fromID = newJump.fromCluster.parentSectionID;
        int toID = newJump.toCluster.parentSectionID;
        double forward = this.calc(fromID, toID);
        double reversed = this.calc(toID, fromID);
        switch (this.directionality.ordinal()) {
            case 1: {
                return Float.valueOf(Float.min((float)forward, (float)reversed));
            }
            case 0: {
                return Float.valueOf(Float.max((float)forward, (float)reversed));
            }
            case 2: {
                return Float.valueOf((float)(forward + reversed));
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atLeast((Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    @Override
    public AggregatedStiffnessCalculator getAggregator() {
        return this.aggCalc;
    }

    public static enum Directionality {
        EITHER,
        BOTH,
        SUM;

    }
}

