/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class AbstractRelativeProb
implements RuptureProbabilityCalc {
    protected transient ClusterConnectionStrategy connStrat;
    protected boolean allowNegative;
    protected boolean relativeToBest = true;
    protected boolean includeLongerJumps = true;
    protected transient Map<Integer, FaultSubsectionCluster> fullClustersMap;

    public AbstractRelativeProb(ClusterConnectionStrategy connStrat, boolean allowNegative, boolean relativeToBest, boolean includeLongerJumps) {
        this.connStrat = connStrat;
        this.allowNegative = allowNegative;
        this.relativeToBest = relativeToBest;
        this.includeLongerJumps = includeLongerJumps;
    }

    public ClusterConnectionStrategy getConnStrat() {
        return this.connStrat;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public boolean isRelativeToBest() {
        return this.relativeToBest;
    }

    @Override
    public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        this.connStrat = connStrat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitFullClusters() {
        if (this.fullClustersMap == null) {
            AbstractRelativeProb abstractRelativeProb = this;
            synchronized (abstractRelativeProb) {
                if (this.fullClustersMap == null) {
                    HashMap<Integer, FaultSubsectionCluster> map = new HashMap<Integer, FaultSubsectionCluster>();
                    for (FaultSubsectionCluster cluster : this.connStrat.getClusters()) {
                        map.put(cluster.parentSectionID, cluster);
                    }
                    this.fullClustersMap = map;
                }
            }
        }
    }

    public abstract double calcAdditionValue(ClusterRupture var1, Collection<? extends FaultSection> var2, PathEvaluator.PathAddition var3);

    public abstract boolean isAddFullClusters();

    public PathEvaluator.PathNavigator getPathNav(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster) {
        if (this.isAddFullClusters()) {
            return new PathEvaluator.ClusterPathNavigator(nucleationCluster, rupture.getTreeNavigator());
        }
        return new PathEvaluator.SectionPathNavigator((Collection<? extends FaultSection>)nucleationCluster.subSects, rupture.getTreeNavigator());
    }

    public HashSet<FaultSubsectionCluster> getSkipToClusters(ClusterRupture rupture) {
        return null;
    }

    public PathEvaluator.PathAddition targetJumpToAddition(Collection<? extends FaultSection> curSects, PathEvaluator.PathAddition testAddition, Jump alternateJump) {
        Object toSects = this.isAddFullClusters() ? alternateJump.toCluster.subSects : Collections.singleton(alternateJump.toSection);
        return new PathEvaluator.PathAddition(testAddition.fromSect, testAddition.fromCluster, (Collection<? extends FaultSection>)toSects, alternateJump.toCluster, alternateJump.distance);
    }

    @Override
    public double calcRuptureProb(ClusterRupture rupture, boolean verbose) {
        HashSet<FaultSubsectionCluster> skipToClusters = this.getSkipToClusters(rupture);
        double prob = 1.0;
        RuptureTreeNavigator rupNav = rupture.getTreeNavigator();
        PathEvaluator.PathNavigator pathNav = this.getPathNav(rupture, rupture.clusters[0]);
        pathNav.setVerbose(verbose);
        if (verbose) {
            System.out.println(this.getName() + ": testing with start=" + String.valueOf(rupture.clusters[0]));
        }
        List<FaultSection> curSects = pathNav.getCurrentSects();
        Set<PathEvaluator.PathAddition> nextAdds = pathNav.getNextAdditions();
        if (verbose) {
            System.out.println("Have " + nextAdds.size() + " nextAdds");
        }
        while (!nextAdds.isEmpty()) {
            for (PathEvaluator.PathAddition add : nextAdds) {
                if (skipToClusters != null && skipToClusters.contains(rupNav.locateCluster(add.toSects.iterator().next()))) {
                    if (!verbose) continue;
                    System.out.println(this.getName() + ": skipping addition: " + String.valueOf(add));
                    continue;
                }
                if ((prob *= this.calcAdditionProb(rupture, curSects, add, verbose)) != 0.0 || verbose) continue;
                break;
            }
            curSects = pathNav.getCurrentSects();
            nextAdds = pathNav.getNextAdditions();
            if (!verbose) continue;
            System.out.println("Have " + nextAdds.size() + " nextAdds");
        }
        Preconditions.checkState((pathNav.getCurrentSects().size() == rupture.getTotalNumSects() ? 1 : 0) != 0, (String)"Processed %s sects but rupture has %s:\n\t%s", (Object)pathNav.getCurrentSects().size(), (Object)rupture.getTotalNumSects(), (Object)rupture);
        return prob;
    }

    protected double calcAdditionProb(ClusterRupture rupture, List<FaultSection> curSects, PathEvaluator.PathAddition add, boolean verbose) {
        double myVal = this.calcAdditionValue(rupture, curSects, add);
        if (verbose) {
            System.out.println("\tAddition taken value (" + String.valueOf(add) + "): " + myVal);
        }
        if (!this.allowNegative && myVal < 0.0) {
            return 0.0;
        }
        float maxDist = Float.POSITIVE_INFINITY;
        if (!this.includeLongerJumps) {
            maxDist = (float)(add.distance + 2.0);
        }
        this.checkInitFullClusters();
        FaultSubsectionCluster fullFrom = this.fullClustersMap.get(add.fromCluster.parentSectionID);
        Preconditions.checkNotNull((Object)fullFrom);
        ArrayList<PathEvaluator.PathAddition> targetAdditions = new ArrayList<PathEvaluator.PathAddition>();
        if (fullFrom.subSects.size() > add.fromCluster.subSects.size() && !fullFrom.endSects.contains((Object)add.fromSect)) {
            FaultSection sect;
            int i;
            int fromSectIndex = fullFrom.subSects.indexOf((Object)add.fromSect);
            Preconditions.checkState((fromSectIndex >= 0 ? 1 : 0) != 0, (String)"From section (%s. %s) not found in full cluster for that parent (parentID=%s, name=%s): %s", (Object[])new Object[]{add.fromSect.getSectionId(), add.fromSect.getSectionName(), fullFrom.parentSectionID, fullFrom.parentSectionName, fullFrom});
            if (fromSectIndex < fullFrom.subSects.size() - 1) {
                ArrayList<FaultSection> arrayList = new ArrayList<FaultSection>();
                for (i = fromSectIndex + 1; i < fullFrom.subSects.size() && !add.fromCluster.contains(sect = (FaultSection)fullFrom.subSects.get(i)); ++i) {
                    arrayList.add(sect);
                    if (!this.isAddFullClusters()) break;
                }
                if (!arrayList.isEmpty()) {
                    targetAdditions.add(new PathEvaluator.PathAddition(add.fromSect, add.fromCluster, arrayList, fullFrom, 0.0));
                }
            }
            if (fromSectIndex > 0) {
                ArrayList<FaultSection> arrayList = new ArrayList<FaultSection>();
                i = fromSectIndex;
                while (--i >= 0 && !add.fromCluster.contains(sect = (FaultSection)fullFrom.subSects.get(i))) {
                    arrayList.add(sect);
                    if (this.isAddFullClusters()) continue;
                    break;
                }
                if (!arrayList.isEmpty()) {
                    targetAdditions.add(new PathEvaluator.PathAddition(add.fromSect, add.fromCluster, arrayList, fullFrom, 0.0));
                }
            }
        }
        for (Jump jump : fullFrom.getConnections(add.fromSect)) {
            if (jump.toCluster.parentSectionID == add.toCluster.parentSectionID || rupture.contains(jump.toSection) || !((float)jump.distance <= maxDist)) continue;
            targetAdditions.add(this.targetJumpToAddition(curSects, add, jump));
        }
        ArrayList<Double> targetVals = new ArrayList<Double>();
        for (PathEvaluator.PathAddition targetAdd : targetAdditions) {
            double val = this.calcAdditionValue(rupture, curSects, targetAdd);
            if (verbose) {
                System.out.println("\tAlternative dest value (" + String.valueOf(targetAdd) + "): " + val);
            }
            targetVals.add(val);
        }
        double d = this.calcProb(myVal, targetVals, verbose);
        return d;
    }

    private double calcProb(double myVal, List<Double> targetVals, boolean verbose) {
        if (targetVals.isEmpty()) {
            if (verbose) {
                System.out.println("\tno alternatives!");
            }
            return 1.0;
        }
        double normalization = Math.min(myVal, 0.0);
        if (this.allowNegative && myVal < 0.0) {
            for (double val : targetVals) {
                normalization = Math.min(val, normalization);
            }
        }
        if (normalization != 0.0) {
            if (verbose) {
                System.out.println("\tNormalizing by min value: " + normalization);
            }
            myVal -= normalization;
            for (int i = 0; i < targetVals.size(); ++i) {
                targetVals.set(i, targetVals.get(i) - normalization);
            }
        }
        double divisor = myVal;
        if (this.relativeToBest) {
            for (double val : targetVals) {
                divisor = Double.max(val, divisor);
            }
        } else {
            for (double val : targetVals) {
                divisor += val;
            }
        }
        if (verbose) {
            if (this.relativeToBest) {
                System.out.println("\tBest: " + divisor);
            } else {
                System.out.println("\tSum: " + divisor);
            }
        }
        Preconditions.checkState(((float)divisor >= 0.0f ? 1 : 0) != 0, (String)"Bad relative divisor = %s.\n\tnormalization: %s\n\tmyVal: %s\n\tallVals (after norm): %s", (Object)divisor, (Object)normalization, (Object)myVal, targetVals);
        if ((float)divisor == 0.0f) {
            return 0.0;
        }
        double prob = myVal / divisor;
        if (verbose) {
            System.out.println("\tP = " + myVal + " / " + divisor + " = " + prob);
        }
        Preconditions.checkState((prob >= 0.0 && prob <= 1.0 ? 1 : 0) != 0, (String)"Bad relative prob! P = %s / %s = %s.\n\tnormalization: %s\n\tallVals (after norm): %s", (Object[])new Object[]{myVal, divisor, prob, normalization, targetVals});
        return prob;
    }
}

