/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;

public class Shaw07JumpDistProb
implements JumpProbabilityCalc.DistDependentJumpProbabilityCalc {
    private double a;
    private double r0;
    public static final double R0_DEFAULT = 3.0;
    static final DecimalFormat optionalDigitDF = new DecimalFormat("0.##");

    public static Shaw07JumpDistProb forHorzOffset(double a, double r0, double horzOffset) {
        double a0 = Math.exp(horzOffset / r0);
        return new Shaw07JumpDistProb(a * a0, r0);
    }

    public Shaw07JumpDistProb(double a, double r0) {
        this.a = a;
        this.r0 = r0;
    }

    public double getA() {
        return this.a;
    }

    public double getR0() {
        return this.r0;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return false;
    }

    @Override
    public String getName() {
        if ((float)this.a != 1.0f) {
            return "Shaw07 [A=" + optionalDigitDF.format(this.a) + ", R\u2080=" + optionalDigitDF.format(this.r0) + "]";
        }
        return "Shaw07 [R\u2080=" + optionalDigitDF.format(this.r0) + "]";
    }

    @Override
    public double calcJumpProbability(double distance) {
        return Shaw07JumpDistProb.calcJumpProbability(distance, this.a, this.r0);
    }

    public static double calcJumpProbability(double distance, double a, double r0) {
        double prob = a * Math.exp(-distance / r0);
        if (a > 1.0) {
            prob = Math.min(1.0, prob);
        }
        return prob;
    }

    public double calcJumpDistance(double probability) {
        return Shaw07JumpDistProb.calcJumpDistance(probability, this.a, this.r0);
    }

    public static double calcJumpDistance(double probability, double a, double r0) {
        Preconditions.checkState((probability > 0.0 && probability <= 1.0 ? 1 : 0) != 0, (String)"Bad probability: %s", (Object)probability);
        return r0 * Math.log(a / probability);
    }

    public static void main(String[] args) {
        Shaw07JumpDistProb prob = new Shaw07JumpDistProb(1.0, 3.0);
        for (double d = 0.0; d <= 25.0; d += 0.1) {
            System.out.println((float)d + " km:\t" + prob.calcJumpProbability(d));
        }
    }
}

