/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.faultSurface.FaultSection;

public class AdaptiveClusterConnectionStrategy
extends ClusterConnectionStrategy {
    private ClusterConnectionStrategy fullConnStrat;
    private double r0;
    private int sectMax;
    private transient Map<FaultSubsectionCluster, List<Jump>> fromJumpsMap;

    public AdaptiveClusterConnectionStrategy(ClusterConnectionStrategy fullConnStrat, double r0, int sectMax) {
        this(fullConnStrat, fullConnStrat.getRawClusters(), r0, sectMax);
    }

    private static List<FaultSubsectionCluster> cloneClusters(List<FaultSubsectionCluster> clusters) {
        ArrayList<FaultSubsectionCluster> ret = new ArrayList<FaultSubsectionCluster>();
        for (FaultSubsectionCluster cluster : clusters) {
            ret.add(new FaultSubsectionCluster((List<? extends FaultSection>)cluster.subSects, cluster.startSect, (Collection<FaultSection>)cluster.endSects));
        }
        return ret;
    }

    public AdaptiveClusterConnectionStrategy(ClusterConnectionStrategy fullConnStrat, List<FaultSubsectionCluster> clusters, double r0, int sectMax) {
        super(fullConnStrat.getSubSections(), AdaptiveClusterConnectionStrategy.cloneClusters(clusters), fullConnStrat.getDistCalc());
        this.init(fullConnStrat, r0, sectMax);
    }

    private void init(ClusterConnectionStrategy fullConnStrat, double r0, int sectMax) {
        Preconditions.checkState((r0 >= 0.0 ? 1 : 0) != 0, (Object)"r0 must be >= 0");
        this.r0 = r0;
        Preconditions.checkArgument((sectMax > 0 ? 1 : 0) != 0);
        this.sectMax = sectMax;
        Preconditions.checkNotNull((Object)fullConnStrat);
        this.fullConnStrat = fullConnStrat;
    }

    @Override
    public synchronized void checkBuildThreaded(int numThreads) {
        System.out.println("Building full threaded...");
        this.fullConnStrat.checkBuildThreaded(numThreads);
        System.out.println("Done building full, building me...");
        this.getJumpsFrom(this.getRawClusters().get(0));
        System.out.println("Done building");
    }

    private synchronized List<Jump> getJumpsFrom(FaultSubsectionCluster cluster) {
        if (this.fromJumpsMap == null) {
            HashMap possibleMap = new HashMap();
            List<FaultSubsectionCluster> clusters = this.getRawClusters();
            for (FaultSubsectionCluster c : clusters) {
                possibleMap.put(c, new ArrayList());
            }
            for (int c1 = 0; c1 < clusters.size(); ++c1) {
                FaultSubsectionCluster from = clusters.get(c1);
                for (int c2 = c1 + 1; c2 < clusters.size(); ++c2) {
                    FaultSubsectionCluster to = clusters.get(c2);
                    List<Jump> possibles = this.fullConnStrat.buildPossibleConnections(from, to);
                    if (possibles == null) continue;
                    for (Jump jump : possibles) {
                        ((List)possibleMap.get(from)).add(jump);
                        ((List)possibleMap.get(to)).add(jump.reverse());
                    }
                }
            }
            HashSet<Jump> allowedJumps = new HashSet<Jump>();
            for (FaultSubsectionCluster from : possibleMap.keySet()) {
                List jumps = (List)possibleMap.get(from);
                Collections.sort(jumps, Jump.dist_comparator);
                HashMap<Integer, Integer> sectCounts = new HashMap<Integer, Integer>();
                HashMap<Integer, Double> sectMaxAlloweds = new HashMap<Integer, Double>();
                for (Jump jump : jumps) {
                    boolean keep;
                    double sectMaxAllowed;
                    int fromID = jump.fromSection.getSectionId();
                    int sectCount = sectCounts.containsKey(fromID) ? (Integer)sectCounts.get(fromID) : 0;
                    double d = sectMaxAllowed = sectCount == 0 ? 0.0 : (Double)sectMaxAlloweds.get(fromID);
                    if ((float)jump.distance <= (float)this.r0) {
                        keep = true;
                    } else {
                        boolean bl = keep = this.sectMax < 0 || sectCount < this.sectMax;
                        if (!keep && !allowedJumps.isEmpty() && (float)jump.distance == (float)sectMaxAllowed) {
                            keep = true;
                        }
                    }
                    if (!keep) continue;
                    sectCounts.put(fromID, sectCount + 1);
                    allowedJumps.add(jump);
                    allowedJumps.add(jump.reverse());
                    sectMaxAlloweds.put(fromID, Math.max(sectMaxAllowed, jump.distance));
                }
            }
            HashMap<FaultSubsectionCluster, List<Jump>> fromJumpsMap = new HashMap<FaultSubsectionCluster, List<Jump>>();
            for (Jump jump : allowedJumps) {
                ArrayList<Jump> fromJumps = (ArrayList<Jump>)fromJumpsMap.get(jump.fromCluster);
                if (fromJumps == null) {
                    fromJumps = new ArrayList<Jump>();
                    fromJumpsMap.put(jump.fromCluster, fromJumps);
                }
                fromJumps.add(jump);
            }
            this.fromJumpsMap = fromJumpsMap;
        }
        return this.fromJumpsMap.get(cluster);
    }

    private List<Jump> doBuildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        List<Jump> possibleJumpsFrom = this.getJumpsFrom(from);
        if (possibleJumpsFrom == null) {
            return null;
        }
        ArrayList<Jump> allowed = new ArrayList<Jump>();
        for (Jump jump : possibleJumpsFrom) {
            Preconditions.checkState((boolean)from.equals(jump.fromCluster));
            if (!to.equals(jump.toCluster)) continue;
            allowed.add(jump);
        }
        if (allowed.isEmpty()) {
            return null;
        }
        return allowed;
    }

    @Override
    protected List<Jump> buildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        List<Jump> forwardJumps = this.doBuildPossibleConnections(from, to);
        List<Jump> backwardJumps = this.doBuildPossibleConnections(to, from);
        ArrayList<Jump> allowed = new ArrayList<Jump>();
        if (forwardJumps != null) {
            allowed.addAll(forwardJumps);
        }
        if (backwardJumps != null && !backwardJumps.isEmpty()) {
            HashSet<IDPairing> currentJumps = new HashSet<IDPairing>();
            for (Jump curJump : allowed) {
                currentJumps.add(AdaptiveClusterConnectionStrategy.pair(curJump));
            }
            for (Jump backwardJump : backwardJumps) {
                if (currentJumps.contains(AdaptiveClusterConnectionStrategy.pair(backwardJump))) continue;
                allowed.add(backwardJump.reverse());
            }
        }
        return allowed;
    }

    private static IDPairing pair(Jump jump) {
        IDPairing pair = new IDPairing(jump.fromSection.getSectionId(), jump.toSection.getSectionId());
        if (pair.getID1() > pair.getID2()) {
            pair = pair.getReversed();
        }
        return pair;
    }

    @Override
    public String getName() {
        if (this.sectMax != 1) {
            return "Adaptive (r\u2080=" + (float)this.r0 + " km, sectMax=" + this.sectMax + ") " + this.fullConnStrat.getName();
        }
        return "Adaptive (r\u2080=" + (float)this.r0 + " km) " + this.fullConnStrat.getName();
    }

    @Override
    public double getMaxJumpDist() {
        return this.fullConnStrat.getMaxJumpDist();
    }
}

