/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class CachedRuptureGrowingStrategy
implements RuptureGrowingStrategy {
    private Table<FaultSubsectionCluster, FaultSection, List<FaultSubsectionCluster>> cacheTable = HashBasedTable.create();

    @Override
    public final synchronized List<FaultSubsectionCluster> getVariations(FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        List<FaultSubsectionCluster> permutations = (List<FaultSubsectionCluster>)this.cacheTable.get((Object)fullCluster, (Object)firstSection);
        if (permutations == null) {
            permutations = this.calcPermutations(fullCluster, firstSection);
            this.cacheTable.put((Object)fullCluster, (Object)firstSection, permutations);
        }
        return permutations;
    }

    protected abstract List<FaultSubsectionCluster> calcPermutations(FaultSubsectionCluster var1, FaultSection var2);

    @Override
    public void clearCaches() {
        this.cacheTable.clear();
    }
}

