/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.CachedRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveUnilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.faultSurface.FaultSection;

public class ExhaustiveBilateralRuptureGrowingStrategy
implements RuptureGrowingStrategy {
    private static final boolean D = false;
    private SecondaryVariations secondaryPermutations;
    private boolean allowLongerSecondary;
    private RuptureGrowingStrategy firstClusterStrat;
    private RuptureGrowingStrategy additionalClusterStrat;

    public ExhaustiveBilateralRuptureGrowingStrategy(final SecondaryVariations secondaryPermutations, final boolean allowLongerSecondary) {
        this.secondaryPermutations = secondaryPermutations;
        this.allowLongerSecondary = allowLongerSecondary;
        this.firstClusterStrat = new ExhaustiveUnilateralRuptureGrowingStrategy();
        this.additionalClusterStrat = new CachedRuptureGrowingStrategy(this){
            final /* synthetic */ ExhaustiveBilateralRuptureGrowingStrategy this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            protected List<FaultSubsectionCluster> calcPermutations(FaultSubsectionCluster fullCluster, FaultSection firstSection) {
                ImmutableList<FaultSection> clusterSects = fullCluster.subSects;
                int myInd = fullCluster.subSects.indexOf((Object)firstSection);
                Preconditions.checkState((myInd >= 0 ? 1 : 0) != 0, (Object)"first section not found in cluster");
                ArrayList<Integer> endPoints = new ArrayList<Integer>(clusterSects.size());
                endPoints.add(myInd);
                int i = myInd;
                while (--i >= 0) {
                    endPoints.add(i);
                }
                for (i = myInd + 1; i < clusterSects.size(); ++i) {
                    endPoints.add(i);
                }
                ArrayList<FaultSubsectionCluster> permuations = new ArrayList<FaultSubsectionCluster>();
                Iterator iterator = endPoints.iterator();
                while (iterator.hasNext()) {
                    int primaryEndLength;
                    int secondaryEndLength;
                    int endIndex = (Integer)iterator.next();
                    if (endIndex == myInd) {
                        permuations.add(ExhaustiveBilateralRuptureGrowingStrategy.buildCopyJumps(fullCluster, Lists.newArrayList((Object[])new FaultSection[]{firstSection}), firstSection));
                        continue;
                    }
                    if (endIndex < myInd) {
                        secondaryEndLength = clusterSects.size() - myInd - 1;
                        primaryEndLength = myInd - endIndex;
                    } else {
                        secondaryEndLength = myInd;
                        primaryEndLength = endIndex - myInd;
                    }
                    ArrayList<Integer> startPoints = new ArrayList<Integer>();
                    startPoints.add(myInd);
                    if (secondaryEndLength > 0) {
                        List<Integer> validLengths = secondaryPermutations.getValidSecondaryLengths(secondaryEndLength, primaryEndLength);
                        for (int len : validLengths) {
                            Preconditions.checkState((len > 0 && len <= secondaryEndLength ? 1 : 0) != 0, (String)"Bad len=%s w/ secondaryEndLength=%s", (int)len, (int)secondaryEndLength);
                            if (!allowLongerSecondary && len > primaryEndLength) continue;
                            if (endIndex < myInd) {
                                startPoints.add(myInd + len);
                                continue;
                            }
                            startPoints.add(myInd - len);
                        }
                    }
                    Iterator iterator2 = startPoints.iterator();
                    while (iterator2.hasNext()) {
                        ArrayList<FaultSection> sects;
                        int startIndex = (Integer)iterator2.next();
                        Preconditions.checkState((startIndex != endIndex ? 1 : 0) != 0);
                        if (startIndex < endIndex) {
                            sects = clusterSects.subList(startIndex, endIndex + 1);
                        } else {
                            sects = new ArrayList<FaultSection>();
                            sects.add((FaultSection)clusterSects.get(startIndex));
                            int i2 = startIndex;
                            while (--i2 >= endIndex) {
                                sects.add((FaultSection)clusterSects.get(i2));
                            }
                        }
                        permuations.add(ExhaustiveBilateralRuptureGrowingStrategy.buildCopyJumps(fullCluster, sects, firstSection));
                    }
                }
                return permuations;
            }
        };
    }

    private static FaultSubsectionCluster buildCopyJumps(FaultSubsectionCluster fullCluster, List<FaultSection> subsetSects, FaultSection startSect) {
        FaultSubsectionCluster permutation = new FaultSubsectionCluster(subsetSects, startSect, null);
        for (FaultSection sect : subsetSects) {
            for (Jump jump : fullCluster.getConnections(sect)) {
                permutation.addConnection(new Jump(sect, permutation, jump.toSection, jump.toCluster, jump.distance));
            }
        }
        return permutation;
    }

    @Override
    public String getName() {
        String ret = "Exhaustive Bilateral, " + this.secondaryPermutations.toString();
        if (this.allowLongerSecondary) {
            ret = ret + ", Seondary Can Be Longer";
        }
        return ret;
    }

    @Override
    public List<FaultSubsectionCluster> getVariations(FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        return this.firstClusterStrat.getVariations(fullCluster, firstSection);
    }

    @Override
    public List<FaultSubsectionCluster> getVariations(ClusterRupture currentRupture, FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        if (currentRupture == null) {
            return this.firstClusterStrat.getVariations(fullCluster, firstSection);
        }
        return this.additionalClusterStrat.getVariations(fullCluster, firstSection);
    }

    @Override
    public void clearCaches() {
        this.firstClusterStrat.clearCaches();
        this.additionalClusterStrat.clearCaches();
    }

    public static enum SecondaryVariations {
        ALL("Both Ends Varied"){

            @Override
            public List<Integer> getValidSecondaryLengths(int secondaryEndLength, int primaryEndLength) {
                ArrayList<Integer> ret = new ArrayList<Integer>();
                for (int i = 1; i <= secondaryEndLength; ++i) {
                    ret.add(i);
                }
                return ret;
            }
        }
        ,
        SINGLE_FULL("Seondary End Fully Ruptures"){

            @Override
            public List<Integer> getValidSecondaryLengths(int secondaryEndLength, int primaryEndLength) {
                return Lists.newArrayList((Object[])new Integer[]{secondaryEndLength});
            }
        }
        ,
        EQUAL_LEN("Secondary End Equal"){

            @Override
            public List<Integer> getValidSecondaryLengths(int secondaryEndLength, int primaryEndLength) {
                return Lists.newArrayList((Object[])new Integer[]{Integer.min(secondaryEndLength, primaryEndLength)});
            }
        };

        private String name;

        private SecondaryVariations(String name) {
            this.name = name;
        }

        public abstract List<Integer> getValidSecondaryLengths(int var1, int var2);

        public String toString() {
            return this.name;
        }
    }
}

