/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.CachedRuptureGrowingStrategy;
import org.opensha.sha.faultSurface.FaultSection;

public class ExhaustiveUnilateralRuptureGrowingStrategy
extends CachedRuptureGrowingStrategy {
    @Override
    public List<FaultSubsectionCluster> calcPermutations(FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        FaultSection nextSection;
        ImmutableList<FaultSection> clusterSects = fullCluster.subSects;
        int myInd = fullCluster.subSects.indexOf((Object)firstSection);
        Preconditions.checkState((myInd >= 0 ? 1 : 0) != 0, (Object)"first section not found in cluster");
        ArrayList<FaultSection> newSects = new ArrayList<FaultSection>();
        newSects.add(firstSection);
        ArrayList<FaultSubsectionCluster> permuations = new ArrayList<FaultSubsectionCluster>();
        permuations.add(ExhaustiveUnilateralRuptureGrowingStrategy.buildCopyJumps(fullCluster, newSects));
        int i = myInd;
        while (--i >= 0) {
            nextSection = (FaultSection)clusterSects.get(i);
            newSects.add(nextSection);
            permuations.add(ExhaustiveUnilateralRuptureGrowingStrategy.buildCopyJumps(fullCluster, newSects));
        }
        newSects = new ArrayList();
        newSects.add(firstSection);
        for (i = myInd + 1; i < clusterSects.size(); ++i) {
            nextSection = (FaultSection)clusterSects.get(i);
            newSects.add(nextSection);
            permuations.add(ExhaustiveUnilateralRuptureGrowingStrategy.buildCopyJumps(fullCluster, newSects));
        }
        return permuations;
    }

    private static FaultSubsectionCluster buildCopyJumps(FaultSubsectionCluster fullCluster, List<FaultSection> subsetSects) {
        FaultSubsectionCluster permutation = new FaultSubsectionCluster(new ArrayList<FaultSection>(subsetSects));
        for (FaultSection sect : subsetSects) {
            for (Jump jump : fullCluster.getConnections(sect)) {
                permutation.addConnection(new Jump(sect, permutation, jump.toSection, jump.toCluster, jump.distance));
            }
        }
        return permutation;
    }

    @Override
    public String getName() {
        return "Exhaustive Unilateral";
    }
}

