/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class InputJumpsOrDistClusterConnectionStrategy
extends ClusterConnectionStrategy {
    private SectionDistanceAzimuthCalculator distCalc;
    private double maxJumpDist;
    private HashSet<IDPairing> allowedSectConnections;

    public InputJumpsOrDistClusterConnectionStrategy(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, Collection<Jump> inputJumps) {
        super(subSects, distCalc);
        this.maxJumpDist = maxJumpDist;
        this.distCalc = distCalc;
        this.initAllowedSectConnections(inputJumps);
    }

    public InputJumpsOrDistClusterConnectionStrategy(List<? extends FaultSection> subSects, List<FaultSubsectionCluster> clusters, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, Collection<Jump> inputJumps) {
        super(subSects, clusters, distCalc);
        this.maxJumpDist = maxJumpDist;
        this.distCalc = distCalc;
        this.initAllowedSectConnections(inputJumps);
    }

    private void initAllowedSectConnections(Collection<Jump> jumps) {
        this.allowedSectConnections = new HashSet();
        for (Jump jump : jumps) {
            IDPairing pair = new IDPairing(jump.fromSection.getSectionId(), jump.toSection.getSectionId());
            this.allowedSectConnections.add(pair);
            this.allowedSectConnections.add(pair.getReversed());
        }
    }

    @Override
    protected List<Jump> buildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        ArrayList<Jump> ret = new ArrayList<Jump>();
        Jump closestJump = null;
        for (FaultSection s1 : from.subSects) {
            for (FaultSection s2 : to.subSects) {
                double dist = this.distCalc.getDistance(s1, s2);
                if (this.allowedSectConnections.contains(new IDPairing(s1.getSectionId(), s2.getSectionId()))) {
                    ret.add(new Jump(s1, from, s2, to, dist));
                    continue;
                }
                if (!((float)dist <= (float)this.maxJumpDist) || closestJump != null && !((float)dist < (float)closestJump.distance)) continue;
                closestJump = new Jump(s1, from, s2, to, dist);
            }
        }
        if (ret.isEmpty() && closestJump != null) {
            ret.add(closestJump);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    @Override
    public String getName() {
        return "InputPlusDist: maxDist=" + (float)this.maxJumpDist + " km";
    }

    @Override
    public double getMaxJumpDist() {
        return this.maxJumpDist;
    }
}

