/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import org.dom4j.DocumentException;
import org.opensha.commons.data.Named;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.SplayCountFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.SplayLengthFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.U3CompatibleCumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.NetRuptureCoulombFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.SectCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.AdaptiveClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveBilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveUnilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.PlausibleClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.SectCountAdaptiveRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.UCERF3ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.inversion.coulomb.CoulombRates;

public class ClusterRupturePerturbationBuilder {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        boolean bl;
        File rupSetsDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
        File markdownDir = new File("/home/kevin/markdown/rupture-sets");
        String primaryName = "Plausible Adaptive 6-15km (MultiEnds), Rake\u2264360, Jump P>0.001, Slip P>0.05 (@Incr), CFF 3/4 Ints >0, CFF Comb Paths: [Sect R>0.5, P>0.01], 10% Fract Increase";
        File primaryFile = new File(rupSetsDir, "fm3_1_plausibleMulti15km_adaptive6km_direct_cmlRake360_jumpP0.001_slipP0.05incrCapDist_cff0.75IntsPos_comb2Paths_cffFavP0.01_cffFavRatioN2P0.5_sectFractGrow0.1.zip");
        float cffFractInts = 0.75f;
        int cffRatioN = 2;
        float cffRatioThresh = 0.5f;
        float cffRelativeProb = 0.01f;
        boolean favorableJumps = true;
        float sectGrowFract = 0.1f;
        double[] altJumpDists = new double[]{5.0, 6.0, 8.0, 10.0, 15.0, 20.0};
        double adaptiveR0 = 6.0;
        ScalingRelationships scale = ScalingRelationships.MEAN_UCERF3;
        boolean rebuild = false;
        boolean replot = true;
        boolean skipPlausibility = true;
        RuptureGrowingStrategy primaryGrowingStrat = sectGrowFract > 0.0f ? new SectCountAdaptiveRuptureGrowingStrategy(sectGrowFract, true, 2) : new ExhaustiveUnilateralRuptureGrowingStrategy();
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(primaryFile);
        PlausibilityConfiguration primaryConfig = rupSet.getModule(PlausibilityConfiguration.class);
        Preconditions.checkNotNull((Object)primaryConfig);
        List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        SectionDistanceAzimuthCalculator distAzCalc = primaryConfig.getDistAzCalc();
        SubSectStiffnessCalculator stiffnessCalc = new SubSectStiffnessCalculator(subSects, 2.0, 30000.0, 30000.0, 0.5, SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP, 1.0);
        AggregatedStiffnessCalculator sumAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        AggregatedStiffnessCalculator fractIntsAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.NORM_BY_COUNT);
        System.out.println("Initializing alt connection strategies");
        double origMaxJumpDist = primaryConfig.getConnectionStrategy().getMaxJumpDist();
        ArrayList<ClusterConnectionStrategy> altConnStrats = new ArrayList<ClusterConnectionStrategy>();
        altConnStrats.add(new DistCutoffClosestSectClusterConnectionStrategy(rupSet.getFaultSectionDataList(), primaryConfig.getDistAzCalc(), origMaxJumpDist));
        List<PlausibilityFilter> origConnFilters = ClusterRupturePerturbationBuilder.buildPlausibleConnFilters(distAzCalc, new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, 0.1), sumAgg, fractIntsAgg, cffFractInts, cffRatioN, cffRatioThresh, cffRelativeProb, favorableJumps, origMaxJumpDist);
        PlausibleClusterConnectionStrategy singleConnStrat = new PlausibleClusterConnectionStrategy(subSects, distAzCalc, origMaxJumpDist, PlausibleClusterConnectionStrategy.JUMP_SELECTOR_DEFAULT_SINGLE, origConnFilters);
        if (adaptiveR0 > 0.0) {
            altConnStrats.add(new AdaptiveClusterConnectionStrategy((ClusterConnectionStrategy)altConnStrats.get(0), adaptiveR0, 1));
            altConnStrats.add(new AdaptiveClusterConnectionStrategy(singleConnStrat, adaptiveR0, 1));
            altConnStrats.add(new PlausibleClusterConnectionStrategy(subSects, distAzCalc, origMaxJumpDist, PlausibleClusterConnectionStrategy.JUMP_SELECTOR_DEFAULT, origConnFilters));
            for (double altR0 : altJumpDists) {
                if ((float)altR0 == (float)adaptiveR0 || !((float)altR0 < (float)origMaxJumpDist)) continue;
                PlausibleClusterConnectionStrategy plausible = new PlausibleClusterConnectionStrategy(subSects, distAzCalc, origMaxJumpDist, PlausibleClusterConnectionStrategy.JUMP_SELECTOR_DEFAULT, origConnFilters);
                altConnStrats.add(new AdaptiveClusterConnectionStrategy(plausible, altR0, 1));
            }
        } else {
            altConnStrats.add(singleConnStrat);
        }
        for (double maxJumpDist : altJumpDists) {
            if ((float)maxJumpDist == (float)origMaxJumpDist) continue;
            List<PlausibilityFilter> connFilters = ClusterRupturePerturbationBuilder.buildPlausibleConnFilters(distAzCalc, new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, 0.1), sumAgg, fractIntsAgg, cffFractInts, cffRatioN, cffRatioThresh, cffRelativeProb, favorableJumps, maxJumpDist);
            PlausibleClusterConnectionStrategy plausible = new PlausibleClusterConnectionStrategy(subSects, distAzCalc, maxJumpDist, PlausibleClusterConnectionStrategy.JUMP_SELECTOR_DEFAULT, connFilters);
            if (adaptiveR0 > 0.0 && (float)adaptiveR0 < (float)maxJumpDist) {
                altConnStrats.add(new AdaptiveClusterConnectionStrategy(plausible, adaptiveR0, 1));
                continue;
            }
            altConnStrats.add(plausible);
        }
        System.out.println("Initializing alt growing strategies");
        ArrayList<RuptureGrowingStrategy> altGrowStrats = new ArrayList<RuptureGrowingStrategy>();
        altGrowStrats.add(new ExhaustiveUnilateralRuptureGrowingStrategy());
        if (sectGrowFract != 0.1f) {
            altGrowStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(0.1f, true, 2));
        }
        if (sectGrowFract != 0.05f) {
            altGrowStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(0.05f, true, 2));
        }
        altGrowStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.EQUAL_LEN, false), sectGrowFract, true, 2));
        altGrowStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.SINGLE_FULL, false), sectGrowFract, true, 2));
        altGrowStrats.add(new SectCountAdaptiveRuptureGrowingStrategy(new ExhaustiveBilateralRuptureGrowingStrategy(ExhaustiveBilateralRuptureGrowingStrategy.SecondaryVariations.ALL, false), sectGrowFract, true, 2));
        System.out.println("Primnary has " + rupSet.getNumRuptures() + " ruptures");
        List<PlausibilityFilter> filters = primaryConfig.getFilters();
        ClusterConnectionStrategy primaryConnStrat = primaryConfig.getConnectionStrategy();
        String primaryPrefix = primaryFile.getName().replace(".zip", "");
        File indexDir = new File(markdownDir, primaryPrefix);
        Preconditions.checkState((indexDir.exists() || indexDir.mkdir() ? 1 : 0) != 0);
        File outputDir = new File(rupSetsDir, primaryPrefix + "_comp");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        System.out.println("Adding filter-removal configs");
        ArrayList<PlausibilityConfiguration> configs = new ArrayList<PlausibilityConfiguration>();
        ArrayList<RuptureGrowingStrategy> growingStrats = new ArrayList<RuptureGrowingStrategy>();
        ArrayList<Object> names = new ArrayList<Object>();
        ArrayList<Object> prefixes = new ArrayList<Object>();
        for (int f = 0; f < filters.size(); ++f) {
            PlausibilityFilter filter = filters.get(f);
            if (filter instanceof SectCountAdaptiveRuptureGrowingStrategy.ConnPointCleanupFilter) continue;
            ArrayList<PlausibilityFilter> otherFilters = new ArrayList<PlausibilityFilter>(filters);
            otherFilters.remove(f);
            if (filter instanceof PathPlausibilityFilter && ((PathPlausibilityFilter)filter).getEvaluators().length > 1) {
                PathPlausibilityFilter pathPlausibilityFilter = (PathPlausibilityFilter)filter;
                NucleationClusterEvaluator[] nucleationClusterEvaluatorArray = pathPlausibilityFilter.getEvaluators();
                for (int e = 0; e < nucleationClusterEvaluatorArray.length; ++e) {
                    int i;
                    NucleationClusterEvaluator[] oEvals = new NucleationClusterEvaluator[nucleationClusterEvaluatorArray.length - 1];
                    for (i = 0; i < e; ++i) {
                        oEvals[i] = nucleationClusterEvaluatorArray[i];
                    }
                    for (i = e + 1; i < nucleationClusterEvaluatorArray.length; ++i) {
                        oEvals[i - 1] = nucleationClusterEvaluatorArray[i];
                    }
                    PathPlausibilityFilter oFilter = new PathPlausibilityFilter(pathPlausibilityFilter.getFractPassThreshold(), pathPlausibilityFilter.isLogicalOr(), oEvals);
                    ArrayList<PlausibilityFilter> myFilters = new ArrayList<PlausibilityFilter>(otherFilters);
                    myFilters.add(oFilter);
                    configs.add(new PlausibilityConfiguration(myFilters, primaryConfig.getMaxNumSplays(), primaryConnStrat, distAzCalc));
                    names.add("Sans Filter: " + nucleationClusterEvaluatorArray[e].getName());
                    prefixes.add("sans_" + ClusterRupturePerturbationBuilder.fileSafe(nucleationClusterEvaluatorArray[e].getShortName()));
                    growingStrats.add(primaryGrowingStrat);
                }
                ArrayList<PlausibilityFilter> myFilters = new ArrayList<PlausibilityFilter>(otherFilters);
                for (NucleationClusterEvaluator eval : nucleationClusterEvaluatorArray) {
                    myFilters.add(new PathPlausibilityFilter(pathPlausibilityFilter.getFractPassThreshold(), pathPlausibilityFilter.isLogicalOr(), eval));
                }
                configs.add(new PlausibilityConfiguration(myFilters, primaryConfig.getMaxNumSplays(), primaryConnStrat, distAzCalc));
                names.add(nucleationClusterEvaluatorArray.length + " Path Filters Separated");
                prefixes.add("separate_paths");
                growingStrats.add(primaryGrowingStrat);
                continue;
            }
            configs.add(new PlausibilityConfiguration(otherFilters, primaryConfig.getMaxNumSplays(), primaryConnStrat, distAzCalc));
            names.add("Sans Filter: " + filter.getName());
            prefixes.add("sans_" + ClusterRupturePerturbationBuilder.fileSafe(filter.getShortName()));
            growingStrats.add(primaryGrowingStrat);
        }
        System.out.println("Adding UCERF3-related alternatives");
        PlausibilityConfiguration.Builder builder = PlausibilityConfiguration.builder(primaryConnStrat, distAzCalc).minSectsPerParent(2, true, true).u3Azimuth().cumulativeRakeChange(180.0f).cumulativeAzChange(560.0f);
        if (primaryGrowingStrat instanceof SectCountAdaptiveRuptureGrowingStrategy) {
            builder.add(((SectCountAdaptiveRuptureGrowingStrategy)primaryGrowingStrat).buildConnPointCleanupFilter(primaryConnStrat));
        }
        configs.add(builder.build());
        names.add("UCERF3 Azimuth & Cumulative Filters");
        prefixes.add("ucerf_filters_sans_coulomb");
        growingStrats.add(primaryGrowingStrat);
        boolean hasCmlAz = false;
        for (PlausibilityFilter plausibilityFilter : filters) {
            if (!(plausibilityFilter instanceof CumulativeAzimuthChangeFilter)) continue;
            hasCmlAz = true;
        }
        if (!hasCmlAz) {
            ArrayList<PlausibilityFilter> plusAz = new ArrayList<PlausibilityFilter>(filters);
            plusAz.add(new CumulativeAzimuthChangeFilter(new JumpAzimuthChangeFilter.SimpleAzimuthCalc(distAzCalc), 560.0f));
            configs.add(PlausibilityConfiguration.builder(primaryConnStrat, distAzCalc).addAll(plusAz).build());
            names.add("Add Cumulative Azimuth");
            prefixes.add("add_CumulativeAzimuth");
            growingStrats.add(primaryGrowingStrat);
        }
        boolean hasCmlRake = false;
        for (PlausibilityFilter plausibilityFilter : filters) {
            if (!(plausibilityFilter instanceof CumulativeRakeChangeFilter) && !(plausibilityFilter instanceof U3CompatibleCumulativeRakeChangeFilter)) continue;
            hasCmlRake = true;
        }
        if (!hasCmlRake) {
            ArrayList<PlausibilityFilter> arrayList = new ArrayList<PlausibilityFilter>(filters);
            arrayList.add(new CumulativeRakeChangeFilter(180.0f));
            configs.add(PlausibilityConfiguration.builder(primaryConnStrat, distAzCalc).addAll(arrayList).build());
            names.add("Add Cumulative Rake<=180");
            prefixes.add("add_CumulativeRake");
            growingStrats.add(primaryGrowingStrat);
        }
        boolean bl2 = false;
        for (PlausibilityFilter filter : filters) {
            if (!(filter instanceof CumulativeProbabilityFilter) || !(((CumulativeProbabilityFilter)filter).getProbCalcs()[0] instanceof Shaw07JumpDistProb)) continue;
            bl = true;
        }
        if (hasCmlRake && bl) {
            ArrayList<PlausibilityFilter> arrayList = new ArrayList<PlausibilityFilter>(filters);
            int r = arrayList.size();
            while (--r >= 0) {
                PlausibilityFilter filter = filters.get(r);
                if (!(filter instanceof CumulativeRakeChangeFilter) && !(filter instanceof U3CompatibleCumulativeRakeChangeFilter) && (!(filter instanceof CumulativeProbabilityFilter) || !(((CumulativeProbabilityFilter)filter).getProbCalcs()[0] instanceof Shaw07JumpDistProb))) continue;
                arrayList.remove(r);
            }
            Preconditions.checkState((arrayList.size() == filters.size() - 2 ? 1 : 0) != 0);
            configs.add(PlausibilityConfiguration.builder(primaryConnStrat, distAzCalc).addAll(arrayList).build());
            names.add("Sans Filters: Cumulative Rake & Jump Distance");
            prefixes.add("sans_CumulativeRakeAndJump");
            growingStrats.add(primaryGrowingStrat);
        }
        builder = PlausibilityConfiguration.builder(primaryConnStrat, distAzCalc).minSectsPerParent(2, true, true).cumulativeRakeChange(180.0f).cumulativeAzChange(560.0f);
        builder.add(new CumulativeProbabilityFilter(cffRatioThresh, new CoulombSectRatioProb(sumAgg, cffRatioN, favorableJumps, (float)primaryConnStrat.getMaxJumpDist(), distAzCalc)));
        builder.add(new NetRuptureCoulombFilter(fractIntsAgg, cffFractInts));
        if (primaryGrowingStrat instanceof SectCountAdaptiveRuptureGrowingStrategy) {
            builder.add(((SectCountAdaptiveRuptureGrowingStrategy)primaryGrowingStrat).buildConnPointCleanupFilter(primaryConnStrat));
        }
        configs.add(builder.build());
        names.add("UCERF3 Cumulative Filters, New CFF Ratio & 3/4 Interactions");
        prefixes.add("ucerf3_cumulatives_cffRatio_cffInteractions");
        growingStrats.add(primaryGrowingStrat);
        if (altGrowStrats != null) {
            System.out.println("Adding alt gorwing strategies");
            for (RuptureGrowingStrategy altPermStrat : altGrowStrats) {
                Iterator<PlausibilityFilter> otherFilters = new ArrayList();
                for (PlausibilityFilter filter : filters) {
                    if (filter instanceof SectCountAdaptiveRuptureGrowingStrategy.ConnPointCleanupFilter) continue;
                    otherFilters.add(filter);
                }
                if (altPermStrat instanceof SectCountAdaptiveRuptureGrowingStrategy) {
                    otherFilters.add(((SectCountAdaptiveRuptureGrowingStrategy)altPermStrat).buildConnPointCleanupFilter(primaryConnStrat));
                }
                configs.add(new PlausibilityConfiguration((List<PlausibilityFilter>)((Object)otherFilters), primaryConfig.getMaxNumSplays(), primaryConnStrat, distAzCalc));
                names.add("Alt Growing: " + altPermStrat.getName());
                prefixes.add("alt_grow_" + ClusterRupturePerturbationBuilder.fileSafe(altPermStrat.getName()));
                growingStrats.add(altPermStrat);
            }
        }
        int n = Integer.max(1, Integer.min(31, Runtime.getRuntime().availableProcessors() - 2));
        if (altConnStrats != null && altConnStrats.size() > 0) {
            System.out.println("Adding alt connection strategies");
            String filtersJSON = primaryConfig.filtersToJSON(filters);
            for (ClusterConnectionStrategy altConnStrat : altConnStrats) {
                altConnStrat.checkBuildThreaded(n);
                List<PlausibilityFilter> altFilters = PlausibilityConfiguration.readFiltersJSON(filtersJSON, altConnStrat, distAzCalc);
                if ((float)altConnStrat.getMaxJumpDist() != (float)primaryConnStrat.getMaxJumpDist()) {
                    System.out.println("Chekcing for Max Jump Dist updates...");
                    for (PlausibilityFilter filter : altFilters) {
                        if (filter instanceof CumulativeProbabilityFilter) {
                            for (Named named : ((CumulativeProbabilityFilter)filter).getProbCalcs()) {
                                ClusterRupturePerturbationBuilder.checkUpdateProbCalcJumpDist((float)altConnStrat.getMaxJumpDist(), (RuptureProbabilityCalc)named);
                            }
                            continue;
                        }
                        if (!(filter instanceof PathPlausibilityFilter)) continue;
                        for (Named named : ((PathPlausibilityFilter)filter).getEvaluators()) {
                            if (named instanceof CumulativeProbPathEvaluator) {
                                for (RuptureProbabilityCalc calc : ((CumulativeProbPathEvaluator)named).getCalcs()) {
                                    ClusterRupturePerturbationBuilder.checkUpdateProbCalcJumpDist((float)altConnStrat.getMaxJumpDist(), calc);
                                }
                                continue;
                            }
                            if (!(named instanceof SectCoulombPathEvaluator)) continue;
                            ((SectCoulombPathEvaluator)named).setMaxJumpDist((float)altConnStrat.getMaxJumpDist());
                            System.out.println("Updated " + named.getName() + " to " + (float)altConnStrat.getMaxJumpDist() + "km");
                        }
                    }
                }
                configs.add(new PlausibilityConfiguration(altFilters, primaryConfig.getMaxNumSplays(), altConnStrat, distAzCalc));
                names.add("Alt Connections: " + altConnStrat.getName());
                prefixes.add("alt_conn_" + ClusterRupturePerturbationBuilder.fileSafe(altConnStrat.getName()));
                growingStrats.add(primaryGrowingStrat);
            }
        }
        if (primaryConfig.getMaxNumSplays() > 0) {
            ArrayList<PlausibilityFilter> otherFilters = new ArrayList<PlausibilityFilter>();
            for (PlausibilityFilter filter : filters) {
                if (filter instanceof SplayLengthFilter || filter instanceof SplayCountFilter) continue;
                otherFilters.add(filter);
            }
            configs.add(new PlausibilityConfiguration(otherFilters, 0, primaryConnStrat, distAzCalc));
            names.add("Sans: Splays");
            prefixes.add("sans_sect_increase_thinning");
            growingStrats.add(primaryGrowingStrat);
        }
        System.out.println("Loading Coulomb caches");
        HashMap<String, List<AggregatedStiffnessCache>> loadedCoulombCaches = new HashMap<String, List<AggregatedStiffnessCache>>();
        ReportPageGen.checkLoadCoulombCache(filters, rupSetsDir, loadedCoulombCaches);
        System.out.println("Will process " + names.size() + " perterbations:");
        HashSet<String> prevPrefixes = new HashSet<String>();
        for (int i = 0; i < configs.size(); ++i) {
            String name = (String)names.get(i);
            String prefix = (String)prefixes.get(i);
            File outputFile = new File(outputDir, prefix + ".zip");
            System.out.println("\t" + name + ": " + prefix + "\texists ? " + outputFile.exists());
            Preconditions.checkState((!prevPrefixes.contains(prefix) ? 1 : 0) != 0, (String)"Duplicate prefix: %s", (Object)prefix);
            prevPrefixes.add(prefix);
        }
        if (subSects.size() == 2606) {
            String prefix = "ucerf3";
            File plotDir = new File(indexDir, prefix);
            Preconditions.checkState((plotDir.exists() || plotDir.mkdir() ? 1 : 0) != 0);
            if (replot || !new File(plotDir, "README.md").exists()) {
                FaultSystemSolution u3 = FaultSystemSolution.load(new File(rupSetsDir, "fm3_1_ucerf3.zip"));
                System.out.println("Plotting UCERF3");
                ReportMetadata meta = new ReportMetadata(new RupSetMetadata(primaryName, rupSet), new RupSetMetadata("UCERF3", u3));
                ReportPageGen pageGen = new ReportPageGen(meta, plotDir, ReportPageGen.getDefaultRupSetPlots(ReportPageGen.PlotLevel.FULL));
                UCERF3ClusterConnectionStrategy altConnStrat = new UCERF3ClusterConnectionStrategy(subSects, distAzCalc, 5.0, CoulombRates.loadUCERF3CoulombRates(FaultModels.FM3_1));
                String filtersJSON = primaryConfig.filtersToJSON(filters);
                List<PlausibilityFilter> list = PlausibilityConfiguration.readFiltersJSON(filtersJSON, (ClusterConnectionStrategy)altConnStrat, distAzCalc);
                int i = list.size();
                while (--i >= 0) {
                    if (!(list.get(i) instanceof SectCountAdaptiveRuptureGrowingStrategy.ConnPointCleanupFilter)) continue;
                    list.remove(i);
                }
                ReportPageGen.checkLoadCoulombCache(list, rupSetsDir, loadedCoulombCaches);
                pageGen.setAltPlausibility(list, null, true);
                pageGen.setReplot(true);
                pageGen.generatePage();
            }
        }
        RupSetMetadata primaryMeta = new RupSetMetadata(primaryName, rupSet);
        for (int i = 0; i < configs.size(); ++i) {
            void var55_110;
            void var55_108;
            File plotDir;
            System.gc();
            PlausibilityConfiguration altConfig = (PlausibilityConfiguration)configs.get(i);
            String name = (String)names.get(i);
            String prefix = (String)prefixes.get(i);
            System.out.println("Processing alternative: " + name);
            RuptureGrowingStrategy permStrat = (RuptureGrowingStrategy)growingStrats.get(i);
            File outputFile = new File(outputDir, prefix + ".zip");
            System.out.println("RupSet file: " + outputFile.getAbsolutePath());
            Object var55_106 = null;
            if (rebuild || !outputFile.exists()) {
                System.out.println("Building...");
                ClusterRuptureBuilder build = new ClusterRuptureBuilder(altConfig);
                List<ClusterRupture> rups = build.build(permStrat, n);
                FaultSystemRupSet faultSystemRupSet = ClusterRuptureBuilder.buildClusterRupSet(scale, rupSet.getFaultSectionDataList(), altConfig, rups);
                System.out.println("Writing to " + outputFile.getAbsolutePath());
                faultSystemRupSet.getArchive().write(outputFile);
            }
            Preconditions.checkState(((plotDir = new File(indexDir, prefix)).exists() || plotDir.mkdir() ? 1 : 0) != 0);
            if (!replot && new File(plotDir, "README.md").exists() && var55_108 == null) continue;
            if (var55_108 == null) {
                System.out.println("Loading already built " + name + " from " + outputFile.getAbsolutePath());
                FaultSystemRupSet faultSystemRupSet = FaultSystemRupSet.load(outputFile);
            }
            System.out.println("Plotting " + name);
            RupSetMetadata compMeta = new RupSetMetadata(name, (FaultSystemRupSet)var55_110);
            ReportMetadata meta = new ReportMetadata(primaryMeta, compMeta);
            ReportPageGen pageGen = new ReportPageGen(meta, plotDir, ReportPageGen.getDefaultRupSetPlots(ReportPageGen.PlotLevel.FULL));
            if (skipPlausibility) {
                pageGen.skipPlausibility();
            }
            pageGen.setIndexDir(indexDir);
            pageGen.setReplot(true);
            pageGen.generatePage();
        }
        System.out.println("DONE");
    }

    private static List<PlausibilityFilter> buildPlausibleConnFilters(SectionDistanceAzimuthCalculator distAzCalc, DistCutoffClosestSectClusterConnectionStrategy neighborsConnStrat, AggregatedStiffnessCalculator sumAgg, AggregatedStiffnessCalculator fractIntsAgg, float cffFractInts, int cffRatioN, float cffRatioThresh, float cffRelativeProb, boolean favorableJumps, double maxJumpDist) {
        ArrayList<PlausibilityFilter> connFilters = new ArrayList<PlausibilityFilter>();
        if (cffRatioThresh > 0.0f) {
            connFilters.add(new CumulativeProbabilityFilter(cffRatioThresh, new CoulombSectRatioProb(sumAgg, cffRatioN, favorableJumps, (float)maxJumpDist, distAzCalc)));
            if (cffRelativeProb > 0.0f) {
                connFilters.add(new PathPlausibilityFilter(new CumulativeProbPathEvaluator(cffRatioThresh, PlausibilityResult.FAIL_HARD_STOP, new CoulombSectRatioProb(sumAgg, cffRatioN, favorableJumps, (float)maxJumpDist, distAzCalc)), new CumulativeProbPathEvaluator(cffRelativeProb, PlausibilityResult.FAIL_HARD_STOP, new RelativeCoulombProb(sumAgg, neighborsConnStrat, false, true, favorableJumps, (float)maxJumpDist, distAzCalc))));
            }
        } else if (cffRelativeProb > 0.0f) {
            connFilters.add(new CumulativeProbabilityFilter(cffRatioThresh, new RelativeCoulombProb(sumAgg, neighborsConnStrat, false, true, favorableJumps, (float)maxJumpDist, distAzCalc)));
        }
        if (cffFractInts > 0.0f) {
            connFilters.add(new NetRuptureCoulombFilter(fractIntsAgg, cffFractInts));
        }
        return connFilters;
    }

    private static String fileSafe(String str) {
        str = str.replace(",", "_");
        str = str.replace("(", "_");
        str = str.replace(")", "_");
        str = str.replace("\u2265", "GE");
        str = str.replace("\u2264", "LE");
        str = str.replace(">", "GT");
        str = str.replace("<", "LT");
        str = str.replace(".", "p");
        return FileNameUtils.simplify(str);
    }

    private static void checkUpdateProbCalcJumpDist(float newJumpDist, RuptureProbabilityCalc calc) {
        if (calc instanceof RelativeCoulombProb) {
            ((RelativeCoulombProb)calc).setMaxJumpDist(newJumpDist);
            System.out.println("Updated " + calc.getName() + " to " + newJumpDist + "km");
        } else if (calc instanceof CoulombSectRatioProb) {
            ((CoulombSectRatioProb)calc).setMaxJumpDist(newJumpDist);
            System.out.println("Updated " + calc.getName() + " to " + newJumpDist + "km");
        }
    }
}

