/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class ComplexRuptureTreeNavigator
implements RuptureTreeNavigator {
    private Map<Integer, FaultSubsectionCluster[]> parentClusterMap;
    private Map<FaultSubsectionCluster, ClusterConnections> clusterConnectionsMap;
    private ClusterRupture rupture;

    public ComplexRuptureTreeNavigator(ClusterRupture rupture) {
        this.rupture = rupture;
        this.parentClusterMap = new HashMap<Integer, FaultSubsectionCluster[]>();
        this.clusterConnectionsMap = new HashMap<FaultSubsectionCluster, ClusterConnections>();
        this.clusterConnectionsMap.put(rupture.clusters[0], new ClusterConnections(null));
        Iterable<Jump> jumps = rupture.getJumpsIterable();
        for (Jump jump : jumps) {
            ClusterConnections connections = this.clusterConnectionsMap.get(jump.toCluster);
            if (connections != null) continue;
            connections = new ClusterConnections(jump);
            this.clusterConnectionsMap.put(jump.toCluster, connections);
        }
        int numClusters = rupture.getTotalNumClusters();
        Preconditions.checkState((this.clusterConnectionsMap.size() == numClusters ? 1 : 0) != 0, (String)"We have %s clusters but clusterConnectionsMap only has %s entries:\n%s", (Object)numClusters, (Object)this.clusterConnectionsMap.size(), this.clusterConnectionsMap);
        for (Jump jump : jumps) {
            ClusterConnections connections = this.clusterConnectionsMap.get(jump.fromCluster);
            Preconditions.checkNotNull((Object)connections, (String)"No ClusterConnections instance found for cluster %s (from jump %s).\n\tRupture: %s\n\tConnMap: %s", (Object)jump.fromCluster, (Object)jump, (Object)rupture, this.clusterConnectionsMap);
            connections.addJumpFrom(jump);
        }
        for (FaultSubsectionCluster cluster : this.clusterConnectionsMap.keySet()) {
            int parentID = cluster.parentSectionID;
            FaultSubsectionCluster[] matches = this.parentClusterMap.get(parentID);
            if (matches == null) {
                this.parentClusterMap.put(parentID, new FaultSubsectionCluster[]{cluster});
                continue;
            }
            matches = Arrays.copyOf(matches, matches.length + 1);
            matches[matches.length - 1] = cluster;
            this.parentClusterMap.put(parentID, matches);
        }
    }

    @Override
    public FaultSubsectionCluster getPredecessor(FaultSubsectionCluster cluster) {
        return this.clusterConnectionsMap.get((Object)cluster).predecessor;
    }

    public List<FaultSubsectionCluster> getDescendants(FaultSubsectionCluster cluster) {
        return this.clusterConnectionsMap.get((Object)cluster).descendants;
    }

    @Override
    public FaultSubsectionCluster locateCluster(FaultSection sect) {
        Preconditions.checkState((sect.getParentSectionId() >= 0 ? 1 : 0) != 0, (Object)"parent section IDs must be populated");
        FaultSubsectionCluster[] clusters = this.parentClusterMap.get(sect.getParentSectionId());
        Preconditions.checkNotNull((Object)clusters, (String)"Couldn't locate cluster with parent %s in rupture:\n%s", (int)sect.getParentSectionId(), (Object)this.rupture);
        if (clusters.length == 1) {
            return clusters[0];
        }
        for (FaultSubsectionCluster cluster : clusters) {
            if (!cluster.contains(sect)) continue;
            return cluster;
        }
        throw new IllegalStateException("Section " + sect.getSectionName() + " not found in any clusters");
    }

    private int indexWithinCluster(FaultSection sect, FaultSubsectionCluster cluster) {
        int targetID = sect.getSectionId();
        for (int i = 0; i < cluster.subSects.size(); ++i) {
            FaultSection test = (FaultSection)cluster.subSects.get(i);
            if (test.getSectionId() != targetID) continue;
            return i;
        }
        throw new IllegalStateException("Couldn't locate section " + sect.getParentSectionId() + ":" + targetID + " (" + sect.getSectionName() + ") in cluster " + String.valueOf(cluster) + ".\nFull rupture: " + String.valueOf(this.rupture));
    }

    @Override
    public Jump getJump(FaultSubsectionCluster fromCluster, FaultSubsectionCluster toCluster) {
        Jump ret = this.doGetJump(fromCluster, toCluster);
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("Rupture does not use a direct jump between " + String.valueOf(fromCluster) + " to " + String.valueOf(toCluster));
    }

    @Override
    public boolean hasJump(FaultSubsectionCluster fromCluster, FaultSubsectionCluster toCluster) {
        return this.doGetJump(fromCluster, toCluster) != null;
    }

    private Jump doGetJump(FaultSubsectionCluster fromCluster, FaultSubsectionCluster toCluster) {
        ClusterConnections connections = this.clusterConnectionsMap.get(toCluster);
        Preconditions.checkNotNull((Object)connections, (String)"toCluster not found: %s", (Object)toCluster);
        if (connections.jumpTo != null && connections.jumpTo.fromCluster == fromCluster) {
            return connections.jumpTo;
        }
        connections = this.clusterConnectionsMap.get(fromCluster);
        Preconditions.checkNotNull((Object)connections, (String)"fromCluster not found: %s", (Object)fromCluster);
        if (connections.jumpTo != null && connections.jumpTo.fromCluster == toCluster) {
            return connections.jumpTo.reverse();
        }
        return null;
    }

    @Override
    public Jump getJump(FaultSection fromSection, FaultSection toSection) {
        Jump ret = this.doGetJump(fromSection, toSection);
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("Rupture does not use a direct jump between " + fromSection.getSectionId() + " to " + toSection.getSectionId());
    }

    @Override
    public boolean hasJump(FaultSection fromSection, FaultSection toSection) {
        return this.doGetJump(fromSection, toSection) != null;
    }

    private Jump doGetJump(FaultSection fromSection, FaultSection toSection) {
        FaultSubsectionCluster toCluster;
        FaultSubsectionCluster fromCluster = this.locateCluster(fromSection);
        Preconditions.checkState((fromCluster != (toCluster = this.locateCluster(toSection)) && fromCluster != null && fromCluster.contains(fromSection) && toCluster != null && toCluster.contains(toSection) ? 1 : 0) != 0);
        ClusterConnections connections = this.clusterConnectionsMap.get(toCluster);
        Preconditions.checkNotNull((Object)connections, (String)"toCluster not found: %s", (Object)toCluster);
        if (connections.jumpTo != null && connections.jumpTo.fromCluster == fromCluster) {
            Jump jump = connections.jumpTo;
            Preconditions.checkState((jump.fromSection.equals(fromSection) && jump.toSection.equals(toSection) ? 1 : 0) != 0, (String)"Jump doesn't occur between %s and %s: %s", (Object)fromSection.getSectionId(), (Object)toSection.getSectionId(), (Object)connections.jumpTo);
            return jump;
        }
        connections = this.clusterConnectionsMap.get(fromCluster);
        Preconditions.checkNotNull((Object)connections, (String)"fromCluster not found: %s", (Object)fromCluster);
        if (connections.jumpTo != null && connections.jumpTo.fromCluster == toCluster) {
            Jump jump = connections.jumpTo.reverse();
            Preconditions.checkState((jump.fromSection.equals(fromSection) && jump.toSection.equals(toSection) ? 1 : 0) != 0, (String)"Jump doesn't occur between %s and %s: %s\n\tRupture: %s", (Object)fromSection.getSectionId(), (Object)toSection.getSectionId(), (Object)connections.jumpTo, (Object)this.rupture);
            return jump;
        }
        return null;
    }

    @Override
    public FaultSection getPredecessor(FaultSection sect) {
        FaultSubsectionCluster cluster = this.locateCluster(sect);
        ClusterConnections connections = this.clusterConnectionsMap.get(cluster);
        int indexInCluster = this.indexWithinCluster(sect, cluster);
        if (connections.jumpTo != null) {
            if (connections.jumpTo.toSection.equals(sect)) {
                return connections.jumpTo.fromSection;
            }
            int jumpToIndex = this.indexWithinCluster(connections.jumpTo.toSection, cluster);
            if (jumpToIndex > indexInCluster) {
                return (FaultSection)cluster.subSects.get(indexInCluster + 1);
            }
        }
        if (indexInCluster > 0) {
            return (FaultSection)cluster.subSects.get(indexInCluster - 1);
        }
        return null;
    }

    public List<FaultSection> getDescendants(FaultSection sect) {
        FaultSubsectionCluster cluster = this.locateCluster(sect);
        int indexInCluster = this.indexWithinCluster(sect, cluster);
        ArrayList<FaultSection> descendants = new ArrayList<FaultSection>();
        ClusterConnections connections = this.clusterConnectionsMap.get(cluster);
        if (connections.jumpTo != null) {
            int jumpIndexInCluster = this.indexWithinCluster(connections.jumpTo.toSection, cluster);
            if (jumpIndexInCluster == indexInCluster) {
                if (indexInCluster > 0) {
                    descendants.add((FaultSection)cluster.subSects.get(indexInCluster - 1));
                }
                if (indexInCluster < cluster.subSects.size() - 1) {
                    descendants.add((FaultSection)cluster.subSects.get(indexInCluster + 1));
                }
            } else if (jumpIndexInCluster > indexInCluster) {
                if (indexInCluster > 0) {
                    descendants.add((FaultSection)cluster.subSects.get(indexInCluster - 1));
                }
            } else if (indexInCluster < cluster.subSects.size() - 1) {
                descendants.add((FaultSection)cluster.subSects.get(indexInCluster + 1));
            }
        } else if (indexInCluster < cluster.subSects.size() - 1) {
            descendants.add((FaultSection)cluster.subSects.get(indexInCluster + 1));
        }
        for (Jump jump : connections.jumpsFrom) {
            if (jump.fromSection.getSectionId() != sect.getSectionId()) continue;
            descendants.add(jump.toSection);
        }
        return descendants;
    }

    @Override
    public Jump getJumpTo(FaultSubsectionCluster cluster) {
        ClusterConnections connections = this.clusterConnectionsMap.get(cluster);
        Preconditions.checkState((connections != null ? 1 : 0) != 0, (String)"Cluster not found in rupture: %s", (Object)cluster);
        return connections.jumpTo;
    }

    private class ClusterConnections {
        final FaultSubsectionCluster predecessor;
        final List<FaultSubsectionCluster> descendants;
        final Jump jumpTo;
        final List<Jump> jumpsFrom;

        public ClusterConnections(Jump jumpTo) {
            this.predecessor = jumpTo == null ? null : jumpTo.fromCluster;
            this.descendants = new ArrayList<FaultSubsectionCluster>();
            this.jumpTo = jumpTo;
            this.jumpsFrom = new ArrayList<Jump>();
        }

        private void addJumpFrom(Jump jump) {
            this.jumpsFrom.add(jump);
            this.descendants.add(jump.toCluster);
        }
    }
}

