/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.MultiDirectionalPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveUnilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.FilterDataClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class PassingSubRuptureSearch {
    private ClusterRupture rupture;
    private List<PlausibilityFilter> filters;
    private RuptureGrowingStrategy permStrat;
    private RuptureTreeNavigator nav;

    public PassingSubRuptureSearch(ClusterRupture rupture, List<PlausibilityFilter> filters) {
        this.rupture = rupture;
        this.filters = new ArrayList<PlausibilityFilter>();
        for (PlausibilityFilter filter : filters) {
            if (filter instanceof MultiDirectionalPlausibilityFilter) {
                this.filters.add(((MultiDirectionalPlausibilityFilter)filter).getFilter());
                continue;
            }
            this.filters.add(filter);
        }
        this.nav = rupture.getTreeNavigator();
        this.permStrat = new ExhaustiveUnilateralRuptureGrowingStrategy();
    }

    public ClusterRupture getLargestPassingSubset() {
        ClusterRupture largestPassing = null;
        for (FaultSubsectionCluster nucleationCluster : this.rupture.getClustersIterable()) {
            FilterDataClusterRupture rup = new FilterDataClusterRupture(nucleationCluster);
            if (!this.passes(rup)) {
                rup = null;
                int largestPassingPerm = 0;
                for (FaultSection sect : nucleationCluster.subSects) {
                    for (FaultSubsectionCluster perm : this.permStrat.getVariations(nucleationCluster, sect)) {
                        FilterDataClusterRupture test;
                        if (perm.subSects.size() <= largestPassingPerm || !this.passes(test = new FilterDataClusterRupture(perm))) continue;
                        rup = test;
                        largestPassingPerm = perm.subSects.size();
                    }
                }
            }
            if (rup == null) continue;
            ClusterRupture full = this.grow(rup);
            if (largestPassing != null && full.getTotalNumSects() <= largestPassing.getTotalNumSects()) continue;
            largestPassing = full;
        }
        return largestPassing;
    }

    public ClusterRupture grow(ClusterRupture rup) {
        ClusterRupture largest = rup;
        for (FaultSubsectionCluster fromCluster : rup.getClustersIterable()) {
            for (FaultSection sect : fromCluster.subSects) {
                for (FaultSection dest : this.getDestinationsNotInRupture(rup, sect)) {
                    ClusterRupture taken;
                    Jump jump = this.nav.getJump(sect, dest);
                    FaultSubsectionCluster toCluster = jump.toCluster;
                    if (!toCluster.startSect.equals(dest)) {
                        toCluster = new FaultSubsectionCluster((List<? extends FaultSection>)toCluster.subSects, dest, (Collection<FaultSection>)toCluster.endSects);
                    }
                    if (!this.passes(taken = rup.take(jump = new Jump(sect, fromCluster, dest, toCluster, jump.distance)))) {
                        taken = null;
                        int maxPass = 0;
                        for (FaultSubsectionCluster perm : this.permStrat.getVariations(jump.toCluster, dest)) {
                            Jump j2;
                            ClusterRupture permTest;
                            if (perm.subSects.size() < maxPass || !this.passes(permTest = rup.take(j2 = new Jump(jump.fromSection, jump.fromCluster, dest, perm, jump.distance)))) continue;
                            taken = permTest;
                            maxPass = perm.subSects.size();
                        }
                    }
                    if (taken == null || (taken = this.grow(taken)).getTotalNumSects() <= largest.getTotalNumSects()) continue;
                    largest = taken;
                }
            }
        }
        return largest;
    }

    private List<FaultSection> getDestinationsNotInRupture(ClusterRupture rup, FaultSection sect) {
        ArrayList<FaultSection> ret = new ArrayList<FaultSection>();
        FaultSection predecessor = this.nav.getPredecessor(sect);
        if (predecessor != null && !rup.contains(predecessor) & predecessor.getParentSectionId() != sect.getParentSectionId()) {
            ret.add(predecessor);
        }
        for (FaultSection descendant : this.nav.getDescendants(sect)) {
            if (!(!rup.contains(descendant) & descendant.getParentSectionId() != sect.getParentSectionId())) continue;
            ret.add(descendant);
        }
        return ret;
    }

    private boolean passes(ClusterRupture testRup) {
        PlausibilityResult result = PlausibilityResult.PASS;
        for (PlausibilityFilter filter : this.filters) {
            if ((result = result.logicalAnd(filter.apply(testRup, false))).isPass()) continue;
            return false;
        }
        return result.isPass();
    }
}

