/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.treeCombiners;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.logicTree.treeCombiner.AbstractLogicTreeCombiner;
import org.opensha.commons.logicTree.treeCombiner.LogicTreeCombinationProcessor;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.sha.earthquake.faultSysSolution.hazard.SiteLogicTreeHazardPageGen;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_SiteLogicTreeHazardCurveCalc;
import org.opensha.sha.earthquake.faultSysSolution.treeCombiners.HazardMapCombinationProcessor;

public class SiteHazardCurveCombinationProcessor
implements LogicTreeCombinationProcessor {
    private final File outerHazardCurvesFile;
    private final File innerHazardCurvesFile;
    private final File hazardCurvesOutputFile;
    private CSVFile<String> sitesCSV = null;
    private List<Site> sites = null;
    private List<List<String>> siteOutNames = null;
    private List<List<List<DiscretizedFunc>>> outerSiteCurves = null;
    private List<List<List<DiscretizedFunc>>> innerSiteCurves = null;
    private List<List<FileWriter>> siteCurveWriters = null;
    private List<Double> sitePeriods = null;
    private List<double[]> sitePerXVals = null;
    private File curveOutDir = null;
    private ExecutorService exec;
    private Stopwatch combineWatch = Stopwatch.createUnstarted();
    private Stopwatch curveWriteWatch = Stopwatch.createUnstarted();
    private LogicTree<?> combTree;

    public SiteHazardCurveCombinationProcessor(File outerHazardCurvesFile, File innerHazardCurvesFile, File hazardCurvesOutputFile) {
        this.outerHazardCurvesFile = outerHazardCurvesFile;
        this.innerHazardCurvesFile = innerHazardCurvesFile;
        this.hazardCurvesOutputFile = hazardCurvesOutputFile;
    }

    @Override
    public String getName() {
        return "Site hazard curves";
    }

    @Override
    public void init(AbstractLogicTreeCombiner.LogicTreeCombinationContext treeCombination, ExecutorService exec, ExecutorService ioExec) throws IOException {
        this.combTree = treeCombination.combTree;
        this.exec = exec;
        Preconditions.checkState((boolean)treeCombination.averageAcrossLevels.isEmpty(), (Object)"Averaging not yet supported");
        ZipFile innerZip = new ZipFile(this.innerHazardCurvesFile);
        CSVFile<String> innerSitesCSV = CSVFile.readStream(innerZip.getInputStream(innerZip.getEntry("sites.csv")), true);
        this.sites = MPJ_SiteLogicTreeHazardCurveCalc.parseSitesCSV(innerSitesCSV, null);
        System.out.println("Loaded " + this.sites.size() + " hazard curve sites");
        ZipFile outerZip = new ZipFile(this.outerHazardCurvesFile);
        this.sitesCSV = CSVFile.readStream(outerZip.getInputStream(outerZip.getEntry("sites.csv")), true);
        List<Site> outerSites = MPJ_SiteLogicTreeHazardCurveCalc.parseSitesCSV(this.sitesCSV, null);
        Preconditions.checkState((this.sites.size() == outerSites.size() ? 1 : 0) != 0, (String)"Inner hazard has %s sites and outer has %s", (int)this.sites.size(), (int)outerSites.size());
        this.outerSiteCurves = new ArrayList<List<List<DiscretizedFunc>>>(this.sites.size());
        this.innerSiteCurves = new ArrayList<List<List<DiscretizedFunc>>>(this.sites.size());
        this.siteOutNames = new ArrayList<List<String>>(this.sites.size());
        for (int s = 0; s < this.sites.size(); ++s) {
            Site site = this.sites.get(s);
            Preconditions.checkState((boolean)LocationUtils.areSimilar(site.getLocation(), outerSites.get(s).getLocation()));
            String sitePrefix = FileNameUtils.simplify(site.getName());
            System.out.println("Pre-loading site hazard curves for site " + s + "/" + this.sites.size() + ": " + site.getName());
            Map<Double, ZipEntry> outerPerEntries = SiteLogicTreeHazardPageGen.locateSiteCurveCSVs(sitePrefix, outerZip);
            Preconditions.checkState((!outerPerEntries.isEmpty() ? 1 : 0) != 0);
            Map<Double, ZipEntry> innerPerEntries = SiteLogicTreeHazardPageGen.locateSiteCurveCSVs(sitePrefix, innerZip);
            Preconditions.checkState((!innerPerEntries.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((outerPerEntries.size() == innerPerEntries.size() ? 1 : 0) != 0);
            if (this.sitePeriods == null) {
                this.sitePeriods = new ArrayList<Double>(outerPerEntries.keySet());
                Collections.sort(this.sitePeriods);
                this.sitePerXVals = new ArrayList<double[]>(this.sitePeriods.size());
            } else {
                Preconditions.checkState((outerPerEntries.size() == this.sitePeriods.size() ? 1 : 0) != 0);
            }
            ArrayList<List<DiscretizedFunc>> outerPerCurves = new ArrayList<List<DiscretizedFunc>>(this.sitePeriods.size());
            this.outerSiteCurves.add(outerPerCurves);
            ArrayList<List<DiscretizedFunc>> innerPerCurves = new ArrayList<List<DiscretizedFunc>>(this.sitePeriods.size());
            this.innerSiteCurves.add(innerPerCurves);
            ArrayList<String> outNames = new ArrayList<String>(this.sitePeriods.size());
            this.siteOutNames.add(outNames);
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                double period = this.sitePeriods.get(p);
                Preconditions.checkState((boolean)innerPerEntries.containsKey(period));
                List<DiscretizedFunc> outerSitePerCurves = SiteLogicTreeHazardPageGen.loadCurves(CSVFile.readStream(outerZip.getInputStream(outerPerEntries.get(period)), true), treeCombination.outerTree);
                Preconditions.checkState((outerSitePerCurves.size() == treeCombination.outerTree.size() ? 1 : 0) != 0);
                outerPerCurves.add(outerSitePerCurves);
                List<DiscretizedFunc> innerSitePerCurves = SiteLogicTreeHazardPageGen.loadCurves(CSVFile.readStream(innerZip.getInputStream(innerPerEntries.get(period)), true), treeCombination.innerTree);
                Preconditions.checkState((innerSitePerCurves.size() == treeCombination.innerTree.size() ? 1 : 0) != 0);
                innerPerCurves.add(innerSitePerCurves);
                outNames.add(outerPerEntries.get(period).getName());
                Preconditions.checkState((this.sitePerXVals.size() >= p ? 1 : 0) != 0);
                DiscretizedFunc outerCurve0 = outerSitePerCurves.get(0);
                DiscretizedFunc innerCurve0 = innerSitePerCurves.get(0);
                Preconditions.checkState((outerCurve0.size() == innerCurve0.size() ? 1 : 0) != 0, (Object)"Curve gridding differs between outer and inner site curves");
                if (this.sitePerXVals.size() != p) continue;
                double[] xVals = new double[outerCurve0.size()];
                for (int i = 0; i < xVals.length; ++i) {
                    xVals[i] = outerCurve0.getX(i);
                    Preconditions.checkState(((float)xVals[i] == (float)innerCurve0.getX(i) ? 1 : 0) != 0);
                }
                this.sitePerXVals.add(xVals);
            }
        }
        innerZip.close();
        outerZip.close();
        String outName = this.hazardCurvesOutputFile.getName();
        this.curveOutDir = outName.toLowerCase().endsWith(".zip") ? new File(this.hazardCurvesOutputFile.getParentFile(), outName.substring(0, outName.length() - 4)) : this.hazardCurvesOutputFile;
        Preconditions.checkState((this.curveOutDir.exists() || this.curveOutDir.mkdir() ? 1 : 0) != 0, (String)"Doesn't exist and couldn't be created: %s", (Object)this.curveOutDir.getAbsolutePath());
    }

    @Override
    public void processBranch(LogicTreeBranch<?> combBranch, int combBranchIndex, double combBranchWeight, LogicTreeBranch<?> outerBranch, int outerBranchIndex, LogicTreeBranch<?> innerBranch, int innerBranchIndex) throws IOException {
        int s;
        this.combineWatch.start();
        ArrayList combineFutures = new ArrayList(this.sites.size());
        for (int s2 = 0; s2 < this.sites.size(); ++s2) {
            ArrayList<Future<HazardMapCombinationProcessor.CurveCombineResult>> periodFutures = new ArrayList<Future<HazardMapCombinationProcessor.CurveCombineResult>>(this.sitePeriods.size());
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                double[] xVals = this.sitePerXVals.get(p);
                DiscretizedFunc outerCurve = this.outerSiteCurves.get(s2).get(p).get(outerBranchIndex);
                DiscretizedFunc innerCurve = this.innerSiteCurves.get(s2).get(p).get(innerBranchIndex);
                periodFutures.add(this.exec.submit(new HazardMapCombinationProcessor.CurveCombineCallable(s2, xVals, outerCurve, innerCurve, null)));
            }
            combineFutures.add(periodFutures);
        }
        if (this.siteCurveWriters == null) {
            this.siteCurveWriters = new ArrayList<List<FileWriter>>(this.sites.size());
            ArrayList<String> perHeaders = new ArrayList<String>(this.sitePeriods.size());
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                double[] xVals = this.sitePerXVals.get(p);
                ArrayList<Object> header = new ArrayList<Object>();
                header.add("Site Name");
                header.add("Branch Index");
                header.add("Branch Weight");
                for (int l = 0; l < combBranch.size(); ++l) {
                    header.add(combBranch.getLevel(l).getShortName());
                }
                for (double x : xVals) {
                    header.add("" + (float)x);
                }
                perHeaders.add(CSVFile.getLineStr(header));
            }
            for (int s3 = 0; s3 < this.sites.size(); ++s3) {
                ArrayList<FileWriter> perCurveWriters = new ArrayList<FileWriter>(this.sitePeriods.size());
                for (int p = 0; p < this.sitePeriods.size(); ++p) {
                    String outName = this.siteOutNames.get(s3).get(p);
                    FileWriter fw = new FileWriter(new File(this.curveOutDir, outName));
                    fw.write((String)perHeaders.get(p));
                    fw.write(10);
                    perCurveWriters.add(fw);
                }
                this.siteCurveWriters.add(perCurveWriters);
            }
        }
        ArrayList siteCombCurveLines = new ArrayList(this.sites.size());
        for (s = 0; s < this.sites.size(); ++s) {
            ArrayList<String> perCurveLines = new ArrayList<String>(this.sitePeriods.size());
            siteCombCurveLines.add(perCurveLines);
            ArrayList<Object> commonPrefix = new ArrayList<Object>(combBranch.size() + 3);
            commonPrefix.add(this.sites.get(s).getName());
            commonPrefix.add("" + combBranchIndex);
            commonPrefix.add("" + combBranchWeight);
            for (LogicTreeNode node : combBranch) {
                commonPrefix.add(node.getShortName());
            }
            String prefixStr = CSVFile.getLineStr(commonPrefix);
            StringBuilder line = new StringBuilder();
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                DiscretizedFunc curve;
                try {
                    HazardMapCombinationProcessor.CurveCombineResult result = (HazardMapCombinationProcessor.CurveCombineResult)((Future)((List)combineFutures.get(s)).get(p)).get();
                    curve = result.combCurve;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                line.setLength(0);
                line.append(prefixStr);
                for (Point2D pt : curve) {
                    line.append(',').append(String.valueOf(pt.getY()));
                }
                line.append('\n');
                perCurveLines.add(line.toString());
            }
        }
        this.combineWatch.stop();
        this.curveWriteWatch.start();
        for (s = 0; s < this.sites.size(); ++s) {
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                this.siteCurveWriters.get(s).get(p).write((String)((List)siteCombCurveLines.get(s)).get(p));
            }
        }
        this.curveWriteWatch.stop();
    }

    @Override
    public void close() throws IOException {
        System.out.println("Finalizing site hazard curve files");
        this.curveWriteWatch.start();
        for (int s = 0; s < this.sites.size(); ++s) {
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                this.siteCurveWriters.get(s).get(p).close();
            }
        }
        this.curveWriteWatch.stop();
        File curveZipFile = this.curveOutDir == this.hazardCurvesOutputFile ? new File(String.valueOf(this.curveOutDir.getAbsoluteFile()) + ".zip") : this.hazardCurvesOutputFile;
        System.out.println("Building site hazard curve zip file: " + curveZipFile.getAbsolutePath());
        ArchiveOutput.ZipFileOutput output = new ArchiveOutput.ZipFileOutput(curveZipFile);
        output.putNextEntry("sites.csv");
        this.sitesCSV.writeToStream(output.getOutputStream());
        output.closeEntry();
        this.combTree.writeToArchive(output, null);
        for (int s = 0; s < this.sites.size(); ++s) {
            for (int p = 0; p < this.sitePeriods.size(); ++p) {
                String csvName = this.siteOutNames.get(s).get(p);
                System.out.println("Processing site " + s + "/" + this.sites.size() + " " + csvName);
                output.putNextEntry(csvName);
                File inFile = new File(this.curveOutDir, csvName);
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
                IOUtils.copy((InputStream)in, (OutputStream)output.getOutputStream());
                ((InputStream)in).close();
                output.closeEntry();
            }
        }
        output.close();
    }

    @Override
    public String getTimeBreakdownString(Stopwatch overallWatch) {
        return "Combining: " + AbstractLogicTreeCombiner.blockingTimePrint(this.combineWatch, overallWatch) + ";\tWriting: " + AbstractLogicTreeCombiner.blockingTimePrint(this.curveWriteWatch, overallWatch);
    }
}

