/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;

public class ModuleCopier {
    public static void main(String[] args) throws ZipException, IOException {
        File outputFile;
        FaultSystemRupSet addFromRupSet;
        FaultSystemSolution addFromSol;
        FaultSystemRupSet addToRupSet;
        FaultSystemSolution addToSol;
        Preconditions.checkArgument((args.length == 2 || args.length == 3 ? 1 : 0) != 0, (Object)"USAGE: <add-to-file> <add-from-file> [<output-file>]");
        File addToFile = new File(args[0]);
        ZipFile addToZip = new ZipFile(addToFile);
        if (FaultSystemSolution.isSolution(addToZip)) {
            addToSol = FaultSystemSolution.load(addToZip);
            addToRupSet = addToSol.getRupSet();
        } else {
            addToRupSet = FaultSystemRupSet.load(addToFile);
            addToSol = null;
        }
        File addFromFile = new File(args[1]);
        ZipFile addFromZip = new ZipFile(addFromFile);
        if (FaultSystemSolution.isSolution(addFromZip)) {
            Preconditions.checkNotNull((Object)addToSol);
            addFromSol = FaultSystemSolution.load(addFromZip);
            addFromRupSet = addFromSol.getRupSet();
        } else {
            addFromRupSet = FaultSystemRupSet.load(addFromFile);
            addFromSol = null;
        }
        ArrayList<OpenSHA_Module> allAdded = new ArrayList<OpenSHA_Module>();
        for (OpenSHA_Module module : addFromRupSet.getModules(true)) {
            if (addToRupSet.hasModuleSuperclass(module.getClass())) continue;
            System.out.println("Copying module '" + module.getName() + "' of type " + module.getClass().getName());
            allAdded.add(module);
            addToRupSet.addModule(module);
        }
        if (addFromSol != null) {
            for (OpenSHA_Module module : addFromSol.getModules(true)) {
                if (addToSol.hasModuleSuperclass(module.getClass())) continue;
                System.out.println("Copying module '" + module.getName() + "' of type " + module.getClass().getName());
                allAdded.add(module);
                addToSol.addModule(module);
            }
        }
        File file = outputFile = args.length == 3 ? new File(args[2]) : addToFile;
        if (addToSol == null) {
            addToRupSet.write(outputFile);
        } else {
            addToSol.write(outputFile);
        }
        System.out.println("Summary of added modules:");
        for (OpenSHA_Module module : allAdded) {
            System.out.println("\t" + module.getName() + ": " + module.getClass().getName());
        }
    }
}

