/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BuildInfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ProxyFaultSectionInstances;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.util.TectonicRegionType;

public class SolModuleStripper {
    private static final double GRID_MIN_MAG_DEFAULT = 5.0;

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption(null, "grid-min-mag", true, "Filter grid source provider to only include ruptures above this magnitude. Default is M5.0");
        ops.addOption(null, "keep-rup-mfds", false, "Flag to keep rupture MFDs (if present)");
        ops.addOption(null, "update-build-info", false, "Flag to update OpenSHA build info rather than retaining the version in the original file");
        return ops;
    }

    public static void main(String[] args) throws IOException {
        CommandLine cmd = FaultSysTools.parseOptions(SolModuleStripper.createOptions(), args, SolModuleStripper.class);
        args = cmd.getArgs();
        if (args.length != 2) {
            System.err.println("USAGE: SolModuleStripper <input-file> <output-file>");
            System.exit(1);
        }
        double gridMinMag = cmd.hasOption("grid-min-mag") ? Double.parseDouble(cmd.getOptionValue("grid-min-mag")) : 5.0;
        File inputFile = new File(args[0]);
        Preconditions.checkState((boolean)inputFile.exists(), (String)"Input file doesn't exist: %s", (Object)inputFile.getAbsolutePath());
        File outputFile = new File(args[1]);
        boolean keepRupMFDs = cmd.hasOption("keep-rup-mfds");
        boolean updateBuildInfo = cmd.hasOption("update-build-info");
        try {
            ZipFile inputZip = new ZipFile(inputFile);
            if (!FaultSystemSolution.isSolution(inputZip)) {
                System.out.println("Input file isn't a FaultSystemSolution, trying SolutionLogicTree");
                ArchiveInput.ApacheZipFileInput sltInput = new ArchiveInput.ApacheZipFileInput(inputFile);
                SolutionLogicTree slt = SolutionLogicTree.load(sltInput);
                SolutionLogicTree.simplify(slt, outputFile, keepRupMFDs, updateBuildInfo);
                inputZip.close();
                sltInput.close();
                System.exit(0);
            }
            FaultSystemSolution inputSol = FaultSystemSolution.load(inputZip);
            FaultSystemSolution strippedSol = SolModuleStripper.stripModules(inputSol, gridMinMag, keepRupMFDs, updateBuildInfo);
            strippedSol.write(outputFile);
            inputZip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static FaultSystemSolution stripModules(FaultSystemSolution inputSol, double gridMinMag) {
        return SolModuleStripper.stripModules(inputSol, gridMinMag, false, false);
    }

    public static FaultSystemSolution stripModules(FaultSystemSolution inputSol, double gridMinMag, boolean keepRupMFDs, boolean updateBuildInfo) {
        RupMFDsModule mfds;
        GridSourceProvider gridProv;
        FaultSystemSolution strippedSol;
        ClusterRuptures.SingleStranded ssClusterRups;
        InfoModule info;
        AveSlipModule aveSlip;
        SlipAlongRuptureModel slipAlong;
        FaultSystemRupSet inputRupSet = inputSol.getRupSet();
        FaultSystemRupSet strippedRupSet = FaultSystemRupSet.buildFromExisting(inputRupSet, false).build();
        RupSetTectonicRegimes tectonics = inputRupSet.getModule(RupSetTectonicRegimes.class);
        if (tectonics != null) {
            strippedRupSet.addModule(tectonics);
        }
        if ((slipAlong = inputRupSet.getModule(SlipAlongRuptureModel.class)) != null) {
            strippedRupSet.addModule(slipAlong);
        }
        if ((aveSlip = inputRupSet.getModule(AveSlipModule.class)) != null) {
            strippedRupSet.addModule(aveSlip);
        }
        BuildInfoModule updatedBuildInfo = null;
        try {
            updatedBuildInfo = updateBuildInfo ? BuildInfoModule.detect() : null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (updateBuildInfo) {
            if (updatedBuildInfo != null) {
                strippedRupSet.addModule(updatedBuildInfo);
            }
        } else {
            BuildInfoModule buildInfo = inputRupSet.getModule(BuildInfoModule.class);
            if (buildInfo != null) {
                strippedRupSet.addModule(buildInfo);
            }
        }
        if ((info = inputRupSet.getModule(InfoModule.class)) != null) {
            strippedRupSet.addModule(info);
        }
        if ((ssClusterRups = inputRupSet.getModule(ClusterRuptures.SingleStranded.class)) != null) {
            strippedRupSet.addModule(ssClusterRups);
        }
        ProxyFaultSectionInstances proxies = inputRupSet.getModule(ProxyFaultSectionInstances.class);
        RuptureSetSplitMappings splitMappings = null;
        if (proxies != null) {
            float oldSum;
            System.out.println("Splitting out proxy ruptures");
            strippedRupSet = proxies.getSplitRuptureSet(strippedRupSet);
            splitMappings = strippedRupSet.requireModule(RuptureSetSplitMappings.class);
            strippedRupSet.removeModule(splitMappings);
            double[] mappedRates = new double[strippedRupSet.getNumRuptures()];
            for (int r = 0; r < mappedRates.length; ++r) {
                mappedRates[r] = inputSol.getRateForRup(splitMappings.getOrigRupID(r)) * splitMappings.getNewRupWeight(r);
            }
            strippedSol = new FaultSystemSolution(strippedRupSet, mappedRates);
            float newSum = (float)strippedSol.getTotalRateForAllFaultSystemRups();
            Preconditions.checkState((newSum == (oldSum = (float)inputSol.getTotalRateForAllFaultSystemRups()) ? 1 : 0) != 0, (String)"Proxy rupture expansion changed the rupture rate from %s to %s", (Object)Float.valueOf(oldSum), (Object)Float.valueOf(newSum));
        } else {
            strippedSol = new FaultSystemSolution(strippedRupSet, inputSol.getRateForAllRups());
        }
        if (updateBuildInfo) {
            if (updatedBuildInfo != null) {
                strippedSol.addModule(updatedBuildInfo);
            }
        } else {
            BuildInfoModule buildInfo = inputSol.getModule(BuildInfoModule.class);
            if (buildInfo != null) {
                strippedSol.addModule(buildInfo);
            }
        }
        if ((info = inputSol.getModule(InfoModule.class)) != null) {
            strippedSol.addModule(info);
        }
        if ((gridProv = inputSol.getGridSourceProvider()) != null) {
            if (gridMinMag > 0.0) {
                gridProv = gridProv.getAboveMinMag((float)gridMinMag);
            }
            if (splitMappings != null && gridProv instanceof GridSourceList) {
                GridSourceList gridSources = (GridSourceList)gridProv;
                EnumMap trtRupsMap = new EnumMap(TectonicRegionType.class);
                for (TectonicRegionType trt : gridSources.getTectonicRegionTypes()) {
                    ArrayList modLists = new ArrayList(gridSources.getNumLocations());
                    for (int gridIndex = 0; gridIndex < gridSources.getNumLocations(); ++gridIndex) {
                        ImmutableList<GridSourceList.GriddedRupture> origRups = gridSources.getRuptures(trt, gridIndex);
                        if (origRups.isEmpty()) {
                            modLists.add(null);
                            continue;
                        }
                        ArrayList<GridSourceList.GriddedRupture> modRups = new ArrayList<GridSourceList.GriddedRupture>(origRups.size());
                        for (GridSourceList.GriddedRupture rup : origRups) {
                            if (rup.associatedSections == null) {
                                modRups.add(rup);
                                continue;
                            }
                            ArrayList<Integer> modSects = new ArrayList<Integer>();
                            ArrayList<Double> modFracts = new ArrayList<Double>();
                            for (int s = 0; s < rup.associatedSections.length; ++s) {
                                List<Integer> mappedIDs = splitMappings.getNewSectIDs(rup.associatedSections[s]);
                                for (int mappedID : mappedIDs) {
                                    modSects.add(mappedID);
                                    modFracts.add(rup.associatedSectionFracts[s] * splitMappings.getNewSectWeight(mappedID));
                                }
                            }
                            modRups.add(new GridSourceList.GriddedRupture(rup.gridIndex, rup.location, rup.properties, rup.rate, Ints.toArray(modSects), Doubles.toArray(modFracts)));
                        }
                        modLists.add(modRups);
                    }
                    trtRupsMap.put(trt, modLists);
                }
                gridProv = new GridSourceList.Precomputed(gridSources, trtRupsMap);
            }
            strippedSol.addModule(gridProv);
        }
        if (keepRupMFDs && (mfds = inputSol.getModule(RupMFDsModule.class)) != null) {
            if (splitMappings != null) {
                DiscretizedFunc[] modMFDs = new DiscretizedFunc[strippedRupSet.getNumRuptures()];
                for (int r = 0; r < modMFDs.length; ++r) {
                    int origID = splitMappings.getOrigRupID(r);
                    DiscretizedFunc origMFD = mfds.getRuptureMFD(origID);
                    if (origMFD == null) continue;
                    double weight = splitMappings.getNewRupWeight(r);
                    if (weight == 1.0) {
                        modMFDs[r] = origMFD;
                        continue;
                    }
                    DiscretizedFunc modMFD = origMFD.deepClone();
                    modMFD.scale(weight);
                    modMFDs[r] = modMFD;
                }
                mfds = new RupMFDsModule(strippedSol, modMFDs);
            }
            strippedSol.addModule(mfds);
        }
        return strippedSol;
    }
}

