/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.util.SolModuleStripper;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.LastEventData;

class UCERF3FileConverter {
    UCERF3FileConverter() {
    }

    public static void main(String[] args) throws ZipException, IOException {
        File inputDir = new File("/home/kevin/OpenSHA/UCERF3/rup_sets/orig");
        File outputDir = new File("/home/kevin/OpenSHA/UCERF3/rup_sets/modular");
        File comoundFile = new File(inputDir, "full_ucerf3_compound_sol.zip");
        U3CompoundFaultSystemSolution cfss = U3CompoundFaultSystemSolution.fromZipFile(comoundFile);
        Map<Integer, List<LastEventData>> lastEventData = LastEventData.load();
        FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        System.out.println("Writing reference branches...");
        for (FaultModels fm : fms) {
            U3LogicTreeBranch branch = U3LogicTreeBranch.fromValues(true, fm);
            System.out.println("Ref branch: " + String.valueOf(branch));
            InversionFaultSystemSolution ivfss = cfss.getSolution(branch);
            LastEventData.populateSubSects(ivfss.getRupSet().getFaultSectionDataList(), lastEventData);
            ivfss.setGridSourceProvider(UCERF3FileConverter.exactGridProv(ivfss.getGridSourceProvider()));
            UCERF3FileConverter.attachExtraIVFSRSModules(ivfss.getRupSet());
            ivfss.write(new File(outputDir, branch.buildFileName() + ".zip"));
            branch.setValue(SlipAlongRuptureModels.UNIFORM);
            System.out.println("Ref (UNIFORM) branch: " + String.valueOf(branch));
            ivfss = cfss.getSolution(branch);
            LastEventData.populateSubSects(ivfss.getRupSet().getFaultSectionDataList(), lastEventData);
            ivfss.setGridSourceProvider(UCERF3FileConverter.exactGridProv(ivfss.getGridSourceProvider()));
            UCERF3FileConverter.attachExtraIVFSRSModules(ivfss.getRupSet());
            ivfss.write(new File(outputDir, branch.buildFileName() + ".zip"));
            DeformationModels refDM = branch.getValue(DeformationModels.class);
            for (DeformationModels dm : DeformationModels.values()) {
                if (dm == refDM || dm.getNodeWeight(branch) == 0.0) continue;
                branch.setValue(dm);
                System.out.println("Alt DM (UNIFORM) branch: " + String.valueOf(branch));
                ivfss = cfss.getSolution(branch);
                LastEventData.populateSubSects(ivfss.getRupSet().getFaultSectionDataList(), lastEventData);
                ivfss.setGridSourceProvider(UCERF3FileConverter.exactGridProv(ivfss.getGridSourceProvider()));
                UCERF3FileConverter.attachExtraIVFSRSModules(ivfss.getRupSet());
                ivfss.write(new File(outputDir, branch.buildFileName() + ".zip"));
            }
        }
        System.out.println("Writing full model files with " + ((U3FaultSystemSolutionFetcher)cfss).getBranches().size() + " branches");
        SolutionLogicTree.UCERF3 solTreeModule = new SolutionLogicTree.UCERF3(cfss);
        solTreeModule.setSerializeGridded(false);
        solTreeModule.write(new File(outputDir, "full_logic_tree.zip"));
        solTreeModule.setSerializeGridded(true);
        solTreeModule.write(new File(outputDir, "full_logic_tree_with_gridded.zip"));
        System.out.println("Writing branch averaged files");
        for (FaultModels fm : fms) {
            U3FaultSystemSolutionFetcher fmFetcher = U3FaultSystemSolutionFetcher.getSubset(cfss, fm);
            SolutionLogicTree.UCERF3 subTreeModule = new SolutionLogicTree.UCERF3(fmFetcher);
            FaultSystemSolution sol = subTreeModule.calcBranchAveraged();
            String prefix = fm.encodeChoiceString() + "_branch_averaged";
            UCERF3FileConverter.writeSimplifiedAndFull(sol, new File(outputDir, prefix + "_full_modules.zip"), new File(outputDir, prefix + ".zip"));
            subTreeModule.setSerializeGridded(false);
            sol.addModule(subTreeModule);
            sol.write(new File(outputDir, prefix + "_with_logic_tree.zip"));
            for (SpatialSeisPDF spatSeis : new SpatialSeisPDF[]{SpatialSeisPDF.UCERF2, SpatialSeisPDF.UCERF3}) {
                U3FaultSystemSolutionFetcher ssFetcher = U3FaultSystemSolutionFetcher.getSubset(fmFetcher, spatSeis);
                SolutionLogicTree.UCERF3 ssSLT = new SolutionLogicTree.UCERF3(ssFetcher);
                sol = ssSLT.calcBranchAveraged();
                prefix = fm.encodeChoiceString() + "_" + spatSeis.encodeChoiceString() + "_branch_averaged";
                UCERF3FileConverter.writeSimplifiedAndFull(sol, new File(outputDir, prefix + "_full_modules.zip"), new File(outputDir, prefix + ".zip"));
            }
        }
    }

    private static void writeSimplifiedAndFull(FaultSystemSolution sol, File fullFile, File simplifiedFile) throws IOException {
        sol.write(fullFile);
        sol = SolModuleStripper.stripModules(sol, 0.0);
        sol.write(simplifiedFile);
    }

    private static GridSourceProvider exactGridProv(GridSourceProvider prov) {
        Preconditions.checkNotNull((Object)prov);
        AbstractGridSourceProvider.Precomputed precomputed = new AbstractGridSourceProvider.Precomputed((MFDGridSourceProvider)prov);
        precomputed.setRound(false);
        return precomputed;
    }

    private static void attachExtraIVFSRSModules(InversionFaultSystemRupSet ivfsrs) throws IOException {
        U3LogicTreeBranch branch = ivfsrs.getLogicTreeBranch();
        FaultModels fm = branch.getValue(FaultModels.class);
        if (fm != null) {
            ivfsrs.addModule(new NamedFaults(ivfsrs, fm.getNamedFaultsMapAlt()));
            ivfsrs.addModule(PaleoseismicConstraintData.loadUCERF3(ivfsrs));
        }
    }
}

