/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake.parsers.ngaWest;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.ngaWest.NGAWestEqkRupture;
import org.opensha.sha.faultSurface.ApproxEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GriddedSurfaceImpl;
import org.opensha.sha.faultSurface.RuptureSurface;

public class NGAWestParser {
    private static final FilenameFilter polFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".POL");
        }
    };
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static HashMap<Integer, RuptureSurface> loadPolTlls(File dir) throws IOException {
        return NGAWestParser.loadPolTlls(dir, 0.0);
    }

    public static HashMap<Integer, RuptureSurface> loadPolTlls(File dir, double gridSpacing) throws IOException {
        HashMap surfs = new HashMap();
        for (File polFile : dir.listFiles(polFilter)) {
            int j;
            Location[][] tok;
            char c;
            File tllFile = new File(dir, polFile.getName().replace(".POL", ".TLL"));
            if (!tllFile.exists()) {
                System.out.println("No TLL file for " + polFile.getName());
                continue;
            }
            ArrayList<String> tllLines = FileUtils.loadFile(tllFile.getAbsolutePath());
            String nameLine = tllLines.get(0).trim();
            String originLine = tllLines.get(1);
            String hypoLine = tllLines.get(2);
            int firstSpace = nameLine.indexOf(32);
            int eqID = Integer.parseInt(nameLine.substring(0, firstSpace));
            nameLine = nameLine.substring(firstSpace).trim();
            Object name = "";
            for (int i = 0; !(i >= nameLine.length() || (c = nameLine.charAt(i)) == ' ' && ((String)name).endsWith(" ")); ++i) {
                name = (String)name + c;
            }
            name = ((String)name).trim();
            StringTokenizer origTok = new StringTokenizer(originLine);
            double origLat = Double.parseDouble(origTok.nextToken());
            double origLon = Double.parseDouble(origTok.nextToken());
            Location origin = new Location(origLat, origLon);
            ArrayList<String> polLines = FileUtils.loadFile(polFile.getAbsolutePath());
            polLines.remove(0);
            polLines.remove(0).trim();
            Location[][] locs = null;
            int size = -1;
            for (int i = 0; i < 4; ++i) {
                String line = polLines.get(i);
                tok = new StringTokenizer(line.trim());
                if (size < 0) {
                    size = tok.countTokens() / 3;
                    Preconditions.checkState((size > 0 ? 1 : 0) != 0, (Object)("Size is 0 for line: " + line));
                    locs = new Location[size][4];
                } else {
                    int mySize = tok.countTokens() / 3;
                    Preconditions.checkState((size == mySize ? 1 : 0) != 0, (Object)("inconsistent sizes for " + polFile.getName() + " (expected=" + size + ", actual=" + mySize + ")\nline: " + line));
                }
                for (j = 0; j < size; ++j) {
                    double kmEast = Double.parseDouble(tok.nextToken());
                    double kmNorth = Double.parseDouble(tok.nextToken());
                    double dep = -Double.parseDouble(tok.nextToken());
                    Location loc = LocationUtils.location(origin, 0.0, kmNorth);
                    loc = LocationUtils.location(loc, 1.5707963267948966, kmEast);
                    locs[j][i] = new Location(loc.getLatitude(), loc.getLongitude(), dep);
                }
            }
            boolean equal = true;
            StringTokenizer prev = null;
            tok = locs;
            j = tok.length;
            for (int kmEast = 0; kmEast < j; ++kmEast) {
                StringTokenizer locArray;
                for (StringTokenizer loc : locArray = tok[kmEast]) {
                    if (prev == null) {
                        prev = loc;
                        continue;
                    }
                    equal = equal && ((Location)((Object)loc)).getLatitude() == ((Location)((Object)prev)).getLatitude() && ((Location)((Object)loc)).getLongitude() == ((Location)((Object)prev)).getLongitude();
                    prev = loc;
                    if (!equal) break;
                }
                if (!equal) break;
            }
            if (equal) continue;
            GriddedSurfaceImpl surface = new GriddedSurfaceImpl(2, size + 1, Double.NaN);
            Preconditions.checkState((surface.size() >= 4L ? 1 : 0) != 0, (Object)("surface's size is <4: " + surface.size() + " (dims: 2x" + (size + 1) + ")"));
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    surface.set(0, i, locs[i][0]);
                    surface.set(1, i, locs[i][3]);
                }
                surface.set(0, i + 1, locs[i][1]);
                surface.set(1, i + 1, locs[i][2]);
            }
            if (!surfs.containsKey(eqID)) {
                surfs.put(eqID, new ArrayList());
            }
            if (gridSpacing > 0.0) {
                FaultTrace upper = new FaultTrace("upper");
                FaultTrace lower = new FaultTrace("lower");
                for (int i = 0; i < surface.getNumCols(); ++i) {
                    upper.add((Location)surface.get(0, i));
                    lower.add((Location)surface.get(1, i));
                }
                ApproxEvenlyGriddedSurface gridSurf = new ApproxEvenlyGriddedSurface(upper, lower, gridSpacing);
                ((ArrayList)surfs.get(eqID)).add(gridSurf);
                continue;
            }
            ((ArrayList)surfs.get(eqID)).add(surface);
        }
        HashMap<Integer, RuptureSurface> map = new HashMap<Integer, RuptureSurface>();
        for (Integer id : surfs.keySet()) {
            ArrayList surfList = (ArrayList)surfs.get(id);
            RuptureSurface surf = surfList.size() == 1 ? (RuptureSurface)surfList.get(0) : new CompoundSurface(surfList);
            map.put(id, surf);
        }
        return map;
    }

    public static ObsEqkRupList loadNGAWestFiles(File excelFile, File polTllDir) throws IOException {
        return NGAWestParser.loadNGAWestFiles(excelFile, polTllDir, 0.0);
    }

    public static ObsEqkRupList loadNGAWestFiles(File excelFile, File polTllDir, double gridSpacing) throws IOException {
        Preconditions.checkNotNull((Object)excelFile, (Object)"Excel file is null!");
        Preconditions.checkArgument((boolean)excelFile.exists(), (Object)"Excel file doesn't exist!");
        Preconditions.checkArgument((boolean)excelFile.isFile(), (Object)"Excel file isn't a regular file!");
        Preconditions.checkNotNull((Object)polTllDir, (Object)"Pol/Tll directory is null!");
        Preconditions.checkArgument((boolean)polTllDir.exists(), (Object)"Excel directory doesn't exist!");
        Preconditions.checkArgument((boolean)polTllDir.isDirectory(), (Object)"Excel directory isn't a directory!");
        HashMap<Integer, RuptureSurface> surfaces = NGAWestParser.loadPolTlls(polTllDir, gridSpacing);
        ObsEqkRupList rups = new ObsEqkRupList();
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new BufferedInputStream(new FileInputStream(excelFile)));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            HSSFRow row = sheet.getRow(i);
            try {
                double test = row.getCell(2).getNumericCellValue();
                if (test <= 0.0) {
                }
            }
            catch (Exception e) {}
            continue;
            NGAWestEqkRupture rup = new NGAWestEqkRupture(row, excelFile.getName());
            int id = rup.getId();
            if (surfaces.containsKey(id)) {
                rup.setRuptureSurface(surfaces.get(id));
            }
            Preconditions.checkState((rup.isFiniteRuptureModel() == (rup.getRuptureSurface() != null) ? 1 : 0) != 0, (Object)("Excel sheet & existance of POL/TLL files doesn't match up! EQ: " + id));
            rups.add(rup);
        }
        return rups;
    }

    public static ObsEqkRupList mergeLists(List<ObsEqkRupture> primaryList, List<ObsEqkRupture> secondaryList) {
        ObsEqkRupList list = new ObsEqkRupList();
        list.addAll(secondaryList);
        for (ObsEqkRupture primary : primaryList) {
            int ind = NGAWestParser.getBestMatchIndex(primary, secondaryList);
            if (ind < 0) {
                list.add(primary);
                continue;
            }
            if (list.get(ind) != secondaryList.get(ind)) {
                System.out.println("Duplicate replace found!!! just adding the second one");
                list.add(primary);
                continue;
            }
            list.set(ind, primary);
        }
        list.sortByOriginTime();
        return list;
    }

    private static String getRupStr(ObsEqkRupture rup) {
        Location hypo = rup.getHypocenterLocation();
        return "Mag:\t" + rup.getMag() + "\tDate:\t" + df.format(new Date(rup.getOriginTime())) + "\tHypo:\t" + hypo.getLatitude() + "," + hypo.getLongitude() + "," + hypo.getDepth();
    }

    public static int getBestMatchIndex(ObsEqkRupture rup, List<ObsEqkRupture> candidates) {
        int bestIndex = -1;
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < candidates.size(); ++i) {
            ObsEqkRupture cand;
            GregorianCalendar cal;
            double score = NGAWestParser.getMatchScore(rup, candidates.get(i));
            if (score < bestScore) {
                bestIndex = i;
                bestScore = score;
            }
            if (!rup.getEventId().equals("1980.11.08, Mw=7.3, W of Eureka, CA.inp") || (cal = (cand = candidates.get(i)).getOriginTimeCal()).get(1) != 1980 || cal.get(2) != 10) continue;
            System.out.println("CAND: " + score + " - " + NGAWestParser.getRupStr(cand));
        }
        System.out.println("Best match score for rupture " + rup.getEventId() + ": " + bestScore);
        ObsEqkRupture match = candidates.get(bestIndex);
        System.out.println("Orig: " + NGAWestParser.getRupStr(rup));
        System.out.println("Best: " + NGAWestParser.getRupStr(match));
        double[] matchDeltas = NGAWestParser.getMatchDeltas(rup, match);
        System.out.println("Deltas:\t" + matchDeltas[0] + "\t" + matchDeltas[1] + "\t" + matchDeltas[2]);
        System.out.println("Deltas^2:\t" + matchDeltas[0] * matchDeltas[0] + "\t" + matchDeltas[1] * matchDeltas[1] + "\t" + matchDeltas[2] * matchDeltas[2]);
        if (bestScore < 160.0) {
            return bestIndex;
        }
        return -1;
    }

    private static double[] getMatchDeltas(ObsEqkRupture rup1, ObsEqkRupture rup2) {
        double magDelta = Math.abs(rup1.getMag() - rup2.getMag());
        magDelta *= 10.0;
        double timeDelta = Math.abs((double)(rup1.getOriginTime() - rup2.getOriginTime()) / 8.64E7);
        timeDelta *= 12.0;
        if (rup1.getHypocenterLocation() == null) {
            return null;
        }
        double distanceDelta = LocationUtils.horzDistanceFast(rup1.getHypocenterLocation(), rup2.getHypocenterLocation());
        double[] matches = new double[]{magDelta, timeDelta, distanceDelta /= 2.0};
        return matches;
    }

    private static double getMatchScore(ObsEqkRupture rup1, ObsEqkRupture rup2) {
        double[] matches = NGAWestParser.getMatchDeltas(rup1, rup2);
        if (matches == null) {
            return Double.MAX_VALUE;
        }
        double squaresFit = matches[0] * matches[0] + matches[1] * matches[1] + matches[2] * matches[2];
        return squaresFit;
    }

    public static void main(String[] args) throws IOException {
        Location zoo = new Location(38.92875, -77.04927);
        Location quake = new Location(37.936, -77.933);
        double dist = LocationUtils.linearDistance(zoo, quake);
        System.out.println("Distance from epicenter to zoo (KM): " + dist);
        double pTimeTravel = dist / 8.0;
        double sTimeTravel = dist / 3.5;
        System.out.println("pTimeTravel (assuming 8km/s p wave speed): " + pTimeTravel);
        System.out.println("sTimeTravel (assuming 3.5km/s s wave speed): " + sTimeTravel);
        System.out.println("delta: " + (sTimeTravel - pTimeTravel));
        System.exit(0);
        File polTllDir = new File("src" + File.separator + "resources" + File.separator + "data" + File.separator + "ngaWest");
        File excelFile = new File(polTllDir, "EQ.V8.xls");
    }
}

